/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.gis.geodb.a;

import com.geoway.adf.gis.basic.LicChecker;
import com.geoway.adf.gis.basic.geometry.CoordinateType;
import com.geoway.adf.gis.basic.geometry.GeometryFunc;
import com.geoway.adf.gis.basic.geometry.GeometryType;
import com.geoway.adf.gis.basic.geometry.IEnvelope;
import com.geoway.adf.gis.basic.geometry.IGeometry;
import com.geoway.adf.gis.basic.geometry.ISpatialReferenceSystem;
import com.geoway.adf.gis.basic.geometry.SpatialReferenceSystemFunc;
import com.geoway.adf.gis.geodb.FeatureType;
import com.geoway.adf.gis.geodb.GeoDatasetType;
import com.geoway.adf.gis.geodb.IFeatureClass;
import com.geoway.adf.gis.geodb.IFeatureDataset;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import com.geoway.adf.gis.geodb.IGeoDataset;
import com.geoway.adf.gis.geodb.IGroupDataset;
import com.geoway.adf.gis.geodb.IMosaicDataset;
import com.geoway.adf.gis.geodb.IPgWorkspace;
import com.geoway.adf.gis.geodb.ITable;
import com.geoway.adf.gis.geodb.ITableView;
import com.geoway.adf.gis.geodb.IWorkspaceFactory;
import com.geoway.adf.gis.geodb.JdbcWorkspace;
import com.geoway.adf.gis.geodb.RegisterDatasetParams;
import com.geoway.adf.gis.geodb.a.af;
import com.geoway.adf.gis.geodb.a.ag;
import com.geoway.adf.gis.geodb.a.ah;
import com.geoway.adf.gis.geodb.a.aj;
import com.geoway.adf.gis.geodb.a.ak;
import com.geoway.adf.gis.geodb.a.al;
import com.geoway.adf.gis.geodb.a.am;
import com.geoway.adf.gis.geodb.a.an;
import com.geoway.adf.gis.geodb.a.ao;
import com.geoway.adf.gis.geodb.a.at;
import com.geoway.adf.gis.geodb.a.au;
import com.geoway.adf.gis.geodb.a.av;
import com.geoway.adf.gis.geodb.a.aw;
import com.geoway.adf.gis.geodb.a.z;
import com.geoway.adf.gis.geodb.cursor.ICursor;
import com.geoway.adf.gis.geodb.field.Field;
import com.geoway.adf.gis.geodb.field.FieldType;
import com.geoway.adf.gis.geodb.field.Fields;
import com.geoway.adf.gis.geodb.field.GeometryField;
import com.geoway.adf.gis.geodb.field.IField;
import com.geoway.adf.gis.geodb.field.IFields;
import com.geoway.adf.gis.geodb.filter.IQueryFilter;
import com.geoway.adf.gis.geodb.filter.ISpatialFilter;
import com.geoway.adf.gis.geodb.filter.SpatialRelationType;
import com.geoway.adf.gis.geodb.postgresql.PgWorkspaceFactory;
import com.geoway.adf.gis.raster.info.PixelDataType;
import com.geoway.adf.gis.raster.info.RasterInfo;
import com.geoway.atlas.license.authorize.LicenseCheck;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.postgis.jdbc.PGgeometry;
import net.postgis.jdbc.geometry.Geometry;
import net.postgis.jdbc.geometry.binary.BinaryParser;
import net.postgis.jdbc.geometry.binary.BinaryWriter;
import org.apache.commons.lang3.math.NumberUtils;

public class aq
extends JdbcWorkspace
implements IPgWorkspace {
    protected static final String bK = "public";
    protected boolean bL = false;
    protected boolean bM = true;
    protected String bN = "public";
    protected au bO;
    protected List<String> bP = new ArrayList<String>();
    protected List<String> bQ = new ArrayList<String>(){
        {
            this.add("information_schema");
            this.add("dbe_perf");
            this.add("dbe_pldebugger");
            this.add("dbe_pldeveloper");
            this.add("dbe_sql_util");
        }
    };
    protected List<String> bR = new ArrayList<String>(){
        {
            this.add("gw_class_metadata");
            this.add("gw_geom_metadata");
            this.add("gw_spatial_ref_metadata");
            this.add("gw_field_metadata");
            this.add("spatial_ref_sys");
            this.add("geography_columns");
            this.add("geometry_columns");
            this.add("pointcloud_columns");
            this.add("raster_columns");
            this.add("raster_overviews");
            this.add("dbtune");
            this.add("gdb_itemrelationships");
            this.add("gdb_itemrelationshiptypes");
            this.add("gdb_items");
            this.add("gdb_itemtypes");
            this.add("gdb_replicalog");
            this.add("gdb_tables_last_modified");
            this.add("spatial_ref_sys");
            this.add("st_geometry_columns");
            this.add("st_spatial_references");
        }
    };
    protected static Pattern bS;
    protected static final Map<String, List<String>> bT;

    public aq(IWorkspaceFactory iWorkspaceFactory, String string, String string2, String string3, Map map) {
        super(iWorkspaceFactory, string, string2, string3, map);
        this.bO = new au(this);
    }

    public aq(IWorkspaceFactory iWorkspaceFactory, Connection connection, String string, String string2, Map map) {
        super(iWorkspaceFactory, connection, string, string2, map);
        this.bO = new au(this);
    }

    @Override
    public String getDriverClassName() {
        return "org.postgresql.Driver";
    }

    @Override
    public String getJdbcUrl() {
        String string = "jdbc:postgresql://" + this.url;
        if (this.options != null && this.options.size() > 0) {
            string = string.contains("?") ? string + "&" : string + "?";
            string = string + this.getConnectOptionsStr();
        }
        return string;
    }

    @Override
    public void setUseMetaTable(boolean bl) {
        this.bM = bl;
    }

    @Override
    public void afterConnected() {
        this.bL = this.dataExist("select extname from pg_catalog.pg_extension where extname='postgis'", new Object[0]);
        if (this.bM) {
            if (this.bO.H(bK)) {
                this.bN = bK;
                this.bM = true;
            } else if (this.bO.H(this.userName)) {
                this.bN = this.userName;
                this.bM = true;
            } else {
                this.bM = false;
            }
        }
        try {
            List<Map<String, Object>> list = this.queryList("SELECT unnest(current_schemas(false)) AS schema_name", new Object[0]);
            this.bP.clear();
            for (Map<String, Object> map : list) {
                String string2 = map.get("schema_name").toString();
                if (this.bQ.contains(string2)) continue;
                this.bP.add(string2);
            }
        }
        catch (Exception exception) {
            this.log.error("\u641c\u7d22\u8def\u5f84\u67e5\u8be2\u5931\u8d25", (Throwable)exception);
        }
        try {
            bT.computeIfAbsent(this.url, string -> {
                List<Map<String, Object>> list = this.queryList("SELECT word FROM pg_get_keywords() WHERE catcode IN ('R', 'T', 'C')", new Object[0]);
                return Optional.ofNullable(list).orElseGet(ArrayList::new).stream().map(map -> map.get("word").toString()).collect(Collectors.toList());
            });
        }
        catch (Exception exception) {
            this.log.error("\u7cfb\u7edf\u4fdd\u7559\u5b57\u67e5\u8be2\u5931\u8d25", (Throwable)exception);
        }
    }

    @Override
    public IFeatureWorkspace clone() {
        return new PgWorkspaceFactory().openWorkspace(this.url, this.userName, this.password, this.options);
    }

    @Override
    public List<String> getDatabaseNames() {
        List<Map<String, Object>> list = this.queryList("select datname from pg_database where datistemplate='f' and datallowconn='t' order by datname", new Object[0]);
        List<String> list2 = list.stream().map(map -> map.get("datname").toString()).collect(Collectors.toList());
        return list2;
    }

    @Override
    public List<String> getSchemaNames() {
        List<Map<String, Object>> list = this.queryList("select nspname as schema_name from pg_catalog.pg_namespace N where has_schema_privilege(current_user, nspname, 'USAGE') and nspname not like 'pg%' and nspname not in (" + this.bQ.stream().map(string -> "'" + string + "'").collect(Collectors.joining(",")) + ") order by case when nspname = current_schema then -1::bigint else N.oid::bigint end", new Object[0]);
        List<String> list2 = list.stream().map(map -> map.get("schema_name").toString()).collect(Collectors.toList());
        return list2;
    }

    @Override
    public void synchronize(String string) {
        aw aw2 = new aw(this);
        aw2.N(string);
    }

    @Override
    public void synchronize(RegisterDatasetParams registerDatasetParams) {
        aw aw2 = new aw(this);
        aw2.a(registerDatasetParams);
    }

    @Override
    public void synchronizeDataset(String string) {
        aw aw2 = new aw(this);
        IGeoDataset iGeoDataset = this.openGeoDataset(string);
        if (iGeoDataset != null) {
            if (iGeoDataset.getType() == GeoDatasetType.FeatureDataset || iGeoDataset.getType() == GeoDatasetType.MosaicDataset || iGeoDataset.getType() == GeoDatasetType.GroupDataset) {
                if (iGeoDataset.getSubsets() != null) {
                    for (IGeoDataset iGeoDataset2 : iGeoDataset.getSubsets()) {
                        z z2 = new z(iGeoDataset2);
                        aw2.h(z2.bq, z2.br);
                    }
                }
            } else {
                z z3 = new z(iGeoDataset);
                if (iGeoDataset.getType() == GeoDatasetType.FeatureClass) {
                    IFeatureClass iFeatureClass = (IFeatureClass)iGeoDataset;
                    iGeoDataset = aw2.b(z3.bq, z3.br, iFeatureClass.getShapeFieldName());
                } else {
                    iGeoDataset = aw2.h(z3.bq, z3.br);
                }
            }
        } else {
            z z4 = new z(string, false);
            iGeoDataset = aw2.h(z4.bq, z4.br);
        }
    }

    @Override
    public void synchronize() {
        aw aw2 = new aw(this);
        aw2.L();
    }

    @Override
    public List<IGeoDataset> getDatasets(String string, GeoDatasetType ... geoDatasetTypeArray) {
        if (this.bM) {
            return this.bO.a(string, geoDatasetTypeArray);
        }
        List<IGeoDataset> list = this.v(string);
        if (geoDatasetTypeArray == null) {
            return list;
        }
        return list.stream().filter(iGeoDataset -> Arrays.asList(geoDatasetTypeArray).contains((Object)iGeoDataset.getType())).collect(Collectors.toList());
    }

    protected boolean g(String string) {
        if (this.connection != null) {
            if (string.contains(".")) {
                z z2 = new z(string, true);
                String string2 = "select table_name from information_schema.tables where lower(table_name)=? and table_schema =?";
                if (super.queryScalar(string2, z2.br, z2.bq) != null) {
                    return true;
                }
            } else {
                String string3 = "select table_name from information_schema.tables where lower(table_name)=?";
                if (super.queryScalar(string3, string.toLowerCase()) != null) {
                    return true;
                }
            }
            return false;
        }
        throw new RuntimeException("\u8fde\u63a5\u672a\u6253\u5f00\uff01");
    }

    protected boolean e(String string, String string2) {
        if (this.connection != null) {
            z z2 = new z(string, true);
            String string3 = "SELECT * FROM information_schema.COLUMNS where table_schema=? and table_name=? and lower(column_name)=?";
            return super.dataExist(string3, z2.bq, z2.br, string2.toLowerCase());
        }
        throw new RuntimeException("\u8fde\u63a5\u672a\u6253\u5f00\uff01");
    }

    @Override
    public List<IGeoDataset> getDatasets() {
        if (this.bM) {
            return this.bO.H();
        }
        return this.v(null);
    }

    @Override
    public List<IGeoDataset> getDatasets(GeoDatasetType ... geoDatasetTypeArray) {
        if (this.bM) {
            return this.bO.a(geoDatasetTypeArray);
        }
        List<IGeoDataset> list = this.v(null);
        if (geoDatasetTypeArray == null) {
            return list;
        }
        return list.stream().filter(iGeoDataset -> Arrays.asList(geoDatasetTypeArray).contains((Object)iGeoDataset.getType())).collect(Collectors.toList());
    }

    @Override
    public List<String> getDatasetNames(GeoDatasetType geoDatasetType) {
        return null;
    }

    @Override
    public boolean datasetExist(String string) {
        if (this.bM && this.bO.J(string)) {
            return true;
        }
        return this.g(string);
    }

    @Override
    public IGeoDataset openGeoDataset(String string) {
        IGeoDataset iGeoDataset = null;
        if (this.bM) {
            iGeoDataset = this.bO.K(string);
        }
        if (iGeoDataset == null) {
            iGeoDataset = this.h(string);
        }
        return iGeoDataset;
    }

    @Override
    public ICursor excuteQuerySql(String string) {
        return new al(this, string, null);
    }

    @Override
    public ICursor excuteQuerySql(String string, Object ... objectArray) {
        return new al(this, string, objectArray);
    }

    @Override
    public IFeatureDataset openFeatureDataset(String string) {
        if (this.bM) {
            return (IFeatureDataset)this.bO.a(GeoDatasetType.FeatureDataset, string);
        }
        return null;
    }

    @Override
    public IFeatureDataset createFeatureDataset(String string, ISpatialReferenceSystem iSpatialReferenceSystem) {
        try {
            this.beginTransaction();
            z z2 = this.t(string);
            ag ag2 = new ag(this, z2.name, z2.name);
            ag2.f(z2.bj);
            ag2.a(iSpatialReferenceSystem);
            this.bO.c(ag2);
            this.commitTransaction();
            return ag2;
        }
        catch (Exception exception) {
            this.rollbackTransaction();
            throw exception;
        }
    }

    @Override
    public IFeatureClass openFeatureClass(String string) {
        IGeoDataset iGeoDataset = null;
        if (this.bM) {
            iGeoDataset = this.bO.a(GeoDatasetType.FeatureClass, string);
        }
        if (iGeoDataset == null) {
            iGeoDataset = this.h(string);
        }
        if (iGeoDataset instanceof IFeatureClass) {
            return (IFeatureClass)iGeoDataset;
        }
        return null;
    }

    @Override
    public IFeatureClass createFeatureClass(String string, IFields iFields, FeatureType featureType, String string2, String string3) {
        return this.a(string, iFields, featureType, string2, string3, null);
    }

    protected IFeatureClass a(String string, IFields iFields, FeatureType featureType, String string2, String string3, IGeoDataset iGeoDataset) {
        Object object;
        z z2 = this.t(string);
        String string4 = z2.bq + "." + z2.name;
        String string5 = null;
        if (iGeoDataset != null) {
            object = new z(iGeoDataset);
            string4 = ((z)object).bq + "." + z2.name;
            string5 = ((z)object).name;
        }
        if (this.datasetExist(string4)) {
            throw new RuntimeException(string + "\u5df2\u5b58\u5728");
        }
        object = Arrays.stream(iFields.toArray()).filter(iField -> iField.getFieldType() == FieldType.OID).findFirst().orElse(null);
        if (object == null) {
            throw new RuntimeException("\u4e0d\u5305\u542boid\u5b57\u6bb5\uff01");
        }
        GeometryField geometryField = Arrays.stream(iFields.toArray()).filter(iField -> iField.getName().equalsIgnoreCase(string2)).findFirst().orElse(null);
        if (geometryField == null) {
            throw new RuntimeException("\u4e0d\u5305\u542b\u51e0\u4f55\u5b57\u6bb5\uff01");
        }
        try {
            this.beginTransaction();
            IFeatureClass iFeatureClass = this.a(string4, iFields, featureType, (IField)object, geometryField, string3, string5);
            this.bO.c(iFeatureClass);
            this.commitTransaction();
            return iFeatureClass;
        }
        catch (Exception exception) {
            this.rollbackTransaction();
            throw exception;
        }
    }

    protected IFeatureClass a(String string, IFields iFields, FeatureType featureType, IField iField, GeometryField geometryField, String string2, String string3) {
        String string4 = "GEOMETRY";
        if (featureType == FeatureType.Unknown) {
            featureType = FeatureType.getByGeometryType(geometryField.getGeometryType());
        }
        if (geometryField.getCoordinateType() == CoordinateType.ZM) {
            string4 = string4 + "ZM";
        } else if (geometryField.getCoordinateType() == CoordinateType.Z) {
            string4 = string4 + "Z";
        } else if (geometryField.getCoordinateType() == CoordinateType.M) {
            string4 = string4 + "M";
        }
        int n2 = 0;
        if (geometryField.getSpatialReferenceSystem() != null && (n2 = geometryField.getSpatialReferenceSystem().getSrid()) == 0) {
            n2 = this.b(geometryField.getSpatialReferenceSystem());
        }
        z z2 = new z(string, true);
        String string5 = z2.br;
        String string6 = z2.bj;
        if (!this.u(string5)) {
            throw new IllegalArgumentException(String.format("[%s]\u540d\u79f0\u53ea\u80fd\u5305\u542b\u5927\u5c0f\u5199\u5b57\u6bcd\u3001\u6570\u5b57\u3001\u4e0b\u5212\u7ebf\u3001\u4e2d\u6587\uff0c\u4e14\u4e0d\u4ee5\u6570\u5b57\u5f00\u5934\uff0c\u957f\u5ea6\u5c0f\u4e8e63", z2.name));
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("CREATE TABLE " + string6 + "(\n");
        stringBuilder.append(iField.getName() + " SERIAL PRIMARY KEY,\n");
        stringBuilder.append(String.format("%s geometry(%s,%s),\n", geometryField.getName(), string4, n2));
        for (IField iField2 : iFields) {
            if (iField2.getName().equalsIgnoreCase(iField.getName()) || iField2.getName().equalsIgnoreCase(geometryField.getName())) continue;
            stringBuilder.append(this.h(iField2) + ",\n");
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 2);
        stringBuilder.append(")");
        this.excuteSql(stringBuilder.toString());
        af af2 = new af(this, z2.name, z2.name, featureType);
        af2.f(string6);
        af2.a((IEnvelope)null);
        af2.a(geometryField.getSpatialReferenceSystem());
        af2.setOidFieldName(iField.getName());
        af2.setShapeFieldName(geometryField.getName());
        af2.setGeometryType(geometryField.getGeometryType());
        af2.setCoordinateType(geometryField.getCoordinateType());
        af2.a(av.c(geometryField.getSpatialReferenceSystem()));
        af2.setParentDatasetName(string3);
        af2.b(string2);
        af2.a(iFields);
        return af2;
    }

    @Override
    public ITable openTable(String string) {
        IGeoDataset iGeoDataset = null;
        if (this.bM) {
            iGeoDataset = this.bO.a(GeoDatasetType.Table, string);
        }
        if (iGeoDataset == null) {
            iGeoDataset = this.h(string);
        }
        if (iGeoDataset instanceof ITable) {
            return (ITable)iGeoDataset;
        }
        return null;
    }

    @Override
    public ITable createTable(String string, IFields iFields) {
        if (this.datasetExist(string)) {
            throw new RuntimeException(string + "\u5df2\u5b58\u5728");
        }
        try {
            this.beginTransaction();
            IField iField2 = Arrays.stream(iFields.toArray()).filter(iField -> iField.getFieldType() == FieldType.OID).findFirst().orElse(null);
            ITable iTable = this.a(string, iFields, iField2, null);
            this.bO.c(iTable);
            this.commitTransaction();
            return iTable;
        }
        catch (Exception exception) {
            this.rollbackTransaction();
            throw exception;
        }
    }

    protected ITable a(String string, IFields iFields, IField iField, IGeoDataset iGeoDataset) {
        Object object;
        z z2 = this.t(string);
        String string2 = z2.bj;
        String string3 = null;
        if (iGeoDataset != null) {
            object = new z(iGeoDataset);
            string2 = ((z)object).bq + "." + z2.br;
            string3 = ((z)object).name;
        }
        if (!this.u((String)(object = z2.br))) {
            throw new IllegalArgumentException(String.format("[%s]\u540d\u79f0\u53ea\u80fd\u5305\u542b\u5927\u5c0f\u5199\u5b57\u6bcd\u3001\u6570\u5b57\u3001\u4e0b\u5212\u7ebf\u3001\u4e2d\u6587\uff0c\u4e14\u4e0d\u4ee5\u6570\u5b57\u5f00\u5934\uff0c\u957f\u5ea6\u5c0f\u4e8e63", string));
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("CREATE TABLE " + string2 + "(\n");
        if (iField != null) {
            stringBuilder.append(iField.getName() + " SERIAL PRIMARY KEY,\n");
        }
        for (IField iField2 : iFields) {
            if (iField != null && iField2.getName().equalsIgnoreCase(iField.getName())) continue;
            stringBuilder.append(this.h(iField2) + ",\n");
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 2);
        stringBuilder.append(")");
        this.excuteSql(stringBuilder.toString());
        am am2 = new am(this, z2.name, z2.name);
        am2.f(string2);
        am2.setOidFieldName(iField == null ? null : iField.getName());
        am2.a(iFields);
        am2.setParentDatasetName(string3);
        return am2;
    }

    @Override
    public ITableView openTableView(String string) {
        IGeoDataset iGeoDataset = null;
        if (this.bM) {
            iGeoDataset = this.bO.a(GeoDatasetType.TableView, string);
        }
        if (iGeoDataset == null) {
            iGeoDataset = this.h(string);
        }
        if (iGeoDataset instanceof ITableView) {
            return (ITableView)iGeoDataset;
        }
        return null;
    }

    @Override
    public ITableView createTableView(String string, String string2) {
        z z2 = this.t(string);
        String string3 = z2.br;
        String string4 = z2.bj;
        if (!this.u(string3)) {
            throw new IllegalArgumentException(String.format("[%s]\u540d\u79f0\u53ea\u80fd\u5305\u542b\u5927\u5c0f\u5199\u5b57\u6bcd\u3001\u6570\u5b57\u3001\u4e0b\u5212\u7ebf\u3001\u4e2d\u6587\uff0c\u4e14\u4e0d\u4ee5\u6570\u5b57\u5f00\u5934\uff0c\u957f\u5ea6\u5c0f\u4e8e63", string));
        }
        if (this.datasetExist(string)) {
            throw new RuntimeException(string + "\u5df2\u5b58\u5728");
        }
        try {
            this.beginTransaction();
            String string5 = "CREATE VIEW " + string4 + " AS " + string2;
            this.excuteSql(string5);
            ao ao2 = new ao(this, z2.name, z2.name);
            ao2.f(string4);
            ao2.s(string2);
            this.bO.c(ao2);
            this.commitTransaction();
            return ao2;
        }
        catch (Exception exception) {
            this.rollbackTransaction();
            throw exception;
        }
    }

    @Override
    public IMosaicDataset openMosaicDataset(String string) {
        if (this.bM) {
            return (IMosaicDataset)this.bO.a(GeoDatasetType.MosaicDataset, string);
        }
        return null;
    }

    @Override
    public IMosaicDataset createMosaicDataset(String string, IFields iFields, ISpatialReferenceSystem iSpatialReferenceSystem, int n2, PixelDataType pixelDataType) {
        z z2 = this.t(string);
        String string2 = z2.br;
        String string3 = z2.bj;
        if (!this.u(string2)) {
            throw new IllegalArgumentException(String.format("[%s]\u540d\u79f0\u53ea\u80fd\u5305\u542b\u5927\u5c0f\u5199\u5b57\u6bcd\u3001\u6570\u5b57\u3001\u4e0b\u5212\u7ebf\u3001\u4e2d\u6587\uff0c\u4e14\u4e0d\u4ee5\u6570\u5b57\u5f00\u5934\uff0c\u957f\u5ea6\u5c0f\u4e8e63", string));
        }
        try {
            Object object2;
            this.beginTransaction();
            ak ak2 = new ak(this, z2.name, z2.name);
            ak2.f(string3);
            ak2.a(iSpatialReferenceSystem);
            Field field = new Field("objectid", "objectid", FieldType.OID);
            GeometryField geometryField = new GeometryField("Shape", "Shape", GeometryType.Polygon, iSpatialReferenceSystem);
            Fields fields = new Fields();
            fields.addField(field);
            fields.addField(geometryField);
            fields.addField(new Field("raster", "raster", FieldType.String, 2000));
            fields.addField(new Field("name", "name", FieldType.String, 512));
            fields.addField(new Field("minps", "minps", FieldType.Double));
            fields.addField(new Field("maxps", "maxps", FieldType.Double));
            fields.addField(new Field("lowps", "lowps", FieldType.Double));
            fields.addField(new Field("highps", "highps", FieldType.Double));
            fields.addField(new Field("category", "category", FieldType.Int));
            fields.addField(new Field("tag", "tag", FieldType.String, 20));
            fields.addField(new Field("centerx", "centerx", FieldType.Double));
            fields.addField(new Field("centery", "centery", FieldType.Double));
            fields.addField(new Field("sorder", "sorder", FieldType.Int));
            fields.addField(new Field("zorder", "zorder", FieldType.Int));
            fields.addField(new Field("typeid", "typeid", FieldType.Int));
            fields.addField(new Field("itemts", "itemts", FieldType.Double));
            fields.addField(new Field("uri", "uri", FieldType.Blob));
            fields.addField(new Field("urihash", "urihash", FieldType.String, 1024));
            fields.addField(new Field("rasterdata", "rasterdata", FieldType.Blob));
            fields.addField(new Field("datasize", "datasize", FieldType.Long));
            if (iFields != null) {
                for (Object object2 : iFields) {
                    fields.addField((IField)object2);
                }
            }
            String string4 = z2.bq + ".GWMD_" + z2.name + "_CAT";
            object2 = this.a(string4, fields, FeatureType.Unknown, field, geometryField, "", z2.name);
            String string5 = z2.bq + ".GWMD_" + z2.name + "_BND";
            fields = new Fields();
            fields.addField(field);
            fields.addField(geometryField);
            IFeatureClass iFeatureClass = this.a(string5, fields, FeatureType.Unknown, field, geometryField, "", z2.name);
            String string6 = z2.bq + ".GWMD_" + z2.name + "_ART";
            fields = new Fields();
            fields.addField(field);
            fields.addField(new Field("typename", "typename", FieldType.String, 50));
            fields.addField(new Field("rastertype", "rastertype", FieldType.Blob));
            fields.addField(new Field("description", "description", FieldType.String, 50));
            fields.addField(new Field("firstadd", "firstadd", FieldType.DateTime));
            fields.addField(new Field("lastadd", "lastadd", FieldType.DateTime));
            fields.addField(new Field("lastsync", "lastsync", FieldType.DateTime));
            ITable iTable = this.a(string6, fields, field, ak2);
            ak2.a((IFeatureClass)object2);
            ak2.b(iFeatureClass);
            RasterInfo rasterInfo = new RasterInfo();
            rasterInfo.setBandCount(Integer.valueOf(n2));
            rasterInfo.setPixelDataType(pixelDataType);
            rasterInfo.setXResolution(Double.valueOf(-1.0));
            rasterInfo.setYResolution(Double.valueOf(-1.0));
            rasterInfo.setHasInvalidValue(Boolean.valueOf(true));
            rasterInfo.setInvalidValue(new Double[n2 > 0 ? n2 : 1]);
            Arrays.fill((Object[])rasterInfo.getInvalidValue(), (Object)0.0);
            rasterInfo.setExtent(GeometryFunc.createEnvelope((double)at.cS, (double)at.cS, (double)at.cT, (double)at.cT));
            rasterInfo.setSpatialReferenceSystem(iSpatialReferenceSystem);
            ak2.a(rasterInfo);
            List<IGeoDataset> list = Arrays.asList(object2, iFeatureClass, iTable);
            ak2.a(Collections.unmodifiableList(list));
            this.bO.c(ak2);
            this.commitTransaction();
            return ak2;
        }
        catch (Exception exception) {
            this.rollbackTransaction();
            throw exception;
        }
    }

    @Override
    public IGroupDataset openGroupDataset(String string) {
        if (this.bM) {
            return (IGroupDataset)this.bO.a(GeoDatasetType.GroupDataset, string);
        }
        return null;
    }

    @Override
    public IGroupDataset createGroupDataset(String string, String string2) {
        try {
            this.beginTransaction();
            z z2 = this.t(string);
            ah ah2 = new ah(this, z2.name, string2);
            ah2.f(z2.bj);
            this.bO.c(ah2);
            this.commitTransaction();
            return ah2;
        }
        catch (Exception exception) {
            this.rollbackTransaction();
            throw exception;
        }
    }

    @Override
    public FieldType convertFieldType(int n2) {
        FieldType fieldType = super.convertFieldType(n2);
        if (fieldType == FieldType.Unknown && n2 == 1111) {
            fieldType = FieldType.Shape;
        }
        return fieldType;
    }

    protected ICursor b(ITable iTable) {
        return new aj(this, iTable);
    }

    protected boolean b(String string, String string2) {
        return this.dataExist("SELECT 1 FROM pg_class c JOIN pg_namespace n ON c.relnamespace = n.oid where n.nspname = ? and relname=?", string, string2);
    }

    protected Long c(String string, String string2) {
        String string3 = "SELECT reltuples FROM pg_class c JOIN pg_namespace n ON c.relnamespace = n.oid WHERE n.nspname = ? AND c.relname = ?";
        Object object = this.queryScalar(string3, string, string2);
        if (object != null) {
            return Float.valueOf(object.toString()).longValue();
        }
        return -1L;
    }

    protected Long d(String string, String string2) {
        String string3 = String.format("select pg_total_relation_size('%s.\"%s\"')", string, string2);
        Object object = this.queryScalar(string3, new Object[0]);
        if (object != null) {
            return Long.valueOf(object.toString());
        }
        return 0L;
    }

    protected boolean q(String string) {
        String string2 = "SELECT CASE WHEN EXISTS (SELECT 1 FROM pg_namespace WHERE nspname = ?) THEN has_schema_privilege(?, 'CREATE') ELSE false END AS has_privilege";
        Object object = this.queryScalar(string2, string, string);
        return Boolean.TRUE.equals(object);
    }

    protected z t(String string) {
        int n2 = string.indexOf(".");
        if (n2 <= 0) {
            for (String string2 : this.bP) {
                if (!this.q(string2)) continue;
                return new z(string2 + "." + string, true);
            }
        }
        return new z(string, true);
    }

    protected boolean u(String string) {
        if (!bS.matcher(string).matches()) {
            return false;
        }
        return string.length() <= 63;
    }

    protected String h(IField iField) {
        String string = iField.getName();
        if (iField.getPhysicalName() != null && !iField.getPhysicalName().isEmpty()) {
            string = "\"" + iField.getPhysicalName().trim() + "\"";
        } else if (((List)bT.getOrDefault(this.url, new ArrayList())).contains(iField.getName().toLowerCase()) || !this.u(iField.getName())) {
            iField.setPhysicalName(iField.getName().trim());
            string = "\"" + iField.getName().trim() + "\"";
        }
        switch (iField.getFieldType()) {
            case Boolean: {
                iField.setLength(1);
                iField.setScale(null);
                string = string + " bool";
                if (!iField.getNullable().booleanValue()) {
                    string = string + " NOT NULL";
                }
                if (iField.getDefaultValue() == null || iField.getDefaultValue().toString().length() <= 0) break;
                if (Boolean.parseBoolean(iField.getDefaultValue().toString())) {
                    string = string + " DEFAULT 't'";
                    break;
                }
                string = string + " DEFAULT 'f'";
                break;
            }
            case Byte: {
                string = iField.getLength() == null || iField.getLength() < 1 ? string + " char" : string + String.format(" char(%d)", iField.getLength());
                iField.setScale(null);
                if (!iField.getNullable().booleanValue()) {
                    string = string + " NOT NULL";
                }
                if (iField.getDefaultValue() == null || iField.getDefaultValue().toString().length() <= 0) break;
                string = string + " DEFAULT '" + this.f(iField.getDefaultValue().toString(), "'") + "'";
                break;
            }
            case Decimal: {
                string = iField.getLength() == null || iField.getLength() < 1 || iField.getScale() == null || iField.getScale() < 0 ? string + " numeric" : string + String.format(" numeric(%d,%d)", iField.getLength(), iField.getScale());
                if (!iField.getNullable().booleanValue()) {
                    string = string + " NOT NULL";
                }
                if (iField.getDefaultValue() == null || iField.getDefaultValue().toString().length() <= 0 || !NumberUtils.isCreatable((String)iField.getDefaultValue().toString())) break;
                string = string + " DEFAULT " + iField.getDefaultValue().toString();
                break;
            }
            case Double: {
                iField.setLength(53);
                iField.setScale(null);
                string = string + " float8";
                if (!iField.getNullable().booleanValue()) {
                    string = string + " NOT NULL";
                }
                if (iField.getDefaultValue() == null || iField.getDefaultValue().toString().length() <= 0 || !NumberUtils.isCreatable((String)iField.getDefaultValue().toString())) break;
                string = string + " DEFAULT " + iField.getDefaultValue().toString();
                break;
            }
            case Short: {
                iField.setLength(16);
                iField.setScale(null);
                string = string + " int2";
                if (!iField.getNullable().booleanValue()) {
                    string = string + " NOT NULL";
                }
                if (iField.getDefaultValue() == null || iField.getDefaultValue().toString().length() <= 0 || !NumberUtils.isCreatable((String)iField.getDefaultValue().toString())) break;
                string = string + " DEFAULT " + iField.getDefaultValue().toString();
                break;
            }
            case String: {
                string = iField.getLength() == null || iField.getLength() < 1 ? string + " varchar" : string + String.format(" varchar(%d)", iField.getLength());
                if (!iField.getNullable().booleanValue()) {
                    string = string + " NOT NULL";
                }
                if (iField.getDefaultValue() == null) break;
                string = string + " DEFAULT '" + this.f(iField.getDefaultValue().toString(), "'") + "'";
                break;
            }
            case Int: {
                iField.setLength(32);
                iField.setScale(null);
                string = string + " int4";
                if (!iField.getNullable().booleanValue()) {
                    string = string + " NOT NULL";
                }
                if (iField.getDefaultValue() == null || iField.getDefaultValue().toString().length() <= 0 || !NumberUtils.isCreatable((String)iField.getDefaultValue().toString())) break;
                string = string + " DEFAULT " + iField.getDefaultValue().toString();
                break;
            }
            case Long: {
                iField.setLength(64);
                iField.setScale(null);
                string = string + " int8";
                if (!iField.getNullable().booleanValue()) {
                    string = string + " NOT NULL";
                }
                if (iField.getDefaultValue() == null || iField.getDefaultValue().toString().length() <= 0 || !NumberUtils.isCreatable((String)iField.getDefaultValue().toString())) break;
                string = string + " DEFAULT " + iField.getDefaultValue().toString();
                break;
            }
            case Float: {
                iField.setLength(24);
                iField.setScale(null);
                string = string + " float4";
                if (!iField.getNullable().booleanValue()) {
                    string = string + " NOT NULL";
                }
                if (iField.getDefaultValue() == null || iField.getDefaultValue().toString().length() <= 0 || !NumberUtils.isCreatable((String)iField.getDefaultValue().toString())) break;
                string = string + " DEFAULT " + iField.getDefaultValue().toString();
                break;
            }
            case DateTime: {
                iField.setLength(6);
                iField.setScale(null);
                string = string + " timestamp(6)";
                if (!iField.getNullable().booleanValue()) {
                    string = string + " NOT NULL";
                }
                if (iField.getDefaultValue() == null || iField.getDefaultValue().toString().length() <= 0) break;
                if (iField.getDefaultValue().toString().equals("NULL")) {
                    string = string + " DEFAULT NULL";
                    break;
                }
                string = string + " DEFAULT '" + this.f(iField.getDefaultValue().toString(), "'") + "'";
                break;
            }
            case Blob: {
                iField.setLength(0);
                iField.setScale(null);
                string = string + " bytea";
                if (iField.getNullable().booleanValue()) break;
                string = string + " NOT NULL";
                break;
            }
            case Text: {
                iField.setLength(0);
                iField.setScale(null);
                string = string + " text";
                if (!iField.getNullable().booleanValue()) {
                    string = string + " NOT NULL";
                }
                if (iField.getDefaultValue() == null || iField.getDefaultValue().toString().length() <= 0) break;
                string = string + " DEFAULT '" + this.f(iField.getDefaultValue().toString(), "'") + "'";
                break;
            }
            default: {
                throw new RuntimeException(iField.getName() + "\u4e0d\u652f\u6301\u7684\u5b57\u6bb5\u7c7b\u578b\uff1a" + (Object)((Object)iField.getFieldType()));
            }
        }
        return string;
    }

    protected String f(String string, String string2) {
        String string3 = string;
        if (string.startsWith(string2)) {
            string3 = string.substring(string2.length());
        }
        if (string3.endsWith(string2)) {
            string3 = string3.substring(0, string3.length() - string2.length());
        }
        return string3;
    }

    private int b(ISpatialReferenceSystem iSpatialReferenceSystem) {
        Object object = this.queryScalar(String.format("select srid from spatial_ref_sys where srtext=? or proj4text=?", new Object[0]), iSpatialReferenceSystem.getWkt(), iSpatialReferenceSystem.exportToProj4());
        if (object != null) {
            return Integer.parseInt(object.toString());
        }
        this.log.error("spatial_ref_sys\u4e2d\u672a\u627e\u5bf9\u5e94\u7684\u7a7a\u95f4\u53c2\u8003\uff1a\n" + iSpatialReferenceSystem.getWkt() + "\n", (Object)iSpatialReferenceSystem.exportToProj4());
        return 0;
    }

    protected String a(ITable iTable, IQueryFilter iQueryFilter) {
        if (iQueryFilter == null || iQueryFilter.getSubFields() == null || iQueryFilter.getSubFields().trim().length() == 0 || iQueryFilter.getSubFields().trim().equals("*")) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (IField iField : iTable.getFields()) {
                if (iField.getPhysicalName() != null && !iField.getPhysicalName().isEmpty()) {
                    arrayList.add("\"" + iField.getPhysicalName() + "\"");
                    continue;
                }
                arrayList.add(iField.getName());
            }
            return String.join((CharSequence)",", arrayList);
        }
        return iQueryFilter.getSubFields();
    }

    @Override
    public String getWhereClause(ITable iTable, IQueryFilter iQueryFilter) {
        if (iQueryFilter == null) {
            return "";
        }
        String string = "";
        if (iQueryFilter.getWhereClause() != null && iQueryFilter.getWhereClause().trim().length() > 0) {
            string = iQueryFilter.getWhereClause();
        }
        if (iQueryFilter instanceof ISpatialFilter && ((ISpatialFilter)iQueryFilter).getGeometry() != null) {
            Object object;
            ISpatialFilter iSpatialFilter = (ISpatialFilter)iQueryFilter;
            String string2 = iSpatialFilter.getGeometryField();
            IField iField = null;
            int n2 = 0;
            if (string2 == null || string2.trim().length() == 0) {
                if (iTable.getType() == GeoDatasetType.FeatureClass) {
                    object = (IFeatureClass)((Object)iTable);
                    iField = iTable.getFields().findField(object.getShapeFieldName());
                    if (object.getSpatialReferenceSystem() != null) {
                        n2 = object.getSpatialReferenceSystem().getSrid();
                    }
                } else {
                    for (SpatialRelationType[] spatialRelationTypeArray : iTable.getFields()) {
                        if (!(spatialRelationTypeArray instanceof GeometryField)) continue;
                        GeometryField geometryField = (GeometryField)spatialRelationTypeArray;
                        iField = spatialRelationTypeArray;
                        if (geometryField.getSpatialReferenceSystem() != null) {
                            n2 = geometryField.getSpatialReferenceSystem().getSrid();
                        }
                        break;
                    }
                }
            } else {
                iField = iTable.getFields().findField(string2);
                if (!(iField instanceof GeometryField)) {
                    throw new RuntimeException(string2 + "\u51e0\u4f55\u5b57\u6bb5\u4e0d\u5b58\u5728");
                }
                object = (GeometryField)iField;
                if (((GeometryField)object).getSpatialReferenceSystem() != null) {
                    n2 = ((GeometryField)object).getSpatialReferenceSystem().getSrid();
                }
            }
            if (iField != null) {
                if (string != null && string.trim().length() > 0) {
                    string = String.format("(%s) and ", string);
                }
                if (iSpatialFilter.getSpatialRels() != null && iSpatialFilter.getSpatialRels().length > 0) {
                    object = new ArrayList();
                    for (SpatialRelationType spatialRelationType : iSpatialFilter.getSpatialRels()) {
                        if (spatialRelationType == SpatialRelationType.Overlaps) {
                            String string3 = this.a(SpatialRelationType.Intersects, iSpatialFilter.getGeometry().toWkt(), n2, iField);
                            string3 = String.format("(%s and not %s)", string3, this.a(SpatialRelationType.Touches, iSpatialFilter.getGeometry().toWkt(), n2, iField));
                            object.add(string3);
                            continue;
                        }
                        object.add(this.a(spatialRelationType, iSpatialFilter.getGeometry().toWkt(), n2, iField));
                    }
                    string = string + String.format("(%s)", String.join((CharSequence)" or ", (Iterable<? extends CharSequence>)object));
                } else if (iSpatialFilter.getSpatialRel() == SpatialRelationType.Overlaps) {
                    object = this.a(SpatialRelationType.Intersects, iSpatialFilter.getGeometry().toWkt(), n2, iField);
                    object = String.format("(%s and not %s)", object, this.a(SpatialRelationType.Touches, iSpatialFilter.getGeometry().toWkt(), n2, iField));
                    string = string + (String)object;
                } else {
                    string = string + this.a(iSpatialFilter.getSpatialRel(), iSpatialFilter.getGeometry().toWkt(), n2, iField);
                }
            }
        }
        if (string != null && string.trim().length() > 0) {
            string = " where " + string;
        }
        return string;
    }

    private String a(SpatialRelationType spatialRelationType, String string, int n2, IField iField) {
        String string2;
        switch (spatialRelationType) {
            case Equals: {
                string2 = "ST_Equals";
                break;
            }
            case Intersects: {
                string2 = "ST_Intersects";
                break;
            }
            case Contains: {
                string2 = "ST_Contains";
                break;
            }
            case Crosses: {
                string2 = "ST_Crosses";
                break;
            }
            case Disjoint: {
                string2 = "ST_Disjoint";
                break;
            }
            case Overlaps: {
                string2 = "ST_Overlaps";
                break;
            }
            case Touches: {
                string2 = "ST_Touches";
                break;
            }
            case Within: {
                string2 = "ST_Within";
                break;
            }
            default: {
                throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u7a7a\u95f4\u5173\u7cfb\uff1a" + (Object)((Object)spatialRelationType));
            }
        }
        String string3 = iField.getName();
        if (iField.getPhysicalName() != null && !iField.getPhysicalName().isEmpty()) {
            string3 = "\"" + iField.getPhysicalName() + "\"";
        }
        return String.format("%s(st_geomfromtext('%s',  %d),  %s)", string2, string, n2, string3);
    }

    protected IGeometry a(Object object) {
        if (object != null) {
            if (object instanceof byte[]) {
                return GeometryFunc.createGeometry((byte[])((byte[])object));
            }
            if (object instanceof String) {
                return GeometryFunc.createGeometryFromHex((String)((String)object));
            }
            if (object instanceof PGgeometry) {
                PGgeometry pGgeometry = (PGgeometry)object;
                pGgeometry.getGeometry().setSrid(0);
                BinaryWriter binaryWriter = new BinaryWriter();
                byte[] byArray = binaryWriter.writeBinary(pGgeometry.getGeometry());
                return GeometryFunc.createGeometry((byte[])byArray);
            }
            throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u51e0\u4f55\u5bf9\u8c61\uff1a" + object.getClass().getName());
        }
        return null;
    }

    protected Object a(IGeometry iGeometry, int n2) {
        if (iGeometry == null || iGeometry.isEmpty()) {
            return null;
        }
        BinaryParser binaryParser = new BinaryParser();
        Geometry geometry = binaryParser.parse(iGeometry.toEWkb(n2));
        return new PGgeometry(geometry);
    }

    protected List<Map<String, Object>> a(String string, String string2, boolean bl) {
        String string3 = "WITH all_tables AS (SELECT table_schema,table_name,table_type FROM information_schema.tables WHERE has_schema_privilege(current_user, table_schema, 'USAGE') UNION (SELECT n.nspname AS table_schema,c.relname AS table_name,'MATERIALIZED VIEW' AS table_type FROM pg_class c JOIN pg_namespace n ON n.oid = c.relnamespace WHERE c.relkind = 'm' and pg_get_userbyid(c.relowner)='" + this.userName + "')) SELECT * FROM all_tables";
        if (this.bL) {
            string3 = string3 + " LEFT JOIN geometry_columns on table_schema=geometry_columns.f_table_schema AND table_name=geometry_columns.f_table_name";
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string != null) {
            string3 = string3 + " WHERE table_schema=?";
            arrayList.add(string);
        }
        if (string2 != null) {
            string3 = string != null ? string3 + " AND" : string3 + " WHERE";
            if (bl) {
                string3 = string3 + " lower(table_name)=?";
                arrayList.add(string2.toLowerCase());
            } else {
                string3 = string3 + " table_name=?";
                arrayList.add(string2);
            }
        }
        string3 = string3 + " ORDER BY table_name";
        List<Map<String, Object>> list = this.queryList(string3, arrayList.toArray());
        return list;
    }

    private List<IGeoDataset> v(String string) {
        ArrayList<IGeoDataset> arrayList = new ArrayList<IGeoDataset>();
        List<Map<String, Object>> list = this.a(string, null, false);
        for (Map<String, Object> map : list) {
            String string2 = map.get("table_schema").toString();
            String string3 = map.get("table_name").toString();
            String string4 = map.get("table_type").toString();
            String string5 = string2 + "." + string3;
            try {
                IGeoDataset iGeoDataset;
                if (this.bR.contains(string3) || (iGeoDataset = this.a(map, false)) == null) continue;
                arrayList.add(iGeoDataset);
            }
            catch (Exception exception) {
                this.log.error(string5 + "\u8bfb\u53d6\u5931\u8d25", (Throwable)exception);
            }
        }
        return arrayList;
    }

    protected IGeoDataset a(Map<String, Object> map, boolean bl) {
        String string = map.get("table_schema").toString();
        String string2 = map.get("table_name").toString();
        String string3 = map.get("table_type").toString();
        String string4 = string + "." + string2;
        if (string3.equals("VIEW")) {
            ao ao2 = new ao(this, string2, string2);
            ao2.f(string4);
            return ao2;
        }
        if (string3.equals("MATERIALIZED VIEW")) {
            an an2 = new an(this, string2, string2);
            an2.f(string4);
            return an2;
        }
        if (string3.equals("BASE TABLE")) {
            if (this.bL) {
                Object object = map.get("f_geometry_column");
                if (object == null) {
                    am am2 = new am(this, string2, string2);
                    am2.f(string4);
                    if (bl) {
                        List<IField> list = this.a(string, string2, am2);
                        am2.a(new Fields(list));
                        IField iField2 = list.stream().filter(iField -> iField.getFieldType() == FieldType.OID).findFirst().orElse(null);
                        am2.setOidFieldName(iField2 == null ? null : iField2.getName());
                    }
                    return am2;
                }
                String string5 = map.get("f_geometry_column").toString();
                String string6 = map.get("type") == null ? null : map.get("type").toString();
                String string7 = map.get("coord_dimension").toString();
                int n2 = (Integer)map.get("srid");
                GeometryType geometryType = this.x(string6);
                FeatureType featureType = FeatureType.getByGeometryType(geometryType);
                CoordinateType coordinateType = this.g(string6, string7);
                af af2 = new af(this, string2, string2, featureType);
                af2.f(string4);
                af2.setGeometryType(geometryType);
                af2.setCoordinateType(coordinateType);
                af2.setShapeFieldName(string5);
                af2.srid = n2;
                if (bl) {
                    List<IField> list = this.a(string, string2, af2);
                    af2.a(new Fields(list));
                    IField iField3 = list.stream().filter(iField -> iField.getFieldType() == FieldType.OID).findFirst().orElse(null);
                    af2.setOidFieldName(iField3 == null ? null : iField3.getName());
                }
                return af2;
            }
            am am3 = new am(this, string2, string2);
            am3.f(string4);
            if (bl) {
                List<IField> list = this.a(string, string2, am3);
                am3.a(new Fields(list));
                IField iField4 = list.stream().filter(iField -> iField.getFieldType() == FieldType.OID).findFirst().orElse(null);
                am3.setOidFieldName(iField4 == null ? null : iField4.getName());
            }
            return am3;
        }
        return null;
    }

    protected IGeoDataset h(String string) {
        List<Map<String, Object>> list;
        String string2 = string;
        String string3 = null;
        Map<String, Object> map = null;
        int n2 = string.indexOf(".");
        if (n2 > 0) {
            string3 = string.substring(0, n2);
            string2 = string.substring(n2 + 1);
        }
        if ((list = this.a(string3, string2, true)).size() > 0) {
            for (Map<String, Object> map2 : list) {
                if (!map2.get("table_name").toString().equals(string2)) continue;
                map = map2;
                break;
            }
            if (map == null) {
                map = list.get(0);
            }
            return this.a(map, true);
        }
        return null;
    }

    protected List<IField> a(String string, String string2, ITable iTable) {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        ArrayList<IField> arrayList = new ArrayList<IField>();
        try {
            Object object;
            String string3 = "SELECT\n\tcol.table_schema,\n\tcol.table_name,\n\tcol.ordinal_position,\n\tcol.column_name,\n\tcol.data_type,\n\tcol.udt_name,\n\tcol.character_maximum_length,\n\tcol.numeric_precision,\n\tcol.numeric_scale,\n\tcol.datetime_precision,\n\tcol.is_nullable,\n\tcol.column_default,\n\tcol_description((col.table_schema || '.' || col.table_name)::regclass::oid, col.ordinal_position) AS column_comment \n FROM information_schema.columns col\n WHERE col.table_schema = ? and col.table_name = ? \n ORDER BY col.ordinal_position";
            if (this.bL) {
                string3 = "SELECT\n\tcol.table_schema,\n\tcol.table_name,\n\tcol.ordinal_position,\n\tcol.column_name,\n\tcol.data_type,\n\tcol.udt_name,\n\tcol.character_maximum_length,\n\tcol.numeric_precision,\n\tcol.numeric_scale,\n\tcol.datetime_precision,\n\tcol.is_nullable,\n\tcol.column_default,\n\tcol_description((col.table_schema || '.' || col.table_name)::regclass::oid, col.ordinal_position) AS column_comment,\n\tgeo_col.coord_dimension,geo_col.srid,geo_col.type as geoemtry_type \n FROM information_schema.columns col left join geometry_columns geo_col on col.table_schema=geo_col.f_table_schema and col.table_name=geo_col.f_table_name and col.column_name=geo_col.f_geometry_column\n WHERE col.table_schema = ? and col.table_name = ? \n ORDER BY col.ordinal_position";
            }
            preparedStatement = this.getConnection().prepareStatement(string3, 1003, 1007);
            preparedStatement.setObject(1, string);
            preparedStatement.setObject(2, string2);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                Object object2;
                Object object3;
                int n2;
                String string4;
                Object object4;
                FieldType fieldType;
                String string5 = resultSet.getString("column_name");
                String object5 = resultSet.getString("column_comment");
                String string6 = resultSet.getString("data_type");
                if ("USER-DEFINED".equalsIgnoreCase(string6)) {
                    string6 = resultSet.getString("udt_name");
                }
                if ((fieldType = this.w(string6)) == FieldType.Shape) {
                    IFeatureClass iFeatureClass;
                    object4 = resultSet.getString("geoemtry_type");
                    string4 = String.valueOf(resultSet.getInt("coord_dimension"));
                    n2 = resultSet.getInt("srid");
                    object3 = this.x((String)object4);
                    object2 = this.g((String)object4, string4);
                    GeometryField geometryField = new GeometryField();
                    object = geometryField;
                    geometryField.setGeometryType((GeometryType)object3);
                    geometryField.setCoordinateType((CoordinateType)object2);
                    if (n2 > 0) {
                        geometryField.setSpatialReferenceSystem(SpatialReferenceSystemFunc.createSpatialReference((int)n2));
                    }
                    if (iTable instanceof IFeatureClass && string5.equalsIgnoreCase((iFeatureClass = (IFeatureClass)((Object)iTable)).getShapeFieldName())) {
                        geometryField.setFieldType(FieldType.Shape);
                        geometryField.setGeometryType(iFeatureClass.getGeometryType());
                        geometryField.setCoordinateType(iFeatureClass.getCoordinateType());
                        geometryField.setSpatialReferenceSystem(iFeatureClass.getSpatialReferenceSystem());
                    }
                } else {
                    object = new Field();
                }
                ((Field)object).setFieldType(fieldType);
                ((Field)object).setName(string5);
                ((Field)object).setAliasName((String)(object5 == null || object5.trim().isEmpty() ? string5 : object5));
                ((Field)object).setNullable(resultSet.getBoolean("is_nullable"));
                ((Field)object).setPhysicalName(string5);
                object4 = resultSet.getObject("column_default");
                if (object4 != null) {
                    string4 = object4.toString();
                    if (string4.toUpperCase().startsWith("NEXTVAL") || string4.toUpperCase().startsWith("NULL")) {
                        object4 = null;
                    } else {
                        n2 = string4.lastIndexOf("::");
                        if (n2 > 0) {
                            object3 = this.f(string4.substring(0, n2), "'");
                            object4 = object3;
                        }
                    }
                }
                ((Field)object).setDefaultValue(object4);
                string4 = resultSet.getString("character_maximum_length");
                String string7 = resultSet.getString("numeric_scale");
                object3 = resultSet.getString("numeric_precision");
                object2 = resultSet.getString("datetime_precision");
                if (string4 != null) {
                    ((Field)object).setLength(Integer.valueOf(string4));
                }
                if (object3 != null) {
                    ((Field)object).setLength(Integer.valueOf((String)object3));
                }
                if (object2 != null) {
                    ((Field)object).setLength(Integer.valueOf((String)object2));
                }
                if (((Field)object).getLength() == null) {
                    ((Field)object).setLength(0);
                }
                ((Field)object).setScale(string7 == null ? null : Integer.valueOf(string7));
                arrayList.add((IField)object);
            }
            if (arrayList.size() > 0 && (object = this.a(string, string2)) != null) {
                for (IField iField : arrayList) {
                    if (!iField.getName().equals(object)) continue;
                    iField.setFieldType(FieldType.OID);
                    break;
                }
            }
        }
        catch (SQLException sQLException) {
            try {
                throw new RuntimeException("\u67e5\u8be2\u5b57\u6bb5\u4fe1\u606f\u5931\u8d25", sQLException);
            }
            catch (Throwable throwable) {
                this.closeObject(resultSet);
                this.closeObject(preparedStatement);
                throw throwable;
            }
        }
        this.closeObject(resultSet);
        this.closeObject(preparedStatement);
        return arrayList;
    }

    protected FieldType w(String string) {
        string = string.toLowerCase();
        FieldType fieldType = FieldType.Unknown;
        if (string.equals("smallint") || string.equals("int2")) {
            fieldType = FieldType.Short;
        } else if (string.equals("integer") || string.equals("int4")) {
            fieldType = FieldType.Int;
        } else if (string.equals("bigint") || string.equals("int8")) {
            fieldType = FieldType.Long;
        } else if (string.contains("character") || string.contains("varchar") || string.equals("name")) {
            fieldType = FieldType.String;
        } else if (string.contains("date")) {
            fieldType = FieldType.DateTime;
        } else if (string.contains("time with")) {
            fieldType = FieldType.DateTime;
        } else if (string.contains("timestamp")) {
            fieldType = FieldType.DateTime;
        } else if (string.contains("bytea")) {
            fieldType = FieldType.Blob;
        } else if (string.equals("real") || string.equals("float4")) {
            fieldType = FieldType.Float;
        } else if (string.contains("double") || string.equals("float8")) {
            fieldType = FieldType.Double;
        } else if (string.contains("geometry") || string.contains("point") || string.contains("line") || string.contains("polygon")) {
            fieldType = FieldType.Shape;
        } else if (string.contains("text")) {
            fieldType = FieldType.Text;
        } else if (string.contains("boolean")) {
            fieldType = FieldType.Boolean;
        } else if (string.contains("numeric")) {
            fieldType = FieldType.Decimal;
        } else {
            this.log.error("\u4e0d\u652f\u6301\u7684\u5b57\u6bb5\u7c7b\u578b\uff1a" + string);
        }
        return fieldType;
    }

    protected String a(String string, String string2) {
        String string3 = "SELECT pg_attribute.attname as column_name FROM pg_constraint\nINNER JOIN pg_class ON pg_constraint.conrelid = pg_class.oid\nINNER JOIN pg_namespace ON pg_namespace.oid = pg_class.relnamespace\nINNER JOIN pg_attribute ON pg_attribute.attrelid = pg_class.oid AND pg_attribute.attnum = any(pg_constraint.conkey)\nWHERE pg_namespace.nspname=? and pg_class.relname=? AND pg_constraint.contype = 'p'";
        List<Map<String, Object>> list = this.queryList(string3, string, string2);
        if (list != null && list.size() == 1) {
            String string4 = list.get(0).get("column_name").toString();
            return string4;
        }
        return null;
    }

    protected GeometryType a(String string, String string2, String string3) {
        try {
            String string4 = String.format("select geometrytype(\"%s\") from %s.\"%s\" limit 1", string3, string, string2);
            Object object = this.queryScalar(string4, new Object[0]);
            if (object != null) {
                String string5 = object.toString().toUpperCase();
                return this.x(string5);
            }
            return GeometryType.Unknown;
        }
        catch (Exception exception) {
            this.log.error(string + "." + string2 + "\u83b7\u53d6\u96c6\u5408\u7c7b\u578b\u5f02\u5e38", (Throwable)exception);
            return GeometryType.Unknown;
        }
    }

    protected GeometryType x(String string) {
        if ("GEOMETRY".equalsIgnoreCase(string)) {
            return GeometryType.Unknown;
        }
        if (string != null) {
            if (string.startsWith("MULTIPOINT")) {
                return GeometryType.MultiPoint;
            }
            if (string.startsWith("POINT")) {
                return GeometryType.Point;
            }
            if (string.contains("MULTILINESTRING")) {
                return GeometryType.Polyline;
            }
            if (string.contains("LINESTRING")) {
                return GeometryType.LineString;
            }
            if (string.contains("LINEARRING")) {
                return GeometryType.LinearRing;
            }
            if (string.contains("MULTIPOLYGON")) {
                return GeometryType.MultiPolygon;
            }
            if (string.contains("POLYGON")) {
                return GeometryType.Polygon;
            }
        }
        return GeometryType.Unknown;
    }

    protected CoordinateType g(String string, String string2) {
        if (string2.equals("3") && string != null && string.endsWith("M")) {
            return CoordinateType.M;
        }
        if (string2.equals("3")) {
            return CoordinateType.Z;
        }
        if (string2.equals("4")) {
            return CoordinateType.ZM;
        }
        return CoordinateType.XY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Class<LicenseCheck> clazz = LicenseCheck.class;
        synchronized (LicenseCheck.class) {
            LicenseCheck.isValid((int)LicChecker.EnumModule.modGIS.value);
            // ** MonitorExit[var0] (shouldn't be in output)
            bS = Pattern.compile("^[a-zA-Z_\\u4e00-\\u9fa5][a-zA-Z0-9_\\u4e00-\\u9fa5]*$");
            bT = new ConcurrentHashMap<String, List<String>>();
            return;
        }
    }
}

