/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.gis.geodb.a;

import com.alibaba.druid.pool.DruidPooledConnection;
import com.alibaba.druid.proxy.jdbc.ConnectionProxy;
import com.geoway.adf.gis.basic.RefObject;
import com.geoway.adf.gis.basic.geometry.IGeometry;
import com.geoway.adf.gis.basic.util.HexStrUtil;
import com.geoway.adf.gis.geodb.IFeatureClass;
import com.geoway.adf.gis.geodb.ITable;
import com.geoway.adf.gis.geodb.JdbcWorkspace;
import com.geoway.adf.gis.geodb.a.ai;
import com.geoway.adf.gis.geodb.a.z;
import com.geoway.adf.gis.geodb.cursor.ICursor;
import com.geoway.adf.gis.geodb.cursor.IFeature;
import com.geoway.adf.gis.geodb.cursor.IFeatureCursor;
import com.geoway.adf.gis.geodb.cursor.IRow;
import com.geoway.adf.gis.geodb.field.FieldType;
import com.geoway.adf.gis.geodb.field.IField;
import com.geoway.adf.gis.geodb.field.IFields;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.sql.Blob;
import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.UUID;
import org.postgresql.copy.CopyManager;
import org.postgresql.core.BaseConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class aj
implements ICursor,
IFeatureCursor {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    protected Connection connection;
    protected JdbcWorkspace workspace;
    protected ITable table;
    protected IFeatureClass featureClass;
    protected IFields fields;
    protected int srid = 0;
    protected String insertSqlFormat;
    protected StringBuilder stringBuilder;
    private RefObject<Boolean> bA = new RefObject((Object)false);
    private RefObject<FieldType> bB = new RefObject((Object)FieldType.Unknown);

    public aj(JdbcWorkspace jdbcWorkspace, ITable iTable) {
        Object object3;
        Object object2;
        this.workspace = jdbcWorkspace;
        this.connection = jdbcWorkspace.getConnection() instanceof DruidPooledConnection ? ((object2 = ((DruidPooledConnection)jdbcWorkspace.getConnection()).getConnection()) instanceof ConnectionProxy ? ((ConnectionProxy)object2).getRawObject() : object2) : jdbcWorkspace.getConnection();
        this.table = iTable;
        if (iTable instanceof IFeatureClass) {
            this.featureClass = (IFeatureClass)((Object)iTable);
            if (this.featureClass.getSpatialReferenceSystem() != null) {
                this.srid = this.featureClass.getSpatialReferenceSystem().getSrid();
            }
        }
        ai.a(this.bA, this.bB, jdbcWorkspace, iTable);
        this.fields = iTable.getFields();
        object2 = new ArrayList();
        for (Object object3 : this.fields) {
            String string = object3.getName();
            if (object3.getPhysicalName() != null && !object3.getPhysicalName().isEmpty()) {
                string = "\"" + object3.getPhysicalName() + "\"";
            }
            if (object3.getName().equalsIgnoreCase(iTable.getOidFieldName())) {
                if (!((Boolean)this.bA.get()).booleanValue()) continue;
                object2.add(string);
                continue;
            }
            object2.add(string);
        }
        if (object2.size() == 0) {
            throw new RuntimeException("insert fields is empty.");
        }
        z z2 = new z(iTable);
        object3 = z2.j();
        this.insertSqlFormat = String.format("COPY %s (%s) from STDIN", object3, String.join((CharSequence)",", (Iterable<? extends CharSequence>)object2));
        this.stringBuilder = new StringBuilder(0xA00000);
        this.logger.info("insert sql:\n" + this.insertSqlFormat);
    }

    @Override
    public ITable getTable() {
        return this.table;
    }

    @Override
    public IFields getFields() {
        return this.fields;
    }

    @Override
    public IFeature nextFeature() {
        return null;
    }

    @Override
    public IRow nextRow() {
        return null;
    }

    @Override
    public void release() {
        try {
            if (this.stringBuilder != null && this.stringBuilder.length() > 0) {
                this.flush();
            }
        }
        finally {
            this.stringBuilder = null;
        }
    }

    @Override
    public boolean insertRow(IRow iRow) {
        int n2 = 0;
        for (int i2 = 0; i2 < this.fields.getFieldCount(); ++i2) {
            IField iField = this.fields.getField(i2);
            if (iField.getName().equalsIgnoreCase(this.table.getOidFieldName())) {
                if (!((Boolean)this.bA.get()).booleanValue()) continue;
                if (n2 > 0) {
                    this.stringBuilder.append("\t");
                }
                if (this.bB.get() == FieldType.String) {
                    if (iRow.getValue(i2) == null) {
                        this.stringBuilder.append(UUID.randomUUID());
                    } else {
                        this.a(this.stringBuilder, (FieldType)((Object)this.bB.get()), iRow.getValue(i2));
                    }
                } else {
                    this.a(this.stringBuilder, (FieldType)((Object)this.bB.get()), iRow.getValue(i2));
                }
                ++n2;
                continue;
            }
            if (n2 > 0) {
                this.stringBuilder.append("\t");
            }
            this.a(this.stringBuilder, iField.getFieldType(), iRow.getValue(i2));
            ++n2;
        }
        this.stringBuilder.append("\r\n");
        if (this.stringBuilder.length() >= 0x6400000) {
            this.flush();
        }
        return true;
    }

    @Override
    public boolean updateRow(IRow iRow) {
        return false;
    }

    @Override
    public boolean deleteRow() {
        return false;
    }

    @Override
    public boolean insertFeature(IFeature iFeature) {
        return this.insertRow(iFeature);
    }

    @Override
    public boolean updateFeature(IFeature iFeature) {
        return false;
    }

    @Override
    public boolean deleteFeature() {
        return false;
    }

    protected boolean flush() {
        byte[] byArray = this.stringBuilder.toString().getBytes(StandardCharsets.UTF_8);
        this.stringBuilder = null;
        CopyManager copyManager = new CopyManager((BaseConnection)this.connection);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        long l2 = copyManager.copyIn(this.insertSqlFormat, (InputStream)byteArrayInputStream);
        this.logger.debug(this.table.getFullName() + " copy\u603b\u6570\uff1a" + l2);
        this.stringBuilder = new StringBuilder(0xA00000);
        return true;
    }

    private void a(StringBuilder stringBuilder, FieldType fieldType, Object object) {
        if (object == null) {
            stringBuilder.append("\\N");
            return;
        }
        switch (fieldType) {
            case DateTime: {
                if (object instanceof Date) {
                    stringBuilder.append(this.dateFormat.format((Date)object));
                    break;
                }
                if (object instanceof String && ((String)object).isEmpty()) {
                    stringBuilder.append("\\N");
                    break;
                }
                stringBuilder.append(object);
                break;
            }
            case Byte: 
            case Text: 
            case String: {
                aj.a(stringBuilder, object.toString());
                break;
            }
            case Blob: {
                byte[] byArray;
                if (object instanceof byte[]) {
                    byArray = (byte[])object;
                } else if (object instanceof Blob) {
                    Blob blob = (Blob)object;
                    byArray = this.workspace.blobToBytes(blob);
                } else {
                    byArray = String.valueOf(object).getBytes(StandardCharsets.UTF_8);
                }
                stringBuilder.append("\\\\x");
                stringBuilder.append(HexStrUtil.bytesToHexChars((byte[])byArray));
                break;
            }
            case Shape: {
                IGeometry iGeometry = (IGeometry)object;
                iGeometry = ai.a(this.featureClass, iGeometry);
                if (iGeometry == null) {
                    stringBuilder.append("\\N");
                    break;
                }
                byte[] byArray = iGeometry.toEWkb(this.srid);
                if (byArray == null) {
                    stringBuilder.append("\\N");
                    break;
                }
                stringBuilder.append(HexStrUtil.bytesToHexChars((byte[])byArray));
                break;
            }
            case Decimal: 
            case Double: 
            case Int: 
            case Long: 
            case Float: 
            case Short: {
                if (object instanceof String && ((String)object).isEmpty()) {
                    stringBuilder.append("\\N");
                    break;
                }
                stringBuilder.append(object);
                break;
            }
            default: {
                stringBuilder.append(object);
            }
        }
    }

    private static void a(StringBuilder stringBuilder, String string) {
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '\\') {
                stringBuilder.append("\\\\");
                continue;
            }
            if (c2 == '\r') {
                stringBuilder.append("\\r");
                continue;
            }
            if (c2 == '\n') {
                stringBuilder.append("\\n");
                continue;
            }
            if (c2 == '\t') {
                stringBuilder.append("\\t");
                continue;
            }
            if (c2 == '\b') {
                stringBuilder.append("\\b");
                continue;
            }
            if (c2 == '\f') {
                stringBuilder.append("\\f");
                continue;
            }
            stringBuilder.append(c2);
        }
    }
}

