/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.gis.geosrv.vtile;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.adf.gis.basic.PageList;
import com.geoway.adf.gis.basic.util.XmlUtil;
import com.geoway.adf.gis.geosrv.IGeoServer;
import com.geoway.adf.gis.geosrv.IGeoService;
import com.geoway.adf.gis.geosrv.ServiceType;
import com.geoway.adf.gis.geosrv.publish.IServicePublishParams;
import com.geoway.adf.gis.geosrv.publish.PublishDataset;
import com.geoway.adf.gis.geosrv.util.HttpClientUtil;
import com.geoway.adf.gis.geosrv.vtile.VTileDataService;
import com.geoway.adf.gis.geosrv.vtile.VTileDatasource;
import com.geoway.adf.gis.geosrv.vtile.VTileDatasourceType;
import com.geoway.adf.gis.geosrv.vtile.VTileGrid;
import com.geoway.adf.gis.geosrv.vtile.VTileService;
import com.geoway.adf.gis.geosrv.vtile.VTileServicePublishParams;
import com.geoway.adf.gis.geosrv.vtile.VTileServiceStyle;
import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.zip.GZIPOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class VTileServer
implements IGeoServer {
    private static final Logger a = LoggerFactory.getLogger(VTileServer.class);
    private final String b;
    private final String c;
    private final String d;
    private String J;
    private final int K = 10000;

    public VTileServer(String string, String string2, String string3) {
        this.b = string;
        this.c = string2;
        this.d = string3;
    }

    @Override
    public boolean testConnect() {
        this.J = this.getMapServerUrl();
        return this.J != null && this.J.length() > 0;
    }

    @Override
    public String getUrl() {
        return this.b;
    }

    @Override
    public List<IGeoService> getServices() {
        return this.a(null, 0, 10000).getList();
    }

    @Override
    public PageList<IGeoService> getServices(List<ServiceType> list, String string, int n, int n2) {
        if (list != null && list.size() != 0 && !list.contains((Object)ServiceType.VectorTileService)) {
            return new PageList();
        }
        return this.a(string, n, n2);
    }

    @Override
    public void deleteService(ServiceType serviceType, String string) {
        VTileService vTileService = (VTileService)this.getService(serviceType, string);
        if (vTileService == null) {
            return;
        }
        String string2 = vTileService.getId();
        String string3 = vTileService.getTaskStatus();
        String string4 = vTileService.getTaskId();
        this.stopCutData(string4, string3);
        String string5 = String.format("%s/service/vector/delete.do", this.b);
        a.info(string5, (Object)string2);
        String string6 = this.doPost(string5, Collections.singletonMap("ids", string2), 10000);
        JSONObject jSONObject = JSONObject.parseObject((String)string6);
        if (!"OK".equalsIgnoreCase(jSONObject.getString("status"))) {
            throw new RuntimeException("\u5220\u9664\u670d\u52a1\u5931\u8d25!" + jSONObject.getString("message"));
        }
        a.info(string + "\u670d\u52a1\u5220\u9664\u6210\u529f");
        if (vTileService.getDataServiceIds() != null) {
            for (String string7 : vTileService.getDataServiceIds()) {
                VTileDataService vTileDataService = this.getDataServiceById(string7);
                if (vTileDataService == null) continue;
                this.deleteDataService(vTileDataService);
            }
        }
    }

    @Override
    public IGeoService getService(ServiceType serviceType, String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>(0);
        hashMap.put("serviceName", string);
        String string2 = this.doPost(String.format("%s/service/vector/detail.do", this.b), hashMap, 10000);
        JSONObject jSONObject = JSONObject.parseObject((String)string2);
        if (!"OK".equalsIgnoreCase(jSONObject.getString("status"))) {
            a.warn(string + "\u83b7\u53d6\u670d\u52a1\u8be6\u60c5\u5931\u8d25!" + jSONObject.getString("message"));
            return null;
        }
        JSONObject jSONObject2 = jSONObject.getJSONObject("data");
        return this.b(jSONObject2);
    }

    @Override
    public IGeoService publishService(IServicePublishParams iServicePublishParams) {
        Object object;
        Object object2;
        VTileServicePublishParams vTileServicePublishParams = (VTileServicePublishParams)iServicePublishParams;
        String string = this.a(vTileServicePublishParams.getPublishDataset());
        if (string == null || string.length() == 0) {
            throw new RuntimeException("\u6570\u636e\u6e90\u6ce8\u518c\u5931\u8d25");
        }
        String string2 = this.getDataGroupId(vTileServicePublishParams.getDataGroupName(), true);
        VTileDataService vTileDataService = this.registerLayer(vTileServicePublishParams, string, string2);
        String string3 = vTileDataService.getName();
        String string4 = vTileDataService.getId();
        if (Boolean.TRUE.equals(vTileServicePublishParams.getCreateDataCache())) {
            object2 = vTileServicePublishParams.getCacheDatasourceId();
            if ((object2 == null || ((String)object2).length() == 0) && (object = this.getMongoDatasource()).size() > 0) {
                object2 = object.get(0).getId();
            }
            object = new ArrayList<VTileDatasource>();
            object.add((VTileDatasource)((Object)Integer.valueOf(vTileServicePublishParams.getCutStartLevel() == null ? 4 : vTileServicePublishParams.getCutStartLevel())));
            object.add((VTileDatasource)((Object)Integer.valueOf(vTileServicePublishParams.getCutEndLevel() == null ? 14 : vTileServicePublishParams.getCutEndLevel())));
            this.createDataCache((String)object2, (List<Integer>)object, string4);
        }
        try {
            this.createMapService(vTileServicePublishParams.getServiceName(), vTileServicePublishParams.getServiceAliasName(), string4);
        }
        catch (Exception exception) {
            this.deleteDataService(vTileDataService);
            throw new RuntimeException(exception);
        }
        this.a(vTileServicePublishParams, string3);
        object2 = this.getService(ServiceType.VectorTileService, vTileServicePublishParams.getServiceName());
        if (object2 == null) {
            throw new RuntimeException(vTileServicePublishParams.getServiceName() + "\u670d\u52a1\u53d1\u5e03\u5931\u8d25\uff01");
        }
        a.info(vTileServicePublishParams.getServiceName() + "\u670d\u52a1\u53d1\u5e03\u6210\u529f");
        if (Boolean.TRUE.equals(vTileServicePublishParams.getCreateMapCache())) {
            List<VTileDatasource> list;
            object = vTileServicePublishParams.getCacheDatasourceId();
            if ((object == null || ((String)object).length() == 0) && (list = this.getMongoDatasource()).size() > 0) {
                object = list.get(0).getId();
            }
            list = new ArrayList<VTileDatasource>();
            list.add((VTileDatasource)((Object)Integer.valueOf(vTileServicePublishParams.getCutStartLevel() == null ? 4 : vTileServicePublishParams.getCutStartLevel())));
            list.add((VTileDatasource)((Object)Integer.valueOf(vTileServicePublishParams.getCutEndLevel() == null ? 14 : vTileServicePublishParams.getCutEndLevel())));
            this.createMapCache((String)object, list, object2.getId());
        }
        return object2;
    }

    public VTileDataService createDataService(VTileServicePublishParams vTileServicePublishParams) {
        String string = this.a(vTileServicePublishParams.getPublishDataset());
        if (string == null || string.length() == 0) {
            throw new RuntimeException("\u6570\u636e\u6e90\u6ce8\u518c\u5931\u8d25");
        }
        String string2 = this.getDataGroupId(vTileServicePublishParams.getDataGroupName(), true);
        VTileDataService vTileDataService = this.registerLayer(vTileServicePublishParams, string, string2);
        if (Boolean.TRUE.equals(vTileServicePublishParams.getCreateDataCache())) {
            List<VTileDatasource> list;
            String string3 = vTileServicePublishParams.getCacheDatasourceId();
            if ((string3 == null || string3.length() == 0) && (list = this.getMongoDatasource()).size() > 0) {
                string3 = list.get(0).getId();
            }
            list = new ArrayList<VTileDatasource>();
            list.add((VTileDatasource)((Object)Integer.valueOf(vTileServicePublishParams.getCutStartLevel() == null ? 4 : vTileServicePublishParams.getCutStartLevel())));
            list.add((VTileDatasource)((Object)Integer.valueOf(vTileServicePublishParams.getCutEndLevel() == null ? 14 : vTileServicePublishParams.getCutEndLevel())));
            this.createDataCache(string3, list, vTileDataService.getId());
        }
        return vTileDataService;
    }

    public String getMapServerUrl() {
        if (this.J != null && this.J.length() > 0) {
            return this.J;
        }
        String string = this.doGet(String.format("%s/dictionary.do", this.b));
        JSONObject jSONObject = JSONObject.parseObject((String)string);
        if (!"OK".equalsIgnoreCase(jSONObject.getString("status"))) {
            throw new RuntimeException("\u8bfb\u53d6\u670d\u52a1\u9884\u89c8\u5730\u5740\u5931\u8d25!" + jSONObject.getString("message"));
        }
        String string2 = jSONObject.getString("data") == null ? "" : jSONObject.getString("data");
        JSONObject jSONObject2 = JSONObject.parseObject((String)string2);
        if (jSONObject2 != null) {
            this.J = jSONObject2.getString("MapServerUrl");
            return this.J;
        }
        return "";
    }

    public void setDefaultStyle(String string, String string2) {
        HashMap<String, String> hashMap = new HashMap<String, String>(0);
        hashMap.put("id", string);
        hashMap.put("styleId", string2);
        String string3 = this.doPost(String.format("%s/service/vector/setDefaultStyle.do", this.b), hashMap, 10000);
        JSONObject jSONObject = JSONObject.parseObject((String)string3);
        String string4 = jSONObject.getString("status");
        if (!"OK".equalsIgnoreCase(string4)) {
            String string5 = jSONObject.getString("message");
            throw new RuntimeException("\u8bbe\u7f6e\u9ed8\u8ba4\u6837\u5f0f\u5931\u8d25\uff01" + string5);
        }
    }

    private PageList<IGeoService> a(String string, int n, int n2) {
        ArrayList<IGeoService> arrayList = new ArrayList<IGeoService>();
        String string2 = String.format("%s/service/vector/list.do?pageIndex=%d&rows=%d", this.b, n, n2);
        if (string != null && string.length() > 0) {
            string2 = String.format("%s/service/vector/list.do?pageIndex=%d&rows=%d&keyWord=%s", this.b, n, n2, string);
        }
        a.info(string2);
        String string3 = this.doGet(string2);
        JSONObject jSONObject = JSONObject.parseObject((String)string3);
        if (!"OK".equalsIgnoreCase(jSONObject.getString("status"))) {
            throw new RuntimeException(jSONObject.getString("message"));
        }
        JSONArray jSONArray = jSONObject.getJSONArray("data");
        if (jSONArray == null) {
            return new PageList();
        }
        int n3 = jSONArray.size();
        Map<String, String> map = this.getAllDataServiceTableName();
        for (int i = 0; i < n3; ++i) {
            JSONObject jSONObject2 = jSONArray.getJSONObject(i);
            IGeoService iGeoService = this.b(jSONObject2);
            if (iGeoService == null) continue;
            this.a(iGeoService, map);
            arrayList.add(iGeoService);
        }
        return new PageList(arrayList, jSONObject.getLong("total"));
    }

    private IGeoService b(JSONObject jSONObject) {
        if (jSONObject.getString("name") == null || jSONObject.getString("name").isEmpty()) {
            return null;
        }
        VTileService vTileService = new VTileService(this);
        vTileService.setServiceType(ServiceType.VectorTileService);
        vTileService.setId(jSONObject.getString("id"));
        vTileService.setName(jSONObject.getString("name"));
        vTileService.setAliasName(jSONObject.getString("alias"));
        vTileService.setHasLabel(jSONObject.getBoolean("haslabel"));
        vTileService.setCutConfig(jSONObject.getString("cutConfig"));
        vTileService.setTaskId(jSONObject.getString("taskId"));
        vTileService.setTaskStatus(jSONObject.getString("taskStatus"));
        String string = jSONObject.getString("defaultstyle");
        String string2 = String.format("%s/all/%s/getMap", this.getMapServerUrl(), vTileService.getName());
        if (string != null && string.length() > 0 && !string.equals("_default__")) {
            string2 = String.format("%s?styleId=%s", string2, string);
            vTileService.setStyleId(string);
        }
        vTileService.setMapServerUrl(this.getMapServerUrl());
        JSONArray jSONArray = jSONObject.getJSONArray("dataServiceIds");
        if (jSONArray != null) {
            List list = (List)jSONArray.toJavaObject(ArrayList.class);
            vTileService.setDataServiceIds(list);
        }
        return vTileService;
    }

    public Map<String, String> getAllDataServiceTableName() {
        JSONArray jSONArray;
        String string = String.format("%s/service/data/list.do?pageIndex=%d&rows=%d", this.b, 0, 100000);
        a.info(string);
        String string2 = this.doGet(string);
        JSONObject jSONObject = JSONObject.parseObject((String)string2);
        if (!"OK".equalsIgnoreCase(jSONObject.getString("status"))) {
            a.error(jSONObject.getString("message"));
        }
        if ((jSONArray = jSONObject.getJSONArray("data")) == null) {
            return new HashMap<String, String>(0);
        }
        int n = jSONArray.size();
        HashMap<String, String> hashMap = new HashMap<String, String>(0);
        for (int i = 0; i < n; ++i) {
            JSONObject jSONObject2 = jSONArray.getJSONObject(i);
            hashMap.put(jSONObject2.getString("id"), jSONObject2.getString("tableName"));
        }
        return hashMap;
    }

    private void a(IGeoService iGeoService, Map<String, String> map) {
        List<String> list = ((VTileService)iGeoService).getDataServiceIds();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (list != null && list.size() > 0) {
            for (String string : list) {
                if (!map.containsKey(string)) continue;
                arrayList.add(map.get(string));
            }
        }
        ((VTileService)iGeoService).setDataServiceTableNames(arrayList);
    }

    public List<VTileGrid> getGrids() {
        HashMap<String, String> hashMap = new HashMap<String, String>(0);
        hashMap.put("pageIndex", "0");
        hashMap.put("rows", "1000");
        String string = String.format("%s/service/grid/list.do", this.b);
        a.info(string);
        String string2 = this.doPost(string, hashMap, 10000);
        JSONObject jSONObject = JSONObject.parseObject((String)string2);
        if (!"ok".equalsIgnoreCase(jSONObject.getString("status"))) {
            throw new RuntimeException("\u83b7\u53d6\u91d1\u5b57\u5854\u5217\u8868\u5931\u8d25\uff1a" + jSONObject.getString("message"));
        }
        JSONArray jSONArray = (JSONArray)jSONObject.get((Object)"data");
        if (jSONArray == null) {
            return new ArrayList<VTileGrid>();
        }
        return jSONArray.toJavaList(VTileGrid.class);
    }

    public List<VTileDatasource> getMongoDatasource() {
        return this.e("7");
    }

    private List<VTileDatasource> e(String string) {
        String string2;
        JSONObject jSONObject;
        HashMap<String, String> hashMap = new HashMap<String, String>(0);
        hashMap.put("source", "1");
        hashMap.put("pageIndex", "0");
        hashMap.put("rows", "1000");
        if (string != null && string.length() > 0) {
            hashMap.put("types", string);
        }
        if (!"ok".equalsIgnoreCase((jSONObject = JSONObject.parseObject((String)(string2 = this.doPost(String.format("%s/datasource/list.do", this.b), hashMap, 10000)))).getString("status"))) {
            throw new RuntimeException("\u83b7\u53d6\u5207\u7247\u5b58\u50a8\u6570\u636e\u5e93\u5931\u8d25\uff1a" + jSONObject.getString("message"));
        }
        JSONArray jSONArray = (JSONArray)jSONObject.get((Object)"data");
        if (jSONArray == null) {
            return new ArrayList<VTileDatasource>();
        }
        return jSONArray.toJavaList(VTileDatasource.class);
    }

    public List<VTileServiceStyle> getServiceStyles(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>(0);
        hashMap.put("serviceId", string);
        hashMap.put("pageIndex", "0");
        hashMap.put("rows", "1000");
        String string2 = String.format("%s/style/list.do", this.b);
        a.info(string2);
        String string3 = this.doPost(string2, hashMap, 10000);
        JSONObject jSONObject = JSONObject.parseObject((String)string3);
        if (!"ok".equalsIgnoreCase(jSONObject.getString("status"))) {
            throw new RuntimeException("\u83b7\u53d6\u6e32\u67d3\u7d22\u5f15\u5217\u8868\u5931\u8d25\uff1a" + jSONObject.getString("message"));
        }
        JSONArray jSONArray = (JSONArray)jSONObject.get((Object)"data");
        if (jSONArray == null) {
            return new ArrayList<VTileServiceStyle>();
        }
        return jSONArray.toJavaList(VTileServiceStyle.class);
    }

    @Override
    public void reCreateCache(IGeoService iGeoService) {
        String string;
        String string2;
        Object object;
        Object object2;
        HashMap<String, String> hashMap;
        VTileService vTileService = (VTileService)iGeoService;
        try {
            hashMap = this.getDataServiceById(vTileService.getDataServiceIds().get(0));
            object2 = new HashMap<String, String>(0);
            object2.put("id", ((VTileDataService)((Object)hashMap)).getId());
            object2.put("name", ((VTileDataService)((Object)hashMap)).getName());
            object2.put("groupId", ((VTileDataService)((Object)hashMap)).getGroupId());
            object2.put("editConfig", "false");
            object2.put("fieldsStr", String.join((CharSequence)",", ((VTileDataService)((Object)hashMap)).getFields()));
            object2.put("fields", String.join((CharSequence)",", ((VTileDataService)((Object)hashMap)).getFields()));
            object2.put("geomField", ((VTileDataService)((Object)hashMap)).getGeometryField());
            object2.put("config", ((VTileDataService)((Object)hashMap)).getInfo());
            object = this.doPost(String.format("%s/service/data/update.do", this.b), (Map<String, String>)object2, 10000);
            string2 = JSONObject.parseObject((String)object);
            string = string2.getString("status");
            a.info("\u91cd\u65b0\u4fdd\u5b58{}\u7684\u6570\u636e\u670d\u52a1\u7ed3\u679c\uff1a{}", (Object)iGeoService.getName(), (Object)string);
        }
        catch (Exception exception) {
            a.error(iGeoService.getName() + "\u4fdd\u5b58\u6570\u636e\u670d\u52a1\u5931\u8d25\uff01", (Throwable)exception);
        }
        if (vTileService.getCutConfig() != null) {
            hashMap = new HashMap(0);
            hashMap.put("id", vTileService.getId());
            hashMap.put("config", vTileService.getCutConfig());
            object2 = this.doPost(String.format("%s/service/vector/cut.do", this.b), hashMap, 10000);
            object = JSONObject.parseObject((String)object2);
            string2 = object.getString("status");
            if (!"OK".equalsIgnoreCase(string2)) {
                string = object.get((Object)"message").toString();
                throw new RuntimeException("\u521b\u5efa\u7f13\u5b58\u5931\u8d25\uff01" + string);
            }
        } else {
            hashMap = new HashMap<String, String>(0);
            hashMap.put("id", vTileService.getId());
            object2 = this.doPost(String.format("%s/service/vector/deleteImageCache.do", this.b), hashMap, 10000);
            object = JSONObject.parseObject((String)object2);
            string2 = object.getString("status");
            if (!"OK".equalsIgnoreCase(string2)) {
                string = object.get((Object)"message").toString();
                a.error(iGeoService.getName() + "\u6e05\u9664\u7f13\u5b58\u5931\u8d25\uff01" + string);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public IGeoService publishTempService(IServicePublishParams iServicePublishParams) {
        String string;
        Object object;
        VTileServicePublishParams vTileServicePublishParams = (VTileServicePublishParams)iServicePublishParams;
        PublishDataset publishDataset = vTileServicePublishParams.getPublishDataset();
        String string2 = publishDataset.getDbUrl() + "/" + publishDataset.getDatasetName();
        String string3 = vTileServicePublishParams.getServiceName() + "_" + this.f(string2);
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("sourceType", (Object)VTileDatasourceType.getByValue(publishDataset.getDbType()).name());
        jSONObject.put("address", (Object)publishDataset.getDbUrl());
        jSONObject.put("userName", (Object)publishDataset.getDbUser());
        jSONObject.put("password", (Object)publishDataset.getDbPassword());
        jSONObject.put("tableName", (Object)publishDataset.getDatasetName());
        jSONObject.put("category", (Object)"temp");
        jSONObject.put("dataName", (Object)string3);
        String string4 = this.a(String.format("%s/service/data/compactRegister.do", this.b), jSONObject.toJSONString(), 10000);
        JSONObject jSONObject2 = JSONObject.parseObject((String)string4);
        String string5 = jSONObject2.getString("status");
        if (!"OK".equalsIgnoreCase(string5)) {
            object = jSONObject2.getJSONObject("data");
            if (object == null) {
                String string6 = jSONObject2.get((Object)"message").toString();
                throw new RuntimeException(string6);
            }
            string = jSONObject2.getJSONObject("data").getString("id");
            if (string == null) {
                String string7 = jSONObject2.get((Object)"message").toString();
                throw new RuntimeException(string7);
            }
        } else {
            string = jSONObject2.getJSONObject("data").getString("id");
        }
        object = new VTileService(this);
        ((VTileService)object).setServiceType(ServiceType.VectorTileService);
        ((VTileService)object).setId(string);
        ((VTileService)object).setName(string3);
        ((VTileService)object).setAliasName(string3);
        ((VTileService)object).setIsDataService(true);
        ((VTileService)object).setMapServerUrl(this.getMapServerUrl());
        ((VTileService)object).setStyleId("_default__");
        return object;
    }

    private String a(PublishDataset publishDataset) {
        String string;
        String string2;
        Object object;
        boolean bl = false;
        String string3 = "";
        List<VTileDatasource> list = this.e(null);
        for (VTileDatasource object2 : list) {
            object = JSONObject.parseObject((String)object2.getConnectionContent());
            string2 = object.getString("address");
            String string4 = string = object.getString("user") == null ? "" : object.getString("user");
            if (!string2.equals(publishDataset.getDbUrl()) || !string.equals(publishDataset.getDbUser())) continue;
            string3 = object2.getId();
            bl = true;
            break;
        }
        if (!bl) {
            String string5;
            JSONObject jSONObject;
            JSONObject jSONObject2 = new JSONObject();
            jSONObject2.put("address", (Object)publishDataset.getDbUrl());
            jSONObject2.put("user", (Object)publishDataset.getDbUser());
            jSONObject2.put("password", (Object)publishDataset.getDbPassword());
            HashMap<String, String> hashMap = new HashMap<String, String>(0);
            hashMap.put("name", publishDataset.getDbUrl().replace("/", "").replace(":", ""));
            hashMap.put("type", publishDataset.getDbType() + "");
            hashMap.put("description", "");
            hashMap.put("connectionContent", jSONObject2.toJSONString());
            hashMap.put("source", "1");
            object = this.doPost(String.format("%s/datasource/save.do", this.b), hashMap, 10000);
            string2 = JSONObject.parseObject((String)object);
            string = string2.getString("status");
            if ("OK".equalsIgnoreCase(string) && (jSONObject = JSONObject.parseObject((String)(string5 = string2.getString("data") == null ? "" : string2.getString("data")))) != null) {
                string3 = jSONObject.get((Object)"id") == null ? "" : jSONObject.get((Object)"id").toString();
            }
        }
        return string3;
    }

    public VTileDataService registerLayer(VTileServicePublishParams vTileServicePublishParams, String string, String string2) {
        Object object;
        Double d;
        Object object2;
        HashMap<String, String> hashMap;
        Object object3;
        JSONObject jSONObject;
        String string3 = vTileServicePublishParams.getServiceName();
        String string4 = this.getDataServiceIdByName(string3, string2);
        int n = 0;
        while (string4 != null) {
            string3 = vTileServicePublishParams.getServiceName() + "_" + ++n;
            string4 = this.getDataServiceIdByName(string3, string2);
        }
        String string5 = vTileServicePublishParams.getPublishDataset().getDatasetName();
        Integer n2 = vTileServicePublishParams.getGridUnit() == null ? 1 : vTileServicePublishParams.getGridUnit();
        String string6 = vTileServicePublishParams.getGridId();
        Integer n3 = 1;
        try {
            jSONObject = this.getGrids();
            object3 = null;
            hashMap = jSONObject.iterator();
            while (hashMap.hasNext()) {
                object2 = hashMap.next();
                if (((VTileGrid)object2).getId().equals(string6)) {
                    object3 = object2;
                    break;
                }
                if (string6 != null || ((VTileGrid)object2).getIsDefault() == null || ((VTileGrid)object2).getIsDefault() <= 0) continue;
                string6 = ((VTileGrid)object2).getId();
                object3 = object2;
                break;
            }
            if (object3 != null && ((VTileGrid)object3).getXml() != null && ((VTileGrid)object3).getXml().length() > 0 && (object2 = XmlUtil.findfirstNode((Node)((Object)(hashMap = XmlUtil.readDocumentFromStr((String)((VTileGrid)object3).getXml()))), (String)"//TileOrigin")) != null) {
                d = XmlUtil.findfirstNodeDoubleValue((Node)object2, (String)"X");
                object = XmlUtil.findfirstNodeDoubleValue((Node)object2, (String)"Y");
                if (d.intValue() != -180 && ((Double)object).intValue() != 90) {
                    n3 = 0;
                }
            }
        }
        catch (Exception exception) {
            a.error(exception.getMessage(), (Throwable)exception);
        }
        if (!n3.equals(n2)) {
            throw new RuntimeException("\u6570\u636e\u5750\u6807\u5355\u4f4d\u4e0e\u91d1\u5b57\u5854\u5750\u6807\u5355\u4f4d\u4e0d\u4e00\u81f4");
        }
        jSONObject = new JSONObject();
        jSONObject.put("name", (Object)string3);
        jSONObject.put("tableName", (Object)string5);
        jSONObject.put("fields", vTileServicePublishParams.getFieldNameList());
        jSONObject.put("dataSourceId", (Object)string);
        jSONObject.put("srid", vTileServicePublishParams.getSrid() == null ? null : String.valueOf(vTileServicePublishParams.getSrid()));
        jSONObject.put("gridUnit", (Object)(vTileServicePublishParams.getGridUnit() == null ? 1 : vTileServicePublishParams.getGridUnit()));
        jSONObject.put("groupId", string2 == null ? Integer.valueOf(-1) : string2);
        jSONObject.put("gridId", (Object)(string6 == null ? "-1" : string6));
        jSONObject.put("geometryField", (Object)vTileServicePublishParams.getGeometryField());
        jSONObject.put("info", (Object)"{\"bufferSize\":5,\"ignoreOnePointFeature\":false,\"hasLineLabel\":true,\"hasPolygonLabel\":true,\"simplify\":0,\"lineCutBase\":400,\"filter\":\"\",\"polygonLabelCenter\":true,\"polygonLabelFollow\":false,\"polygonLabelLevel\":10}");
        object3 = new JSONArray();
        object3.add((Object)jSONObject);
        hashMap = new HashMap<String, String>(0);
        hashMap.put("datas", JSONArray.toJSONString((Object)object3));
        a.info(JSONArray.toJSONString((Object)object3));
        object2 = this.doPost(String.format("%s/service/data/register/mult.do", this.b), hashMap, 60000);
        d = JSONObject.parseObject((String)object2);
        object = d.getString("status");
        if ("OK".equalsIgnoreCase((String)object)) {
            VTileDataService vTileDataService = this.getDataServiceByName(string3, string2);
            if (vTileDataService == null) {
                throw new RuntimeException(string3 + " \u6570\u636e\u670d\u52a1\u83b7\u53d6\u5931\u8d25");
            }
            return vTileDataService;
        }
        String string7 = d.get("message").toString();
        throw new RuntimeException(string7);
    }

    public String getDataGroupId(String string, boolean bl) {
        if (string == null || string.isEmpty()) {
            return "-1";
        }
        String string2 = this.doPost(String.format("%s/service/data/group/list.do", this.b), null, 10000);
        JSONObject jSONObject = JSONObject.parseObject((String)string2);
        if ("OK".equalsIgnoreCase(jSONObject.getString("status"))) {
            Object object;
            JSONArray jSONArray = jSONObject.getJSONArray("data");
            if (jSONArray != null) {
                for (int i = 0; i < jSONArray.size(); ++i) {
                    object = jSONArray.getJSONObject(i);
                    String string3 = object.get((Object)"name").toString();
                    if (!string3.equalsIgnoreCase(string)) continue;
                    return object.getString("id");
                }
            }
            if (bl) {
                HashMap<String, String> hashMap = new HashMap<String, String>(0);
                hashMap.put("name", string);
                string2 = this.doPost(String.format("%s/service/data/group/save.do", this.b), hashMap, 10000);
                jSONObject = JSONObject.parseObject((String)string2);
                if ("OK".equalsIgnoreCase(jSONObject.getString("status"))) {
                    return this.getDataGroupId(string, false);
                }
                object = jSONObject.get((Object)"message").toString();
                throw new RuntimeException((String)object);
            }
            return null;
        }
        String string4 = jSONObject.get((Object)"message").toString();
        throw new RuntimeException(string4);
    }

    public String getDataServiceIdByName(String string, String string2) {
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>(0);
            hashMap.put("pageIndex", Integer.toString(0));
            hashMap.put("rows", "10000");
            hashMap.put("groupId", string2 == null ? "-1" : string2);
            hashMap.put("keyWord", string);
            String string3 = this.doPost(String.format("%s/service/data/list.do", this.b), hashMap, 10000);
            JSONObject jSONObject = JSONObject.parseObject((String)string3);
            if (!"OK".equalsIgnoreCase(jSONObject.getString("status"))) {
                throw new RuntimeException("\u67e5\u8be2\u6570\u636e\u670d\u52a1\u5931\u8d25\uff01" + jSONObject.getString("message"));
            }
            String string4 = jSONObject.get((Object)"data") == null ? "" : jSONObject.get((Object)"data").toString();
            JSONArray jSONArray = JSONArray.parseArray((String)string4);
            if (jSONArray != null) {
                for (int i = 0; i < jSONArray.size(); ++i) {
                    JSONObject jSONObject2 = jSONArray.getJSONObject(i);
                    String string5 = jSONObject2.get((Object)"id").toString();
                    String string6 = jSONObject2.get((Object)"name").toString();
                    if (!string6.equals(string)) continue;
                    return string5;
                }
            }
            return null;
        }
        catch (Exception exception) {
            a.error(string + " \u6570\u636e\u670d\u52a1\u83b7\u53d6\u5f02\u5e38", (Throwable)exception);
            return null;
        }
    }

    public VTileDataService getDataServiceByName(String string, String string2) {
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>(0);
            hashMap.put("pageIndex", Integer.toString(0));
            hashMap.put("rows", "10000");
            hashMap.put("groupId", string2 == null ? "-1" : string2);
            hashMap.put("keyWord", string);
            String string3 = this.doPost(String.format("%s/service/data/list.do", this.b), hashMap, 10000);
            JSONObject jSONObject = JSONObject.parseObject((String)string3);
            if (!"OK".equalsIgnoreCase(jSONObject.getString("status"))) {
                throw new RuntimeException("\u67e5\u8be2\u6570\u636e\u670d\u52a1\u5931\u8d25\uff01" + jSONObject.getString("message"));
            }
            String string4 = jSONObject.get((Object)"data") == null ? "" : jSONObject.get((Object)"data").toString();
            JSONArray jSONArray = JSONArray.parseArray((String)string4);
            if (jSONArray != null) {
                for (int i = 0; i < jSONArray.size(); ++i) {
                    JSONObject jSONObject2 = jSONArray.getJSONObject(i);
                    String string5 = jSONObject2.get((Object)"id").toString();
                    String string6 = jSONObject2.get((Object)"name").toString();
                    if (!string6.equals(string)) continue;
                    return (VTileDataService)jSONObject2.toJavaObject(VTileDataService.class);
                }
            }
            return null;
        }
        catch (Exception exception) {
            a.error(string + " \u6570\u636e\u670d\u52a1\u83b7\u53d6\u5f02\u5e38", (Throwable)exception);
            return null;
        }
    }

    public VTileDataService getDataServiceById(String string) {
        try {
            if (string == null || string.length() == 0) {
                return null;
            }
            HashMap<String, String> hashMap = new HashMap<String, String>(0);
            hashMap.put("id", string);
            String string2 = this.doPost(String.format("%s/service/data/detail.do", this.b), hashMap, 10000);
            JSONObject jSONObject = JSONObject.parseObject((String)string2);
            String string3 = jSONObject.getString("status");
            if (!"OK".equalsIgnoreCase(string3)) {
                a.error("\u83b7\u53d6\u6570\u636e\u670d\u52a1\u8be6\u60c5\u5931\u8d25\uff01" + jSONObject.getString("message"));
                return null;
            }
            JSONObject jSONObject2 = jSONObject.getJSONObject("data");
            if (jSONObject2 != null) {
                return (VTileDataService)jSONObject2.toJavaObject(VTileDataService.class);
            }
            return null;
        }
        catch (Exception exception) {
            a.error(string + "\u6570\u636e\u670d\u52a1\u83b7\u53d6\u8be6\u60c5\u5f02\u5e38", (Throwable)exception);
            return null;
        }
    }

    public void deleteDataService(VTileDataService vTileDataService) {
        try {
            String string = vTileDataService.getTaskStatus();
            String string2 = vTileDataService.getTaskId();
            this.stopCutData(string2, string);
            this.deleteDataService(vTileDataService.getId());
        }
        catch (Exception exception) {
            a.error("\u5220\u9664\u6570\u636e\u670d\u52a1\u5931\u8d25", (Throwable)exception);
        }
    }

    public void deleteDataService(String string) {
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>(0);
            hashMap.put("ids", string);
            String string2 = this.doPost(String.format("%s/service/data/delete.do", this.b), hashMap, 10000);
            JSONObject jSONObject = JSONObject.parseObject((String)string2);
            String string3 = jSONObject.getString("status");
            if (!"OK".equalsIgnoreCase(string3)) {
                String string4 = jSONObject.getString("message");
                a.error("\u5220\u9664\u6570\u636e\u670d\u52a1\uff01" + string4);
            }
        }
        catch (Exception exception) {
            a.error("\u5220\u9664\u6570\u636e\u670d\u52a1\u5931\u8d25", (Throwable)exception);
        }
    }

    public boolean createMapCache(String string, List<Integer> list, String string2) {
        if (string == null || string.length() == 0) {
            throw new RuntimeException("\u672a\u8bbe\u7f6e\u7f13\u5b58\u6570\u636e\u5e93");
        }
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("cacheDatasourceId", (Object)string);
        jSONObject.put("cutLevel", list);
        jSONObject.put("cacheTaskType", (Object)"immediate");
        jSONObject.put("timeline", (Object)new Date().getTime());
        jSONObject.put("pick", (Object)false);
        jSONObject.put("tileSource", (Object)1);
        jSONObject.put("styleId", (Object)"-1");
        jSONObject.put("styleFilters", new ArrayList());
        HashMap<String, String> hashMap = new HashMap<String, String>(0);
        hashMap.put("id", string2);
        hashMap.put("config", JSONObject.toJSONString((Object)jSONObject));
        String string3 = this.doPost(String.format("%s/service/vector/cut.do", this.b), hashMap, 10000);
        JSONObject jSONObject2 = JSONObject.parseObject((String)string3);
        String string4 = jSONObject2.get((Object)"status").toString().toUpperCase(Locale.ROOT);
        if ("OK".equals(string4)) {
            return true;
        }
        String string5 = jSONObject2.get((Object)"message").toString();
        throw new RuntimeException("\u521b\u5efa\u7f13\u5b58\u5931\u8d25\uff01" + string5);
    }

    @Deprecated
    public boolean createDataCache(String string, List<Integer> list, String string2) {
        if (string == null || string.length() == 0) {
            throw new RuntimeException("\u672a\u8bbe\u7f6e\u7f13\u5b58\u6570\u636e\u5e93");
        }
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("cacheDatasourceId", (Object)string);
        jSONObject.put("cutLevel", list);
        HashMap<String, String> hashMap = new HashMap<String, String>(0);
        hashMap.put("id", string2);
        hashMap.put("config", JSONObject.toJSONString((Object)jSONObject));
        String string3 = this.doPost(String.format("%s/service/data/cut.do", this.b), hashMap, 10000);
        JSONObject jSONObject2 = JSONObject.parseObject((String)string3);
        String string4 = jSONObject2.get((Object)"status").toString().toUpperCase(Locale.ROOT);
        if ("OK".equals(string4)) {
            return true;
        }
        String string5 = jSONObject2.get((Object)"message").toString();
        throw new RuntimeException("\u521b\u5efa\u7f13\u5b58\u5931\u8d25\uff01" + string5);
    }

    public void stopCutData(String string, String string2) {
        try {
            if (string != null && !"5".equals(string2)) {
                HashMap<String, String> hashMap = new HashMap<String, String>(0);
                hashMap.put("taskId", string);
                String string3 = this.doPost(String.format("%s/cut/task/stop.do", this.b), hashMap, 10000);
                a.info(string3);
            }
        }
        catch (Exception exception) {
            a.error("\u505c\u6b62\u5207\u7247\u4efb\u52a1\u5931\u8d25", (Throwable)exception);
        }
    }

    public void createMapService(String string, String string2, String string3) {
        HashMap<String, String> hashMap = new HashMap<String, String>(0);
        hashMap.put("serviceName", string);
        hashMap.put("serviceAlias", string2);
        hashMap.put("dataIds", string3);
        String string4 = this.doPost(String.format("%s/service/vector/registerByDataIds.do", this.b), hashMap, 10000);
        JSONObject jSONObject = JSONObject.parseObject((String)string4);
        String string5 = jSONObject.getString("status");
        if (!"OK".equalsIgnoreCase(string5)) {
            String string6 = jSONObject.get((Object)"message").toString();
            throw new RuntimeException("\u5730\u56fe\u670d\u52a1\u53d1\u5e03\u5931\u8d25\uff01" + string6);
        }
    }

    public void importStyle(String string, String string2, String string3, Double d, Double d2) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
        gZIPOutputStream.write(string.getBytes(StandardCharsets.UTF_8));
        gZIPOutputStream.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        int[] nArray = new int[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            nArray[i] = Byte.toUnsignedInt(byArray[i]);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(0);
        hashMap.put("belongService", string2);
        hashMap.put("styleName", string3);
        hashMap.put("styleId", string3);
        hashMap.put("thumb", null);
        if (d == null) {
            d = 108.0;
        }
        if (d2 == null) {
            d2 = 34.0;
        }
        if (d != null && d2 != null) {
            hashMap.put("x", d.toString());
            hashMap.put("y", d2.toString());
        }
        hashMap.put("styleContent", Arrays.toString(nArray).replace("[", "").replace("]", ""));
        String string4 = this.doPost(String.format("%s/style/import.do", this.b), hashMap, 10000);
        JSONObject jSONObject = JSONObject.parseObject((String)string4);
        String string5 = jSONObject.get((Object)"status").toString().toUpperCase(Locale.ROOT);
        if (!"OK".equals(string5)) {
            a.error(jSONObject.get((Object)"message").toString());
            string4 = this.doPost(String.format("%s/style/import.do", this.b), hashMap, 10000);
            jSONObject = JSONObject.parseObject((String)string4);
            string5 = jSONObject.get((Object)"status").toString().toUpperCase(Locale.ROOT);
            if (!"OK".equals(string5)) {
                String string6 = jSONObject.get((Object)"message").toString();
                throw new RuntimeException(string6);
            }
        }
    }

    private Boolean a(VTileServicePublishParams vTileServicePublishParams, String string) {
        try {
            String string2 = null;
            JSONObject jSONObject = null;
            if (vTileServicePublishParams.getStyleJson() != null && vTileServicePublishParams.getStyleJson().length() > 0) {
                try {
                    jSONObject = JSONObject.parseObject((String)vTileServicePublishParams.getStyleJson());
                    this.a((JSON)jSONObject, string);
                }
                catch (Exception exception) {
                    a.error("\u8bfb\u53d6\u6837\u5f0fjson\u5f02\u5e38", (Throwable)exception);
                }
                string2 = vTileServicePublishParams.getStyleId();
                if (string2 == null || string2.length() == 0) {
                    string2 = vTileServicePublishParams.getServiceName();
                }
            }
            if (jSONObject == null) {
                string2 = "ws";
                String string3 = "";
                switch (vTileServicePublishParams.getFeatureType()) {
                    case 0: {
                        string3 = "point-mark";
                        break;
                    }
                    case 1: {
                        string3 = "line";
                        break;
                    }
                    case 2: {
                        string3 = "polygon";
                        break;
                    }
                    default: {
                        throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u51e0\u4f55\u7c7b\u578b\uff1a" + vTileServicePublishParams.getFeatureType());
                    }
                }
                jSONObject = VTileServiceStyle.getRenderStyle(string, string3);
            }
            this.importStyle(jSONObject.toJSONString(), vTileServicePublishParams.getServiceName(), string2, vTileServicePublishParams.getCenterX(), vTileServicePublishParams.getCenterY());
            return true;
        }
        catch (Exception exception) {
            a.error(vTileServicePublishParams.getServiceName() + "\u6837\u5f0f\u5bfc\u5165\u5931\u8d25\uff01", (Throwable)exception);
            return false;
        }
    }

    private void a(JSON jSON, String string) {
        block4: {
            block3: {
                if (!(jSON instanceof JSONObject)) break block3;
                JSONObject jSONObject = (JSONObject)jSON;
                for (String string2 : jSONObject.keySet()) {
                    if (jSONObject.get((Object)string2) instanceof JSON) {
                        this.a((JSON)jSONObject.get((Object)string2), string);
                        continue;
                    }
                    if (!string2.equals("data")) continue;
                    jSONObject.put("data", (Object)string);
                }
                break block4;
            }
            if (!(jSON instanceof JSONArray)) break block4;
            JSONArray jSONArray = (JSONArray)jSON;
            for (Object e : jSONArray) {
                if (!(e instanceof JSON)) continue;
                this.a((JSON)e, string);
            }
        }
    }

    private String doPost(String string, Map<String, String> map, int n) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("atlas-token", "GEOWAY-2024");
        return HttpClientUtil.doPost(string, map, hashMap, n);
    }

    private String a(String string, String string2, int n) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("atlas-token", "GEOWAY-2024");
        return HttpClientUtil.doPostJson(string, string2, hashMap, n);
    }

    private String doGet(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("atlas-token", "GEOWAY-2024");
        return HttpClientUtil.doGet(string, null, hashMap, 10000);
    }

    private String f(String string) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(string.getBytes());
            byte[] byArray = messageDigest.digest();
            StringBuilder stringBuilder = new StringBuilder();
            for (byte by : byArray) {
                stringBuilder.append(String.format("%02x", by));
            }
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            a.error(this.b, (Throwable)exception);
            return UUID.randomUUID().toString().replace("-", "");
        }
    }
}

