/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.gis.geosrv.ime;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.adf.gis.basic.PageList;
import com.geoway.adf.gis.geosrv.IGeoServer;
import com.geoway.adf.gis.geosrv.IGeoService;
import com.geoway.adf.gis.geosrv.ServiceType;
import com.geoway.adf.gis.geosrv.ime.IMEDatasourceType;
import com.geoway.adf.gis.geosrv.ime.IMEService;
import com.geoway.adf.gis.geosrv.ime.IMEServicePublishParams;
import com.geoway.adf.gis.geosrv.publish.IServicePublishParams;
import com.geoway.adf.gis.geosrv.publish.PublishDataset;
import com.geoway.adf.gis.geosrv.util.HttpClientUtil;
import java.io.File;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IMEServer
implements IGeoServer {
    private static final Logger a = LoggerFactory.getLogger(IMEServer.class);
    private final String b;
    private final String c;
    private final String d;

    public IMEServer(String string, String string2, String string3) {
        if (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        this.b = string;
        this.c = string2;
        this.d = string3;
    }

    @Override
    public boolean testConnect() {
        return HttpClientUtil.testGet(String.format("%s/rest/admin/version", this.b));
    }

    @Override
    public String getUrl() {
        return this.b;
    }

    @Override
    public List<IGeoService> getServices() {
        HashMap<String, String> hashMap = new HashMap<String, String>(0);
        hashMap.put("type", "all");
        return this.a(hashMap);
    }

    @Override
    public PageList<IGeoService> getServices(List<ServiceType> list, String string, int n, int n2) {
        List<Object> list2 = new ArrayList();
        if (list == null || list.size() == 0) {
            list2 = this.getServices();
        } else {
            for (ServiceType serviceType : list) {
                HashMap<String, String> hashMap = new HashMap<String, String>(0);
                String string2 = IMEServer.a(serviceType);
                if (string2.length() <= 0) continue;
                hashMap.put("type", string2);
                list2.addAll(this.a(hashMap));
            }
        }
        if (string != null && string.length() > 0) {
            list2 = list2.stream().filter(iGeoService -> iGeoService.getName().contains(string)).collect(Collectors.toList());
        }
        return new PageList(list2, Integer.valueOf(n), Integer.valueOf(n2));
    }

    @Override
    public void deleteService(ServiceType serviceType, String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>(0);
        hashMap.put("name", string);
        String string2 = String.format("%s/rest/admin/stop", this.b);
        HttpClientUtil.doPost(string2, hashMap);
        string2 = String.format("%s/rest/admin/delete", this.b);
        String string3 = HttpClientUtil.doPost(string2, hashMap);
        JSONObject jSONObject = JSONObject.parseObject((String)string3);
        if (!"OK".equalsIgnoreCase(jSONObject.getString("status"))) {
            throw new RuntimeException("\u5220\u9664\u670d\u52a1\u5931\u8d25!" + jSONObject.getString("message"));
        }
    }

    @Override
    public IGeoService getService(ServiceType serviceType, String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>(0);
        hashMap.put("name", string);
        String string2 = HttpClientUtil.doGet(String.format("%s/rest/admin/detail", this.b), hashMap);
        JSONObject jSONObject = JSONObject.parseObject((String)string2);
        if (!"OK".equalsIgnoreCase(jSONObject.getString("status"))) {
            a.error(string + "\u83b7\u53d6\u670d\u52a1\u8be6\u60c5\u5931\u8d25!" + jSONObject.getString("message"));
            return null;
        }
        String string3 = jSONObject.get((Object)"result") == null ? "" : jSONObject.get((Object)"result").toString();
        JSONObject jSONObject2 = JSONObject.parseObject((String)string3);
        IMEService iMEService = this.a(jSONObject2);
        return iMEService;
    }

    @Override
    public IGeoService publishService(IServicePublishParams iServicePublishParams) {
        String string;
        IMEServicePublishParams iMEServicePublishParams = (IMEServicePublishParams)iServicePublishParams;
        switch (iMEServicePublishParams.getServiceType()) {
            case DTileService: {
                string = this.a(iMEServicePublishParams, "5");
                break;
            }
            case RasterTileService: {
                string = this.a(iMEServicePublishParams, "Tile", "1");
                break;
            }
            case TerrainService: {
                string = this.a(iMEServicePublishParams, "Terrain", "3");
                break;
            }
            case Annotation3dService: {
                string = this.a(iMEServicePublishParams, "DTile", "3");
                break;
            }
            case Tiles3dService: {
                string = this.a(iMEServicePublishParams, "3dtiles", "3");
                break;
            }
            default: {
                throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u670d\u52a1\u53d1\u5e03\u7c7b\u578b\uff1a" + (Object)((Object)iMEServicePublishParams.getServiceType()));
            }
        }
        JSONObject jSONObject = JSONObject.parseObject((String)string);
        if ("ok".equalsIgnoreCase(jSONObject.getString("status"))) {
            JSONObject jSONObject2 = jSONObject.getJSONObject("result");
            IGeoService iGeoService = this.getService(iMEServicePublishParams.getServiceType(), iMEServicePublishParams.getServiceName());
            if (iGeoService == null) {
                throw new RuntimeException(iMEServicePublishParams.getServiceName() + "\u670d\u52a1\u53d1\u5e03\u5931\u8d25\uff01");
            }
            return iGeoService;
        }
        throw new RuntimeException(jSONObject.getString("message") == null ? "\u670d\u52a1\u53d1\u5e03\u5931\u8d25\uff01" : jSONObject.getString("message"));
    }

    @Override
    public void reCreateCache(IGeoService iGeoService) {
        String string;
        JSONObject jSONObject;
        String string2;
        if (iGeoService.getServiceType() == ServiceType.DTileService && !"OK".equalsIgnoreCase(string2 = (jSONObject = JSONObject.parseObject((String)(string = HttpClientUtil.doPost(String.format("%s/rest/%s/dtile/reload", this.b, iGeoService.getName()), null)))).getString("status"))) {
            String string3 = jSONObject.get((Object)"message").toString();
            a.error(iGeoService.getName() + "\u6e05\u9664\u7f13\u5b58\u5931\u8d25\uff01" + string3);
        }
    }

    @Override
    public IGeoService publishTempService(IServicePublishParams iServicePublishParams) {
        IMEServicePublishParams iMEServicePublishParams = (IMEServicePublishParams)iServicePublishParams;
        PublishDataset publishDataset = iMEServicePublishParams.getPublishDataset();
        switch (iMEServicePublishParams.getServiceType()) {
            case RasterTileService: {
                IMEDatasourceType iMEDatasourceType = IMEDatasourceType.getByValue(publishDataset.getDbType());
                if (iMEDatasourceType == IMEDatasourceType.arcgisTiles) {
                    IMEService iMEService = new IMEService(this);
                    iMEService.setId(null);
                    iMEService.setName(iMEServicePublishParams.getServiceName());
                    iMEService.setAliasName(iMEServicePublishParams.getServiceAliasName());
                    iMEService.setServiceType(ServiceType.RasterTileService);
                    String string = publishDataset.getDbUrl() + File.separator + publishDataset.getDatasetName();
                    String string2 = this.b + "/rest/wmts?connParam=" + URLEncoder.encode(string, "utf-8");
                    iMEService.setServiceUrl(string2);
                    return iMEService;
                }
                throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u6e90\u7c7b\u578b\uff1a" + publishDataset.getDbType());
            }
        }
        throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u670d\u52a1\u53d1\u5e03\u7c7b\u578b\uff1a" + (Object)((Object)iMEServicePublishParams.getServiceType()));
    }

    public IGeoService publishTempDTileService(String string, Integer n) {
        HashMap<String, String> hashMap = new HashMap<String, String>(0);
        hashMap.put("path", string);
        hashMap.put("srid", String.valueOf(n));
        String string2 = HttpClientUtil.doPost(String.format("%s/rest/admin/dtile/temp", this.b), hashMap);
        JSONObject jSONObject = JSONObject.parseObject((String)string2);
        String string3 = jSONObject.getString("status");
        if (!"OK".equalsIgnoreCase(string3)) {
            String string4 = jSONObject.get((Object)"message").toString();
            throw new RuntimeException("\u4e34\u65f6\u670d\u52a1\u521b\u5efa\u5931\u8d25\uff01" + string4);
        }
        return this.a(jSONObject.getJSONObject("result"));
    }

    private String a(IMEServicePublishParams iMEServicePublishParams, String string) {
        String string2 = this.registerDatasource(iMEServicePublishParams, string);
        String string3 = iMEServicePublishParams.getPublishDataset().getDatasetName();
        if (string3.startsWith("public.")) {
            string3 = string3.substring("public.".length());
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(0);
        hashMap.put("type", "DTile");
        hashMap.put("name", iMEServicePublishParams.getServiceName());
        hashMap.put("alias", iMEServicePublishParams.getServiceAliasName());
        hashMap.put("datasourceID", string2);
        hashMap.put("dataset", string3);
        hashMap.put("pyramidKey", iMEServicePublishParams.getPyramidKey());
        String string4 = HttpClientUtil.doPost(String.format("%s/rest/admin/publish", this.b), hashMap);
        return string4;
    }

    private String a(IMEServicePublishParams iMEServicePublishParams, String string, String string2) {
        String string3 = this.registerDatasource(iMEServicePublishParams, string2);
        HashMap<String, String> hashMap = new HashMap<String, String>(0);
        hashMap.put("type", string);
        hashMap.put("name", iMEServicePublishParams.getServiceName());
        hashMap.put("alias", iMEServicePublishParams.getServiceAliasName());
        hashMap.put("datasource", string3);
        hashMap.put("datasetName", iMEServicePublishParams.getPublishDataset().getDatasetName());
        String string4 = HttpClientUtil.doPost(String.format("%s/rest/admin/publishTile", this.b), hashMap);
        return string4;
    }

    private List<IGeoService> a(Map<String, String> map) {
        ArrayList<IGeoService> arrayList = new ArrayList<IGeoService>();
        try {
            String string = HttpClientUtil.doGet(String.format("%s/rest/admin/list", this.b), map);
            JSONObject jSONObject = JSONObject.parseObject((String)string);
            if (!"OK".equalsIgnoreCase(jSONObject.getString("status"))) {
                throw new RuntimeException(jSONObject.getString("message"));
            }
            String string2 = jSONObject.get((Object)"results") == null ? "" : jSONObject.get((Object)"results").toString();
            JSONArray jSONArray = JSONArray.parseArray((String)string2);
            if (jSONArray == null) {
                return arrayList;
            }
            int n = jSONArray.size();
            for (int i = 0; i < n; ++i) {
                JSONObject jSONObject2 = jSONArray.getJSONObject(i);
                IMEService iMEService = this.a(jSONObject2);
                if (iMEService == null) continue;
                arrayList.add(iMEService);
            }
            arrayList.sort(Comparator.comparingInt(iGeoService -> iGeoService.getServiceType().getValue()));
            return arrayList;
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            if (string == null) {
                string = "IME\u670d\u52a1\u5668\u8bbf\u95ee\u5931\u8d25";
            }
            throw new RuntimeException("\u83b7\u53d6\u670d\u52a1\u5217\u8868\u5931\u8d25\uff1a" + string, exception);
        }
    }

    private IMEService a(JSONObject jSONObject) {
        int n;
        String string = jSONObject.getString("serviceType");
        ServiceType serviceType = IMEServer.a(string);
        if (serviceType == ServiceType.Unknown) {
            return null;
        }
        IMEService iMEService = new IMEService(this);
        iMEService.setName(jSONObject.getString("name"));
        iMEService.setId(jSONObject.getString("id"));
        iMEService.setAliasName(jSONObject.getString("alias"));
        iMEService.setServiceType(serviceType);
        String string2 = string.toLowerCase(Locale.ROOT);
        if ("Tile".equals(string)) {
            string2 = "wmts";
        }
        String string3 = null;
        JSONObject jSONObject2 = jSONObject.getJSONObject("capacities");
        if (jSONObject2 == null) {
            a.error(jSONObject.getString("name") + " \u670d\u52a1capacities\u4e3a\u7a7a");
            String string4 = jSONObject.getString("root");
            if (string4 != null && !string4.isEmpty()) {
                string3 = string4 + iMEService.getName() + "/" + string.toLowerCase();
            }
        } else {
            string3 = jSONObject2.getString(string2);
        }
        if (string3 == null) {
            return null;
        }
        if (string3 != null && !string3.startsWith(this.b) && (n = string3.indexOf("/rest")) > 0) {
            string3 = this.b + string3.substring(n);
        }
        iMEService.setServiceUrl(string3);
        return iMEService;
    }

    private static ServiceType a(String string) {
        switch (string) {
            case "Tile": {
                return ServiceType.RasterTileService;
            }
            case "POI": {
                return ServiceType.POIService;
            }
            case "Terrain": {
                return ServiceType.TerrainService;
            }
            case "DTile": {
                return ServiceType.DTileService;
            }
            case "Annotation": {
                return ServiceType.Annotation3dService;
            }
            case "3dtiles": {
                return ServiceType.Tiles3dService;
            }
            case "Aggregation": {
                return ServiceType.Aggregation;
            }
        }
        return ServiceType.Unknown;
    }

    private static String a(ServiceType serviceType) {
        switch (serviceType) {
            case RasterTileService: {
                return "Tile";
            }
            case DTileService: {
                return "DTile";
            }
            case POIService: {
                return "POI";
            }
            case TerrainService: {
                return "Terrain";
            }
            case Annotation3dService: {
                return "Annotation";
            }
            case Tiles3dService: {
                return "3dtiles";
            }
            case Aggregation: {
                return "Aggregation";
            }
        }
        return "";
    }

    public String registerDatasource(IMEServicePublishParams iMEServicePublishParams, String string) {
        Object object;
        int n;
        PublishDataset publishDataset = iMEServicePublishParams.getPublishDataset();
        String string2 = publishDataset.getDbUrl().startsWith("/") || publishDataset.getDbUrl().startsWith("\\") ? new File(publishDataset.getDbUrl()).getName() : publishDataset.getDbUrl().replace("/", "").replace(":", "_");
        JSONArray jSONArray = this.b(string);
        JSONObject jSONObject = null;
        if (jSONArray != null) {
            for (n = 0; n < jSONArray.size(); ++n) {
                object = jSONArray.getJSONObject(n);
                if (!publishDataset.getDbUrl().equals(object.getString("connParams")) || !publishDataset.getDbType().equals(object.getString("type"))) continue;
                jSONObject = object;
                break;
            }
        }
        if (jSONObject == null) {
            if (jSONArray != null) {
                for (n = 0; n < jSONArray.size(); ++n) {
                    if (!jSONArray.getJSONObject(n).getString("name").equals(string2)) continue;
                    string2 = string2 + "_" + new Date().getTime();
                    break;
                }
            }
            HashMap<String, String> hashMap = new HashMap<String, String>(0);
            hashMap.put("cate", string);
            hashMap.put("name", string2);
            hashMap.put("connParams", publishDataset.getDbUrl());
            hashMap.put("user", publishDataset.getDbUser());
            hashMap.put("pwd", publishDataset.getDbPassword());
            hashMap.put("type", publishDataset.getDbType());
            object = HttpClientUtil.doPost(String.format("%s/rest/admin/datasource/publish", this.b), hashMap);
            JSONObject jSONObject2 = JSONObject.parseObject((String)object);
            if ("ok".equalsIgnoreCase(jSONObject2.getString("status"))) {
                jSONArray = this.b(string);
                for (int i = 0; i < jSONArray.size(); ++i) {
                    if (!jSONArray.getJSONObject(i).getString("name").equals(string2)) continue;
                    jSONObject = jSONArray.getJSONObject(i);
                    break;
                }
            } else {
                throw new RuntimeException((String)object);
            }
        }
        if (jSONObject == null) {
            throw new RuntimeException("\u6570\u636e\u6e90\u6ce8\u518c\u5931\u8d25\uff01");
        }
        return jSONObject.getString("id");
    }

    private JSONArray b(String string) {
        String string2 = HttpClientUtil.doGet(String.format("%s/rest/admin/datasource/list?cate=%s", this.b, string));
        JSONObject jSONObject = JSONObject.parseObject((String)string2);
        if ("ok".equalsIgnoreCase(jSONObject.getString("status"))) {
            String string3 = jSONObject.get((Object)"results") == null ? "" : jSONObject.get((Object)"results").toString();
            JSONArray jSONArray = JSONArray.parseArray((String)string3);
            return jSONArray;
        }
        throw new RuntimeException(string2);
    }
}

