/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.gis.raster.a;

import com.geoway.adf.gis.basic.geometry.GeometryFunc;
import com.geoway.adf.gis.basic.geometry.SpatialReferenceSystemFunc;
import com.geoway.adf.gis.raster.IRasterDataset;
import com.geoway.adf.gis.raster.IRasterWorkspace;
import com.geoway.adf.gis.raster.info.PixelDataType;
import com.geoway.adf.gis.raster.info.RasterInfo;
import com.geoway.adf.gis.raster.info.RasterStatisticInfo;
import com.geoway.adf.gis.raster.info.Size;
import java.util.ArrayList;
import java.util.Arrays;
import org.gdal.gdal.Band;
import org.gdal.gdal.Dataset;
import org.gdal.gdal.gdal;
import org.gdal.gdalconst.gdalconstConstants;

public class a
implements IRasterDataset {
    protected String a;
    protected String b;
    protected IRasterWorkspace c;
    private RasterInfo d;
    private Dataset e;

    public a(IRasterWorkspace iRasterWorkspace, String string, String string2, Dataset dataset) {
        this.a = string;
        this.b = string2;
        this.c = iRasterWorkspace;
        this.e = dataset;
        this.a(string2);
    }

    @Override
    public Dataset getRaster() {
        return this.e;
    }

    @Override
    public String getName() {
        return this.a;
    }

    @Override
    public String getFullName() {
        return this.b;
    }

    @Override
    public RasterInfo getRasterInfo() {
        return this.d;
    }

    @Override
    public void closeRaster() {
        this.e.delete();
    }

    @Override
    public boolean calculateStatisticInfo(boolean bl) {
        if (bl && this.d.getStatisticInfos() != null) {
            return true;
        }
        RasterStatisticInfo[] rasterStatisticInfoArray = new RasterStatisticInfo[this.d.getBandCount().intValue()];
        for (int i = 0; i < this.e.getRasterCount(); ++i) {
            double[] dArray = new double[1];
            double[] dArray2 = new double[1];
            double[] dArray3 = new double[1];
            double[] dArray4 = new double[1];
            if (this.e.GetRasterBand(i + 1).ComputeStatistics(true, dArray, dArray2, dArray3, dArray4) != 0) {
                return false;
            }
            RasterStatisticInfo rasterStatisticInfo = new RasterStatisticInfo();
            rasterStatisticInfo.setMinValue(dArray[0]);
            rasterStatisticInfo.setMaxValue(dArray2[0]);
            rasterStatisticInfo.setMeanValue(dArray3[0]);
            rasterStatisticInfo.setStdValue(dArray4[0]);
            rasterStatisticInfoArray[i] = rasterStatisticInfo;
        }
        this.d.setStatisticInfos(rasterStatisticInfoArray);
        return true;
    }

    @Override
    public boolean defineNoDataValue(Double d) {
        for (int i = 0; i < this.e.getRasterCount(); ++i) {
            this.e.GetRasterBand(i + 1).SetNoDataValue(d.doubleValue());
        }
        Object[] objectArray = new Double[this.d.getBandCount().intValue()];
        Arrays.fill(objectArray, d);
        this.d.setInvalidValue((Double[])objectArray);
        return true;
    }

    @Override
    public boolean saveAs(String string) {
        Dataset dataset = gdal.Translate((String)string, (Dataset)this.e, null);
        if (dataset != null) {
            dataset.delete();
            return true;
        }
        return false;
    }

    private void a(String string) {
        this.d = new RasterInfo();
        this.d.setRasterPath(string);
        this.d.setWidth(this.e.GetRasterXSize());
        this.d.setHeight(this.e.GetRasterYSize());
        this.d.setBandCount(this.e.GetRasterCount());
        int n = this.e.GetRasterBand(1).GetRasterDataType();
        this.d.setPixelDataType(com.geoway.adf.gis.raster.a.a.a(n));
        int n2 = this.e.GetRasterBand(1).GetOverviewCount();
        this.d.setHasPyramid(n2 > 0);
        this.d.setPyramidLevel(n2);
        if (n2 > 0) {
            ArrayList<Size> arrayList = new ArrayList<Size>();
            for (int i = 0; i < n2; ++i) {
                Band band = this.e.GetRasterBand(1).GetOverview(i);
                arrayList.add(new Size(band.getXSize(), band.getYSize()));
            }
            this.d.setPyramidSizes(arrayList);
        }
        boolean bl = false;
        Double[] doubleArray = new Double[this.e.getRasterCount()];
        for (int i = 0; i < this.e.getRasterCount(); ++i) {
            Double[] doubleArray2 = new Double[1];
            this.e.GetRasterBand(i + 1).GetNoDataValue(doubleArray2);
            doubleArray[i] = doubleArray2[0];
            bl = bl || doubleArray2[0] != null;
        }
        this.d.setHasInvalidValue(bl);
        this.d.setInvalidValue(doubleArray);
        double[] dArray = this.e.GetGeoTransform();
        this.d.setXResolution(dArray[1]);
        this.d.setYResolution(dArray[5]);
        double d = dArray[0];
        double d2 = dArray[3];
        double d3 = d + (double)this.e.getRasterXSize() * dArray[1] + (double)this.e.getRasterXSize() * dArray[2];
        double d4 = d2 + (double)this.e.getRasterYSize() * dArray[4] + (double)this.e.getRasterYSize() * dArray[5];
        this.d.setExtent(GeometryFunc.createEnvelope((double)d, (double)d4, (double)d3, (double)d2));
        if (this.e.GetSpatialRef() != null) {
            this.d.setSpatialReferenceSystem(SpatialReferenceSystemFunc.createSpatialReferenceByObject((Object)this.e.GetSpatialRef()));
        }
        boolean bl2 = true;
        RasterStatisticInfo[] rasterStatisticInfoArray = new RasterStatisticInfo[this.d.getBandCount().intValue()];
        for (int i = 0; i < this.e.getRasterCount(); ++i) {
            double[] dArray2 = new double[1];
            double[] dArray3 = new double[1];
            double[] dArray4 = new double[1];
            double[] dArray5 = new double[1];
            if (this.e.GetRasterBand(i + 1).GetStatistics(false, false, dArray2, dArray3, dArray4, dArray5) != 0) {
                bl2 = false;
                break;
            }
            if (dArray3[0] < dArray2[0]) {
                bl2 = false;
                break;
            }
            RasterStatisticInfo rasterStatisticInfo = new RasterStatisticInfo();
            rasterStatisticInfo.setMinValue(dArray2[0]);
            rasterStatisticInfo.setMaxValue(dArray3[0]);
            rasterStatisticInfo.setMeanValue(dArray4[0]);
            rasterStatisticInfo.setStdValue(dArray5[0]);
            rasterStatisticInfoArray[i] = rasterStatisticInfo;
        }
        if (bl2) {
            this.d.setStatisticInfos(rasterStatisticInfoArray);
        }
    }

    private static PixelDataType a(int n) {
        PixelDataType pixelDataType = PixelDataType.Unknown;
        if (n == gdalconstConstants.GDT_Byte) {
            pixelDataType = PixelDataType.Byte;
        } else if (n == gdalconstConstants.GDT_CFloat32) {
            pixelDataType = PixelDataType.CFloat32;
        } else if (n == gdalconstConstants.GDT_CFloat64) {
            pixelDataType = PixelDataType.CFloat64;
        } else if (n == gdalconstConstants.GDT_CInt16) {
            pixelDataType = PixelDataType.CInt16;
        } else if (n == gdalconstConstants.GDT_CInt32) {
            pixelDataType = PixelDataType.CInt32;
        } else if (n == gdalconstConstants.GDT_Float32) {
            pixelDataType = PixelDataType.Float32;
        } else if (n == gdalconstConstants.GDT_Float64) {
            pixelDataType = PixelDataType.Float64;
        } else if (n == gdalconstConstants.GDT_Int16) {
            pixelDataType = PixelDataType.Int16;
        } else if (n == gdalconstConstants.GDT_Int32) {
            pixelDataType = PixelDataType.Int32;
        } else if (n == gdalconstConstants.GDT_TypeCount) {
            pixelDataType = PixelDataType.TypeCount;
        } else if (n == gdalconstConstants.GDT_UInt16) {
            pixelDataType = PixelDataType.UInt16;
        } else if (n == gdalconstConstants.GDT_UInt32) {
            pixelDataType = PixelDataType.UInt32;
        } else if (n == gdalconstConstants.GDT_Unknown) {
            pixelDataType = PixelDataType.Unknown;
        }
        return pixelDataType;
    }
}

