/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.gis.raster.info;

import com.geoway.adf.gis.basic.geometry.IEnvelope;
import com.geoway.adf.gis.basic.geometry.ISpatialReferenceSystem;
import com.geoway.adf.gis.raster.info.PixelDataType;
import com.geoway.adf.gis.raster.info.RasterStatisticInfo;
import com.geoway.adf.gis.raster.info.RasterStorageInfo;
import com.geoway.adf.gis.raster.info.Size;
import java.util.Arrays;
import java.util.List;

public class RasterInfo {
    private String m;
    private Integer n;
    private Integer o;
    private Integer p;
    private Double q;
    private Double r;
    private PixelDataType s;
    private Boolean t;
    private Double[] u;
    private Integer v;
    private Boolean w;
    private List<Size> x;
    private IEnvelope y;
    private ISpatialReferenceSystem z;
    private RasterStatisticInfo[] A;
    private RasterStorageInfo B;

    public String getRasterPath() {
        return this.m;
    }

    public Integer getHeight() {
        return this.n;
    }

    public Integer getWidth() {
        return this.o;
    }

    public Integer getBandCount() {
        return this.p;
    }

    public Double getXResolution() {
        return this.q;
    }

    public Double getYResolution() {
        return this.r;
    }

    public PixelDataType getPixelDataType() {
        return this.s;
    }

    public Boolean getHasInvalidValue() {
        return this.t;
    }

    public Double[] getInvalidValue() {
        return this.u;
    }

    public Integer getPyramidLevel() {
        return this.v;
    }

    public Boolean getHasPyramid() {
        return this.w;
    }

    public List<Size> getPyramidSizes() {
        return this.x;
    }

    public IEnvelope getExtent() {
        return this.y;
    }

    public ISpatialReferenceSystem getSpatialReferenceSystem() {
        return this.z;
    }

    public RasterStatisticInfo[] getStatisticInfos() {
        return this.A;
    }

    public RasterStorageInfo getStorageInfo() {
        return this.B;
    }

    public void setRasterPath(String string) {
        this.m = string;
    }

    public void setHeight(Integer n) {
        this.n = n;
    }

    public void setWidth(Integer n) {
        this.o = n;
    }

    public void setBandCount(Integer n) {
        this.p = n;
    }

    public void setXResolution(Double d) {
        this.q = d;
    }

    public void setYResolution(Double d) {
        this.r = d;
    }

    public void setPixelDataType(PixelDataType pixelDataType) {
        this.s = pixelDataType;
    }

    public void setHasInvalidValue(Boolean bl) {
        this.t = bl;
    }

    public void setInvalidValue(Double[] doubleArray) {
        this.u = doubleArray;
    }

    public void setPyramidLevel(Integer n) {
        this.v = n;
    }

    public void setHasPyramid(Boolean bl) {
        this.w = bl;
    }

    public void setPyramidSizes(List<Size> list) {
        this.x = list;
    }

    public void setExtent(IEnvelope iEnvelope) {
        this.y = iEnvelope;
    }

    public void setSpatialReferenceSystem(ISpatialReferenceSystem iSpatialReferenceSystem) {
        this.z = iSpatialReferenceSystem;
    }

    public void setStatisticInfos(RasterStatisticInfo[] rasterStatisticInfoArray) {
        this.A = rasterStatisticInfoArray;
    }

    public void setStorageInfo(RasterStorageInfo rasterStorageInfo) {
        this.B = rasterStorageInfo;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof RasterInfo)) {
            return false;
        }
        RasterInfo rasterInfo = (RasterInfo)object;
        if (!rasterInfo.canEqual(this)) {
            return false;
        }
        Integer n = this.getHeight();
        Integer n2 = rasterInfo.getHeight();
        if (n == null ? n2 != null : !((Object)n).equals(n2)) {
            return false;
        }
        Integer n3 = this.getWidth();
        Integer n4 = rasterInfo.getWidth();
        if (n3 == null ? n4 != null : !((Object)n3).equals(n4)) {
            return false;
        }
        Integer n5 = this.getBandCount();
        Integer n6 = rasterInfo.getBandCount();
        if (n5 == null ? n6 != null : !((Object)n5).equals(n6)) {
            return false;
        }
        Double d = this.getXResolution();
        Double d2 = rasterInfo.getXResolution();
        if (d == null ? d2 != null : !((Object)d).equals(d2)) {
            return false;
        }
        Double d3 = this.getYResolution();
        Double d4 = rasterInfo.getYResolution();
        if (d3 == null ? d4 != null : !((Object)d3).equals(d4)) {
            return false;
        }
        Boolean bl = this.getHasInvalidValue();
        Boolean bl2 = rasterInfo.getHasInvalidValue();
        if (bl == null ? bl2 != null : !((Object)bl).equals(bl2)) {
            return false;
        }
        Integer n7 = this.getPyramidLevel();
        Integer n8 = rasterInfo.getPyramidLevel();
        if (n7 == null ? n8 != null : !((Object)n7).equals(n8)) {
            return false;
        }
        Boolean bl3 = this.getHasPyramid();
        Boolean bl4 = rasterInfo.getHasPyramid();
        if (bl3 == null ? bl4 != null : !((Object)bl3).equals(bl4)) {
            return false;
        }
        String string = this.getRasterPath();
        String string2 = rasterInfo.getRasterPath();
        if (string == null ? string2 != null : !string.equals(string2)) {
            return false;
        }
        PixelDataType pixelDataType = this.getPixelDataType();
        PixelDataType pixelDataType2 = rasterInfo.getPixelDataType();
        if (pixelDataType == null ? pixelDataType2 != null : !((Object)((Object)pixelDataType)).equals((Object)pixelDataType2)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getInvalidValue(), rasterInfo.getInvalidValue())) {
            return false;
        }
        List<Size> list = this.getPyramidSizes();
        List<Size> list2 = rasterInfo.getPyramidSizes();
        if (list == null ? list2 != null : !((Object)list).equals(list2)) {
            return false;
        }
        IEnvelope iEnvelope = this.getExtent();
        IEnvelope iEnvelope2 = rasterInfo.getExtent();
        if (iEnvelope == null ? iEnvelope2 != null : !iEnvelope.equals(iEnvelope2)) {
            return false;
        }
        ISpatialReferenceSystem iSpatialReferenceSystem = this.getSpatialReferenceSystem();
        ISpatialReferenceSystem iSpatialReferenceSystem2 = rasterInfo.getSpatialReferenceSystem();
        if (iSpatialReferenceSystem == null ? iSpatialReferenceSystem2 != null : !iSpatialReferenceSystem.equals(iSpatialReferenceSystem2)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getStatisticInfos(), rasterInfo.getStatisticInfos())) {
            return false;
        }
        RasterStorageInfo rasterStorageInfo = this.getStorageInfo();
        RasterStorageInfo rasterStorageInfo2 = rasterInfo.getStorageInfo();
        return !(rasterStorageInfo == null ? rasterStorageInfo2 != null : !((Object)rasterStorageInfo).equals(rasterStorageInfo2));
    }

    protected boolean canEqual(Object object) {
        return object instanceof RasterInfo;
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        Integer n3 = this.getHeight();
        n2 = n2 * 59 + (n3 == null ? 43 : ((Object)n3).hashCode());
        Integer n4 = this.getWidth();
        n2 = n2 * 59 + (n4 == null ? 43 : ((Object)n4).hashCode());
        Integer n5 = this.getBandCount();
        n2 = n2 * 59 + (n5 == null ? 43 : ((Object)n5).hashCode());
        Double d = this.getXResolution();
        n2 = n2 * 59 + (d == null ? 43 : ((Object)d).hashCode());
        Double d2 = this.getYResolution();
        n2 = n2 * 59 + (d2 == null ? 43 : ((Object)d2).hashCode());
        Boolean bl = this.getHasInvalidValue();
        n2 = n2 * 59 + (bl == null ? 43 : ((Object)bl).hashCode());
        Integer n6 = this.getPyramidLevel();
        n2 = n2 * 59 + (n6 == null ? 43 : ((Object)n6).hashCode());
        Boolean bl2 = this.getHasPyramid();
        n2 = n2 * 59 + (bl2 == null ? 43 : ((Object)bl2).hashCode());
        String string = this.getRasterPath();
        n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
        PixelDataType pixelDataType = this.getPixelDataType();
        n2 = n2 * 59 + (pixelDataType == null ? 43 : ((Object)((Object)pixelDataType)).hashCode());
        n2 = n2 * 59 + Arrays.deepHashCode(this.getInvalidValue());
        List<Size> list = this.getPyramidSizes();
        n2 = n2 * 59 + (list == null ? 43 : ((Object)list).hashCode());
        IEnvelope iEnvelope = this.getExtent();
        n2 = n2 * 59 + (iEnvelope == null ? 43 : iEnvelope.hashCode());
        ISpatialReferenceSystem iSpatialReferenceSystem = this.getSpatialReferenceSystem();
        n2 = n2 * 59 + (iSpatialReferenceSystem == null ? 43 : iSpatialReferenceSystem.hashCode());
        n2 = n2 * 59 + Arrays.deepHashCode(this.getStatisticInfos());
        RasterStorageInfo rasterStorageInfo = this.getStorageInfo();
        n2 = n2 * 59 + (rasterStorageInfo == null ? 43 : ((Object)rasterStorageInfo).hashCode());
        return n2;
    }

    public String toString() {
        return "RasterInfo(rasterPath=" + this.getRasterPath() + ", height=" + this.getHeight() + ", width=" + this.getWidth() + ", bandCount=" + this.getBandCount() + ", xResolution=" + this.getXResolution() + ", yResolution=" + this.getYResolution() + ", pixelDataType=" + (Object)((Object)this.getPixelDataType()) + ", hasInvalidValue=" + this.getHasInvalidValue() + ", invalidValue=" + Arrays.deepToString(this.getInvalidValue()) + ", pyramidLevel=" + this.getPyramidLevel() + ", hasPyramid=" + this.getHasPyramid() + ", pyramidSizes=" + this.getPyramidSizes() + ", extent=" + this.getExtent() + ", spatialReferenceSystem=" + this.getSpatialReferenceSystem() + ", statisticInfos=" + Arrays.deepToString(this.getStatisticInfos()) + ", storageInfo=" + this.getStorageInfo() + ")";
    }
}

