/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.gis.tile.arcgis;

import com.geoway.adf.gis.tile.ITileDataSource;
import com.geoway.adf.gis.tile.ITileDataset;
import com.geoway.adf.gis.tile.TileMeta;
import com.geoway.adf.gis.tile.TileType;
import com.geoway.adf.gis.tile.a.a;
import com.geoway.adf.gis.tile.a.b;
import com.geoway.adf.gis.tile.a.c;
import com.geoway.adf.gis.tile.arcgis.ArcGISTileMeta;
import com.geoway.adf.gis.tile.arcgis.TilingSchemaHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class ArcGISTileDataSource
implements ITileDataSource {
    protected final File tilePath;

    public ArcGISTileDataSource(String string) {
        this.tilePath = new File(string);
    }

    @Override
    public String getConnectionString() {
        return this.tilePath.toString();
    }

    @Override
    public boolean connect() {
        return this.tilePath.exists();
    }

    @Override
    public void close() {
    }

    @Override
    public List<ITileDataset> getDatasets() {
        ITileDataset iTileDataset = this.getDataset(null);
        ArrayList<ITileDataset> arrayList = new ArrayList<ITileDataset>();
        arrayList.add(iTileDataset);
        return arrayList;
    }

    @Override
    public List<ITileDataset> getDatasets(TileType ... tileTypeArray) {
        return this.getDatasets();
    }

    @Override
    public ITileDataset getDataset(String string) {
        ArcGISTileMeta arcGISTileMeta = this.a();
        if (arcGISTileMeta == null) {
            return null;
        }
        ITileDataset iTileDataset = null;
        switch (arcGISTileMeta.getStorageFormat()) {
            case Exploded: {
                iTileDataset = new c(this, arcGISTileMeta);
                break;
            }
            case Compact: {
                iTileDataset = new a(this, arcGISTileMeta);
                break;
            }
            case CompactV2: {
                iTileDataset = new b(this, arcGISTileMeta);
            }
        }
        return iTileDataset;
    }

    @Override
    public ITileDataset createDataset(TileMeta tileMeta) {
        File file = new File(this.tilePath, "_alllayers");
        if (!file.isDirectory() || !file.exists()) {
            this.mkdirs(file);
        }
        ArcGISTileMeta arcGISTileMeta = new ArcGISTileMeta();
        arcGISTileMeta.copyFrom(tileMeta);
        arcGISTileMeta.setTileType(TileType.RasterTile);
        TilingSchemaHelper.writeMetaInfo(this.tilePath, arcGISTileMeta);
        ITileDataset iTileDataset = null;
        switch (arcGISTileMeta.getStorageFormat()) {
            case Exploded: {
                iTileDataset = new c(this, arcGISTileMeta);
                break;
            }
            case Compact: {
                iTileDataset = new a(this, arcGISTileMeta);
                break;
            }
            case CompactV2: {
                iTileDataset = new b(this, arcGISTileMeta);
            }
        }
        return iTileDataset;
    }

    @Override
    public void deleteDataset(String string) {
        if (this.tilePath.exists()) {
            this.tilePath.delete();
        }
    }

    public boolean updateTileMeta(TileMeta tileMeta) {
        if (!(tileMeta instanceof ArcGISTileMeta)) {
            throw new RuntimeException("\u5143\u6570\u636e\u7c7b\u578b\u4e0d\u6b63\u786e");
        }
        TilingSchemaHelper.writeMetaInfo(this.tilePath, (ArcGISTileMeta)tileMeta);
        return true;
    }

    private ArcGISTileMeta a() {
        ArcGISTileMeta arcGISTileMeta = TilingSchemaHelper.ReadESRIMetaInfo(this.tilePath);
        if (arcGISTileMeta == null) {
            return null;
        }
        File file = new File(this.tilePath, "_alllayers");
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (File file2 : fileArray) {
                if (!file2.getName().startsWith("L")) continue;
                Integer n = null;
                try {
                    n = Integer.parseInt(file2.getName().substring(1));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (n == null) continue;
                arrayList.add(n);
            }
        }
        arrayList.sort(Integer::compareTo);
        if (arrayList.size() > 0) {
            arcGISTileMeta.setStartLevel((Integer)arrayList.get(0));
            arcGISTileMeta.setEndLevel((Integer)arrayList.get(arrayList.size() - 1));
            arcGISTileMeta.setLevels(arrayList);
        }
        return arcGISTileMeta;
    }

    public void mkdirs(File file) {
        if (file.isDirectory() && file.exists()) {
            return;
        }
        if (!file.mkdirs() && !file.exists()) {
            throw new RuntimeException(file + " \u76ee\u5f55\u521b\u5efa\u5931\u8d25");
        }
    }
}

