/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.gis.tile.a;

import com.alibaba.fastjson2.JSONObject;
import com.geoway.adf.gis.basic.geometry.IGeometry;
import com.geoway.adf.gis.tile.IModel3dTileDataset;
import com.geoway.adf.gis.tile.ITileDataSource;
import com.geoway.adf.gis.tile.ITileDataset;
import com.geoway.adf.gis.tile.TileData;
import com.geoway.adf.gis.tile.TileMeta;
import com.geoway.adf.gis.tile.TileType;
import com.geoway.adf.gis.tile.meta.MapExtent;
import com.geoway.adf.gis.tile.model3d.Model3dTileDataSource;
import com.geoway.adf.gis.tile.model3d.parse.TilesetJsonUtil;
import com.geoway.adf.gis.tile.model3d.parse.TilesetObject;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Date;
import java.util.List;
import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class h
implements IModel3dTileDataset,
ITileDataset {
    private static final Logger a = LoggerFactory.getLogger(h.class);
    private final Model3dTileDataSource aD;
    private TileMeta u;
    private final String aE;
    private final Stack<File> aA = new Stack();
    private final Stack<TilesetObject> aF = new Stack();
    private IGeometry aB;
    private MapExtent aC;

    public h(Model3dTileDataSource model3dTileDataSource, TileMeta tileMeta) {
        this.aD = model3dTileDataSource;
        this.u = tileMeta;
        this.aE = model3dTileDataSource.getConnectionString();
    }

    @Override
    public String getName() {
        return this.u.getName();
    }

    @Override
    public String getAliasName() {
        return this.u.getAliasName();
    }

    @Override
    public TileType getType() {
        return this.u.getTileType();
    }

    @Override
    public ITileDataSource getDataSource() {
        return this.aD;
    }

    @Override
    public TileMeta getTileMeta() {
        return this.u;
    }

    @Override
    public void startWrite() {
    }

    @Override
    public void commitWrite(boolean bl) {
    }

    @Override
    public boolean updateTileMeta(TileMeta tileMeta) {
        TileMeta tileMeta2 = new TileMeta();
        tileMeta2.copyFrom(tileMeta);
        tileMeta2.setUpdateTime(new Date());
        return true;
    }

    @Override
    public List<Integer> getAllLevels() {
        return this.u.getLevels();
    }

    @Override
    public Long getDataCount() {
        return null;
    }

    @Override
    public Long getDataSize() {
        return null;
    }

    @Override
    public boolean existTile(int n, int n2, int n3) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TileData getTile(int n, int n2, int n3) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TileData getTile(String string) {
        File file = new File(this.aE, string);
        return this.a(file);
    }

    @Override
    public boolean deleteTile(int n, int n2, int n3) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean writeTile(TileData tileData, boolean bl) {
        File file = new File(this.aE, tileData.getKey());
        if (file.exists() && !bl) {
            return false;
        }
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        Files.write(file.toPath(), tileData.getData(), StandardOpenOption.CREATE);
        return true;
    }

    @Override
    public void setExtentFilter(MapExtent mapExtent) {
        this.aC = mapExtent;
    }

    @Override
    public void setGeometryFilter(IGeometry iGeometry) {
        this.aB = iGeometry;
        if (iGeometry != null) {
            this.aC = new MapExtent(iGeometry.getEnvelope().getXMin(), iGeometry.getEnvelope().getYMin(), iGeometry.getEnvelope().getXMax(), iGeometry.getEnvelope().getYMax());
        }
    }

    @Override
    public void resetReading() {
        this.aA.clear();
        if (this.aC == null) {
            this.aA.push(new File(this.aE));
        } else {
            TilesetObject tilesetObject = new TilesetObject();
            tilesetObject.setContentUri("tileset.json");
            this.aF.push(tilesetObject);
        }
    }

    @Override
    public TileData nextTileData() {
        if (this.aC != null) {
            return this.l();
        }
        if (this.aA.isEmpty()) {
            return null;
        }
        File file = this.aA.pop();
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            if (fileArray != null) {
                for (int i2 = fileArray.length - 1; i2 >= 0; --i2) {
                    this.aA.push(fileArray[i2]);
                }
            }
            return this.nextTileData();
        }
        TileData tileData = this.a(file);
        if (tileData == null) {
            return this.nextTileData();
        }
        return tileData;
    }

    private TileData l() {
        if (this.aF.isEmpty()) {
            return null;
        }
        TilesetObject tilesetObject = this.aF.pop();
        String string = tilesetObject.getContentUri();
        try {
            if (string.contains(".json")) {
                TileData tileData = this.c(string);
                if (tileData == null) {
                    return this.nextTileData();
                }
                String string2 = new String(tileData.getData(), StandardCharsets.UTF_8);
                JSONObject jSONObject = JSONObject.parseObject((String)string2);
                TilesetObject tilesetObject2 = TilesetJsonUtil.filterTileset(jSONObject, tilesetObject, this.aC, this.aB);
                if (tilesetObject2 == null) {
                    return this.nextTileData();
                }
                List<TilesetObject> list = tilesetObject2.getChildren();
                if (list != null) {
                    for (TilesetObject tilesetObject3 : list) {
                        if (tilesetObject3.getContentUri() == null || tilesetObject3.getContentUri().isEmpty()) continue;
                        tilesetObject3.setContentUri(TilesetJsonUtil.getRelativeUri(string, tilesetObject3.getContentUri()));
                        this.aF.push(tilesetObject3);
                    }
                }
                if (tilesetObject2.getContentUri() != null && !tilesetObject2.getContentUri().isEmpty()) {
                    TilesetObject tilesetObject4 = new TilesetObject();
                    tilesetObject4.setBoundingVolume(tilesetObject2.getBoundingVolume());
                    tilesetObject4.setContentUri(TilesetJsonUtil.getRelativeUri(string, tilesetObject2.getContentUri()));
                    this.aF.push(tilesetObject4);
                }
                tileData.setData(jSONObject.toString().getBytes(StandardCharsets.UTF_8));
                return tileData;
            }
            TileData tileData = this.c(string);
            if (tileData == null) {
                return this.nextTileData();
            }
            return tileData;
        }
        catch (Exception exception) {
            a.error(string + " \u8bfb\u53d6\u5f02\u5e38", (Throwable)exception);
            return this.nextTileData();
        }
    }

    private TileData c(String string) {
        File file = new File(this.aE, string);
        return this.a(file);
    }

    private TileData a(File file) {
        try {
            String string = file.getCanonicalPath();
            String string2 = file.getCanonicalPath().replace(this.aE, "");
            string2 = string2.replaceAll("\\\\", "/");
            if (string2.startsWith("/")) {
                string2 = string2.substring(1);
            }
            TileData tileData = new TileData();
            tileData.setKey(string2);
            tileData.setFormat("3dtiles");
            tileData.setData(Files.readAllBytes(Paths.get(string, new String[0])));
            return tileData;
        }
        catch (Exception exception) {
            a.error(file.getAbsolutePath() + " \u8bfb\u53d6\u5f02\u5e38", (Throwable)exception);
            return null;
        }
    }
}

