/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.gis.tile.model3d.parse;

import com.geoway.adf.gis.tile.a.i;
import com.geoway.adf.gis.tile.a.j;
import com.geoway.adf.gis.tile.model3d.parse.Tiles3dBoundingVolume;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BoundingVolumeUtil {
    public static double[] regionValues(Tiles3dBoundingVolume tiles3dBoundingVolume) {
        Tiles3dBoundingVolume.Type type = tiles3dBoundingVolume.getType();
        double[] dArray = tiles3dBoundingVolume.getValues();
        switch (type) {
            case region: {
                return dArray;
            }
            case box: {
                double d2 = dArray[0] - dArray[3];
                double d3 = dArray[1] - dArray[7];
                double d4 = dArray[2] - dArray[11];
                double d5 = dArray[0] + dArray[3];
                double d6 = dArray[1] + dArray[7];
                double d7 = dArray[2] + dArray[11];
                ArrayList<j> arrayList = new ArrayList<j>();
                arrayList.add(new j(d2, d3, d4));
                arrayList.add(new j(d2, d6, d4));
                arrayList.add(new j(d5, d6, d4));
                arrayList.add(new j(d5, d3, d4));
                arrayList.add(new j(d2, d3, d7));
                arrayList.add(new j(d2, d6, d7));
                arrayList.add(new j(d5, d6, d7));
                arrayList.add(new j(d5, d3, d7));
                double d8 = Double.MAX_VALUE;
                double d9 = Double.MIN_VALUE;
                double d10 = Double.MAX_VALUE;
                double d11 = Double.MIN_VALUE;
                double d12 = Double.MAX_VALUE;
                double d13 = Double.MIN_VALUE;
                for (j j2 : arrayList) {
                    double[] dArray2 = new double[]{j2.m(), j2.n(), j2.o(), 1.0};
                    double[][] dArray3 = i.a(dArray2, 1, 4);
                    double[][] dArray4 = i.a(tiles3dBoundingVolume.getTransform(), 4, 4);
                    double[][] dArray5 = i.a(dArray3, dArray4);
                    double[] dArray6 = BoundingVolumeUtil.ECEFtoWGS84(dArray5[0][0], dArray5[0][1], dArray5[0][2]);
                    d8 = Math.min(d8, BoundingVolumeUtil.a(dArray6[0]));
                    d9 = Math.max(d9, BoundingVolumeUtil.a(dArray6[0]));
                    d10 = Math.min(d10, BoundingVolumeUtil.a(dArray6[1]));
                    d11 = Math.max(d11, BoundingVolumeUtil.a(dArray6[1]));
                    d12 = Math.min(d12, dArray6[2]);
                    d13 = Math.max(d13, dArray6[2]);
                }
                return new double[]{d8, d10, d9, d11, d12, d13};
            }
        }
        throw new RuntimeException("\u4e0d\u652f\u6301\u7684BoundingVolume\u7c7b\u578b : " + (Object)((Object)type));
    }

    public static Map<String, double[]> region(Tiles3dBoundingVolume tiles3dBoundingVolume) {
        HashMap<String, double[]> hashMap = new HashMap<String, double[]>();
        hashMap.put("region", BoundingVolumeUtil.regionValues(tiles3dBoundingVolume));
        return hashMap;
    }

    public static Tiles3dBoundingVolume union(List<Tiles3dBoundingVolume> list) {
        Tiles3dBoundingVolume tiles3dBoundingVolume = new Tiles3dBoundingVolume();
        tiles3dBoundingVolume.setType(Tiles3dBoundingVolume.Type.region);
        if (list.isEmpty()) {
            tiles3dBoundingVolume.setValues(new double[]{-Math.PI, -1.5707963267948966, Math.PI, 1.5707963267948966, -9999.0, 9999.0});
        } else {
            double d2 = 180.0;
            double d3 = 90.0;
            double d4 = -180.0;
            double d5 = -90.0;
            double d6 = Double.MAX_VALUE;
            double d7 = Double.MIN_VALUE;
            for (Tiles3dBoundingVolume tiles3dBoundingVolume2 : list) {
                double[] dArray = BoundingVolumeUtil.regionValues(tiles3dBoundingVolume2);
                d2 = Math.min(d2, dArray[0]);
                d3 = Math.min(d3, dArray[1]);
                d4 = Math.max(d4, dArray[2]);
                d5 = Math.max(d5, dArray[3]);
                d6 = Math.min(d6, dArray[4]);
                d7 = Math.max(d7, dArray[5]);
            }
            tiles3dBoundingVolume.setValues(new double[]{d2, d3, d4, d5, d6, d7});
        }
        return tiles3dBoundingVolume;
    }

    private static double a(double d2) {
        return d2 * Math.PI / 180.0;
    }

    private static double b(double d2) {
        return d2 * 180.0 / Math.PI;
    }

    public static double[] WGS84toECEF(double d2, double d3, double d4) {
        double d5 = 6378137.0;
        double d6 = 6356752.31424518;
        double d7 = (d5 * d5 - d6 * d6) / (d5 * d5);
        double d8 = Math.cos(d2 * Math.PI / 180.0);
        double d9 = Math.sin(d2 * Math.PI / 180.0);
        double d10 = Math.cos(d3 * Math.PI / 180.0);
        double d11 = Math.sin(d3 * Math.PI / 180.0);
        double d12 = d5 / Math.sqrt(1.0 - d7 * d9 * d9);
        double d13 = d12 + d4;
        double d14 = d13 * d8 * d10;
        double d15 = d13 * d8 * d11;
        double d16 = (d6 * d6 * d12 / (d5 * d5) + d4) * d9;
        return new double[]{d14, d15, d16};
    }

    public static double[] ECEFtoWGS84(double d2, double d3, double d4) {
        double d5 = 6378137.0;
        double d6 = 6356752.31424518;
        double d7 = Math.sqrt((d5 * d5 - d6 * d6) / (d5 * d5));
        double d8 = Math.sqrt((d5 * d5 - d6 * d6) / (d6 * d6));
        double d9 = Math.sqrt(d2 * d2 + d3 * d3);
        double d10 = Math.atan2(d4 * d5, d9 * d6);
        double d11 = Math.atan2(d3, d2);
        double d12 = Math.atan2(d4 + d8 * d8 * d6 * Math.pow(Math.sin(d10), 3.0), d9 - d7 * d7 * d5 * Math.pow(Math.cos(d10), 3.0));
        double d13 = d5 / Math.sqrt(1.0 - d7 * d7 * Math.pow(Math.sin(d12), 2.0));
        double d14 = d9 / Math.cos(d12) - d13;
        d11 = d11 * 180.0 / Math.PI;
        d12 = d12 * 180.0 / Math.PI;
        return new double[]{d11, d12, d14};
    }
}

