/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.gis.tile.mongo;

import com.alibaba.fastjson.JSONArray;
import com.geoway.adf.gis.tile.ITileDataSource;
import com.geoway.adf.gis.tile.ITileDataset;
import com.geoway.adf.gis.tile.TileMeta;
import com.geoway.adf.gis.tile.TileType;
import com.geoway.adf.gis.tile.a.k;
import com.geoway.adf.gis.tile.meta.LODInfo;
import com.geoway.adf.gis.tile.meta.SpatialReference;
import com.geoway.adf.gis.tile.meta.TileSchema;
import com.geoway.adf.gis.tile.meta.YAxis;
import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.result.UpdateResult;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoTileDataSource
implements ITileDataSource {
    private static final Logger a = LoggerFactory.getLogger(MongoTileDataSource.class);
    public static final String META_TABLENAME = "TBTILE_META";
    public static final String F_TABLENAME = "F_TableName";
    public static final String F_DATASETNAME = "F_TableDatasetName";
    public static final String F_TILETYPE = "F_TileType";
    public static final String F_STARTLEVEL = "F_StartLevel";
    public static final String F_ENDLEVEL = "F_EndLevel";
    public static final String F_LEVELS = "F_Levels";
    public static final String F_XMAX = "F_Xmax";
    public static final String F_XMIN = "F_Xmin";
    public static final String F_YMAX = "F_Ymax";
    public static final String F_YMIN = "F_Ymin";
    public static final String F_ORIGIN = "F_Origin";
    public static final String F_CS = "F_CoordinateSystem";
    public static final String F_WKID = "F_Wkid";
    public static final String F_YAXIS = "F_YAxis";
    public static final String F_TILESIZE = "F_TileSize";
    public static final String F_UPDATETIME = "F_UpdateTime";
    public static final String F_INPUTTIME = "F_InputTime";
    public static final String F_LODINFOS = "F_LodInfos";
    public static final String F_FORMAT = "F_TileImageType";
    public static final String F_VERSION = "F_Version";
    public static final String F_TAG = "F_Tag";
    private final String aQ;
    private final String aR;
    private final String aS;
    private final String aT;
    private String aU = "";
    private MongoClient aV;
    private MongoDatabase aW;
    private static Map<String, MongoClient> aX = new ConcurrentHashMap<String, MongoClient>();

    public MongoTileDataSource(String string, String string2, String string3) {
        this.aR = string2;
        this.aS = string3;
        int n = string.lastIndexOf("/");
        if (n > 0) {
            this.aQ = string.substring(0, n);
            String string4 = string.substring(n + 1);
            if ((n = string4.lastIndexOf("?")) > 0) {
                this.aT = string4.substring(0, n);
                this.aU = string4.substring(n);
            } else {
                this.aT = string4;
                this.aU = "";
            }
        } else {
            this.aQ = string;
            this.aT = "admin";
        }
    }

    public MongoDatabase getMongoDatabase() {
        return this.aW;
    }

    @Override
    public String getConnectionString() {
        if (this.aR != null && this.aS != null) {
            return String.format("mongodb://%s:%s@%s/%s", this.aR, this.aS, this.aQ, this.aT) + this.aU;
        }
        return String.format("mongodb://%s", this.aQ);
    }

    @Override
    public boolean connect() {
        if (this.aV != null) {
            return true;
        }
        String string = this.getConnectionString();
        MongoClient mongoClient = aX.containsKey(string) ? aX.get(string) : MongoTileDataSource.a(string, this.aQ, this.aT, this.aR, this.aS, this.aU);
        try {
            if (this.aT != null) {
                this.aW = mongoClient.getDatabase(this.aT);
                String string2 = (String)this.aW.listCollectionNames().first();
                this.aV = mongoClient;
                return true;
            }
            mongoClient.listDatabaseNames().first();
            this.aV = mongoClient;
            return true;
        }
        catch (Exception exception) {
            this.aV = null;
            this.aW = null;
            aX.remove(string);
            if (mongoClient != null) {
                mongoClient.close();
            }
            throw exception;
        }
    }

    private static synchronized MongoClient a(String string, String string2, String string3, String string4, String string5, String string6) {
        MongoClient mongoClient;
        if (aX.containsKey(string)) {
            mongoClient = aX.get(string);
        } else {
            String string7 = "mongodb://" + string2 + "/" + string3 + string6;
            ConnectionString connectionString = new ConnectionString(string7);
            if (string4 != null && string4.length() > 0 && string5 != null) {
                connectionString = new ConnectionString(String.format("mongodb://%s:%s@%s/%s", string4, string5, string2, string3) + string6);
            }
            MongoClientSettings.Builder builder2 = MongoClientSettings.builder().applyConnectionString(connectionString).applyToSocketSettings(builder -> builder.connectTimeout(10, TimeUnit.SECONDS).readTimeout(30, TimeUnit.SECONDS)).applyToConnectionPoolSettings(builder -> builder.maxWaitTime(3000L, TimeUnit.SECONDS).minSize(10).maxSize(400));
            MongoClientSettings mongoClientSettings = builder2.build();
            mongoClient = MongoClients.create((MongoClientSettings)mongoClientSettings);
            aX.put(string, mongoClient);
        }
        return mongoClient;
    }

    @Override
    public void close() {
        if (this.aV != null) {
            // empty if block
        }
    }

    public List<String> listDatabaseNames() {
        ArrayList arrayList = new ArrayList();
        return (List)this.aV.listDatabaseNames().into(arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ITileDataset> getDatasets() {
        MongoCollection mongoCollection = this.aW.getCollection(META_TABLENAME);
        ArrayList<ITileDataset> arrayList = new ArrayList<ITileDataset>();
        try (MongoCursor mongoCursor = mongoCollection.find().iterator();){
            while (mongoCursor.hasNext()) {
                TileMeta tileMeta = this.a((Document)mongoCursor.next());
                if (tileMeta == null) continue;
                k k2 = new k(this, tileMeta);
                arrayList.add(k2);
            }
        }
        return arrayList;
    }

    @Override
    public List<ITileDataset> getDatasets(TileType ... tileTypeArray) {
        List<ITileDataset> list = this.getDatasets();
        if (tileTypeArray == null) {
            return list;
        }
        return list.stream().filter(iTileDataset -> Arrays.asList(tileTypeArray).contains((Object)iTileDataset.getType())).collect(Collectors.toList());
    }

    @Override
    public ITileDataset getDataset(String string) {
        MongoCollection mongoCollection = this.aW.getCollection(META_TABLENAME);
        Document document = (Document)mongoCollection.find(Filters.eq((String)F_TABLENAME, (Object)string)).first();
        if (document == null) {
            return null;
        }
        TileMeta tileMeta = this.a(document);
        if (tileMeta != null) {
            k k2 = new k(this, tileMeta);
            return k2;
        }
        return null;
    }

    @Override
    public ITileDataset createDataset(TileMeta tileMeta) {
        String string = tileMeta.getName();
        MongoCollection mongoCollection = this.aW.getCollection(META_TABLENAME);
        Document document = (Document)mongoCollection.find(Filters.eq((String)F_TABLENAME, (Object)string)).first();
        if (document != null) {
            throw new RuntimeException("\u6570\u636e\u96c6\u5df2\u5b58\u5728 : " + string);
        }
        TileMeta tileMeta2 = new TileMeta();
        tileMeta2.copyFrom(tileMeta);
        tileMeta2.setUpdateTime(new Date());
        if (tileMeta2.getAliasName() == null || tileMeta2.getAliasName().length() == 0) {
            tileMeta2.setAliasName(string);
        }
        Document document2 = this.a(tileMeta2);
        mongoCollection.insertOne((Object)document2);
        this.aW.createCollection(string);
        MongoCollection mongoCollection2 = this.aW.getCollection(string);
        mongoCollection2.createIndex((Bson)new Document("key", (Object)1));
        k k2 = new k(this, tileMeta2);
        return k2;
    }

    @Override
    public void deleteDataset(String string) {
        MongoCollection mongoCollection = this.aW.getCollection(META_TABLENAME);
        mongoCollection.deleteOne(Filters.eq((String)F_TABLENAME, (Object)string));
        MongoCollection mongoCollection2 = this.aW.getCollection(string);
        mongoCollection2.drop();
    }

    public boolean updateTileMeta(TileMeta tileMeta) {
        MongoCollection mongoCollection = this.aW.getCollection(META_TABLENAME);
        Document document = (Document)mongoCollection.find(Filters.eq((String)F_TABLENAME, (Object)tileMeta.getName())).first();
        if (document == null) {
            return false;
        }
        Document document2 = new Document().append(F_TABLENAME, (Object)document.getString((Object)F_TABLENAME));
        Document document3 = this.a(tileMeta);
        UpdateResult updateResult = mongoCollection.updateOne((Bson)document2, (Bson)new Document("$set", (Object)document3));
        return updateResult.wasAcknowledged();
    }

    private Document a(TileMeta tileMeta) {
        Cloneable cloneable;
        Document document = new Document();
        document.put(F_TABLENAME, (Object)tileMeta.getName());
        document.put(F_DATASETNAME, (Object)tileMeta.getAliasName());
        if (tileMeta.getStartLevel() != null) {
            document.put(F_STARTLEVEL, (Object)tileMeta.getStartLevel());
        }
        if (tileMeta.getEndLevel() != null) {
            document.put(F_ENDLEVEL, (Object)tileMeta.getEndLevel());
        }
        if (tileMeta.getStartLevel() != null && tileMeta.getEndLevel() != null) {
            cloneable = new ArrayList<Integer>();
            for (int i2 = tileMeta.getStartLevel().intValue(); i2 <= tileMeta.getEndLevel(); ++i2) {
                cloneable.add(i2);
            }
            document.put(F_LEVELS, (Object)cloneable.stream().map(Object::toString).collect(Collectors.joining(",")));
            tileMeta.setLevels((List<Integer>)((Object)cloneable));
        } else {
            document.put(F_LEVELS, null);
        }
        document.put(F_XMIN, (Object)tileMeta.getXmin());
        document.put(F_XMAX, (Object)tileMeta.getXmax());
        document.put(F_YMIN, (Object)tileMeta.getYmin());
        document.put(F_YMAX, (Object)tileMeta.getYmax());
        document.put(F_UPDATETIME, (Object)new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(tileMeta.getUpdateTime()));
        document.put(F_INPUTTIME, (Object)new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(tileMeta.getUpdateTime()));
        document.put(F_FORMAT, (Object)tileMeta.getDataFormat());
        document.put(F_VERSION, (Object)tileMeta.getVersion());
        document.put(F_TAG, (Object)tileMeta.getTag());
        if (tileMeta.getTileSchema() != null) {
            cloneable = tileMeta.getTileSchema();
            document.put(F_YAXIS, ((TileSchema)cloneable).getYaxis() == null ? YAxis.OSM : ((TileSchema)cloneable).getYaxis().toString());
            if (((TileSchema)cloneable).getLodInfos() != null) {
                document.put(F_LODINFOS, (Object)LODInfo.toJsonString(((TileSchema)cloneable).getLodInfos()));
            } else {
                document.put(F_LODINFOS, null);
            }
            if (((TileSchema)cloneable).getSpatialReference() != null) {
                document.put(F_CS, (Object)((TileSchema)cloneable).getSpatialReference().getWkt());
                document.put(F_WKID, (Object)((TileSchema)cloneable).getSpatialReference().getWkid());
            } else {
                document.put(F_CS, null);
                document.put(F_WKID, null);
            }
            if (((TileSchema)cloneable).getWidth() != null && ((TileSchema)cloneable).getHeight() != null) {
                document.put(F_TILESIZE, (Object)(((TileSchema)cloneable).getWidth() + "," + ((TileSchema)cloneable).getHeight()));
            } else {
                document.put(F_TILESIZE, null);
            }
            if (((TileSchema)cloneable).getOriginX() != null && ((TileSchema)cloneable).getOriginY() != null) {
                document.put(F_ORIGIN, (Object)(((TileSchema)cloneable).getOriginX() + "," + ((TileSchema)cloneable).getOriginY()));
            } else {
                document.put(F_LODINFOS, null);
            }
        } else {
            document.put(F_ORIGIN, null);
            document.put(F_CS, null);
            document.put(F_WKID, null);
            document.put(F_YAXIS, null);
            document.put(F_TILESIZE, null);
            document.put(F_LODINFOS, null);
        }
        switch (tileMeta.getTileType()) {
            case RasterTile: {
                document.put(F_TILETYPE, (Object)"\u6805\u683c");
                break;
            }
            case TerrainTile: {
                document.put(F_TILETYPE, (Object)"\u5730\u5f62");
                break;
            }
            case Model3DTile: {
                document.put(F_TILETYPE, (Object)"3dtiles");
                break;
            }
            default: {
                document.put(F_TILETYPE, null);
            }
        }
        return document;
    }

    private TileMeta a(Document document) {
        try {
            Object object;
            Object object2;
            Object object3;
            String[] stringArray;
            TileMeta tileMeta = new TileMeta();
            tileMeta.setName(this.a(document, F_TABLENAME));
            tileMeta.setAliasName(this.a(document, F_DATASETNAME));
            tileMeta.setDataFormat(this.a(document, F_FORMAT));
            tileMeta.setTag(this.a(document, F_TAG));
            tileMeta.setVersion(this.a(document, F_VERSION));
            tileMeta.setUpdateTime(this.a(document, Date.class, F_UPDATETIME));
            String string2 = this.a(document, F_UPDATETIME);
            tileMeta.setXmax(this.a(document, Double.class, F_XMAX));
            tileMeta.setXmin(this.a(document, Double.class, F_XMIN));
            tileMeta.setYmax(this.a(document, Double.class, F_YMAX));
            tileMeta.setYmin(this.a(document, Double.class, F_YMIN));
            TileSchema tileSchema = new TileSchema();
            tileMeta.setTileSchema(tileSchema);
            String string3 = this.a(document, F_CS);
            Integer n = this.a(document, F_WKID, Integer.class, 0);
            SpatialReference spatialReference = SpatialReference.fromSrid(n);
            if (spatialReference == null && (string3 != null && string3.length() > 0 || n > 0)) {
                spatialReference = new SpatialReference(n, string3);
            }
            tileSchema.setSpatialReference(spatialReference);
            String string4 = this.a(document, F_TILESIZE);
            if (string4 != null && string4.length() > 0) {
                stringArray = string4.split(",");
                tileSchema.setWidth(Integer.parseInt(stringArray[0]));
                tileSchema.setHeight(Integer.parseInt(stringArray[1]));
            }
            if ((stringArray = this.a(document, F_ORIGIN)) != null && stringArray.length() > 0) {
                object3 = stringArray.split(",");
                tileSchema.setOriginX(Double.parseDouble(object3[0]));
                tileSchema.setOriginY(Double.parseDouble(object3[1]));
            }
            tileMeta.setStartLevel(this.a(document, Integer.class, F_STARTLEVEL));
            tileMeta.setEndLevel(this.a(document, Integer.class, F_ENDLEVEL));
            object3 = this.a(document, F_LEVELS);
            if (object3 != null && ((String)object3).length() > 0) {
                object2 = ((String)object3).split(",");
                object = Arrays.stream(object2).map(string -> Integer.valueOf(string)).collect(Collectors.toList());
                tileMeta.setLevels((List<Integer>)object);
            } else if (tileMeta.getStartLevel() != null && tileMeta.getEndLevel() != null) {
                object2 = new ArrayList();
                for (int i2 = tileMeta.getStartLevel().intValue(); i2 < tileMeta.getEndLevel(); ++i2) {
                    object2.add(i2);
                }
                tileMeta.setLevels((List<Integer>)object2);
            }
            object2 = this.a(document, F_LODINFOS);
            if (object2 != null && ((String)object2).length() > 0 && (object = JSONArray.parseArray((String)object2)) != null) {
                Object object4 = object.toJavaList(LODInfo.class);
                tileSchema.setLodInfos((List<LODInfo>)object4);
            }
            if ((object = this.a(document, F_TILETYPE)) != null && ((String)object).length() > 0) {
                switch (object) {
                    case "\u6805\u683c": {
                        tileMeta.setTileType(TileType.RasterTile);
                        break;
                    }
                    case "\u5730\u5f62": {
                        tileMeta.setTileType(TileType.TerrainTile);
                        break;
                    }
                    case "\u6ce8\u8bb0": {
                        return null;
                    }
                    case "3dtiles": {
                        tileMeta.setTileType(TileType.Model3DTile);
                        break;
                    }
                    default: {
                        tileMeta.setTileType(TileType.RasterTile);
                    }
                }
            }
            return tileMeta;
        }
        catch (Exception exception) {
            a.error(document == null ? "\u6587\u6863\u4e3anull" : document.toString());
            a.error("\u74e6\u7247\u5143\u6570\u636e\u8bfb\u53d6\u5f02\u5e38", (Throwable)exception);
            return null;
        }
    }

    private String a(Document document, String string) {
        return this.a(document, string, String.class, null);
    }

    private <T> T a(Document document, Class<T> clazz, String string) {
        return this.a(document, string, clazz, null);
    }

    private <T> T a(Document document, String string, Class<T> clazz, T t) {
        if (!document.containsKey((Object)string)) {
            return t;
        }
        Object object = document.get((Object)string);
        if (object == null) {
            return t;
        }
        try {
            if (clazz.isAssignableFrom(Double.class)) {
                return (T)Double.valueOf(object.toString());
            }
            if (clazz.isAssignableFrom(Float.class)) {
                return (T)Float.valueOf(object.toString());
            }
            if (clazz.isAssignableFrom(Integer.class)) {
                return (T)Integer.valueOf(object.toString());
            }
            if (clazz.isAssignableFrom(Short.class)) {
                return (T)Short.valueOf(object.toString());
            }
            if (clazz.isAssignableFrom(Long.class)) {
                return (T)Long.valueOf(object.toString());
            }
            if (clazz.isAssignableFrom(Boolean.class)) {
                return (T)Boolean.valueOf(object.toString());
            }
            if (clazz.isAssignableFrom(String.class)) {
                return (T)object.toString();
            }
            if (clazz.isAssignableFrom(Date.class)) {
                if (object instanceof Date) {
                    return (T)object;
                }
                SimpleDateFormat[] simpleDateFormatArray = new SimpleDateFormat[]{new SimpleDateFormat("MM/dd/yyyy HH:mm:ss"), new SimpleDateFormat("yyyy/MM/dd HH:mm:ss")};
                String string2 = object.toString();
                for (SimpleDateFormat simpleDateFormat : simpleDateFormatArray) {
                    try {
                        return (T)new Timestamp(simpleDateFormat.parse(string2).getTime());
                    }
                    catch (ParseException parseException) {
                        parseException.printStackTrace();
                    }
                }
                return null;
            }
            return (T)object;
        }
        catch (Exception exception) {
            a.error(exception.getMessage());
            return t;
        }
    }
}

