/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.gis.tile.wmts;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.adf.gis.tile.ITileDataSource;
import com.geoway.adf.gis.tile.ITileDataset;
import com.geoway.adf.gis.tile.TileData;
import com.geoway.adf.gis.tile.TileMeta;
import com.geoway.adf.gis.tile.TileType;
import com.geoway.adf.gis.tile.a.l;
import com.geoway.adf.gis.tile.wmts.HttpUtil;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorTileDataSource
implements ITileDataSource {
    private static final Logger a = LoggerFactory.getLogger(VectorTileDataSource.class);
    private final String aS;
    private String bh;

    public VectorTileDataSource(String string) {
        if (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        this.aS = string;
    }

    public String getMapServerUrl() {
        return this.bh;
    }

    @Override
    public String getConnectionString() {
        return this.aS;
    }

    @Override
    public boolean connect() {
        this.bh = this.p();
        return this.bh != null && this.bh.length() > 0;
    }

    @Override
    public void close() {
    }

    @Override
    public List<ITileDataset> getDatasets() {
        try {
            ArrayList<ITileDataset> arrayList = new ArrayList<ITileDataset>();
            String string = String.format("%s/service/vector/list.do?pageIndex=%d&rows=%d", this.aS, 0, 10000);
            a.info(string);
            String string2 = HttpUtil.doGet(string, 10000);
            JSONObject jSONObject = JSONObject.parseObject((String)string2);
            if (!"OK".equalsIgnoreCase(jSONObject.getString("status"))) {
                throw new RuntimeException(jSONObject.getString("message"));
            }
            JSONArray jSONArray = jSONObject.getJSONArray("data");
            if (jSONArray == null) {
                return arrayList;
            }
            int n = jSONArray.size();
            for (int i2 = 0; i2 < n; ++i2) {
                JSONObject jSONObject2 = jSONArray.getJSONObject(i2);
                l l2 = this.a(jSONObject2);
                arrayList.add(l2);
            }
            return arrayList;
        }
        catch (Exception exception) {
            throw new RuntimeException(this.aS + "\u670d\u52a1\u5217\u8868\u8bfb\u53d6\u5931\u8d25", exception);
        }
    }

    @Override
    public List<ITileDataset> getDatasets(TileType ... tileTypeArray) {
        return this.getDatasets();
    }

    @Override
    public ITileDataset getDataset(String string) {
        try {
            String string2 = HttpUtil.doGet(String.format("%s/service/vector/detail.do?serviceName=%s", this.aS, string), 10000);
            JSONObject jSONObject = JSONObject.parseObject((String)string2);
            if (!"OK".equalsIgnoreCase(jSONObject.getString("status"))) {
                a.warn(string + "\u83b7\u53d6\u670d\u52a1\u8be6\u60c5\u5931\u8d25!" + jSONObject.getString("message"));
                return null;
            }
            JSONObject jSONObject2 = jSONObject.getJSONObject("data");
            return this.a(jSONObject2);
        }
        catch (Exception exception) {
            throw new RuntimeException(this.aS + "\u670d\u52a1\u89e3\u6790\u5931\u8d25", exception);
        }
    }

    @Override
    public ITileDataset createDataset(TileMeta tileMeta) {
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u521b\u5efa\u74e6\u7247\u6570\u636e\u96c6");
    }

    @Override
    public void deleteDataset(String string) {
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u5220\u9664\u74e6\u7247\u6570\u636e\u96c6");
    }

    public TileData getTile(String string, int n, int n2, int n3, String string2, String string3, Map<String, String> map) {
        String string4;
        if (string3 == null || string3.isEmpty()) {
            string3 = "all";
        }
        if (string3.equals("mapImg")) {
            string4 = String.format("%s/vmap/%s/getMap?", this.bh, string);
        } else if (string3.equals("labelImg")) {
            string4 = String.format("%s/label/%s/getImg?", this.bh, string);
        } else if (string3.equals("all")) {
            string4 = String.format("%s/all/%s/getMap?", this.bh, string);
        } else {
            throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u670d\u52a1\u80fd\u529b\uff1a" + string3);
        }
        string4 = string4 + String.format("l=%d&y=%d&x=%d", n, n2, n3);
        if (string2 != null && string2.length() > 0) {
            string4 = string4 + "&styleId=" + string2;
        }
        if (map != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String string5 = URLEncoder.encode(entry.getKey(), "UTF-8");
                String string6 = URLEncoder.encode(entry.getValue(), "UTF-8");
                string4 = string4 + "&" + string5 + "=" + string6;
            }
        }
        return this.requestTile(string4, n, n2, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TileData requestTile(String string, int n, int n2, int n3) {
        RequestConfig requestConfig;
        CloseableHttpResponse closeableHttpResponse = null;
        try {
            HttpGet httpGet = new HttpGet(string);
            requestConfig = RequestConfig.custom().setConnectTimeout(5000).setConnectionRequestTimeout(5000).setSocketTimeout(5000).build();
            httpGet.setConfig(requestConfig);
            closeableHttpResponse = HttpUtil.httpclient.execute((HttpUriRequest)httpGet);
            int n4 = closeableHttpResponse.getStatusLine().getStatusCode();
            if (200 == n4) {
                HttpEntity httpEntity = closeableHttpResponse.getEntity();
                if (httpEntity == null) {
                    TileData tileData = null;
                    HttpUtil.closeResponse(closeableHttpResponse);
                    return tileData;
                }
                byte[] byArray = EntityUtils.toByteArray((HttpEntity)httpEntity);
                if (byArray == null || byArray.length == 0) {
                    TileData tileData = null;
                    HttpUtil.closeResponse(closeableHttpResponse);
                    return tileData;
                }
                TileData tileData = new TileData();
                tileData.setKey(n2 + "_" + n3 + "_" + n);
                tileData.setLevel(n);
                tileData.setLevel(n);
                tileData.setCol(n3);
                tileData.setRow(n2);
                tileData.setFormat("png");
                tileData.setData(byArray);
                TileData tileData2 = tileData;
                HttpUtil.closeResponse(closeableHttpResponse);
                return tileData2;
            }
            if (204 == n4) {
                TileData tileData = null;
                HttpUtil.closeResponse(closeableHttpResponse);
                return tileData;
            }
            a.error(String.format("%s\u83b7\u53d6\u74e6\u7247\u65f6\u51fa\u9519,\u72b6\u6001\u7801\u4e3a%d", string, n4));
            TileData tileData = null;
            HttpUtil.closeResponse(closeableHttpResponse);
            return tileData;
        }
        catch (Exception exception) {
            a.error(String.format("%s\u83b7\u53d6\u74e6\u7247\u5931\u8d25", string), (Throwable)exception);
            requestConfig = null;
            return requestConfig;
        }
        finally {
            HttpUtil.closeResponse(closeableHttpResponse);
        }
    }

    private String p() {
        if (this.bh != null && this.bh.length() > 0) {
            return this.bh;
        }
        String string = HttpUtil.doGet(String.format("%s/dictionary.do", this.aS), 10000);
        JSONObject jSONObject = JSONObject.parseObject((String)string);
        if (!"OK".equalsIgnoreCase(jSONObject.getString("status"))) {
            throw new RuntimeException("\u8bfb\u53d6\u670d\u52a1\u9884\u89c8\u5730\u5740\u5931\u8d25!" + jSONObject.getString("message"));
        }
        String string2 = jSONObject.getString("data") == null ? "" : jSONObject.getString("data");
        JSONObject jSONObject2 = JSONObject.parseObject((String)string2);
        if (jSONObject2 != null) {
            this.bh = jSONObject2.getString("MapServerUrl");
            return this.bh;
        }
        return "";
    }

    private l a(JSONObject jSONObject) {
        String string = jSONObject.getString("name");
        String string2 = jSONObject.getString("alias");
        String string3 = jSONObject.getString("defaultstyle");
        Integer n = jSONObject.getInteger("srid");
        l l2 = new l(this, string, string2, string3);
        l2.a(n);
        return l2;
    }
}

