/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.gis.tile.meta;

import com.geoway.adf.gis.tile.meta.LODInfo;
import com.geoway.adf.gis.tile.meta.SpatialReference;
import com.geoway.adf.gis.tile.meta.YAxis;
import java.util.ArrayList;
import java.util.List;

public class TileSchema
implements Cloneable {
    private SpatialReference s;
    private Double ar;
    private Double as;
    private Integer at;
    private Integer au;
    private YAxis av = YAxis.OSM;
    private Integer aw = 96;
    private List<LODInfo> ax;
    public static final TileSchema Tianditu;
    public static final TileSchema WebMercator;
    public static final TileSchema ArcGIS;
    public static final TileSchema TerrainV20;

    public TileSchema clone() {
        TileSchema tileSchema = (TileSchema)super.clone();
        if (this.ax != null) {
            tileSchema.ax = new ArrayList<LODInfo>();
            for (LODInfo lODInfo : this.ax) {
                tileSchema.ax.add(lODInfo.clone());
            }
        }
        if (this.s != null) {
            tileSchema.s = this.s.clone();
        }
        return tileSchema;
    }

    public SpatialReference getSpatialReference() {
        return this.s;
    }

    public Double getOriginX() {
        return this.ar;
    }

    public Double getOriginY() {
        return this.as;
    }

    public Integer getWidth() {
        return this.at;
    }

    public Integer getHeight() {
        return this.au;
    }

    public YAxis getYaxis() {
        return this.av;
    }

    public Integer getDpi() {
        return this.aw;
    }

    public List<LODInfo> getLodInfos() {
        return this.ax;
    }

    public void setSpatialReference(SpatialReference spatialReference) {
        this.s = spatialReference;
    }

    public void setOriginX(Double d2) {
        this.ar = d2;
    }

    public void setOriginY(Double d2) {
        this.as = d2;
    }

    public void setWidth(Integer n) {
        this.at = n;
    }

    public void setHeight(Integer n) {
        this.au = n;
    }

    public void setYaxis(YAxis yAxis) {
        this.av = yAxis;
    }

    public void setDpi(Integer n) {
        this.aw = n;
    }

    public void setLodInfos(List<LODInfo> list) {
        this.ax = list;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof TileSchema)) {
            return false;
        }
        TileSchema tileSchema = (TileSchema)object;
        if (!tileSchema.canEqual(this)) {
            return false;
        }
        Double d2 = this.getOriginX();
        Double d3 = tileSchema.getOriginX();
        if (d2 == null ? d3 != null : !((Object)d2).equals(d3)) {
            return false;
        }
        Double d4 = this.getOriginY();
        Double d5 = tileSchema.getOriginY();
        if (d4 == null ? d5 != null : !((Object)d4).equals(d5)) {
            return false;
        }
        Integer n = this.getWidth();
        Integer n2 = tileSchema.getWidth();
        if (n == null ? n2 != null : !((Object)n).equals(n2)) {
            return false;
        }
        Integer n3 = this.getHeight();
        Integer n4 = tileSchema.getHeight();
        if (n3 == null ? n4 != null : !((Object)n3).equals(n4)) {
            return false;
        }
        Integer n5 = this.getDpi();
        Integer n6 = tileSchema.getDpi();
        if (n5 == null ? n6 != null : !((Object)n5).equals(n6)) {
            return false;
        }
        SpatialReference spatialReference = this.getSpatialReference();
        SpatialReference spatialReference2 = tileSchema.getSpatialReference();
        if (spatialReference == null ? spatialReference2 != null : !((Object)spatialReference).equals(spatialReference2)) {
            return false;
        }
        YAxis yAxis = this.getYaxis();
        YAxis yAxis2 = tileSchema.getYaxis();
        if (yAxis == null ? yAxis2 != null : !((Object)((Object)yAxis)).equals((Object)yAxis2)) {
            return false;
        }
        List<LODInfo> list = this.getLodInfos();
        List<LODInfo> list2 = tileSchema.getLodInfos();
        return !(list == null ? list2 != null : !((Object)list).equals(list2));
    }

    protected boolean canEqual(Object object) {
        return object instanceof TileSchema;
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        Double d2 = this.getOriginX();
        n2 = n2 * 59 + (d2 == null ? 43 : ((Object)d2).hashCode());
        Double d3 = this.getOriginY();
        n2 = n2 * 59 + (d3 == null ? 43 : ((Object)d3).hashCode());
        Integer n3 = this.getWidth();
        n2 = n2 * 59 + (n3 == null ? 43 : ((Object)n3).hashCode());
        Integer n4 = this.getHeight();
        n2 = n2 * 59 + (n4 == null ? 43 : ((Object)n4).hashCode());
        Integer n5 = this.getDpi();
        n2 = n2 * 59 + (n5 == null ? 43 : ((Object)n5).hashCode());
        SpatialReference spatialReference = this.getSpatialReference();
        n2 = n2 * 59 + (spatialReference == null ? 43 : ((Object)spatialReference).hashCode());
        YAxis yAxis = this.getYaxis();
        n2 = n2 * 59 + (yAxis == null ? 43 : ((Object)((Object)yAxis)).hashCode());
        List<LODInfo> list = this.getLodInfos();
        n2 = n2 * 59 + (list == null ? 43 : ((Object)list).hashCode());
        return n2;
    }

    public String toString() {
        return "TileSchema(spatialReference=" + this.getSpatialReference() + ", originX=" + this.getOriginX() + ", originY=" + this.getOriginY() + ", width=" + this.getWidth() + ", height=" + this.getHeight() + ", yaxis=" + (Object)((Object)this.getYaxis()) + ", dpi=" + this.getDpi() + ", lodInfos=" + this.getLodInfos() + ")";
    }

    static {
        ArrayList<LODInfo> arrayList = new ArrayList<LODInfo>();
        double d2 = 0.703125;
        double d3 = 2.9582935545E8;
        for (int i2 = 0; i2 < 23; ++i2) {
            LODInfo lODInfo = new LODInfo();
            lODInfo.setLevelID(i2 + 1);
            lODInfo.setResolution(d2 / Math.pow(2.0, i2));
            lODInfo.setScale(d3 / Math.pow(2.0, i2));
            arrayList.add(lODInfo);
        }
        Tianditu = new TileSchema();
        TileSchema.Tianditu.s = SpatialReference.CGCS2000;
        TileSchema.Tianditu.aw = 96;
        TileSchema.Tianditu.ar = -180.0;
        TileSchema.Tianditu.as = 90.0;
        TileSchema.Tianditu.at = 256;
        TileSchema.Tianditu.au = 256;
        TileSchema.Tianditu.av = YAxis.OSM;
        TileSchema.Tianditu.ax = arrayList;
        d2 = 0.7031250000000002;
        d3 = 2.9549759305875003E8;
        ArrayList<LODInfo> arrayList2 = new ArrayList<LODInfo>();
        for (int i3 = 0; i3 <= 23; ++i3) {
            LODInfo lODInfo = new LODInfo();
            lODInfo.setLevelID(i3);
            lODInfo.setResolution(d2 / Math.pow(2.0, i3));
            lODInfo.setScale(d3 / Math.pow(2.0, i3));
            arrayList2.add(lODInfo);
        }
        ArcGIS = new TileSchema();
        TileSchema.ArcGIS.s = SpatialReference.WGS84;
        TileSchema.ArcGIS.aw = 96;
        TileSchema.ArcGIS.ar = -180.0;
        TileSchema.ArcGIS.as = 90.0;
        TileSchema.ArcGIS.at = 256;
        TileSchema.ArcGIS.au = 256;
        TileSchema.ArcGIS.av = YAxis.OSM;
        TileSchema.ArcGIS.ax = arrayList2;
        d2 = 156543.032;
        d3 = 5.916587109091299E8;
        ArrayList<LODInfo> arrayList3 = new ArrayList<LODInfo>();
        for (int i4 = 0; i4 <= 23; ++i4) {
            LODInfo lODInfo = new LODInfo();
            lODInfo.setLevelID(i4);
            lODInfo.setResolution(d2 / Math.pow(2.0, i4));
            lODInfo.setScale(d3 / Math.pow(2.0, i4));
            arrayList3.add(lODInfo);
        }
        WebMercator = new TileSchema();
        TileSchema.WebMercator.s = SpatialReference.WGS84WebMercator;
        TileSchema.WebMercator.aw = 96;
        TileSchema.WebMercator.ar = -d2 / 2.0 * 256.0;
        TileSchema.WebMercator.as = d2 / 2.0 * 256.0;
        TileSchema.WebMercator.at = 256;
        TileSchema.WebMercator.au = 256;
        TileSchema.WebMercator.av = YAxis.OSM;
        TileSchema.WebMercator.ax = arrayList3;
        d2 = 5.45454545454545;
        d3 = 2.9549759305875003E8;
        ArrayList<LODInfo> arrayList4 = new ArrayList<LODInfo>();
        for (int i5 = 0; i5 < 22; ++i5) {
            LODInfo lODInfo = new LODInfo();
            lODInfo.setLevelID(i5 + 1);
            lODInfo.setResolution(d2 / Math.pow(2.0, i5));
            lODInfo.setScale(d3 / Math.pow(2.0, i5));
            arrayList4.add(lODInfo);
        }
        TerrainV20 = new TileSchema();
        TileSchema.TerrainV20.s = SpatialReference.CGCS2000;
        TileSchema.TerrainV20.aw = 96;
        TileSchema.TerrainV20.ar = -180.0;
        TileSchema.TerrainV20.as = 90.0;
        TileSchema.TerrainV20.at = 33;
        TileSchema.TerrainV20.au = 33;
        TileSchema.TerrainV20.av = YAxis.OSM;
        TileSchema.TerrainV20.ax = arrayList4;
    }
}

