/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.gis.tile.guobiao;

import com.geoway.adf.gis.tile.ITileDataSource;
import com.geoway.adf.gis.tile.ITileDataset;
import com.geoway.adf.gis.tile.TileMeta;
import com.geoway.adf.gis.tile.TileType;
import com.geoway.adf.gis.tile.a.e;
import com.geoway.adf.gis.tile.meta.SpatialReference;
import com.geoway.adf.gis.tile.meta.TileSchema;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class GuoBiaoTileDataSource
implements ITileDataSource {
    private final File tilePath;
    private final SpatialReference s;

    public GuoBiaoTileDataSource(String string) {
        this.tilePath = new File(string);
        this.s = SpatialReference.CGCS2000;
    }

    public GuoBiaoTileDataSource(String string, int n) {
        this.tilePath = new File(string);
        this.s = SpatialReference.fromSrid(n);
        if (this.s == null) {
            throw new RuntimeException("\u56fd\u6807\u74e6\u7247\u4e0d\u652f\u6301\u7684srid:" + n);
        }
    }

    @Override
    public String getConnectionString() {
        return this.tilePath.toString();
    }

    @Override
    public boolean connect() {
        return this.tilePath.exists();
    }

    @Override
    public void close() {
    }

    @Override
    public List<ITileDataset> getDatasets() {
        ITileDataset iTileDataset = this.getDataset(null);
        ArrayList<ITileDataset> arrayList = new ArrayList<ITileDataset>();
        arrayList.add(iTileDataset);
        return arrayList;
    }

    @Override
    public List<ITileDataset> getDatasets(TileType ... tileTypeArray) {
        return this.getDatasets();
    }

    @Override
    public ITileDataset getDataset(String string) {
        TileMeta tileMeta = this.i();
        e e2 = new e(this, tileMeta);
        return e2;
    }

    @Override
    public ITileDataset createDataset(TileMeta tileMeta) {
        if (!this.tilePath.isDirectory() || !this.tilePath.exists()) {
            this.tilePath.mkdirs();
        }
        TileMeta tileMeta2 = new TileMeta();
        tileMeta2.copyFrom(tileMeta);
        tileMeta2.setTileType(TileType.RasterTile);
        e e2 = new e(this, tileMeta2);
        return e2;
    }

    @Override
    public void deleteDataset(String string) {
        if (this.tilePath.exists()) {
            this.tilePath.delete();
        }
    }

    private TileMeta i() {
        Number number;
        Comparable<File> comparable2;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        File[] fileArray = this.tilePath.listFiles();
        if (fileArray != null) {
            for (Comparable<File> comparable2 : fileArray) {
                if (!comparable2.getName().startsWith("L") || (number = this.a(comparable2.getName().substring(1))) == null) continue;
                arrayList.add((Integer)number);
            }
        }
        arrayList.sort(Integer::compareTo);
        TileSchema tileSchema = this.s.getWkid() == SpatialReference.WGS84WebMercator.getWkid() ? TileSchema.WebMercator : TileSchema.Tianditu;
        Double d2 = tileSchema.getOriginX();
        Double d3 = -tileSchema.getOriginY().doubleValue();
        comparable2 = -tileSchema.getOriginX().doubleValue();
        number = tileSchema.getOriginY();
        TileMeta tileMeta = new TileMeta();
        tileMeta.setName(this.tilePath.getName());
        tileMeta.setAliasName(this.tilePath.getName());
        tileMeta.setDataFormat("png");
        tileMeta.setTileType(TileType.RasterTile);
        tileMeta.setXmin(d2);
        tileMeta.setYmin(d3);
        tileMeta.setXmax((Double)comparable2);
        tileMeta.setYmax((Double)number);
        tileMeta.setTileSchema(tileSchema);
        if (arrayList.size() > 0) {
            tileMeta.setStartLevel((Integer)arrayList.get(0));
            tileMeta.setEndLevel((Integer)arrayList.get(arrayList.size() - 1));
            tileMeta.setLevels(arrayList);
        }
        return tileMeta;
    }

    private Integer a(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

