/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.gis.tile.arcgis;

import com.geoway.adf.gis.basic.util.XmlUtil;
import com.geoway.adf.gis.tile.arcgis.ArcGISTileMeta;
import com.geoway.adf.gis.tile.arcgis.ArcGISTileStorageFormat;
import com.geoway.adf.gis.tile.meta.LODInfo;
import com.geoway.adf.gis.tile.meta.SpatialReference;
import com.geoway.adf.gis.tile.meta.TileSchema;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TilingSchemaHelper {
    private static final Logger a = LoggerFactory.getLogger(TilingSchemaHelper.class);

    public static ArcGISTileMeta ReadESRIMetaInfo(File file) {
        File file2 = new File(file, "conf.xml");
        if (!file2.isFile() || !file2.exists()) {
            file2 = new File(file, "Conf.xml");
        }
        if (!file2.isFile() || !file2.exists()) {
            return null;
        }
        File file3 = new File(file, "conf.cdi");
        if (!file3.isFile() || !file3.exists()) {
            file3 = new File(file, "Conf.cdi");
        }
        if (!file3.isFile() || !file3.exists()) {
            return null;
        }
        ArcGISTileMeta arcGISTileMeta = new ArcGISTileMeta();
        arcGISTileMeta.setName(file.getName());
        arcGISTileMeta.setAliasName(file.getName());
        TilingSchemaHelper.a(file2, arcGISTileMeta);
        TilingSchemaHelper.b(file3, arcGISTileMeta);
        return arcGISTileMeta;
    }

    private static void a(File file, ArcGISTileMeta arcGISTileMeta) {
        try {
            Object object;
            Object object2;
            Object object3;
            Document document = XmlUtil.readDocumentFromFile((File)file);
            Node node = XmlUtil.findfirstNode((Node)document, (String)"CacheInfo");
            TileSchema tileSchema = new TileSchema();
            arcGISTileMeta.setTileSchema(tileSchema);
            Node node2 = XmlUtil.findfirstNode((Node)node, (String)"TileCacheInfo");
            double d2 = XmlUtil.findfirstNodeDoubleValue((Node)node2, (String)"TileOrigin/X");
            double d3 = XmlUtil.findfirstNodeDoubleValue((Node)node2, (String)"TileOrigin/Y");
            tileSchema.setOriginX(d2);
            tileSchema.setOriginY(d3);
            tileSchema.setWidth(XmlUtil.findfirstNodeIntValue((Node)node2, (String)"TileCols"));
            tileSchema.setHeight(XmlUtil.findfirstNodeIntValue((Node)node2, (String)"TileRows"));
            tileSchema.setDpi(XmlUtil.findfirstNodeIntValue((Node)node2, (String)"DPI"));
            String string = XmlUtil.findfirstNodeStringValue((Node)node2, (String)"TileOriginPosition");
            if (string != null && !string.isEmpty()) {
                arcGISTileMeta.setTileOriginPosition(string);
            }
            Node node3 = XmlUtil.findfirstNode((Node)node2, (String)"SpatialReference");
            SpatialReference spatialReference = TilingSchemaHelper.a(node3);
            tileSchema.setSpatialReference(spatialReference);
            NodeList nodeList = XmlUtil.findNodeList((Node)node2, (String)"LODInfos/LODInfo");
            ArrayList<LODInfo> arrayList = new ArrayList<LODInfo>();
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
                object3 = nodeList.item(i2);
                object2 = new LODInfo();
                object = XmlUtil.findfirstNodeIntValue((Node)object3, (String)"LevelID");
                if (object == null || arrayList2.contains(object)) continue;
                arrayList2.add((Integer)object);
                ((LODInfo)object2).setLevelID((Integer)object);
                ((LODInfo)object2).setScale(XmlUtil.findfirstNodeDoubleValue((Node)object3, (String)"Scale"));
                ((LODInfo)object2).setResolution(XmlUtil.findfirstNodeDoubleValue((Node)object3, (String)"Resolution"));
                arrayList.add((LODInfo)object2);
            }
            arrayList.sort(Comparator.comparing(LODInfo::getLevelID));
            tileSchema.setLodInfos(arrayList);
            Node node4 = XmlUtil.findfirstNode((Node)node, (String)"TileImageInfo");
            object3 = XmlUtil.findfirstNodeStringValue((Node)node4, (String)"CacheTileFormat").toUpperCase();
            arcGISTileMeta.setDataFormat((String)object3);
            arcGISTileMeta.setCompressionQuality(XmlUtil.findfirstNodeIntValue((Node)node4, (String)"CompressionQuality"));
            arcGISTileMeta.setAntialiasing(XmlUtil.findfirstNodeBooleanValue((Node)node4, (String)"Antialiasing"));
            object2 = XmlUtil.findfirstNode((Node)node, (String)"CacheStorageInfo");
            if (object2 != null) {
                switch (object = XmlUtil.findfirstNodeStringValue((Node)object2, (String)"StorageFormat")) {
                    case "esriMapCacheStorageModeExploded": {
                        arcGISTileMeta.setStorageFormat(ArcGISTileStorageFormat.Exploded);
                        break;
                    }
                    case "esriMapCacheStorageModeCompact": {
                        arcGISTileMeta.setStorageFormat(ArcGISTileStorageFormat.Compact);
                        break;
                    }
                    case "esriMapCacheStorageModeCompactV2": {
                        arcGISTileMeta.setStorageFormat(ArcGISTileStorageFormat.CompactV2);
                        break;
                    }
                    default: {
                        throw new RuntimeException("\u4e0d\u652f\u6301\u7684arcgis\u5b58\u50a8\u7c7b\u578b\uff1a" + (String)object);
                    }
                }
                arcGISTileMeta.setPacketSize(XmlUtil.findfirstNodeIntValue((Node)object2, (String)"PacketSize"));
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(String.format("\u8bfb\u53d6\u914d\u7f6e\u6587\u4ef6%s\u5931\u8d25:\n", file) + exception.getMessage(), exception);
        }
    }

    private static void b(File file, ArcGISTileMeta arcGISTileMeta) {
        try {
            Document document = XmlUtil.readDocumentFromFile((File)file);
            Node node = XmlUtil.findfirstNode((Node)document, (String)"EnvelopeN");
            arcGISTileMeta.setXmin(XmlUtil.findfirstNodeDoubleValue((Node)node, (String)"XMin"));
            arcGISTileMeta.setYmin(XmlUtil.findfirstNodeDoubleValue((Node)node, (String)"YMin"));
            arcGISTileMeta.setXmax(XmlUtil.findfirstNodeDoubleValue((Node)node, (String)"XMax"));
            arcGISTileMeta.setYmax(XmlUtil.findfirstNodeDoubleValue((Node)node, (String)"YMax"));
            if (arcGISTileMeta.getTileSchema().getSpatialReference() == null) {
                Element element = (Element)XmlUtil.findfirstNode((Node)node, (String)"SpatialReference");
                SpatialReference spatialReference = TilingSchemaHelper.a(element);
                if (spatialReference == null) {
                    spatialReference = SpatialReference.CGCS2000;
                }
                arcGISTileMeta.getTileSchema().setSpatialReference(spatialReference);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(String.format("\u8bfb\u53d6\u914d\u7f6e\u6587\u4ef6%s\u5931\u8d25:\n", file) + exception.getMessage(), exception);
        }
    }

    private static SpatialReference a(Node node) {
        try {
            if (node != null) {
                SpatialReference spatialReference = new SpatialReference();
                spatialReference.setWkt(XmlUtil.findfirstNodeStringValue((Node)node, (String)"WKT"));
                spatialReference.setWkid(XmlUtil.findfirstNodeIntValue((Node)node, (String)"WKID"));
                spatialReference.setHighPrecision(XmlUtil.findfirstNodeBooleanValue((Node)node, (String)"HighPrecision"));
                spatialReference.setOriginX(XmlUtil.findfirstNodeDoubleValue((Node)node, (String)"XOrigin"));
                spatialReference.setOriginY(XmlUtil.findfirstNodeDoubleValue((Node)node, (String)"YOrigin"));
                spatialReference.setScaleZ(XmlUtil.findfirstNodeDoubleValue((Node)node, (String)"ZScale"));
                spatialReference.setOriginM(XmlUtil.findfirstNodeDoubleValue((Node)node, (String)"MOrigin"));
                spatialReference.setScaleM(XmlUtil.findfirstNodeDoubleValue((Node)node, (String)"MScale"));
                spatialReference.setToleranceXY(XmlUtil.findfirstNodeDoubleValue((Node)node, (String)"XYTolerance"));
                spatialReference.setToleranceZ(XmlUtil.findfirstNodeDoubleValue((Node)node, (String)"ZTolerance"));
                spatialReference.setToleranceM(XmlUtil.findfirstNodeDoubleValue((Node)node, (String)"MTolerance"));
                spatialReference.setLeftLongitude(XmlUtil.findfirstNodeDoubleValue((Node)node, (String)"LeftLongitude"));
                spatialReference.setLatestWKID(XmlUtil.findfirstNodeIntValue((Node)node, (String)"LatestWKID"));
                return spatialReference;
            }
            return null;
        }
        catch (Exception exception) {
            a.error(node.toString(), (Throwable)exception);
            return null;
        }
    }

    public static void writeMetaInfo(File file, ArcGISTileMeta arcGISTileMeta) {
        File file2 = new File(file, "conf.xml");
        TilingSchemaHelper.c(file2, arcGISTileMeta);
        File file3 = new File(file, "conf.cdi");
        TilingSchemaHelper.writeConfCdi(file3, arcGISTileMeta);
    }

    /*
     * WARNING - void declaration
     */
    private static void c(File file, ArcGISTileMeta arcGISTileMeta) throws ParserConfigurationException, IOException, TransformerException {
        void var9_16;
        Element element;
        Document document = XmlUtil.createDocument();
        Element element2 = document.createElement("CacheInfo");
        document.appendChild(element2);
        element2.setAttribute("xsi:type", "typens:CacheInfo");
        element2.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        element2.setAttribute("xmlns:xs", "http://www.w3.org/2001/XMLSchema");
        element2.setAttribute("xmlns:typens", "http://www.esri.com/schemas/ArcGIS/10.1");
        TileSchema tileSchema = arcGISTileMeta.getTileSchema();
        Element element3 = XmlUtil.appendElement((Element)element2, (String)"TileCacheInfo", null);
        element3.setAttribute("xsi:type", "typens:TileCacheInfo");
        TilingSchemaHelper.a(element3, tileSchema.getSpatialReference());
        Element element4 = XmlUtil.appendElement((Element)element3, (String)"TileOrigin", null);
        element4.setAttribute("xsi:type", "typens:PointN");
        XmlUtil.appendElement((Element)element4, (String)"X", (Object)tileSchema.getOriginX());
        XmlUtil.appendElement((Element)element4, (String)"Y", (Object)tileSchema.getOriginY());
        XmlUtil.appendElement((Element)element3, (String)"TileOriginPosition", (Object)arcGISTileMeta.getTileOriginPosition());
        XmlUtil.appendElement((Element)element3, (String)"TileCols", (Object)tileSchema.getWidth());
        XmlUtil.appendElement((Element)element3, (String)"TileRows", (Object)tileSchema.getHeight());
        XmlUtil.appendElement((Element)element3, (String)"DPI", (Object)tileSchema.getDpi());
        XmlUtil.appendElement((Element)element3, (String)"PreciseDPI", (Object)tileSchema.getDpi());
        Element element5 = XmlUtil.appendElement((Element)element3, (String)"LODInfos", null);
        element5.setAttribute("xsi:type", "typens:ArrayOfLODInfo");
        for (LODInfo object2 : tileSchema.getLodInfos()) {
            if (object2.getLevelID() > 24) continue;
            element = XmlUtil.appendElement((Element)element5, (String)"LODInfo", null);
            element.setAttribute("xsi:type", "typens:LODInfo");
            XmlUtil.appendElement((Element)element, (String)"LevelID", (Object)object2.getLevelID());
            XmlUtil.appendElement((Element)element, (String)"Scale", (Object)object2.getScale());
            XmlUtil.appendElement((Element)element, (String)"Resolution", (Object)object2.getResolution());
        }
        String string = arcGISTileMeta.getDataFormat();
        String string2 = "PNG32";
        if ("WEBP".equals(string)) {
            String string3 = "WEBP";
        } else if (string.contains("PNG24")) {
            String string4 = "PNG24";
        } else if (string.contains("PNG")) {
            String string5 = "PNG";
        } else if ("JPG".equals(string) || "JPEG".equals(string)) {
            String string6 = "JPG";
        } else {
            String string7 = "MIXED";
        }
        element = XmlUtil.appendElement((Element)element2, (String)"TileImageInfo", null);
        element.setAttribute("xsi:type", "typens:TileImageInfo");
        XmlUtil.appendElement((Element)element, (String)"CacheTileFormat", (Object)var9_16);
        XmlUtil.appendElement((Element)element, (String)"CompressionQuality", (Object)arcGISTileMeta.getCompressionQuality());
        XmlUtil.appendElement((Element)element, (String)"Antialiasing", (Object)arcGISTileMeta.getAntialiasing());
        Element element6 = XmlUtil.appendElement((Element)element2, (String)"CacheStorageInfo", null);
        element6.setAttribute("xsi:type", "typens:CacheStorageInfo");
        XmlUtil.appendElement((Element)element6, (String)"StorageFormat", (Object)arcGISTileMeta.getStorageFormat().value);
        XmlUtil.appendElement((Element)element6, (String)"PacketSize", (Object)arcGISTileMeta.getPacketSize());
        XmlUtil.write2File((File)file, (Document)document);
    }

    public static void writeConfCdi(File file, ArcGISTileMeta arcGISTileMeta) throws ParserConfigurationException, IOException, TransformerException {
        Document document = XmlUtil.createDocument();
        Element element = document.createElement("EnvelopeN");
        document.appendChild(element);
        element.setAttribute("xsi:type", "typens:EnvelopeN");
        element.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        element.setAttribute("xmlns:xs", "http://www.w3.org/2001/XMLSchema");
        element.setAttribute("xmlns:typens", "http://www.esri.com/schemas/ArcGIS/10.1");
        XmlUtil.appendElement((Element)element, (String)"XMin", (Object)arcGISTileMeta.getXmin());
        XmlUtil.appendElement((Element)element, (String)"YMin", (Object)arcGISTileMeta.getYmin());
        XmlUtil.appendElement((Element)element, (String)"XMax", (Object)arcGISTileMeta.getXmax());
        XmlUtil.appendElement((Element)element, (String)"YMax", (Object)arcGISTileMeta.getYmax());
        TilingSchemaHelper.a(element, arcGISTileMeta.getTileSchema().getSpatialReference());
        XmlUtil.write2File((File)file, (Document)document);
    }

    private static Element a(Element element, SpatialReference spatialReference) {
        Element element2 = XmlUtil.appendElement((Element)element, (String)"SpatialReference", null);
        if (spatialReference != null) {
            String string = "";
            string = spatialReference.getWkt().contains("PROJCS") || spatialReference.getWkt().contains("projcs") ? "typens:ProjectedCoordinateSystem" : "typens:GeographicCoordinateSystem";
            element2.setAttribute("xsi:type", string);
            XmlUtil.appendElement((Element)element2, (String)"WKT", (Object)spatialReference.getWkt());
            XmlUtil.appendElement((Element)element2, (String)"WKID", (Object)spatialReference.getWkid());
            XmlUtil.appendElement((Element)element2, (String)"LatestWKID", (Object)spatialReference.getLatestWKID());
            XmlUtil.appendElement((Element)element2, (String)"XOrigin", (Object)spatialReference.getOriginX());
            XmlUtil.appendElement((Element)element2, (String)"YOrigin", (Object)spatialReference.getOriginY());
            XmlUtil.appendElement((Element)element2, (String)"MOrigin", (Object)spatialReference.getOriginM());
            XmlUtil.appendElement((Element)element2, (String)"ZOrigin", (Object)spatialReference.getOriginZ());
            XmlUtil.appendElement((Element)element2, (String)"XYScale", (Object)spatialReference.getScaleXY());
            XmlUtil.appendElement((Element)element2, (String)"ZScale", (Object)spatialReference.getScaleZ());
            XmlUtil.appendElement((Element)element2, (String)"MScale", (Object)spatialReference.getScaleM());
            XmlUtil.appendElement((Element)element2, (String)"XYTolerance", (Object)spatialReference.getToleranceXY());
            XmlUtil.appendElement((Element)element2, (String)"ZTolerance", (Object)spatialReference.getToleranceZ());
            XmlUtil.appendElement((Element)element2, (String)"MTolerance", (Object)spatialReference.getToleranceM());
            XmlUtil.appendElement((Element)element2, (String)"HighPrecision", (Object)spatialReference.isHighPrecision());
            XmlUtil.appendElement((Element)element2, (String)"LeftLongitude", (Object)spatialReference.getLeftLongitude());
        }
        return element2;
    }
}

