/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.gis.tile.mbtiles;

import com.geoway.adf.gis.basic.geometry.GeometryFunc;
import com.geoway.adf.gis.basic.geometry.SpatialReferenceSystemFunc;
import com.geoway.adf.gis.tile.ITileDataSource;
import com.geoway.adf.gis.tile.ITileDataset;
import com.geoway.adf.gis.tile.TileMeta;
import com.geoway.adf.gis.tile.TileType;
import com.geoway.adf.gis.tile.a.f;
import com.geoway.adf.gis.tile.meta.LODInfo;
import com.geoway.adf.gis.tile.meta.SpatialReference;
import com.geoway.adf.gis.tile.meta.TileSchema;
import com.geoway.adf.gis.tile.meta.YAxis;
import java.io.File;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MBTilesTileDataSource
implements ITileDataSource {
    private static final Logger a = LoggerFactory.getLogger(MBTilesTileDataSource.class);
    private final String v = "name";
    private final String w = "type";
    private final String x = "version";
    private final String y = "description";
    private final String z = "format";
    private final String A = "bounds";
    private final String B = "minzoom";
    private final String C = "maxzoom";
    private final String D = "axis_origin_x";
    private final String E = "axis_origin_y";
    private final String F = "col_direction";
    private final String G = "row_direction";
    private final String H = "crs_wkid";
    private final String I = "crs_wkt";
    private final String J = "tile_height";
    private final String K = "tile_width";
    private final String L = "lodinfos";
    private final String M = "levels";
    private final String N = "tiletype";
    private final String O = "tag";
    private final String P = "versioninfo";
    private static final String Q = "org.sqlite.JDBC";
    private final File R;
    private Connection S;
    protected boolean inTransaction = false;

    public MBTilesTileDataSource(String string) {
        this.R = new File(string);
    }

    public Connection getMBTilesConnection() {
        return this.S;
    }

    public boolean getInTransaction() {
        try {
            if (this.S != null) {
                return this.inTransaction && !this.S.getAutoCommit();
            }
        }
        catch (SQLException sQLException) {
            a.error(sQLException.getMessage(), (Throwable)sQLException);
        }
        return false;
    }

    public void beginTransaction() {
        if (this.S != null) {
            if (this.getInTransaction()) {
                throw new RuntimeException("\u4e0d\u80fd\u5d4c\u5957\u4e8b\u52a1\uff01");
            }
            this.S.setAutoCommit(false);
            this.inTransaction = true;
        }
    }

    public void commitTransaction() {
        if (this.S == null) {
            throw new RuntimeException("\u4e8b\u52a1\u672a\u5f00\u542f");
        }
        this.S.commit();
        this.S.setAutoCommit(true);
        this.inTransaction = false;
    }

    public void rollbackTransaction() {
        if (!this.getInTransaction()) {
            throw new RuntimeException("\u4e8b\u52a1\u672a\u5f00\u542f");
        }
        this.S.rollback();
        this.S.setAutoCommit(true);
        this.inTransaction = false;
    }

    @Override
    public String getConnectionString() {
        return this.R.toString();
    }

    @Override
    public boolean connect() {
        try {
            if (this.S != null && !this.S.isClosed()) {
                return true;
            }
        }
        catch (SQLException sQLException) {
            a.error("\u67e5\u770b\u6570\u636e\u5e93\u8fde\u63a5\u5f02\u5e38", (Throwable)sQLException);
        }
        if (!this.R.getParentFile().exists()) {
            this.R.getParentFile().mkdirs();
        }
        Class.forName(Q);
        this.S = DriverManager.getConnection(String.format("jdbc:sqlite:%s", this.getConnectionString()));
        try {
            DatabaseMetaData databaseMetaData = this.S.getMetaData();
            ResultSet resultSet = databaseMetaData.getTables(null, null, "images", null);
            if (!resultSet.next()) {
                this.j();
            }
            if (!(resultSet = databaseMetaData.getTables(null, null, "metadata", null)).next()) {
                this.k();
            }
        }
        catch (Exception exception) {
            a.error("\u5143\u6570\u636e\u8868\u521b\u5efa\u5931\u8d25", (Throwable)exception);
        }
        return true;
    }

    @Override
    public void close() {
        try {
            if (this.S != null) {
                this.S.close();
            }
        }
        catch (Exception exception) {
            a.error("\u6570\u636e\u6e90\u5173\u95ed\u5931\u8d25", (Throwable)exception);
        }
        finally {
            this.S = null;
        }
    }

    @Override
    public List<ITileDataset> getDatasets() {
        ITileDataset iTileDataset = this.getDataset(null);
        ArrayList<ITileDataset> arrayList = new ArrayList<ITileDataset>();
        arrayList.add(iTileDataset);
        return arrayList;
    }

    @Override
    public List<ITileDataset> getDatasets(TileType ... tileTypeArray) {
        return this.getDatasets();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ITileDataset getDataset(String string) {
        try (Statement statement = this.S.createStatement(1003, 1007);){
            Object object;
            Object object2;
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            ResultSet resultSet = statement.executeQuery("select * from metadata");
            while (resultSet.next()) {
                if (resultSet.getString("name") == null || resultSet.getString("name").isEmpty()) continue;
                hashMap.put(resultSet.getString("name"), resultSet.getObject("value"));
            }
            resultSet.close();
            if (hashMap.size() == 0) {
                ITileDataset iTileDataset = null;
                return iTileDataset;
            }
            TileMeta tileMeta = new TileMeta();
            tileMeta.setName(this.R.getName());
            tileMeta.setAliasName(tileMeta.getName());
            tileMeta.setDataFormat(hashMap.get("format") == null ? null : hashMap.get("format").toString());
            tileMeta.setTag(hashMap.get("tag") == null ? null : hashMap.get("tag").toString());
            tileMeta.setVersion(hashMap.get("version") == null ? null : hashMap.get("version").toString());
            if (hashMap.get("tiletype") != null) {
                if ("\u5730\u5f62".equals(hashMap.get("tiletype"))) {
                    tileMeta.setTileType(TileType.TerrainTile);
                } else if ("3dtiles".equals(hashMap.get("tiletype"))) {
                    tileMeta.setTileType(TileType.Model3DTile);
                } else {
                    tileMeta.setTileType(TileType.RasterTile);
                }
            }
            if (hashMap.get("bounds") != null && ((String[])(object2 = hashMap.get("bounds").toString().split(","))).length >= 4) {
                try {
                    tileMeta.setXmin(Double.parseDouble(object2[0]));
                    tileMeta.setYmin(Double.parseDouble(object2[1]));
                    tileMeta.setXmax(Double.parseDouble((String)object2[2]));
                    tileMeta.setYmax(Double.parseDouble((String)object2[3]));
                }
                catch (Exception exception) {
                    a.error("\u8303\u56f4\u8bfb\u53d6\u5f02\u5e38\uff1a" + hashMap.get("bounds"));
                }
            }
            if (hashMap.get("levels") != null) {
                try {
                    object2 = hashMap.get("levels").toString().split(",");
                    object = Arrays.stream(object2).map(Integer::parseInt).collect(Collectors.toList());
                    tileMeta.setLevels((List<Integer>)object);
                    if (object.size() > 0) {
                        tileMeta.setStartLevel((Integer)object.get(0));
                        tileMeta.setEndLevel((Integer)object.get(object.size() - 1));
                    }
                }
                catch (Exception exception) {
                    a.error("\u7ea7\u522b\u8bfb\u53d6\u5f02\u5e38\uff1a" + hashMap.get("levels"));
                }
            } else {
                object2 = null;
                object = null;
                try {
                    if (hashMap.get("minzoom") != null) {
                        object2 = Integer.parseInt(hashMap.get("minzoom").toString());
                    }
                    if (hashMap.get("maxzoom") != null) {
                        object = Integer.parseInt(hashMap.get("maxzoom").toString());
                    }
                }
                catch (Exception exception) {
                    a.error("\u7ea7\u522b\u8bfb\u53d6\u5f02\u5e38");
                }
                tileMeta.setStartLevel((Integer)object2);
                tileMeta.setEndLevel((Integer)object);
                if (object2 != null && object != null) {
                    tileMeta.setLevels(IntStream.range((Integer)object2, (Integer)object + 1).boxed().collect(Collectors.toList()));
                }
            }
            if (hashMap.get("lodinfos") != null) {
                Object object3;
                object2 = LODInfo.parseJsonString(hashMap.get("lodinfos").toString());
                object = new TileSchema();
                ((TileSchema)object).setLodInfos((List<LODInfo>)object2);
                if (hashMap.get("crs_wkid") != null) {
                    try {
                        int n = Integer.valueOf(hashMap.get("crs_wkid").toString());
                        object3 = SpatialReference.fromSrid(n);
                        if (object3 == null && hashMap.get("crs_wkt") != null) {
                            object3 = new SpatialReference(n, hashMap.get("crs_wkt").toString());
                        }
                        ((TileSchema)object).setSpatialReference((SpatialReference)object3);
                    }
                    catch (Exception exception) {
                        a.error("\u7ea7\u522b\u8bfb\u53d6\u5f02\u5e38\uff1a" + hashMap.get("crs_wkid"));
                    }
                }
                if (hashMap.get("col_direction") != null && "-1".equals(hashMap.get("col_direction"))) {
                    ((TileSchema)object).setYaxis(YAxis.TMS);
                }
                Integer n = 256;
                object3 = 256;
                double d2 = -180.0;
                double d3 = 90.0;
                if (hashMap.get("tile_height") != null) {
                    try {
                        object3 = Integer.parseInt(hashMap.get("tile_height").toString());
                    }
                    catch (Exception exception) {
                        a.error("V_TILE_HEIGHT\u8bfb\u53d6\u5f02\u5e38\uff1a" + hashMap.get("tile_height"));
                    }
                }
                if (hashMap.get("tile_width") != null) {
                    try {
                        n = Integer.parseInt(hashMap.get("tile_width").toString());
                    }
                    catch (Exception exception) {
                        a.error("V_TILE_WIDTH\u8bfb\u53d6\u5f02\u5e38\uff1a" + hashMap.get("tile_width"));
                    }
                }
                if (hashMap.get("axis_origin_x") != null) {
                    try {
                        d2 = Double.parseDouble(hashMap.get("axis_origin_x").toString());
                    }
                    catch (Exception exception) {
                        a.error("V_ORIGIN_X\u8bfb\u53d6\u5f02\u5e38\uff1a" + hashMap.get("axis_origin_x"));
                    }
                }
                if (hashMap.get("axis_origin_y") != null) {
                    try {
                        d3 = Double.parseDouble(hashMap.get("axis_origin_y").toString());
                    }
                    catch (Exception exception) {
                        a.error("V_ORIGIN_Y\u8bfb\u53d6\u5f02\u5e38\uff1a" + hashMap.get("axis_origin_y"));
                    }
                }
                ((TileSchema)object).setWidth(n);
                ((TileSchema)object).setHeight((Integer)object3);
                ((TileSchema)object).setOriginX(d2);
                ((TileSchema)object).setOriginY(d3);
                tileMeta.setTileSchema((TileSchema)object);
            } else {
                tileMeta.setTileSchema(TileSchema.WebMercator.clone());
                tileMeta.getTileSchema().setYaxis(YAxis.TMS);
                tileMeta.getTileSchema().setOriginY(0.0 - TileSchema.WebMercator.getOriginY());
                try {
                    if (tileMeta.getXmin() != null && tileMeta.getXmax() != null && tileMeta.getYmin() != null && tileMeta.getYmax() != null && (object = (object2 = GeometryFunc.createEnvelope((double)tileMeta.getXmin(), (double)tileMeta.getYmin(), (double)tileMeta.getXmax(), (double)tileMeta.getYmax())).projectToCopy(SpatialReferenceSystemFunc.createSpatialReference((int)4326), SpatialReferenceSystemFunc.createSpatialReference((int)3857))) != null) {
                        tileMeta.setXmin(object.getEnvelope().getXMin());
                        tileMeta.setXmax(object.getEnvelope().getXMax());
                        tileMeta.setYmin(object.getEnvelope().getYMin());
                        tileMeta.setYmax(object.getEnvelope().getYMax());
                    }
                }
                catch (Exception exception) {
                    a.error("\u8303\u56f4\u8bfb\u53d6\u5f02\u5e38\uff1a" + hashMap.get("bounds"));
                }
            }
            object = object2 = new f(this, tileMeta);
            return object;
        }
    }

    @Override
    public ITileDataset createDataset(TileMeta tileMeta) {
        TileMeta tileMeta2 = new TileMeta();
        tileMeta2.copyFrom(tileMeta);
        this.updateTileMeta(tileMeta2);
        f f2 = new f(this, tileMeta2);
        return f2;
    }

    @Override
    public void deleteDataset(String string) {
        try (Statement statement = this.S.createStatement();){
            statement.addBatch("delete from images;");
            statement.addBatch("delete from map;");
            statement.addBatch("delete from metadata;");
            int[] nArray = statement.executeBatch();
        }
    }

    public boolean updateTileMeta(TileMeta tileMeta) {
        Statement statement = null;
        try {
            this.beginTransaction();
            String string = "delete from metadata";
            statement = this.S.createStatement();
            statement.executeUpdate(string);
            statement.close();
            statement = null;
            String string2 = "insert into metadata (name,value) values ";
            String string3 = tileMeta.getDataFormat();
            if (string3 != null && string3.toLowerCase().contains("png")) {
                string3 = "png";
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(String.format("('%s', '%s')", "name", tileMeta.getName()));
            arrayList.add(String.format("('%s', '%s')", "type", "baselayer"));
            arrayList.add(String.format("('%s', '%s')", "version", tileMeta.getVersion()));
            arrayList.add(String.format("('%s', '%s')", "description", ""));
            arrayList.add(String.format("('%s', '%s')", "format", string3));
            if (tileMeta.getXmin() != null && tileMeta.getYmin() != null && tileMeta.getXmax() != null && tileMeta.getYmax() != null) {
                arrayList.add(String.format("('%s', '%s')", "bounds", String.format("%f,%f,%f,%f", tileMeta.getXmin(), tileMeta.getYmin(), tileMeta.getXmax(), tileMeta.getYmax())));
            }
            if (tileMeta.getTileSchema() != null) {
                arrayList.add(String.format("('%s', '%s')", "axis_origin_x", tileMeta.getTileSchema().getOriginX()));
                arrayList.add(String.format("('%s', '%s')", "axis_origin_y", tileMeta.getTileSchema().getOriginY()));
                arrayList.add(String.format("('%s', '%s')", "tile_height", tileMeta.getTileSchema().getHeight()));
                arrayList.add(String.format("('%s', '%s')", "tile_width", tileMeta.getTileSchema().getWidth()));
                if (tileMeta.getTileSchema().getLodInfos() != null) {
                    arrayList.add(String.format("('%s', '%s')", "lodinfos", LODInfo.toJsonString(tileMeta.getTileSchema().getLodInfos())));
                }
                if (tileMeta.getTileSchema().getSpatialReference() != null) {
                    arrayList.add(String.format("('%s', '%s')", "crs_wkid", tileMeta.getTileSchema().getSpatialReference().getWkid()));
                    arrayList.add(String.format("('%s', '%s')", "crs_wkt", tileMeta.getTileSchema().getSpatialReference().getWkt()));
                }
            }
            if (tileMeta.getTileSchema().getYaxis() == YAxis.TMS) {
                arrayList.add(String.format("('%s', '%s')", "col_direction", -1));
                arrayList.add(String.format("('%s', '%s')", "row_direction", -1));
            } else {
                arrayList.add(String.format("('%s', '%s')", "col_direction", 1));
                arrayList.add(String.format("('%s', '%s')", "row_direction", -1));
            }
            if (tileMeta.getLevels() != null) {
                arrayList.add(String.format("('%s', '%s')", "levels", tileMeta.getLevels().stream().map(String::valueOf).collect(Collectors.joining(","))));
                arrayList.add(String.format("('%s', '%s')", "minzoom", tileMeta.getStartLevel()));
                arrayList.add(String.format("('%s', '%s')", "maxzoom", tileMeta.getEndLevel()));
            }
            switch (tileMeta.getTileType()) {
                case RasterTile: {
                    arrayList.add(String.format("('%s', '%s')", "tiletype", "\u6805\u683c"));
                    break;
                }
                case TerrainTile: {
                    arrayList.add(String.format("('%s', '%s')", "tiletype", "\u5730\u5f62"));
                    break;
                }
                case Model3DTile: {
                    arrayList.add(String.format("('%s', '%s')", "tiletype", "3dtiles"));
                    break;
                }
                default: {
                    arrayList.add(String.format("('%s', '%s')", "tiletype", "\u6805\u683c"));
                }
            }
            arrayList.add(String.format("('%s', '%s')", "tag", tileMeta.getTag()));
            string2 = string2 + String.join((CharSequence)",", arrayList);
            statement = this.S.createStatement();
            statement.executeUpdate(string2);
            this.commitTransaction();
            return true;
        }
        catch (Exception exception) {
            a.error(this.getConnectionString() + "\u5143\u6570\u636e\u5199\u5165\u5931\u8d25");
            this.rollbackTransaction();
            if (statement != null) {
                statement.close();
            }
            throw exception;
        }
    }

    private void j() throws SQLException {
        try (Statement statement = this.S.createStatement();){
            statement.addBatch("CREATE TABLE images(tile_data blob,tile_id varchar(256));");
            statement.addBatch("CREATE UNIQUE INDEX images_id on images(tile_id);");
            statement.addBatch("CREATE TABLE map(zoom_level integer, tile_column integer, tile_row integer, tile_id varchar(256),tile_version integer,format varchar(256));");
            statement.addBatch("CREATE UNIQUE INDEX map_index on map(zoom_level, tile_column, tile_row,tile_version);");
            statement.addBatch("CREATE TABLE version( id integer PRIMARY KEY, name text, info text, datetime DATETIME);");
            statement.addBatch("CREATE VIEW tiles as select map.zoom_level as zoom_level,map.tile_column as tile_column,map.tile_row as tile_row,images.tile_data as tile_data,map.tile_version as tile_version,map.format as format FROM map JOIN images on images.tile_id = map.tile_id;");
            int[] nArray = statement.executeBatch();
        }
    }

    private void k() throws SQLException {
        try (Statement statement = this.S.createStatement();){
            statement.addBatch("CREATE TABLE metadata(name TEXT,value TEXT);");
            statement.addBatch("CREATE UNIQUE INDEX name ON metadata (name);");
            int[] nArray = statement.executeBatch();
        }
    }
}

