/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.gis.tile.meta;

public class SpatialReference
implements Cloneable {
    public static final String WKT_WGS84 = "GEOGCS[\"GCS_WGS_1984\",DATUM[\"D_WGS_1984\",SPHEROID[\"WGS_1984\",6378137.0,298.257223563]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4326]]";
    public static final String WKT_WebMector = "PROJCS[\"WGS_1984_Web_Mercator\",GEOGCS[\"GCS_WGS_1984_Major_Auxiliary_Sphere\",DATUM[\"D_WGS_1984_Major_Auxiliary_Sphere\",SPHEROID[\"WGS_1984_Major_Auxiliary_Sphere\",6378137.0,0.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Mercator\"],PARAMETER[\"False_Easting\",0.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",0.0],PARAMETER[\"Standard_Parallel_1\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3857]]";
    public static final String WKT_CGCS2000 = "GEOGCS[\"GCS_China_Geodetic_Coordinate_System_2000\",DATUM[\"D_China_2000\",SPHEROID[\"CGCS2000\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4490]]";
    public static final SpatialReference WGS84 = new SpatialReference();
    public static final SpatialReference CGCS2000 = new SpatialReference();
    public static final SpatialReference WGS84WebMercator;
    private int ac = 4326;
    private int ad = 4326;
    private String ae = "GEOGCS[\"GCS_WGS_1984\",DATUM[\"D_WGS_1984\",SPHEROID[\"WGS_1984\",6378137.0,298.257223563]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4326]]";
    private String name = "GCS_WGS_1984";
    private double af = -400.0;
    private double ag = -400.0;
    private double ah = 1.125899906842624E13;
    private double ai = -100000.0;
    private double aj = 10000.0;
    private double ak = -100000.0;
    private double al = 10000.0;
    private double am = 8.983152841195215E-9;
    private double an = 0.001;
    private double ao = 0.001;
    private boolean ap = true;
    private double aq = -180.0;

    public SpatialReference() {
    }

    public SpatialReference(int n, String string) {
        this.ac = n;
        this.ad = n;
        this.ae = string;
        int n2 = string.indexOf("[");
        int n3 = string.indexOf(",");
        String string2 = string.substring(n2 + 1, n3);
        if (string2.startsWith("\"")) {
            string2 = string2.substring(1);
        }
        if (string2.endsWith("\"")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        this.name = string2;
    }

    public SpatialReference clone() {
        return (SpatialReference)super.clone();
    }

    public static SpatialReference fromSrid(int n) {
        switch (n) {
            case 4326: {
                return WGS84;
            }
            case 4490: {
                return CGCS2000;
            }
            case 3785: 
            case 3857: 
            case 102100: 
            case 102113: 
            case 900913: {
                return WGS84WebMercator;
            }
        }
        return null;
    }

    public int getWkid() {
        return this.ac;
    }

    public int getLatestWKID() {
        return this.ad;
    }

    public String getWkt() {
        return this.ae;
    }

    public String getName() {
        return this.name;
    }

    public double getOriginX() {
        return this.af;
    }

    public double getOriginY() {
        return this.ag;
    }

    public double getScaleXY() {
        return this.ah;
    }

    public double getOriginZ() {
        return this.ai;
    }

    public double getScaleZ() {
        return this.aj;
    }

    public double getOriginM() {
        return this.ak;
    }

    public double getScaleM() {
        return this.al;
    }

    public double getToleranceXY() {
        return this.am;
    }

    public double getToleranceZ() {
        return this.an;
    }

    public double getToleranceM() {
        return this.ao;
    }

    public boolean isHighPrecision() {
        return this.ap;
    }

    public double getLeftLongitude() {
        return this.aq;
    }

    public void setWkid(int n) {
        this.ac = n;
    }

    public void setLatestWKID(int n) {
        this.ad = n;
    }

    public void setWkt(String string) {
        this.ae = string;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setOriginX(double d2) {
        this.af = d2;
    }

    public void setOriginY(double d2) {
        this.ag = d2;
    }

    public void setScaleXY(double d2) {
        this.ah = d2;
    }

    public void setOriginZ(double d2) {
        this.ai = d2;
    }

    public void setScaleZ(double d2) {
        this.aj = d2;
    }

    public void setOriginM(double d2) {
        this.ak = d2;
    }

    public void setScaleM(double d2) {
        this.al = d2;
    }

    public void setToleranceXY(double d2) {
        this.am = d2;
    }

    public void setToleranceZ(double d2) {
        this.an = d2;
    }

    public void setToleranceM(double d2) {
        this.ao = d2;
    }

    public void setHighPrecision(boolean bl) {
        this.ap = bl;
    }

    public void setLeftLongitude(double d2) {
        this.aq = d2;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SpatialReference)) {
            return false;
        }
        SpatialReference spatialReference = (SpatialReference)object;
        if (!spatialReference.canEqual(this)) {
            return false;
        }
        if (this.getWkid() != spatialReference.getWkid()) {
            return false;
        }
        if (this.getLatestWKID() != spatialReference.getLatestWKID()) {
            return false;
        }
        if (Double.compare(this.getOriginX(), spatialReference.getOriginX()) != 0) {
            return false;
        }
        if (Double.compare(this.getOriginY(), spatialReference.getOriginY()) != 0) {
            return false;
        }
        if (Double.compare(this.getScaleXY(), spatialReference.getScaleXY()) != 0) {
            return false;
        }
        if (Double.compare(this.getOriginZ(), spatialReference.getOriginZ()) != 0) {
            return false;
        }
        if (Double.compare(this.getScaleZ(), spatialReference.getScaleZ()) != 0) {
            return false;
        }
        if (Double.compare(this.getOriginM(), spatialReference.getOriginM()) != 0) {
            return false;
        }
        if (Double.compare(this.getScaleM(), spatialReference.getScaleM()) != 0) {
            return false;
        }
        if (Double.compare(this.getToleranceXY(), spatialReference.getToleranceXY()) != 0) {
            return false;
        }
        if (Double.compare(this.getToleranceZ(), spatialReference.getToleranceZ()) != 0) {
            return false;
        }
        if (Double.compare(this.getToleranceM(), spatialReference.getToleranceM()) != 0) {
            return false;
        }
        if (this.isHighPrecision() != spatialReference.isHighPrecision()) {
            return false;
        }
        if (Double.compare(this.getLeftLongitude(), spatialReference.getLeftLongitude()) != 0) {
            return false;
        }
        String string = this.getWkt();
        String string2 = spatialReference.getWkt();
        if (string == null ? string2 != null : !string.equals(string2)) {
            return false;
        }
        String string3 = this.getName();
        String string4 = spatialReference.getName();
        return !(string3 == null ? string4 != null : !string3.equals(string4));
    }

    protected boolean canEqual(Object object) {
        return object instanceof SpatialReference;
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        n2 = n2 * 59 + this.getWkid();
        n2 = n2 * 59 + this.getLatestWKID();
        long l2 = Double.doubleToLongBits(this.getOriginX());
        n2 = n2 * 59 + (int)(l2 >>> 32 ^ l2);
        long l3 = Double.doubleToLongBits(this.getOriginY());
        n2 = n2 * 59 + (int)(l3 >>> 32 ^ l3);
        long l4 = Double.doubleToLongBits(this.getScaleXY());
        n2 = n2 * 59 + (int)(l4 >>> 32 ^ l4);
        long l5 = Double.doubleToLongBits(this.getOriginZ());
        n2 = n2 * 59 + (int)(l5 >>> 32 ^ l5);
        long l6 = Double.doubleToLongBits(this.getScaleZ());
        n2 = n2 * 59 + (int)(l6 >>> 32 ^ l6);
        long l7 = Double.doubleToLongBits(this.getOriginM());
        n2 = n2 * 59 + (int)(l7 >>> 32 ^ l7);
        long l8 = Double.doubleToLongBits(this.getScaleM());
        n2 = n2 * 59 + (int)(l8 >>> 32 ^ l8);
        long l9 = Double.doubleToLongBits(this.getToleranceXY());
        n2 = n2 * 59 + (int)(l9 >>> 32 ^ l9);
        long l10 = Double.doubleToLongBits(this.getToleranceZ());
        n2 = n2 * 59 + (int)(l10 >>> 32 ^ l10);
        long l11 = Double.doubleToLongBits(this.getToleranceM());
        n2 = n2 * 59 + (int)(l11 >>> 32 ^ l11);
        n2 = n2 * 59 + (this.isHighPrecision() ? 79 : 97);
        long l12 = Double.doubleToLongBits(this.getLeftLongitude());
        n2 = n2 * 59 + (int)(l12 >>> 32 ^ l12);
        String string = this.getWkt();
        n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
        String string2 = this.getName();
        n2 = n2 * 59 + (string2 == null ? 43 : string2.hashCode());
        return n2;
    }

    public String toString() {
        return "SpatialReference(wkid=" + this.getWkid() + ", latestWKID=" + this.getLatestWKID() + ", wkt=" + this.getWkt() + ", name=" + this.getName() + ", originX=" + this.getOriginX() + ", originY=" + this.getOriginY() + ", scaleXY=" + this.getScaleXY() + ", originZ=" + this.getOriginZ() + ", scaleZ=" + this.getScaleZ() + ", originM=" + this.getOriginM() + ", scaleM=" + this.getScaleM() + ", toleranceXY=" + this.getToleranceXY() + ", toleranceZ=" + this.getToleranceZ() + ", toleranceM=" + this.getToleranceM() + ", highPrecision=" + this.isHighPrecision() + ", leftLongitude=" + this.getLeftLongitude() + ")";
    }

    static {
        CGCS2000.setName("GCS_China_Geodetic_Coordinate_System_2000");
        CGCS2000.setWkt(WKT_CGCS2000);
        CGCS2000.setOriginX(-400.0);
        CGCS2000.setOriginY(-400.0);
        CGCS2000.setScaleXY(1.125899906842624E13);
        CGCS2000.setOriginZ(-100000.0);
        CGCS2000.setScaleZ(10000.0);
        CGCS2000.setOriginM(-100000.0);
        CGCS2000.setScaleM(10000.0);
        CGCS2000.setToleranceXY(8.983152841195215E-9);
        CGCS2000.setToleranceZ(0.001);
        CGCS2000.setToleranceM(0.001);
        CGCS2000.setHighPrecision(true);
        CGCS2000.setLeftLongitude(-180.0);
        CGCS2000.setWkid(4490);
        CGCS2000.setLatestWKID(4490);
        WGS84WebMercator = new SpatialReference();
        WGS84WebMercator.setName("WGS_1984_Web_Mercator");
        WGS84WebMercator.setWkt(WKT_WebMector);
        WGS84WebMercator.setOriginX(-2.00377E7);
        WGS84WebMercator.setOriginY(-3.02411E7);
        WGS84WebMercator.setScaleXY(1.4892314192838538E8);
        WGS84WebMercator.setOriginZ(-100000.0);
        WGS84WebMercator.setScaleZ(10000.0);
        WGS84WebMercator.setOriginM(-100000.0);
        WGS84WebMercator.setScaleM(10000.0);
        WGS84WebMercator.setToleranceXY(0.001);
        WGS84WebMercator.setToleranceZ(0.001);
        WGS84WebMercator.setToleranceM(0.001);
        WGS84WebMercator.setHighPrecision(true);
        WGS84WebMercator.setLeftLongitude(0.0);
        WGS84WebMercator.setWkid(3857);
        WGS84WebMercator.setLatestWKID(3857);
    }
}

