/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.gis.tile.model3d.parse;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.geoway.adf.gis.basic.geometry.GeometryFunc;
import com.geoway.adf.gis.basic.geometry.IGeometry;
import com.geoway.adf.gis.tile.a.i;
import com.geoway.adf.gis.tile.meta.MapExtent;
import com.geoway.adf.gis.tile.model3d.parse.BoundingVolumeUtil;
import com.geoway.adf.gis.tile.model3d.parse.Tiles3dBoundingVolume;
import com.geoway.adf.gis.tile.model3d.parse.TilesetObject;
import java.util.ArrayList;
import java.util.List;

public class TilesetJsonUtil {
    public static TilesetObject filterTileset(JSONObject jSONObject, TilesetObject tilesetObject, MapExtent mapExtent, IGeometry iGeometry) {
        JSONObject jSONObject2 = jSONObject.getJSONObject("root");
        if (jSONObject2 == null) {
            return null;
        }
        Tiles3dBoundingVolume tiles3dBoundingVolume = TilesetJsonUtil.a(jSONObject2, tilesetObject == null ? null : tilesetObject.getBoundingVolume());
        MapExtent mapExtent2 = TilesetJsonUtil.getTile3dBound(tiles3dBoundingVolume);
        if (!TilesetJsonUtil.a(mapExtent2, mapExtent, iGeometry)) {
            return null;
        }
        TilesetObject tilesetObject2 = new TilesetObject();
        tilesetObject2.setBoundingVolume(tiles3dBoundingVolume);
        JSONObject jSONObject3 = jSONObject2.getJSONObject("content");
        if (jSONObject3 != null) {
            tilesetObject2.setContentUri(jSONObject3.getString("uri"));
        }
        List<TilesetObject> list = TilesetJsonUtil.a(jSONObject2, tilesetObject2, mapExtent, iGeometry);
        tilesetObject2.setChildren(list);
        return tilesetObject2;
    }

    private static List<TilesetObject> a(JSONObject jSONObject, TilesetObject tilesetObject, MapExtent mapExtent, IGeometry iGeometry) {
        JSONArray jSONArray = jSONObject.getJSONArray("children");
        if (jSONArray != null && jSONArray.size() > 0) {
            ArrayList<TilesetObject> arrayList = new ArrayList<TilesetObject>();
            for (int i2 = 0; i2 < jSONArray.size(); ++i2) {
                List<TilesetObject> list;
                JSONObject jSONObject2 = jSONArray.getJSONObject(i2);
                Tiles3dBoundingVolume tiles3dBoundingVolume = TilesetJsonUtil.a(jSONObject2, tilesetObject.getBoundingVolume());
                MapExtent mapExtent2 = TilesetJsonUtil.getTile3dBound(tiles3dBoundingVolume);
                if (!TilesetJsonUtil.a(mapExtent2, mapExtent, iGeometry)) {
                    jSONArray.remove((Object)jSONObject2);
                    --i2;
                    continue;
                }
                TilesetObject tilesetObject2 = new TilesetObject();
                arrayList.add(tilesetObject2);
                tilesetObject2.setBoundingVolume(tiles3dBoundingVolume);
                JSONObject jSONObject3 = jSONObject2.getJSONObject("content");
                if (jSONObject3 != null) {
                    tilesetObject2.setContentUri(jSONObject3.getString("uri"));
                }
                if ((list = TilesetJsonUtil.a(jSONObject2, tilesetObject2, mapExtent, iGeometry)) == null) continue;
                arrayList.addAll(list);
            }
            return arrayList;
        }
        return null;
    }

    private static Tiles3dBoundingVolume a(JSONObject jSONObject, Tiles3dBoundingVolume tiles3dBoundingVolume) {
        JSONObject jSONObject2 = jSONObject.getJSONObject("boundingVolume");
        Tiles3dBoundingVolume tiles3dBoundingVolume2 = new Tiles3dBoundingVolume();
        if (jSONObject2.containsKey("box")) {
            tiles3dBoundingVolume2.setType(Tiles3dBoundingVolume.Type.box);
            tiles3dBoundingVolume2.setValues(TilesetJsonUtil.a(jSONObject2.getJSONArray("box")));
            if (jSONObject.containsKey("transform")) {
                double[] dArray = TilesetJsonUtil.a(jSONObject.getJSONArray("transform"));
                if (tiles3dBoundingVolume != null && tiles3dBoundingVolume.getTransform() != null) {
                    double[] dArray2 = i.a(tiles3dBoundingVolume.getTransform(), dArray);
                    dArray = dArray2;
                }
                tiles3dBoundingVolume2.setTransform(dArray);
            } else if (tiles3dBoundingVolume != null && tiles3dBoundingVolume.getTransform() != null) {
                tiles3dBoundingVolume2.setTransform(tiles3dBoundingVolume.getTransform());
            } else {
                tiles3dBoundingVolume2.setTransform(new double[]{1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0});
            }
        } else if (jSONObject2.containsKey("region")) {
            tiles3dBoundingVolume2.setType(Tiles3dBoundingVolume.Type.region);
            tiles3dBoundingVolume2.setValues(TilesetJsonUtil.a(jSONObject2.getJSONArray("region")));
        } else if (jSONObject2.containsKey("sphere")) {
            tiles3dBoundingVolume2.setType(Tiles3dBoundingVolume.Type.sphere);
            tiles3dBoundingVolume2.setValues(TilesetJsonUtil.a(jSONObject2.getJSONArray("sphere")));
        }
        return tiles3dBoundingVolume2;
    }

    public static String getRelativeUri(String string, String string2) {
        int n;
        if (string2.startsWith("/")) {
            string2 = string2.substring(1);
        }
        if (string2.startsWith("./")) {
            string2 = string2.substring(2);
        }
        if (string2.contains("?")) {
            string2 = string2.split("\\?")[0];
        }
        String string3 = (n = string.lastIndexOf("/")) > 0 ? string.substring(0, n) : "";
        while (string2.startsWith("../")) {
            string2 = string2.substring(3);
            int n2 = string3.lastIndexOf("/");
            if (n2 > 0) {
                string3 = string3.substring(0, n2);
                continue;
            }
            string3 = "";
        }
        return string3.isEmpty() ? string2 : string3 + "/" + string2;
    }

    public static MapExtent getTile3dBound(Tiles3dBoundingVolume tiles3dBoundingVolume) {
        double[] dArray = BoundingVolumeUtil.regionValues(tiles3dBoundingVolume);
        double d2 = Math.toDegrees(dArray[0]);
        double d3 = Math.toDegrees(dArray[1]);
        double d4 = Math.toDegrees(dArray[2]);
        double d5 = Math.toDegrees(dArray[3]);
        return new MapExtent(d2, d3, d4, d5);
    }

    private static boolean a(MapExtent mapExtent, MapExtent mapExtent2, IGeometry iGeometry) {
        if (mapExtent == null) {
            return true;
        }
        if (mapExtent2 != null && (mapExtent.getMinX().doubleValue() >= mapExtent2.getMaxX().doubleValue() || mapExtent2.getMinX().doubleValue() >= mapExtent.getMaxX().doubleValue() || mapExtent.getMinY().doubleValue() >= mapExtent2.getMaxY().doubleValue() || mapExtent2.getMinY().doubleValue() >= mapExtent.getMaxY().doubleValue())) {
            return false;
        }
        return iGeometry == null || GeometryFunc.createEnvelope((double)mapExtent.getMinX().doubleValue(), (double)mapExtent.getMinY().doubleValue(), (double)mapExtent.getMaxX().doubleValue(), (double)mapExtent.getMaxY().doubleValue()).intersects(iGeometry);
    }

    private static double[] a(JSONArray jSONArray) {
        double[] dArray = new double[jSONArray.size()];
        for (int i2 = 0; i2 < jSONArray.size(); ++i2) {
            Object object = jSONArray.get(i2);
            dArray[i2] = null == object ? 0.0 : Double.parseDouble(String.valueOf(object));
        }
        return dArray;
    }
}

