/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.gis.tile;

import com.geoway.adf.gis.tile.TileType;
import com.geoway.adf.gis.tile.meta.TileSchema;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class TileMeta
implements Cloneable {
    protected String name;
    protected String aliasName;
    protected TileType tileType = TileType.RasterTile;
    protected TileSchema tileSchema;
    protected Double xmin;
    protected Double xmax;
    protected Double ymin;
    protected Double ymax;
    protected String dataFormat;
    protected Integer startLevel;
    protected Integer endLevel;
    protected List<Integer> levels;
    protected String tag;
    protected String version;
    protected Date updateTime;

    public TileMeta clone() {
        TileMeta tileMeta = (TileMeta)super.clone();
        if (this.tileSchema != null) {
            tileMeta.tileSchema = this.tileSchema.clone();
        }
        if (this.levels != null) {
            tileMeta.levels = new ArrayList<Integer>(this.levels);
        }
        return tileMeta;
    }

    public void copyFrom(TileMeta tileMeta) {
        this.name = tileMeta.name;
        this.aliasName = tileMeta.aliasName;
        this.dataFormat = tileMeta.dataFormat;
        this.tileType = tileMeta.tileType;
        this.xmin = tileMeta.xmin;
        this.ymin = tileMeta.ymin;
        this.xmax = tileMeta.xmax;
        this.ymax = tileMeta.ymax;
        this.startLevel = tileMeta.startLevel;
        this.endLevel = tileMeta.endLevel;
        if (tileMeta.levels != null) {
            this.levels = new ArrayList<Integer>(tileMeta.getLevels());
        }
        if (tileMeta.getTileSchema() != null) {
            this.tileSchema = tileMeta.getTileSchema().clone();
        }
        this.tag = tileMeta.tag;
        this.version = tileMeta.version;
        this.updateTime = tileMeta.updateTime;
    }

    public String getName() {
        return this.name;
    }

    public String getAliasName() {
        return this.aliasName;
    }

    public TileType getTileType() {
        return this.tileType;
    }

    public TileSchema getTileSchema() {
        return this.tileSchema;
    }

    public Double getXmin() {
        return this.xmin;
    }

    public Double getXmax() {
        return this.xmax;
    }

    public Double getYmin() {
        return this.ymin;
    }

    public Double getYmax() {
        return this.ymax;
    }

    public String getDataFormat() {
        return this.dataFormat;
    }

    public Integer getStartLevel() {
        return this.startLevel;
    }

    public Integer getEndLevel() {
        return this.endLevel;
    }

    public List<Integer> getLevels() {
        return this.levels;
    }

    public String getTag() {
        return this.tag;
    }

    public String getVersion() {
        return this.version;
    }

    public Date getUpdateTime() {
        return this.updateTime;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setAliasName(String string) {
        this.aliasName = string;
    }

    public void setTileType(TileType tileType) {
        this.tileType = tileType;
    }

    public void setTileSchema(TileSchema tileSchema) {
        this.tileSchema = tileSchema;
    }

    public void setXmin(Double d2) {
        this.xmin = d2;
    }

    public void setXmax(Double d2) {
        this.xmax = d2;
    }

    public void setYmin(Double d2) {
        this.ymin = d2;
    }

    public void setYmax(Double d2) {
        this.ymax = d2;
    }

    public void setDataFormat(String string) {
        this.dataFormat = string;
    }

    public void setStartLevel(Integer n) {
        this.startLevel = n;
    }

    public void setEndLevel(Integer n) {
        this.endLevel = n;
    }

    public void setLevels(List<Integer> list) {
        this.levels = list;
    }

    public void setTag(String string) {
        this.tag = string;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public void setUpdateTime(Date date) {
        this.updateTime = date;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof TileMeta)) {
            return false;
        }
        TileMeta tileMeta = (TileMeta)object;
        if (!tileMeta.canEqual(this)) {
            return false;
        }
        Double d2 = this.getXmin();
        Double d3 = tileMeta.getXmin();
        if (d2 == null ? d3 != null : !((Object)d2).equals(d3)) {
            return false;
        }
        Double d4 = this.getXmax();
        Double d5 = tileMeta.getXmax();
        if (d4 == null ? d5 != null : !((Object)d4).equals(d5)) {
            return false;
        }
        Double d6 = this.getYmin();
        Double d7 = tileMeta.getYmin();
        if (d6 == null ? d7 != null : !((Object)d6).equals(d7)) {
            return false;
        }
        Double d8 = this.getYmax();
        Double d9 = tileMeta.getYmax();
        if (d8 == null ? d9 != null : !((Object)d8).equals(d9)) {
            return false;
        }
        Integer n = this.getStartLevel();
        Integer n2 = tileMeta.getStartLevel();
        if (n == null ? n2 != null : !((Object)n).equals(n2)) {
            return false;
        }
        Integer n3 = this.getEndLevel();
        Integer n4 = tileMeta.getEndLevel();
        if (n3 == null ? n4 != null : !((Object)n3).equals(n4)) {
            return false;
        }
        String string = this.getName();
        String string2 = tileMeta.getName();
        if (string == null ? string2 != null : !string.equals(string2)) {
            return false;
        }
        String string3 = this.getAliasName();
        String string4 = tileMeta.getAliasName();
        if (string3 == null ? string4 != null : !string3.equals(string4)) {
            return false;
        }
        TileType tileType = this.getTileType();
        TileType tileType2 = tileMeta.getTileType();
        if (tileType == null ? tileType2 != null : !((Object)((Object)tileType)).equals((Object)tileType2)) {
            return false;
        }
        TileSchema tileSchema = this.getTileSchema();
        TileSchema tileSchema2 = tileMeta.getTileSchema();
        if (tileSchema == null ? tileSchema2 != null : !((Object)tileSchema).equals(tileSchema2)) {
            return false;
        }
        String string5 = this.getDataFormat();
        String string6 = tileMeta.getDataFormat();
        if (string5 == null ? string6 != null : !string5.equals(string6)) {
            return false;
        }
        List<Integer> list = this.getLevels();
        List<Integer> list2 = tileMeta.getLevels();
        if (list == null ? list2 != null : !((Object)list).equals(list2)) {
            return false;
        }
        String string7 = this.getTag();
        String string8 = tileMeta.getTag();
        if (string7 == null ? string8 != null : !string7.equals(string8)) {
            return false;
        }
        String string9 = this.getVersion();
        String string10 = tileMeta.getVersion();
        if (string9 == null ? string10 != null : !string9.equals(string10)) {
            return false;
        }
        Date date = this.getUpdateTime();
        Date date2 = tileMeta.getUpdateTime();
        return !(date == null ? date2 != null : !((Object)date).equals(date2));
    }

    protected boolean canEqual(Object object) {
        return object instanceof TileMeta;
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        Double d2 = this.getXmin();
        n2 = n2 * 59 + (d2 == null ? 43 : ((Object)d2).hashCode());
        Double d3 = this.getXmax();
        n2 = n2 * 59 + (d3 == null ? 43 : ((Object)d3).hashCode());
        Double d4 = this.getYmin();
        n2 = n2 * 59 + (d4 == null ? 43 : ((Object)d4).hashCode());
        Double d5 = this.getYmax();
        n2 = n2 * 59 + (d5 == null ? 43 : ((Object)d5).hashCode());
        Integer n3 = this.getStartLevel();
        n2 = n2 * 59 + (n3 == null ? 43 : ((Object)n3).hashCode());
        Integer n4 = this.getEndLevel();
        n2 = n2 * 59 + (n4 == null ? 43 : ((Object)n4).hashCode());
        String string = this.getName();
        n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
        String string2 = this.getAliasName();
        n2 = n2 * 59 + (string2 == null ? 43 : string2.hashCode());
        TileType tileType = this.getTileType();
        n2 = n2 * 59 + (tileType == null ? 43 : ((Object)((Object)tileType)).hashCode());
        TileSchema tileSchema = this.getTileSchema();
        n2 = n2 * 59 + (tileSchema == null ? 43 : ((Object)tileSchema).hashCode());
        String string3 = this.getDataFormat();
        n2 = n2 * 59 + (string3 == null ? 43 : string3.hashCode());
        List<Integer> list = this.getLevels();
        n2 = n2 * 59 + (list == null ? 43 : ((Object)list).hashCode());
        String string4 = this.getTag();
        n2 = n2 * 59 + (string4 == null ? 43 : string4.hashCode());
        String string5 = this.getVersion();
        n2 = n2 * 59 + (string5 == null ? 43 : string5.hashCode());
        Date date = this.getUpdateTime();
        n2 = n2 * 59 + (date == null ? 43 : ((Object)date).hashCode());
        return n2;
    }

    public String toString() {
        return "TileMeta(name=" + this.getName() + ", aliasName=" + this.getAliasName() + ", tileType=" + (Object)((Object)this.getTileType()) + ", tileSchema=" + this.getTileSchema() + ", xmin=" + this.getXmin() + ", xmax=" + this.getXmax() + ", ymin=" + this.getYmin() + ", ymax=" + this.getYmax() + ", dataFormat=" + this.getDataFormat() + ", startLevel=" + this.getStartLevel() + ", endLevel=" + this.getEndLevel() + ", levels=" + this.getLevels() + ", tag=" + this.getTag() + ", version=" + this.getVersion() + ", updateTime=" + this.getUpdateTime() + ")";
    }
}

