/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.gis.tile.a;

import com.geoway.adf.gis.tile.ITileDataSource;
import com.geoway.adf.gis.tile.ITileDataset;
import com.geoway.adf.gis.tile.TileData;
import com.geoway.adf.gis.tile.TileMeta;
import com.geoway.adf.gis.tile.TileType;
import com.geoway.adf.gis.tile.mbtiles.MBTilesTileDataSource;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sqlite.jdbc4.JDBC4ResultSet;

public class f
implements ITileDataset {
    private static final Logger a = LoggerFactory.getLogger(f.class);
    private final MBTilesTileDataSource U;
    private final Connection S;
    private TileMeta u;

    public f(MBTilesTileDataSource mBTilesTileDataSource, TileMeta tileMeta) {
        this.U = mBTilesTileDataSource;
        this.u = tileMeta;
        this.S = mBTilesTileDataSource.getMBTilesConnection();
    }

    @Override
    public String getName() {
        return this.u.getName();
    }

    @Override
    public String getAliasName() {
        return this.u.getAliasName();
    }

    @Override
    public TileType getType() {
        return this.u.getTileType();
    }

    @Override
    public ITileDataSource getDataSource() {
        return this.U;
    }

    @Override
    public TileMeta getTileMeta() {
        return this.u;
    }

    @Override
    public boolean updateTileMeta(TileMeta tileMeta) {
        TileMeta tileMeta2 = new TileMeta();
        tileMeta2.copyFrom(tileMeta);
        tileMeta2.setUpdateTime(new Date());
        if (this.U.updateTileMeta(tileMeta2)) {
            this.u = tileMeta2;
            return true;
        }
        return false;
    }

    @Override
    public List<Integer> getAllLevels() {
        if (this.u.getLevels() == null) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            this.u.setLevels(arrayList);
            String string = "select min(zoom_level),max(zoom_level) from tiles";
            try (PreparedStatement preparedStatement = this.S.prepareStatement(string);){
                ResultSet resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    int n = resultSet.getInt(1);
                    int n2 = resultSet.getInt(2);
                    for (int i2 = n; i2 <= n2; ++i2) {
                        arrayList.add(i2);
                    }
                }
            }
            catch (Exception exception) {
                a.error("\u8bfb\u53d6\u74e6\u7247\u7ea7\u522b\u5931\u8d25", (Throwable)exception);
            }
            return arrayList;
        }
        return this.u.getLevels();
    }

    @Override
    public Long getDataCount() {
        return null;
    }

    @Override
    public Long getDataSize() {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean existTile(int n, int n2, int n3) {
        String string = String.format("select zoom_level from tiles where zoom_level=%d and tile_row=%d and tile_column=%d", n, n2, n3);
        try (PreparedStatement preparedStatement = this.S.prepareStatement(string);){
            ResultSet resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) return false;
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            a.error(String.format("\u8bfb\u53d6\u74e6\u7247\u5931\u8d25\u3010%d,%d,%d\u3011", n, n2, n3), (Throwable)exception);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public TileData getTile(int n, int n2, int n3) {
        String string = String.format("select * from tiles where zoom_level=%d and tile_row=%d and tile_column=%d", n, n2, n3);
        try (PreparedStatement preparedStatement = this.S.prepareStatement(string);){
            ResultSet resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) return null;
            byte[] byArray = resultSet.getBytes("tile_data");
            if (byArray == null) return null;
            if (byArray.length <= 0) return null;
            TileData tileData2 = new TileData();
            tileData2.setKey(n2 + "_" + n3 + "_" + n);
            tileData2.setLevel(resultSet.getInt("zoom_level"));
            tileData2.setRow(resultSet.getInt("tile_row"));
            tileData2.setCol(resultSet.getInt("tile_column"));
            if (!(resultSet instanceof JDBC4ResultSet) || ((JDBC4ResultSet)resultSet).cols.length <= 3) {
                tileData2.setFormat(this.u.getDataFormat());
            } else {
                for (String string2 : ((JDBC4ResultSet)resultSet).cols) {
                    if (!"format".equals(string2)) continue;
                    tileData2.setFormat(resultSet.getString("format"));
                    break;
                }
            }
            tileData2.setData(byArray);
            TileData tileData = tileData2;
            return tileData;
        }
        catch (Exception exception) {
            a.error(String.format("\u8bfb\u53d6\u74e6\u7247\u5931\u8d25\u3010%d,%d,%d\u3011", n, n2, n3), (Throwable)exception);
        }
        return null;
    }

    @Override
    public TileData getTile(String string) {
        String[] stringArray = string.split("_");
        if (stringArray.length != 3) {
            throw new IllegalArgumentException("key\u503c\u4e0d\u6b63\u786e");
        }
        return this.getTile(Integer.parseInt(stringArray[2]), Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean deleteTile(int n, int n2, int n3) {
        try {
            String string = String.format("select tile_id from map where zoom_level=%d and tile_row=%d and tile_column=%d", n, n2, n3);
            try (PreparedStatement preparedStatement = this.S.prepareStatement(string);){
                ResultSet resultSet = preparedStatement.executeQuery();
                String string2 = "";
                if (resultSet.next()) {
                    string2 = resultSet.getString("tile_id");
                }
                if (string2 == null || string2.isEmpty()) {
                    boolean bl = true;
                    return bl;
                }
                String string3 = String.format("delete from map where zoom_level = %d and tile_column = %d and tile_row = %d", n, n3, n2);
                try (PreparedStatement preparedStatement2 = this.S.prepareStatement(string3);){
                    int n4 = preparedStatement2.executeUpdate(string3);
                    if (n4 <= 0) return true;
                    string = String.format("select tile_id from map where tile_id ='%s'", string2);
                    try (PreparedStatement preparedStatement3 = this.S.prepareStatement(string);){
                        resultSet = preparedStatement3.executeQuery();
                        if (resultSet.next()) return true;
                        string = String.format("delete from images where tile_id ='%s'", string2);
                        try (PreparedStatement preparedStatement4 = this.S.prepareStatement(string);){
                            preparedStatement4.executeUpdate(string);
                            return true;
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            a.error(String.format("\u5220\u9664\u74e6\u7247\u5931\u8d25\u3010%d,%d,%d\u3011", n, n2, n3), (Throwable)exception);
            return false;
        }
    }

    @Override
    public boolean writeTile(TileData tileData, boolean bl) {
        byte[] byArray = tileData.getData();
        int n = tileData.getLevel();
        int n2 = tileData.getRow();
        int n3 = tileData.getCol();
        try {
            Throwable throwable;
            PreparedStatement preparedStatement;
            String string;
            this.deleteTile(n, n2, n3);
            String string2 = this.b(byArray);
            if (!this.b(string2).booleanValue()) {
                string = "insert into images(tile_data,tile_id) values (?,?)";
                preparedStatement = this.S.prepareStatement(string);
                throwable = null;
                try {
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                    preparedStatement.setBinaryStream(1, (InputStream)byteArrayInputStream, byArray.length);
                    preparedStatement.setString(2, string2);
                    preparedStatement.executeUpdate();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (preparedStatement != null) {
                        if (throwable != null) {
                            try {
                                preparedStatement.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            preparedStatement.close();
                        }
                    }
                }
            }
            string = String.format("insert into map values (%d,%d,%d,'%s',%d,'%s')", n, n3, n2, string2, 0, tileData.getFormat());
            preparedStatement = this.S.prepareStatement(string);
            throwable = null;
            try {
                preparedStatement.executeUpdate();
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (preparedStatement != null) {
                    if (throwable != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        preparedStatement.close();
                    }
                }
            }
            return true;
        }
        catch (Exception exception) {
            a.error(String.format("\u5199\u5165\u74e6\u7247\u5931\u8d25\u3010%d,%d,%d\u3011", n, n2, n3), (Throwable)exception);
            return false;
        }
    }

    @Override
    public void startWrite() {
        this.U.beginTransaction();
    }

    @Override
    public void commitWrite(boolean bl) {
        if (bl) {
            this.U.commitTransaction();
        } else {
            this.U.rollbackTransaction();
        }
    }

    private Boolean b(String string) throws SQLException {
        String string2 = String.format("SELECT tile_id FROM images where tile_id='%s'", string);
        try (PreparedStatement preparedStatement = this.S.prepareStatement(string2);){
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                Boolean bl = true;
                return bl;
            }
            Boolean bl = false;
            return bl;
        }
    }

    private String b(byte[] byArray) throws NoSuchAlgorithmException {
        byte[] byArray2 = MessageDigest.getInstance("MD5").digest(byArray);
        StringBuilder stringBuilder = new StringBuilder();
        for (byte by : byArray2) {
            stringBuilder.append(String.format("%2x", by));
        }
        return stringBuilder.toString();
    }
}

