/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.gis.tile.meta;

import com.geoway.adf.gis.tile.meta.LODInfo;
import com.geoway.adf.gis.tile.meta.MapExtent;
import com.geoway.adf.gis.tile.meta.TileRange;
import com.geoway.adf.gis.tile.meta.TileSchema;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class TileTransform {
    public static TileRange worldToTile(MapExtent mapExtent, int n, TileSchema tileSchema) {
        switch (tileSchema.getYaxis()) {
            case TMS: {
                return TileTransform.a(mapExtent, n, tileSchema);
            }
            case OSM: {
                return TileTransform.b(mapExtent, n, tileSchema);
            }
        }
        throw new RuntimeException("YAxis type was not found");
    }

    public static MapExtent tileToWorld(TileRange tileRange, int n, TileSchema tileSchema) {
        switch (tileSchema.getYaxis()) {
            case TMS: {
                return TileTransform.a(tileRange, n, tileSchema);
            }
            case OSM: {
                return TileTransform.b(tileRange, n, tileSchema);
            }
        }
        throw new RuntimeException("YAxis type was not found");
    }

    private static TileRange a(MapExtent mapExtent, int n, TileSchema tileSchema) {
        LODInfo lODInfo2 = tileSchema.getLodInfos().stream().filter(lODInfo -> lODInfo.getLevelID().equals(n)).findFirst().orElse(null);
        if (lODInfo2 == null) {
            throw new RuntimeException(n + "\u7ea7\u522b\u4e0d\u5b58\u5728");
        }
        BigDecimal bigDecimal = BigDecimal.valueOf(tileSchema.getOriginX());
        BigDecimal bigDecimal2 = BigDecimal.valueOf(tileSchema.getOriginY());
        BigDecimal bigDecimal3 = BigDecimal.valueOf(lODInfo2.getResolution()).multiply(BigDecimal.valueOf(tileSchema.getWidth().intValue()));
        int n2 = mapExtent.getMinX().subtract(bigDecimal).divide(bigDecimal3, 25, RoundingMode.HALF_UP).setScale(0, RoundingMode.FLOOR).intValue();
        int n3 = mapExtent.getMinY().subtract(bigDecimal2).divide(bigDecimal3, 25, RoundingMode.HALF_UP).setScale(0, RoundingMode.FLOOR).intValue();
        int n4 = mapExtent.getMaxX().subtract(bigDecimal).divide(bigDecimal3, 25, RoundingMode.HALF_UP).setScale(0, RoundingMode.CEILING).intValue();
        int n5 = mapExtent.getMaxY().subtract(bigDecimal2).divide(bigDecimal3, 25, RoundingMode.HALF_UP).setScale(0, RoundingMode.CEILING).intValue();
        return new TileRange(n2, n3, n4 - n2, n5 - n3);
    }

    private static MapExtent a(TileRange tileRange, int n, TileSchema tileSchema) {
        LODInfo lODInfo2 = tileSchema.getLodInfos().stream().filter(lODInfo -> lODInfo.getLevelID().equals(n)).findFirst().orElse(null);
        if (lODInfo2 == null) {
            throw new RuntimeException(n + "\u7ea7\u522b\u4e0d\u5b58\u5728");
        }
        BigDecimal bigDecimal = BigDecimal.valueOf(tileSchema.getOriginX());
        BigDecimal bigDecimal2 = BigDecimal.valueOf(tileSchema.getOriginY());
        BigDecimal bigDecimal3 = BigDecimal.valueOf(lODInfo2.getResolution()).multiply(BigDecimal.valueOf(tileSchema.getWidth().intValue()));
        BigDecimal bigDecimal4 = BigDecimal.valueOf(tileRange.getFirstCol()).multiply(bigDecimal3).add(bigDecimal);
        BigDecimal bigDecimal5 = BigDecimal.valueOf(tileRange.getFirstRow()).multiply(bigDecimal3).add(bigDecimal2);
        BigDecimal bigDecimal6 = BigDecimal.valueOf(tileRange.getFirstCol() + tileRange.getColCount()).multiply(bigDecimal3).add(bigDecimal);
        BigDecimal bigDecimal7 = BigDecimal.valueOf(tileRange.getFirstRow() + tileRange.getRowCount()).multiply(bigDecimal3).add(bigDecimal2);
        return new MapExtent(bigDecimal4, bigDecimal5, bigDecimal6, bigDecimal7);
    }

    private static TileRange b(MapExtent mapExtent, int n, TileSchema tileSchema) {
        LODInfo lODInfo2 = tileSchema.getLodInfos().stream().filter(lODInfo -> lODInfo.getLevelID().equals(n)).findFirst().orElse(null);
        if (lODInfo2 == null) {
            throw new RuntimeException(n + "\u7ea7\u522b\u4e0d\u5b58\u5728");
        }
        BigDecimal bigDecimal = BigDecimal.valueOf(tileSchema.getOriginX());
        BigDecimal bigDecimal2 = BigDecimal.valueOf(tileSchema.getOriginY());
        BigDecimal bigDecimal3 = BigDecimal.valueOf(lODInfo2.getResolution()).multiply(BigDecimal.valueOf(tileSchema.getWidth().intValue()));
        int n2 = mapExtent.getMinX().subtract(bigDecimal).divide(bigDecimal3, 25, RoundingMode.HALF_UP).setScale(0, RoundingMode.FLOOR).intValue();
        int n3 = bigDecimal2.subtract(mapExtent.getMaxY()).divide(bigDecimal3, 25, RoundingMode.HALF_UP).setScale(0, RoundingMode.FLOOR).intValue();
        int n4 = mapExtent.getMaxX().subtract(bigDecimal).divide(bigDecimal3, 25, RoundingMode.HALF_UP).setScale(0, RoundingMode.CEILING).intValue();
        int n5 = bigDecimal2.subtract(mapExtent.getMinY()).divide(bigDecimal3, 25, RoundingMode.HALF_UP).setScale(0, RoundingMode.CEILING).intValue();
        return new TileRange(n2, n3, n4 - n2, n5 - n3);
    }

    private static MapExtent b(TileRange tileRange, int n, TileSchema tileSchema) {
        LODInfo lODInfo2 = tileSchema.getLodInfos().stream().filter(lODInfo -> lODInfo.getLevelID().equals(n)).findFirst().orElse(null);
        if (lODInfo2 == null) {
            throw new RuntimeException(n + "\u7ea7\u522b\u4e0d\u5b58\u5728");
        }
        BigDecimal bigDecimal = BigDecimal.valueOf(tileSchema.getOriginX());
        BigDecimal bigDecimal2 = BigDecimal.valueOf(tileSchema.getOriginY());
        BigDecimal bigDecimal3 = BigDecimal.valueOf(lODInfo2.getResolution()).multiply(BigDecimal.valueOf(tileSchema.getWidth().intValue()));
        BigDecimal bigDecimal4 = BigDecimal.valueOf(tileRange.getFirstCol()).multiply(bigDecimal3).add(bigDecimal);
        BigDecimal bigDecimal5 = bigDecimal2.subtract(BigDecimal.valueOf(tileRange.getFirstRow() + tileRange.getRowCount()).multiply(bigDecimal3));
        BigDecimal bigDecimal6 = BigDecimal.valueOf(tileRange.getFirstCol() + tileRange.getColCount()).multiply(bigDecimal3).add(bigDecimal);
        BigDecimal bigDecimal7 = bigDecimal2.subtract(BigDecimal.valueOf(tileRange.getFirstRow()).multiply(bigDecimal3));
        return new MapExtent(bigDecimal4, bigDecimal5, bigDecimal6, bigDecimal7);
    }
}

