/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.ai.base.chat.client;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson2.JSON;
import com.geoway.ns.ai.base.RefObject;
import com.geoway.ns.ai.base.application.AIProviderType;
import com.geoway.ns.ai.base.application.AIReference;
import com.geoway.ns.ai.base.chat.AiChatResult;
import com.geoway.ns.ai.base.chat.client.AiChatClient;
import com.geoway.ns.ai.base.chat.client.BaseChatClient;
import com.geoway.ns.ai.base.chat.message.AIReferenceMessage;
import com.geoway.ns.ai.base.chat.message.AiAssistantMessage;
import com.geoway.ns.ai.base.chat.message.AiMessage;
import com.geoway.ns.ai.base.tool.AiTool;
import com.geoway.ns.ai.base.tool.AiToolContext;
import java.util.List;
import java.util.function.Consumer;
import org.springframework.http.MediaType;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Flux;

public class MetasoChatClient
extends BaseChatClient
implements AiChatClient {
    private String url;
    private String authorization;
    private String sceneId;

    public MetasoChatClient(String url, String authorization, String sceneId) {
        this.url = url;
        this.authorization = authorization;
        this.sceneId = sceneId;
    }

    @Override
    public AiChatResult chat(String userInput, AiToolContext aiToolContext) {
        throw new RuntimeException("MetasoChatClient\u6682\u672a\u5b9e\u73b0");
    }

    @Override
    public AiChatResult chat(String userInput, List<AiTool> tools, AiToolContext aiToolContext) {
        throw new RuntimeException("MetasoChatClient\u6682\u672a\u5b9e\u73b0");
    }

    @Override
    public AiChatResult chat(List<AiMessage> messages, List<AiTool> tools, AiToolContext aiToolContext) {
        throw new RuntimeException("MetasoChatClient\u6682\u672a\u5b9e\u73b0");
    }

    @Override
    public AiChatResult chat(List<AiMessage> messages, AiToolContext aiToolContext, List<AiTool> tools, Consumer<AiMessage> messageConsumer) {
        throw new RuntimeException("MetasoChatClient\u6682\u672a\u5b9e\u73b0");
    }

    @Override
    protected Flux<AiMessage> getStream(List<AiMessage> messages, RefObject<StringBuilder> totalText) {
        WebClient client = WebClient.builder().baseUrl(this.url).defaultHeader("Authorization", new String[]{"Bearer " + this.authorization}).build();
        com.alibaba.fastjson2.JSONObject json = new com.alibaba.fastjson2.JSONObject();
        json.put((Object)"question", messages.get(messages.size() - 1).getContent());
        json.put((Object)"searchTopicId", (Object)this.sceneId);
        json.put((Object)"stream", (Object)true);
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)client.post().uri("/api/open/search/v2", new Object[0])).contentType(MediaType.APPLICATION_JSON).accept(new MediaType[]{MediaType.TEXT_EVENT_STREAM})).bodyValue((Object)JSON.toJSONString((Object)json)).retrieve().bodyToFlux(String.class).map(f -> this.convert2AiMessage((String)f, totalText));
    }

    private AiMessage convert2AiMessage(String str, RefObject<StringBuilder> refObject) {
        String type;
        if (str.equalsIgnoreCase("[DONE]")) {
            AiAssistantMessage aiAssistantMessage = new AiAssistantMessage("");
            aiAssistantMessage.setIsReturn(true);
            aiAssistantMessage.setIsStore(false);
            return aiAssistantMessage;
        }
        JSONObject srcJsonObject = JSONObject.parseObject((String)str);
        if (!srcJsonObject.containsKey((Object)"type")) {
            AiAssistantMessage aiAssistantMessage = new AiAssistantMessage("");
            aiAssistantMessage.setIsStore(false);
            aiAssistantMessage.setIsReturn(true);
            return aiAssistantMessage;
        }
        switch (type = srcJsonObject.getString("type").toLowerCase()) {
            case "append-text": {
                String text = srcJsonObject.getString("text");
                refObject.get().append(text);
                AiAssistantMessage aiAssistantMessage = new AiAssistantMessage(text);
                aiAssistantMessage.setIsStore(false);
                aiAssistantMessage.setIsReturn(true);
                return aiAssistantMessage;
            }
            case "set-reference": {
                JSONArray referenceArray = srcJsonObject.getJSONArray("list");
                List aiReferences = referenceArray.toJavaList(AIReference.class);
                aiReferences.forEach(reference -> {
                    reference.setProvider(AIProviderType.METASO.getDesc());
                    reference.setSceneId(this.sceneId);
                    if (reference.getFile_meta() != null) {
                        reference.setType(reference.getFile_meta().getType());
                        reference.setUrl(reference.getFile_meta().getUrl());
                    }
                });
                return new AIReferenceMessage(aiReferences);
            }
        }
        AiAssistantMessage aiAssistantMessage = new AiAssistantMessage("");
        aiAssistantMessage.setIsStore(false);
        aiAssistantMessage.setIsReturn(true);
        return aiAssistantMessage;
    }
}

