/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.ai.base.tool;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.json.JSONUtil;
import com.geoway.ns.ai.base.chat.message.AiMessage;
import com.geoway.ns.ai.base.chat.message.AiToolMessage;
import com.geoway.ns.ai.base.tool.AIToolParam;
import com.geoway.ns.ai.base.tool.AiTool;
import com.geoway.ns.ai.base.tool.AiToolContext;
import com.geoway.ns.ai.base.tool.AiToolDefinition;
import com.geoway.ns.ai.base.tool.AiToolResult;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.function.Consumer;

public abstract class AiBaseTool<T extends AIToolParam, F extends AiToolDefinition>
implements AiTool {
    protected AiToolContext aiToolContext;
    protected Consumer<AiMessage> aiMessageConsumer;

    protected abstract AiToolResult call(T var1);

    public F getToolDefinition() {
        return this.getDefaultToolDefinition();
    }

    @Override
    public AiToolResult call(String toolInput, AiToolContext aiToolContext, Consumer<AiMessage> aiMessageConsumer) {
        this.aiMessageConsumer = aiMessageConsumer;
        this.aiToolContext = aiToolContext;
        AIToolParam param = (AIToolParam)JSONUtil.toBean((String)toolInput, (Class)this.getParamClassT());
        return this.call(param);
    }

    public AiToolResult call(T params, AiToolContext aiToolContext, Consumer<AiMessage> aiMessageConsumer) {
        this.aiMessageConsumer = aiMessageConsumer;
        this.aiToolContext = aiToolContext;
        return this.call(params);
    }

    private Class getParamClassT() {
        Class<?> superClass = this.getClass();
        Type genericSuperclass = superClass.getGenericSuperclass();
        while (!(genericSuperclass instanceof ParameterizedType)) {
            superClass = superClass.getSuperclass();
            genericSuperclass = superClass.getGenericSuperclass();
        }
        HashMap param = new HashMap();
        Class classT = (Class)((ParameterizedType)genericSuperclass).getActualTypeArguments()[0];
        return classT;
    }

    private Class getDefinitionClassT() {
        Class<?> superClass = this.getClass();
        Type genericSuperclass = superClass.getGenericSuperclass();
        while (!(genericSuperclass instanceof ParameterizedType)) {
            superClass = superClass.getSuperclass();
            genericSuperclass = superClass.getGenericSuperclass();
        }
        HashMap param = new HashMap();
        Class classT = (Class)((ParameterizedType)genericSuperclass).getActualTypeArguments()[1];
        return classT;
    }

    private T getDefaultToolParam() {
        try {
            Class classT = this.getParamClassT();
            return (T)((AIToolParam)BeanUtil.mapToBean(new HashMap(), (Class)classT, (boolean)false));
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private F getDefaultToolDefinition() {
        try {
            Class classT = this.getDefinitionClassT();
            return (F)((AiToolDefinition)BeanUtil.mapToBean(new HashMap(), (Class)classT, (boolean)false));
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    protected void messageInvoke(AiToolResult toolResult) {
        this.messageInvoke(new AiToolMessage(toolResult.getCallResult(), toolResult.getModelResult()));
    }

    protected void messageInvoke(AiMessage aiMessage) {
        if (this.aiMessageConsumer != null) {
            this.aiMessageConsumer.accept(aiMessage);
        }
    }
}

