/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.ai.base.chat.client;

import com.geoway.ns.ai.base.RefObject;
import com.geoway.ns.ai.base.chat.AiChatResult;
import com.geoway.ns.ai.base.chat.client.AiChatClient;
import com.geoway.ns.ai.base.chat.message.AIMessageType;
import com.geoway.ns.ai.base.chat.message.AiAssistantMessage;
import com.geoway.ns.ai.base.chat.message.AiMessage;
import com.geoway.ns.ai.base.tool.AiTool;
import com.geoway.ns.ai.base.tool.AiToolContext;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import reactor.core.publisher.Flux;

public abstract class BaseChatClient
implements AiChatClient {
    @Override
    public AiChatResult chat(String userInput, AiToolContext aiToolContext) {
        return this.chat(userInput, null, aiToolContext);
    }

    @Override
    public AiChatResult chat(String userInput, List<AiTool> tools, AiToolContext aiToolContext) {
        ArrayList<AiMessage> messages = new ArrayList<AiMessage>();
        AiMessage message = new AiMessage();
        message.setRole(AIMessageType.User.getDesc());
        message.setContent(userInput);
        messages.add(message);
        return this.chat(messages, tools, aiToolContext);
    }

    @Override
    public abstract AiChatResult chat(List<AiMessage> var1, List<AiTool> var2, AiToolContext var3);

    @Override
    public Flux<AiMessage> chatStream(List<AiMessage> messages) {
        RefObject<StringBuilder> totalText = new RefObject<StringBuilder>(new StringBuilder());
        return this.getStream(messages, totalText);
    }

    @Override
    public void chatStream(List<AiMessage> messages, Consumer<AiMessage> messageConsumer) {
        if (messageConsumer == null) {
            return;
        }
        RefObject<StringBuilder> totalText = new RefObject<StringBuilder>(new StringBuilder());
        RefObject aiMessageRefObject = new RefObject();
        Flux flux = this.getStream(messages, totalText).map(aiMessage -> {
            if (aiMessage.getRole().equalsIgnoreCase(AIMessageType.Reference.getDesc())) {
                aiMessageRefObject.set(aiMessage);
            } else {
                messageConsumer.accept((AiMessage)aiMessage);
            }
            return aiMessage;
        });
        flux.blockLast();
        AiAssistantMessage aiAssistantMessage = new AiAssistantMessage(totalText.get().toString());
        aiAssistantMessage.setIsReturn(false);
        aiAssistantMessage.setIsStore(true);
        messageConsumer.accept(aiAssistantMessage);
        if (aiMessageRefObject.get() != null) {
            messageConsumer.accept((AiMessage)aiMessageRefObject.get());
        }
    }

    protected abstract Flux<AiMessage> getStream(List<AiMessage> var1, RefObject<StringBuilder> var2);
}

