/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.ai.base.tool;

import com.geoway.ns.ai.base.chat.client.AiChatClient;
import com.geoway.ns.ai.base.chat.message.AiMessage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class AiToolContext {
    private final Map<String, Object> context;
    public static final String TOOL_CALL_HISTORY = "TOOL_CALL_HISTORY";
    public static final String TOOL_CALL_CHAT_CLIENT = "TOOL_CALL_CHAT_CLIENT";

    public AiToolContext(Map<String, Object> context) {
        this.context = context;
    }

    public Map<String, Object> getContext() {
        return this.context;
    }

    public List<AiMessage> getToolCallHistory() {
        return (List)this.context.get(TOOL_CALL_HISTORY);
    }

    public String getUserInput() {
        List<AiMessage> messages = this.getToolCallHistory();
        ArrayList<AiMessage> copyMessage = new ArrayList<AiMessage>(messages);
        Collections.reverse(copyMessage);
        AiMessage userMessage = copyMessage.stream().filter(f -> f.getRole().equals("user")).findFirst().orElse(null);
        if (userMessage == null) {
            return "";
        }
        return userMessage.getContent().toString();
    }

    public AiChatClient getLlmChatClient() {
        return (AiChatClient)this.context.get(TOOL_CALL_CHAT_CLIENT);
    }
}

