/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.ai.base.chat.client;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.geoway.ns.ai.base.RefObject;
import com.geoway.ns.ai.base.chat.AiChatResult;
import com.geoway.ns.ai.base.chat.client.AiChatClient;
import com.geoway.ns.ai.base.chat.client.BaseChatClient;
import com.geoway.ns.ai.base.chat.message.AiAssistantMessage;
import com.geoway.ns.ai.base.chat.message.AiMessage;
import com.geoway.ns.ai.base.tool.AiTool;
import com.geoway.ns.ai.base.tool.AiToolContext;
import java.util.List;
import java.util.function.Consumer;
import org.springframework.http.MediaType;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Flux;

public class AnyThingChatClient
extends BaseChatClient
implements AiChatClient {
    private final String url;
    private final String key;
    private final String space;

    public AnyThingChatClient(String url, String key, String space) {
        this.url = url;
        this.key = key;
        this.space = space;
    }

    @Override
    public AiChatResult chat(List<AiMessage> list, List<AiTool> list1, AiToolContext aiToolContext) {
        return null;
    }

    @Override
    public AiChatResult chat(List<AiMessage> list, AiToolContext aiToolContext, List<AiTool> list1, Consumer<AiMessage> consumer) {
        return null;
    }

    @Override
    protected Flux<AiMessage> getStream(List<AiMessage> list, RefObject<StringBuilder> refObject) {
        AiMessage aiMessage = list.get(list.size() - 1);
        String slug = this.createChat(aiMessage);
        WebClient client = WebClient.builder().baseUrl(this.url).defaultHeader("Authorization", new String[]{"Bearer " + this.key}).build();
        JSONObject json = new JSONObject();
        json.put((Object)"message", aiMessage.getContent());
        json.put((Object)"mode", (Object)"chat");
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)client.post().uri("/workspace/" + this.space + "/thread/" + slug + "/stream-chat", new Object[0])).contentType(MediaType.APPLICATION_JSON).accept(new MediaType[]{MediaType.TEXT_EVENT_STREAM})).bodyValue((Object)JSON.toJSONString((Object)json)).retrieve().bodyToFlux(String.class).map(f -> this.convert2AiMessage((String)f, refObject));
    }

    private AiMessage convert2AiMessage(String str, RefObject<StringBuilder> refObject) {
        JSONObject object = JSON.parseObject((String)str);
        String type = object.getString("type");
        if ("textResponseChunk".equals(type)) {
            String text = object.getString("textResponse");
            refObject.get().append(text);
            AiAssistantMessage aiAssistantMessage = new AiAssistantMessage(text);
            aiAssistantMessage.setIsStore(false);
            aiAssistantMessage.setIsReturn(true);
            return aiAssistantMessage;
        }
        AiAssistantMessage aiAssistantMessage = new AiAssistantMessage("");
        aiAssistantMessage.setIsStore(false);
        aiAssistantMessage.setIsReturn(true);
        return aiAssistantMessage;
    }

    private String createChat(AiMessage message) {
        String userId = message.getUserId();
        JSONObject object = new JSONObject();
        object.put((Object)"name", (Object)userId);
        object.put((Object)"slug", (Object)userId);
        String curl = this.url + "/workspace/" + this.space + "/thread/new";
        HttpResponse execute = ((HttpRequest)HttpUtil.createPost((String)curl).header("Authorization", "Bearer " + this.key)).body(object.toJSONString(new JSONWriter.Feature[0])).execute();
        return userId;
    }
}

