/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.ai.base.chat.client;

import cn.hutool.core.io.file.FileNameUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson2.JSON;
import com.geoway.ns.ai.base.RefObject;
import com.geoway.ns.ai.base.application.AIProviderType;
import com.geoway.ns.ai.base.application.AIReference;
import com.geoway.ns.ai.base.chat.AiChatResult;
import com.geoway.ns.ai.base.chat.client.AiChatClient;
import com.geoway.ns.ai.base.chat.client.BaseChatClient;
import com.geoway.ns.ai.base.chat.message.AIReferenceMessage;
import com.geoway.ns.ai.base.chat.message.AiAssistantMessage;
import com.geoway.ns.ai.base.chat.message.AiMessage;
import com.geoway.ns.ai.base.tool.AiTool;
import com.geoway.ns.ai.base.tool.AiToolContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import org.springframework.http.MediaType;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Flux;

public class AtlasClient
extends BaseChatClient
implements AiChatClient {
    private String url;
    private String kk;
    private String appid;
    private String model;
    private String authorization;

    public AtlasClient(String url, String authorization, String model, String appid, String kk) {
        this.url = url;
        this.kk = kk;
        this.appid = appid;
        this.model = model;
        this.authorization = authorization;
    }

    private WebClient createWebClient(String api, String authorization) {
        return WebClient.builder().baseUrl(api).defaultHeader("Authorization", new String[]{"Bearer " + authorization}).build();
    }

    @Override
    public AiChatResult chat(String userInput, AiToolContext aiToolContext) {
        throw new RuntimeException("AtlasClient\u6682\u672a\u5b9e\u73b0");
    }

    @Override
    public AiChatResult chat(String userInput, List<AiTool> tools, AiToolContext aiToolContext) {
        throw new RuntimeException("AtlasClient\u6682\u672a\u5b9e\u73b0");
    }

    @Override
    public AiChatResult chat(List<AiMessage> messages, List<AiTool> tools, AiToolContext aiToolContext) {
        throw new RuntimeException("AtlasClient\u6682\u672a\u5b9e\u73b0");
    }

    @Override
    public AiChatResult chat(List<AiMessage> messages, AiToolContext aiToolContext, List<AiTool> tools, Consumer<AiMessage> messageConsumer) {
        throw new RuntimeException("AtlasClient\u6682\u672a\u5b9e\u73b0");
    }

    @Override
    protected Flux<AiMessage> getStream(List<AiMessage> messages, RefObject<StringBuilder> totalText) {
        String chatId = Long.toString(System.currentTimeMillis());
        if (messages.size() > 0 && StrUtil.isNotBlank((CharSequence)messages.get(0).getChatId())) {
            chatId = messages.get(0).getChatId();
        }
        WebClient client = this.createWebClient(this.url, this.authorization);
        com.alibaba.fastjson2.JSONObject json = new com.alibaba.fastjson2.JSONObject();
        json.put((Object)"llm_instance_id", (Object)this.getModelId(this.url, this.authorization, this.appid));
        json.put((Object)"timestamp", (Object)System.currentTimeMillis());
        json.put((Object)"show_think", (Object)false);
        json.put((Object)"content", messages.get(messages.size() - 1).getContent());
        ArrayList<String> kkids = new ArrayList<String>();
        kkids.add(this.kk);
        json.put((Object)"kb_ids", kkids);
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)client.post().uri(String.format("/app/%s/chats/%s", this.appid, chatId), new Object[0])).contentType(MediaType.APPLICATION_JSON).accept(new MediaType[]{MediaType.TEXT_EVENT_STREAM})).bodyValue((Object)JSON.toJSONString((Object)json)).retrieve().bodyToFlux(String.class).map(str -> this.convert2AiMessage((String)str, totalText));
    }

    private AiMessage convert2AiMessage(String str, RefObject<StringBuilder> refObject) {
        long start = System.currentTimeMillis();
        JSONObject srcJsonObject = JSONObject.parseObject((String)str);
        if (!srcJsonObject.containsKey((Object)"data")) {
            System.out.println("\u8f6c\u6362\u65f6\u95f4\uff1a" + (System.currentTimeMillis() - start));
            AiAssistantMessage aiAssistantMessage = new AiAssistantMessage("");
            aiAssistantMessage.setIsStore(false);
            return aiAssistantMessage;
        }
        JSONObject srcDataJsonObject = srcJsonObject.getJSONObject("data");
        if (!srcDataJsonObject.containsKey((Object)"output")) {
            System.out.println("\u8f6c\u6362\u65f6\u95f4\uff1a" + (System.currentTimeMillis() - start));
            AiAssistantMessage aiAssistantMessage = new AiAssistantMessage("");
            aiAssistantMessage.setIsStore(false);
            return aiAssistantMessage;
        }
        JSONObject outputDataJsonObject = srcDataJsonObject.getJSONObject("output");
        String mttype = outputDataJsonObject.getString("mtype");
        if (StrUtil.isBlank((CharSequence)mttype)) {
            System.out.println("\u8f6c\u6362\u65f6\u95f4\uff1a" + (System.currentTimeMillis() - start));
            AiAssistantMessage aiAssistantMessage = new AiAssistantMessage("");
            aiAssistantMessage.setIsStore(false);
            return aiAssistantMessage;
        }
        if (mttype.equals("text")) {
            String text = outputDataJsonObject.getString("content");
            refObject.get().append(text);
            AiAssistantMessage aiAssistantMessage = new AiAssistantMessage(text);
            aiAssistantMessage.setIsStore(false);
            return aiAssistantMessage;
        }
        if (mttype.equals("reference")) {
            JSONObject referenceJsonObject = JSONObject.parseObject((String)outputDataJsonObject.getString("content"));
            JSONArray srcResultDocArray = referenceJsonObject.getJSONArray("result_docs");
            ArrayList<AIReference> aiReferences = new ArrayList<AIReference>();
            for (int i = 0; i < srcResultDocArray.size(); ++i) {
                JSONObject srcResultDoc = srcResultDocArray.getJSONObject(i);
                AIReference tarResultDoc = new AIReference();
                tarResultDoc.setTitle(srcResultDoc.getString("doc_name"));
                tarResultDoc.setAuthor("");
                tarResultDoc.setFileId(srcResultDoc.getString("file_id"));
                tarResultDoc.getFile_meta().setType(FileNameUtil.getSuffix((String)srcResultDoc.getString("doc_name")));
                tarResultDoc.setProvider(AIProviderType.ATLAS.getDesc());
                tarResultDoc.setType(tarResultDoc.getFile_meta().getType());
                tarResultDoc.setUrl("");
                aiReferences.add(tarResultDoc);
            }
            return new AIReferenceMessage(aiReferences);
        }
        System.out.println("\u8f6c\u6362\u65f6\u95f4\uff1a" + (System.currentTimeMillis() - start));
        AiAssistantMessage aiAssistantMessage = new AiAssistantMessage("");
        aiAssistantMessage.setIsStore(false);
        return aiAssistantMessage;
    }

    private String getModelId(String api, String authorization, String appId) {
        String modelName = this.model;
        String url = String.format(api + "/app/%s/llms", appId);
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Authorization", "Bearer " + authorization);
        String result = ((HttpRequest)HttpRequest.get((String)url).header("Authorization", "Bearer " + authorization)).execute().body();
        JSONObject jsonObject = JSONObject.parseObject((String)result);
        JSONArray jsonArray = jsonObject.getJSONArray("data");
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject temp = jsonArray.getJSONObject(i);
            if (!temp.getString("name").equalsIgnoreCase(modelName)) continue;
            return temp.getString("id");
        }
        throw new RuntimeException("\u6a21\u578b\u4e0d\u5b58\u5728\uff1a" + modelName);
    }
}

