/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.ai.base.tool.gateway;

import cn.hutool.extra.template.Template;
import cn.hutool.extra.template.TemplateConfig;
import cn.hutool.extra.template.TemplateUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import cn.hutool.http.Method;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.geoway.ns.ai.base.chat.message.AiAssistantMessage;
import com.geoway.ns.ai.base.chat.message.AiMessage;
import com.geoway.ns.ai.base.gateway.AiGatewayDefinition;
import com.geoway.ns.ai.base.gateway.AiGatewayRenderTemplate;
import com.geoway.ns.ai.base.gateway.AiGatewayRequestTemplate;
import com.geoway.ns.ai.base.render.AiRenderTemplate;
import com.geoway.ns.ai.base.render.AiRenderTemplateUtil;
import com.geoway.ns.ai.base.tool.AiTool;
import com.geoway.ns.ai.base.tool.AiToolContext;
import com.geoway.ns.ai.base.tool.AiToolDefinition;
import com.geoway.ns.ai.base.tool.AiToolResult;
import com.geoway.ns.ai.base.tool.gateway.AiGatewayToolCallResult;
import com.geoway.ns.ai.base.tool.gateway.AiGatewayToolDefinition;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;

public class AiGatewayTool
implements AiTool {
    private AiGatewayDefinition gatewayDefinition;
    private Map<String, String> headerMap;

    public AiGatewayTool(AiGatewayDefinition aiGatewayDefinition, Map<String, String> headerMap) {
        this.gatewayDefinition = aiGatewayDefinition;
        this.headerMap = headerMap;
    }

    @Override
    public AiToolDefinition getToolDefinition() {
        return new AiGatewayToolDefinition(this.gatewayDefinition);
    }

    @Override
    public AiToolResult call(String toolInput, AiToolContext aiToolContext, Consumer<AiMessage> aiMessageConsumer) {
        int disableDecimalFeature = JSON.DEFAULT_PARSER_FEATURE & ~Feature.UseBigDecimal.getMask();
        Map requestParams = (Map)JSON.parseObject((String)toolInput, Map.class, (int)disableDecimalFeature, (Feature[])new Feature[0]);
        String requestTempateStr = JSONUtil.toJsonStr((Object)this.gatewayDefinition.getRequestTemplate());
        Template requestTempate = TemplateUtil.createEngine((TemplateConfig)new TemplateConfig()).getTemplate(requestTempateStr);
        requestTempateStr = requestTempate.render(requestParams);
        AiGatewayRequestTemplate gatewayRequestTemplate = (AiGatewayRequestTemplate)JSONUtil.toBean((String)requestTempateStr, AiGatewayRequestTemplate.class);
        gatewayRequestTemplate.getHeader().putAll(this.headerMap);
        Method method = gatewayRequestTemplate.getMethod().equalsIgnoreCase("post") ? Method.POST : Method.GET;
        HttpRequest httpRequest = HttpUtil.createRequest((Method)method, (String)gatewayRequestTemplate.getUrl());
        httpRequest = (HttpRequest)httpRequest.addHeaders(gatewayRequestTemplate.getHeader());
        if (gatewayRequestTemplate.getQuery() != null) {
            httpRequest = httpRequest.form(gatewayRequestTemplate.getQuery());
        }
        if (gatewayRequestTemplate.getBody() != null && gatewayRequestTemplate.getBody().size() > 0) {
            httpRequest = httpRequest.body(JSONUtil.toJsonStr((Object)gatewayRequestTemplate.getBody()));
        }
        String resultStr = httpRequest.execute().body();
        Map resultMap = (Map)JSON.parseObject((String)resultStr, Map.class, (int)disableDecimalFeature, (Feature[])new Feature[0]);
        for (AiGatewayRenderTemplate template : this.gatewayDefinition.getRenderTemplate()) {
            String messageId = UUID.randomUUID().toString();
            AiRenderTemplate aiRenderTemplate = AiRenderTemplateUtil.getTemplate(template.getType(), template.getConfig());
            resultMap.put("messageId", messageId);
            String renderResult = aiRenderTemplate.render(resultMap) + "\r\n";
            AiAssistantMessage aiMessage = new AiAssistantMessage(renderResult);
            aiMessage.setIsReturn(true);
            aiMessage.setIsStore(true);
            aiMessage.setMessageId(messageId);
            if (aiMessageConsumer == null) continue;
            aiMessageConsumer.accept(aiMessage);
        }
        AiGatewayToolCallResult aiToolCallResult = new AiGatewayToolCallResult(this.gatewayDefinition.getRequestDefinition().getName());
        aiToolCallResult.setData(resultStr);
        AiToolResult aiToolResult = new AiToolResult(resultStr, aiToolCallResult);
        aiToolResult.setReturn(false);
        aiToolResult.setStore(false);
        return aiToolResult;
    }
}

