/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.ai.base.tool.http;

import com.geoway.ns.ai.base.HttpUtils;
import com.geoway.ns.ai.base.controller.RestResult;
import com.geoway.ns.ai.base.tool.AiToolDefinition;
import com.geoway.ns.ai.base.tool.http.AiHttpToolDefinitionResponse;
import java.io.Serializable;
import java.util.Map;

public class AiHttpToolDefinitionRequest
implements AiToolDefinition,
Serializable {
    private String host;
    private String classname;
    private AiHttpToolDefinitionResponse response;

    public AiHttpToolDefinitionRequest(String host, String classname, Map<String, String> headerMap) {
        this.host = host;
        this.classname = classname;
        String url = host + "/ai/tool/metadata?classname=" + classname;
        RestResult<AiHttpToolDefinitionResponse> restResult = HttpUtils.getHttp(url, null, headerMap, AiHttpToolDefinitionResponse.class);
        this.response = restResult.getData();
    }

    @Override
    public String name() {
        return this.response.name();
    }

    @Override
    public String description() {
        return this.response.description();
    }

    @Override
    public String inputSchema() {
        return this.response.inputSchema();
    }

    public String getHost() {
        return this.host;
    }

    public String getClassname() {
        return this.classname;
    }

    public AiHttpToolDefinitionResponse getResponse() {
        return this.response;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setClassname(String classname) {
        this.classname = classname;
    }

    public void setResponse(AiHttpToolDefinitionResponse response) {
        this.response = response;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AiHttpToolDefinitionRequest)) {
            return false;
        }
        AiHttpToolDefinitionRequest other = (AiHttpToolDefinitionRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$classname = this.getClassname();
        String other$classname = other.getClassname();
        if (this$classname == null ? other$classname != null : !this$classname.equals(other$classname)) {
            return false;
        }
        AiHttpToolDefinitionResponse this$response = this.getResponse();
        AiHttpToolDefinitionResponse other$response = other.getResponse();
        return !(this$response == null ? other$response != null : !((Object)this$response).equals(other$response));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AiHttpToolDefinitionRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $classname = this.getClassname();
        result = result * 59 + ($classname == null ? 43 : $classname.hashCode());
        AiHttpToolDefinitionResponse $response = this.getResponse();
        result = result * 59 + ($response == null ? 43 : ((Object)$response).hashCode());
        return result;
    }

    public String toString() {
        return "AiHttpToolDefinitionRequest(host=" + this.getHost() + ", classname=" + this.getClassname() + ", response=" + this.getResponse() + ")";
    }
}

