/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.ai.base.chat.client;

import cn.hutool.core.exceptions.ExceptionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSONArray;
import com.geoway.ns.ai.base.RefObject;
import com.geoway.ns.ai.base.chat.AiChatRequest;
import com.geoway.ns.ai.base.chat.AiChatResponse;
import com.geoway.ns.ai.base.chat.AiChatResult;
import com.geoway.ns.ai.base.chat.AiChatToolCall;
import com.geoway.ns.ai.base.chat.client.BaseChatClient;
import com.geoway.ns.ai.base.chat.dto.AiChatLogDTO;
import com.geoway.ns.ai.base.chat.message.AIMessageType;
import com.geoway.ns.ai.base.chat.message.AiAssistantMessage;
import com.geoway.ns.ai.base.chat.message.AiMessage;
import com.geoway.ns.ai.base.chat.message.AiToolMessage;
import com.geoway.ns.ai.base.tool.AiTool;
import com.geoway.ns.ai.base.tool.AiToolContext;
import com.geoway.ns.ai.base.tool.AiToolResult;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.springframework.http.MediaType;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Flux;

public class OpenAIClient
extends BaseChatClient {
    private final String model;
    private final String url;
    private final String key;

    public OpenAIClient(String url, String key, String model) {
        this.url = url;
        this.key = key;
        this.model = model;
    }

    private static void handleAiChatResponse(AiChatResponse chatResponse) {
        if (chatResponse == null || chatResponse.getChoices() == null || chatResponse.getChoices().size() == 0 || chatResponse.getChoices().get(0).getMessage().getContent() == null) {
            return;
        }
        if (chatResponse.getChoices().get(0).getMessage().getContent().toString().startsWith("<tool_call>")) {
            String toolCallStr = OpenAIClient.removeToolCll(chatResponse.getChoices().get(0).getMessage().getContent().toString());
            AiChatToolCall.AiFunction function = (AiChatToolCall.AiFunction)JSONUtil.toBean((String)toolCallStr, AiChatToolCall.AiFunction.class);
            AiChatToolCall toolCall = new AiChatToolCall();
            toolCall.setId(UUID.randomUUID().toString());
            toolCall.setType("");
            toolCall.setFunction(function);
            chatResponse.getChoices().get(0).getMessage().setTool_calls(Collections.singletonList(toolCall));
        }
    }

    private static String removeToolCll(String str) {
        str = str.replace("<tool_call>", "");
        str = str.replace("</tool_call>", "");
        return str;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public AiToolResult excuteTool(List<AiMessage> messages, AiToolContext aiToolContext, AiTool tool, Consumer<AiMessage> messageConsumer) {
        OkHttpClient client = new OkHttpClient.Builder().readTimeout(3000L, TimeUnit.SECONDS).connectTimeout(1000L, TimeUnit.SECONDS).writeTimeout(1000L, TimeUnit.SECONDS).build();
        AiChatRequest request = new AiChatRequest();
        request.setMessages(messages);
        String inputSchema = tool.getToolDefinition().inputSchema();
        JSONObject jsonObject = JSONUtil.parseObj((String)inputSchema);
        ArrayList<Object> objects = new ArrayList<Object>();
        objects.add(jsonObject);
        request.setTools(objects);
        request.setModel(this.model);
        request.setTool_choice("auto");
        request.getChat_template_kwargs().put("enable_thinking", false);
        request.getExtra_body().put("enable_thinking", false);
        RequestBody body = RequestBody.create((okhttp3.MediaType)okhttp3.MediaType.parse((String)"application/json"), (String)JSONUtil.toJsonStr((Object)request));
        String requestStr = JSONUtil.toJsonStr((Object)request);
        AiChatLogDTO aiChatLogDTO = new AiChatLogDTO();
        aiChatLogDTO.setQuestion(requestStr);
        Request httpRequest = new Request.Builder().url(this.url).post(body).addHeader("Authorization", "Bearer " + this.key).build();
        long start = System.currentTimeMillis();
        try (Response response = client.newCall(httpRequest).execute();){
            String res = response.body().string();
            long chatCost = (System.currentTimeMillis() - start) / 1000L;
            aiChatLogDTO.setChatCost(chatCost);
            aiChatLogDTO.setAnswer(res);
            AiChatResponse chatResponse = (AiChatResponse)JSONUtil.toBean((String)res, AiChatResponse.class);
            OpenAIClient.handleAiChatResponse(chatResponse);
            if (chatResponse.getChoices().get(0).getMessage().getTool_calls() != null && chatResponse.getChoices().get(0).getMessage().getTool_calls().size() > 0) {
                AiChatToolCall toolCall = chatResponse.getChoices().get(0).getMessage().getTool_calls().get(0);
                aiChatLogDTO.setToolName(toolCall.getFunction().getName());
                aiChatLogDTO.setToolParams(toolCall.getFunction().getArguments());
                AiToolResult toolResult = this.excuteTool(Collections.singletonList(tool), toolCall, aiToolContext, messageConsumer);
                long toolCost = (System.currentTimeMillis() - start) / 1000L;
                aiChatLogDTO.setToolCost(toolCost);
                if (toolResult != null) {
                    aiChatLogDTO.setToolResult(JSONUtil.toJsonStr((Object)toolResult));
                    System.out.println("\u8c03\u7528\u5de5\u5177\uff1a" + toolCall.getFunction().getName() + ",\u8fd4\u56de\u7ed3\u679c\uff1a" + toolResult.getModelResult());
                    AiAssistantMessage assistantMessage = new AiAssistantMessage(null);
                    assistantMessage.setRole(AIMessageType.Assistant.getDesc());
                    assistantMessage.setTool_calls(Collections.singletonList(toolCall));
                    AiToolMessage toolMessage = new AiToolMessage(toolResult.getCallResult(), toolResult.getModelResult());
                    toolMessage.setTool_call_id(toolCall.getId());
                    if (messageConsumer != null && toolResult.getReturn().booleanValue()) {
                        messageConsumer.accept(toolMessage);
                    }
                }
                this.logInvoke(aiChatLogDTO);
                AiToolResult aiToolResult = toolResult;
                return aiToolResult;
            }
            this.logInvoke(aiChatLogDTO);
            AiToolResult aiToolResult = null;
            return aiToolResult;
        }
        catch (Exception exception) {
            long toolCost = (System.currentTimeMillis() - start) / 1000L;
            aiChatLogDTO.setToolCost(toolCost);
            String message = ExceptionUtil.getSimpleMessage((Throwable)exception);
            String stacktrace = ExceptionUtil.stacktraceToString((Throwable)exception);
            aiChatLogDTO.setErrorMsg(message + ":" + stacktrace);
            this.logInvoke(aiChatLogDTO);
            throw new RuntimeException(exception);
        }
    }

    private void askDeepSeek(List<AiMessage> messages, List<AiTool> tools, List<AiToolResult> toolResults, AiToolContext toolContent, RefObject<AiChatResponse> refObject, Consumer<AiMessage> messageConsumer) throws IOException {
        block25: {
            OkHttpClient client = new OkHttpClient.Builder().readTimeout(3000L, TimeUnit.SECONDS).connectTimeout(1000L, TimeUnit.SECONDS).writeTimeout(1000L, TimeUnit.SECONDS).build();
            AiChatRequest request = new AiChatRequest();
            List clone = (List)ObjectUtil.clone(messages);
            clone.forEach(f -> {
                if (f.getTool_call_result() != null) {
                    f.setTool_call_result(f.getContent());
                }
            });
            request.setMessages(clone);
            long start = System.currentTimeMillis();
            if (tools != null) {
                request.setTools(new ArrayList<Object>());
                tools.forEach(tool -> {
                    String inputSchema = tool.getToolDefinition().inputSchema();
                    JSONObject jsonObject = JSONUtil.parseObj((String)inputSchema);
                    request.getTools().add(jsonObject);
                });
            }
            request.setModel(this.model);
            if (tools != null && tools.size() > 0) {
                request.setTool_choice("auto");
            } else {
                request.setTool_choice(null);
            }
            String requestStr = JSONUtil.toJsonStr((Object)request);
            request.getChat_template_kwargs().put("enable_thinking", false);
            request.getExtra_body().put("enable_thinking", false);
            RequestBody body = RequestBody.create((okhttp3.MediaType)okhttp3.MediaType.parse((String)"application/json"), (String)JSONUtil.toJsonStr((Object)request));
            AiChatLogDTO aiChatLogDTO = new AiChatLogDTO();
            aiChatLogDTO.setQuestion(requestStr);
            Request httpRequest = new Request.Builder().url(this.url).post(body).addHeader("Authorization", "Bearer " + this.key).build();
            try (Response response = client.newCall(httpRequest).execute();){
                String res = response.body().string();
                long chatCost = (System.currentTimeMillis() - start) / 1000L;
                aiChatLogDTO.setChatCost(chatCost);
                aiChatLogDTO.setAnswer(res);
                start = System.currentTimeMillis();
                AiChatResponse chatResponse = (AiChatResponse)JSONUtil.toBean((String)res, AiChatResponse.class);
                OpenAIClient.handleAiChatResponse(chatResponse);
                refObject.set(chatResponse);
                if (chatResponse.getChoices().get(0).getMessage().getTool_calls() != null && chatResponse.getChoices().get(0).getMessage().getTool_calls().size() > 0) {
                    for (AiChatToolCall toolCall : chatResponse.getChoices().get(0).getMessage().getTool_calls()) {
                        aiChatLogDTO.setToolName(toolCall.getFunction().getName());
                        aiChatLogDTO.setToolParams(toolCall.getFunction().getArguments());
                        AiToolResult toolResult = this.excuteTool(tools, toolCall, toolContent, messageConsumer);
                        long toolCost = (System.currentTimeMillis() - start) / 1000L;
                        aiChatLogDTO.setToolCost(toolCost);
                        if (toolResult == null) {
                            toolResult = new AiToolResult("\u65e0\u6267\u884c\u7ed3\u679c");
                        }
                        aiChatLogDTO.setToolResult(JSONUtil.toJsonStr((Object)toolResult));
                        this.logInvoke(aiChatLogDTO);
                        toolResults.add(toolResult);
                        AiAssistantMessage assistantMessage = new AiAssistantMessage(null);
                        assistantMessage.setRole(AIMessageType.Assistant.getDesc());
                        assistantMessage.setTool_calls(Collections.singletonList(toolCall));
                        AiToolMessage toolMessage = new AiToolMessage(toolResult.getCallResult(), toolResult.getModelResult());
                        toolMessage.setTool_call_id(toolCall.getId());
                        if (messageConsumer != null && toolResult.getReturn().booleanValue()) {
                            messageConsumer.accept(toolMessage);
                        }
                        messages.add(assistantMessage);
                        messages.add(toolMessage);
                        if (toolResult.getToolParam() == null || !toolResult.getToolParam().is_final_tool()) continue;
                        return;
                    }
                    this.askDeepSeek(messages, tools, toolResults, toolContent, refObject, messageConsumer);
                    break block25;
                }
                this.logInvoke(aiChatLogDTO);
                AiMessage assistantMessage = new AiMessage();
                assistantMessage.setRole(AIMessageType.Assistant.getDesc());
                assistantMessage.setContent(chatResponse.getChoices().get(0).getMessage().getContent());
                if (messageConsumer != null && toolResults.size() == 0) {
                    messageConsumer.accept(assistantMessage);
                }
            }
            catch (Exception exception) {
                long toolCost = (System.currentTimeMillis() - start) / 1000L;
                aiChatLogDTO.setToolCost(toolCost);
                String message = ExceptionUtil.getSimpleMessage((Throwable)exception);
                String stacktrace = ExceptionUtil.stacktraceToString((Throwable)exception);
                aiChatLogDTO.setErrorMsg(message + ":" + stacktrace);
                this.logInvoke(aiChatLogDTO);
                throw new RuntimeException(exception);
            }
        }
    }

    private AiToolResult excuteTool(List<AiTool> tools, AiChatToolCall toolCall, AiToolContext toolContext, Consumer<AiMessage> messageConsumer) {
        AiTool aiToolCallback = tools.stream().filter(f -> f.getToolDefinition().name().equals(toolCall.getFunction().getName())).findAny().orElse(null);
        if (aiToolCallback == null) {
            throw new RuntimeException("\u672a\u627e\u5230\u5de5\u5177\uff1a" + toolCall.getFunction().getName());
        }
        try {
            AiToolResult aiToolResult = aiToolCallback.call(toolCall.getFunction().getArguments(), toolContext, messageConsumer);
            return aiToolResult;
        }
        catch (Exception exception) {
            throw new RuntimeException(String.format("\u6267\u884c\u5de5\u5177\u3010%s\u3011\u5f02\u5e38", toolCall.getFunction().getName()), exception);
        }
    }

    @Override
    public AiChatResult chat(List<AiMessage> messages, List<AiTool> tools, AiToolContext aiToolContext) {
        return this.chat(messages, aiToolContext, tools, null);
    }

    @Override
    public AiChatResult chat(List<AiMessage> messages, AiToolContext aiToolContext, List<AiTool> tools, Consumer<AiMessage> messageConsumer) {
        try {
            ArrayList<AiMessage> copyMessage = new ArrayList<AiMessage>(messages);
            RefObject<AiChatResponse> chatResponse = new RefObject<AiChatResponse>();
            ArrayList<AiToolResult> toolResults = new ArrayList<AiToolResult>();
            if (aiToolContext == null) {
                aiToolContext = new AiToolContext();
                aiToolContext.setChatClient(this);
                aiToolContext.put("TOOL_CALL_HISTORY", copyMessage);
            } else {
                aiToolContext.put("TOOL_CALL_HISTORY", copyMessage);
                aiToolContext.setChatClient(this);
            }
            this.askDeepSeek(copyMessage, tools, toolResults, aiToolContext, chatResponse, messageConsumer);
            AiChatResult chatResult = new AiChatResult();
            Object chatContent = chatResponse.get().getChoices().get(0).getMessage().getContent();
            chatResult.setContent(chatContent == null ? "" : chatContent.toString());
            return chatResult;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    protected Flux<AiMessage> getStream(List<AiMessage> messages, RefObject<StringBuilder> totalText) {
        AiChatRequest request = new AiChatRequest();
        request.setMessages(messages);
        request.setModel(this.model);
        request.getExtra_body().put("enable_thinking", false);
        request.getChat_template_kwargs().put("enable_thinking", false);
        request.setStream(true);
        String json = JSONUtil.toJsonStr((Object)request);
        WebClient webClient = WebClient.builder().defaultHeader("Authorization", new String[]{"Bearer " + this.key}).build();
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)webClient.post().uri(this.url, new Object[0])).contentType(MediaType.APPLICATION_JSON).accept(new MediaType[]{MediaType.TEXT_EVENT_STREAM})).bodyValue((Object)JSONUtil.toJsonStr((Object)request)).retrieve().bodyToFlux(String.class).map(str -> {
            try {
                if (str.equalsIgnoreCase("[DONE]")) {
                    AiAssistantMessage aiAssistantMessage = new AiAssistantMessage("");
                    aiAssistantMessage.setIsReturn(true);
                    aiAssistantMessage.setIsStore(false);
                    return aiAssistantMessage;
                }
                com.alibaba.fastjson.JSONObject srcJsonObject = com.alibaba.fastjson.JSONObject.parseObject((String)str);
                JSONArray choiceJsonArray = srcJsonObject.getJSONArray("choices");
                com.alibaba.fastjson.JSONObject choiceJsonObject = choiceJsonArray.getJSONObject(0);
                if (!choiceJsonObject.containsKey((Object)"delta")) {
                    AiAssistantMessage aiAssistantMessage = new AiAssistantMessage("");
                    aiAssistantMessage.setIsReturn(true);
                    aiAssistantMessage.setIsStore(false);
                    return aiAssistantMessage;
                }
                com.alibaba.fastjson.JSONObject deltaObject = choiceJsonObject.getJSONObject("delta");
                String content = deltaObject.getOrDefault((Object)"content", (Object)"").toString();
                ((StringBuilder)totalText.get()).append(content);
                AiAssistantMessage aiAssistantMessage = new AiAssistantMessage(content);
                aiAssistantMessage.setIsReturn(true);
                aiAssistantMessage.setIsStore(false);
                return aiAssistantMessage;
            }
            catch (Exception E) {
                throw new RuntimeException(E);
            }
        });
    }
}

