/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.ai.chat.util;

import cn.hutool.core.util.StrUtil;
import com.geoway.ns.ai.base.application.AIApplication;
import com.geoway.ns.ai.base.application.AIChatModel;
import com.geoway.ns.ai.base.application.AIKnowledge;
import com.geoway.ns.ai.base.application.AIProviderType;
import com.geoway.ns.ai.base.application.AiApplicationProvider;
import com.geoway.ns.ai.base.chat.client.AiChatClient;
import com.geoway.ns.ai.base.chat.client.AtlasClient;
import com.geoway.ns.ai.base.chat.client.MetasoChatClient;
import com.geoway.ns.ai.base.chat.client.OpenAIClient;
import com.geoway.ns.ai.chat.dto.AiChatDTO;
import com.geoway.ns.ai.chat.util.AiSpringUtil;

public class AiChatClientUtil {
    public static AiChatClient getChatClient(AiChatDTO aiChatDTO) {
        AiApplicationProvider aiApplicationProvider = AiSpringUtil.getBean(AiApplicationProvider.class);
        AIApplication aiApplication = aiApplicationProvider.getApplication().stream().filter(f -> f.getName().equalsIgnoreCase(aiChatDTO.getTopic())).findFirst().orElse(null);
        AIChatModel aiChatModel = (AIChatModel)aiApplication.getModels().get(0);
        AIKnowledge aiKnowledge = null;
        if (StrUtil.isNotBlank((CharSequence)aiChatDTO.getChatModel())) {
            aiChatModel = aiApplication.getModels().stream().filter(f -> f.getName().equalsIgnoreCase(aiChatDTO.getChatModel())).findFirst().orElse(aiChatModel);
        }
        if (StrUtil.isBlank((CharSequence)aiChatDTO.getKnowledgeName())) {
            String url = aiChatModel.getUrl() + "/v1/chat/completions";
            return new OpenAIClient(url, aiChatModel.getKey(), aiChatModel.getName());
        }
        if (aiChatModel.getProvider().equalsIgnoreCase(AIProviderType.ATLAS.getDesc())) {
            aiKnowledge = (AIKnowledge)aiApplication.getKnowledges().get(0);
            aiKnowledge = aiApplication.getKnowledges().stream().filter(f -> f.getName().equalsIgnoreCase(aiChatDTO.getKnowledgeName())).findAny().orElse(aiKnowledge);
            AtlasClient atlasClient = new AtlasClient(aiChatModel.getUrl(), aiChatModel.getKey(), aiChatModel.getName(), aiChatModel.getAppId(), aiKnowledge.getId());
            return atlasClient;
        }
        aiKnowledge = (AIKnowledge)aiApplication.getKnowledges().get(0);
        aiKnowledge = aiApplication.getKnowledges().stream().filter(f -> f.getName().equalsIgnoreCase(aiChatDTO.getKnowledgeName())).findAny().orElse(aiKnowledge);
        MetasoChatClient metasoChatClient = new MetasoChatClient(aiChatModel.getUrl(), aiKnowledge.getId(), aiKnowledge.getSceneId());
        return metasoChatClient;
    }
}

