/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.ai.chat.util;

import com.geoway.ns.ai.base.application.AIApplication;
import com.geoway.ns.ai.base.application.AIChatTool;
import com.geoway.ns.ai.base.application.AiApplicationProvider;
import com.geoway.ns.ai.base.tool.AiTool;
import com.geoway.ns.ai.chat.dto.AiChatDTO;
import com.geoway.ns.ai.chat.util.AiSpringUtil;
import java.util.ArrayList;
import java.util.List;

public class AiChatToolUtil {
    public static List<AiTool> getAiTools(AiChatDTO aiChatDTO) {
        try {
            AiApplicationProvider aiApplicationProvider = AiSpringUtil.getBean(AiApplicationProvider.class);
            AIApplication aiApplication = aiApplicationProvider.getApplication().stream().filter(f -> f.getName().equalsIgnoreCase(aiChatDTO.getTopic())).findFirst().orElse(null);
            if (aiApplication.getTools() == null || aiApplication.getTools().size() == 0) {
                return new ArrayList<AiTool>();
            }
            ArrayList<AiTool> result = new ArrayList<AiTool>();
            for (AIChatTool aiChatTool : aiApplication.getTools()) {
                Class<?> clazz = Class.forName(aiChatTool.getClassname());
                AiTool aiTool = (AiTool)clazz.newInstance();
                result.add(aiTool);
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

