/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.ai.chat.util;

import cn.hutool.core.util.StrUtil;
import com.geoway.ns.ai.base.application.AIApplication;
import com.geoway.ns.ai.base.application.AIChatModel;
import com.geoway.ns.ai.base.application.AIKnowledge;
import com.geoway.ns.ai.base.application.AiApplicationProvider;
import com.geoway.ns.ai.chat.dto.AiChatDTO;
import com.geoway.ns.ai.chat.util.AiSpringUtil;

public class AIApplicationUtil {
    public static AIChatModel getChatModel(AiChatDTO aiChatDTO) {
        AIApplication aiApplication = AIApplicationUtil.getAIApplication(aiChatDTO);
        AIChatModel aiChatModel = (AIChatModel)aiApplication.getModels().get(0);
        if (StrUtil.isNotBlank((CharSequence)aiChatDTO.getChatModel())) {
            aiChatModel = aiApplication.getModels().stream().filter(f -> f.getName().equalsIgnoreCase(aiChatDTO.getChatModel())).findFirst().orElse(aiChatModel);
        }
        return aiChatModel;
    }

    public static AIApplication getAIApplication(AiChatDTO aiChatDTO) {
        AiApplicationProvider aiApplicationProvider = AiSpringUtil.getBean(AiApplicationProvider.class);
        AIApplication aiApplication = aiApplicationProvider.getApplication().stream().filter(f -> f.getName().equalsIgnoreCase(aiChatDTO.getTopic())).findFirst().orElse(null);
        return aiApplication;
    }

    public static AIKnowledge getAIKnowledge(AiChatDTO aiChatDTO) {
        AIApplication aiApplication = AIApplicationUtil.getAIApplication(aiChatDTO);
        AIKnowledge aiKnowledge = (AIKnowledge)aiApplication.getKnowledges().get(0);
        aiKnowledge = aiApplication.getKnowledges().stream().filter(f -> f.getName().equalsIgnoreCase(aiChatDTO.getKnowledgeName())).findAny().orElse(aiKnowledge);
        return aiKnowledge;
    }
}

