/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.ai.chat.util;

import cn.hutool.core.util.StrUtil;
import com.geoway.ns.ai.base.application.AIChatModel;
import com.geoway.ns.ai.base.application.AIProviderType;
import com.geoway.ns.ai.base.chat.client.AiChatClient;
import com.geoway.ns.ai.chat.dto.AiChatDTO;
import com.geoway.ns.ai.chat.factory.AiChatClientFactory;
import com.geoway.ns.ai.chat.factory.AtlasAiChatClientFactory;
import com.geoway.ns.ai.chat.factory.MetasoAiChatClientFactory;
import com.geoway.ns.ai.chat.factory.OpenAiChatClientFactory;
import com.geoway.ns.ai.chat.util.AIApplicationUtil;

public class AiChatClientUtil {
    public static AiChatClient getChatClient(AiChatDTO aiChatDTO) {
        AIChatModel aiChatModel = AIApplicationUtil.getChatModel(aiChatDTO);
        AIProviderType aiProviderType = AIProviderType.getEnumByValue((String)aiChatModel.getProvider());
        AiChatClientFactory factory = null;
        switch (aiProviderType) {
            case OpenAi: {
                factory = new OpenAiChatClientFactory();
                break;
            }
            case METASO: {
                factory = new MetasoAiChatClientFactory();
                break;
            }
            case ATLAS: {
                factory = new AtlasAiChatClientFactory();
                break;
            }
            case Other: {
                if (StrUtil.isBlank((CharSequence)aiChatModel.getFactoryClassName())) {
                    throw new RuntimeException(String.format("\u5927\u6a21\u578b\u3010%s\u3011\u672a\u5b9a\u4e49\u5b9e\u73b0\u7c7b\uff0c\u8bf7\u6838\u67e5", aiChatModel.getName()));
                }
                try {
                    Class<?> clazz = Class.forName(aiChatModel.getFactoryClassName());
                    factory = (AiChatClientFactory)clazz.newInstance();
                    break;
                }
                catch (Exception e) {
                    throw new RuntimeException(String.format("\u5927\u6a21\u578b\u3010%s\u3011\u521d\u59cb\u5316\u6709\u8bef\uff0c\u8bf7\u6838\u67e5", aiChatModel.getName()));
                }
            }
        }
        return factory.getChatClient(aiChatDTO);
    }
}

