/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.ai.chat.util;

import com.geoway.ns.ai.base.application.AIApplication;
import com.geoway.ns.ai.base.application.AIChatTool;
import com.geoway.ns.ai.base.application.AiApplicationProvider;
import com.geoway.ns.ai.base.chat.dto.AiChatDTO;
import com.geoway.ns.ai.base.tool.AIToolType;
import com.geoway.ns.ai.base.tool.AiTool;
import com.geoway.ns.ai.base.tool.composition.AiCompositionTool;
import com.geoway.ns.ai.base.tool.composition.AiCompositionToolDefinition;
import com.geoway.ns.ai.base.tool.http.AiHttpTool;
import com.geoway.ns.ai.chat.service.AiUserService;
import com.geoway.ns.ai.chat.util.AiSpringUtil;
import java.util.ArrayList;
import java.util.List;

public class AiChatToolUtil {
    public static List<AiTool> getAiTools(AiChatDTO aiChatDTO) {
        try {
            AiApplicationProvider aiApplicationProvider = AiSpringUtil.getBean(AiApplicationProvider.class);
            AIApplication aiApplication = aiApplicationProvider.getApplication().stream().filter(f -> f.getName().equalsIgnoreCase(aiChatDTO.getTopic())).findFirst().orElse(null);
            if (aiApplication.getTools() == null || aiApplication.getTools().size() == 0) {
                return new ArrayList<AiTool>();
            }
            ArrayList<AiTool> result = new ArrayList<AiTool>();
            AiChatToolUtil.getAiTools(aiApplication.getTools(), result);
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void getAiTools(List<AIChatTool> tools, List<AiTool> result) {
        try {
            for (AIChatTool aiChatTool : tools) {
                AIToolType aiToolType = AIToolType.getEnumByDesc((String)aiChatTool.getType());
                switch (aiToolType) {
                    case HTTP: {
                        AiUserService aiUserService = AiSpringUtil.getBean(AiUserService.class);
                        AiHttpTool aiHttpTool = new AiHttpTool(aiChatTool.getHost(), aiChatTool.getClassname(), aiUserService.getHeader());
                        result.add((AiTool)aiHttpTool);
                        break;
                    }
                    case COMPOSITION: {
                        if (aiChatTool.getChildren() == null && aiChatTool.getChildren().size() == 0) break;
                        AiCompositionToolDefinition aiCompositionToolDefinition = new AiCompositionToolDefinition(aiChatTool.getName(), aiChatTool.getDesc());
                        AiCompositionTool aiCompositionTool = new AiCompositionTool();
                        aiCompositionTool.setToolDefinition(aiCompositionToolDefinition);
                        result.add((AiTool)aiCompositionTool);
                        AiChatToolUtil.getAiTools(aiChatTool.getChildren(), aiCompositionTool.getChildren());
                        break;
                    }
                    case SYSTEM: {
                        Class<?> clazz = Class.forName(aiChatTool.getClassname());
                        AiTool aiTool = (AiTool)clazz.newInstance();
                        result.add(aiTool);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

