/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.ai.chat.service.impl;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.geoway.ns.ai.base.gateway.AiGatewayDefinition;
import com.geoway.ns.ai.base.gateway.AiGatewayProvider;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class AiGatewayProviderImpl
implements AiGatewayProvider {
    private static final Logger log = LoggerFactory.getLogger(AiGatewayProviderImpl.class);
    @Value(value="${ai.gatewayPath:}")
    private String gatewayPath;

    public List<AiGatewayDefinition> getGateway() {
        try {
            if (StrUtil.isBlank((CharSequence)this.gatewayPath)) {
                return new ArrayList<AiGatewayDefinition>();
            }
            if (!FileUtil.exist((String)this.gatewayPath)) {
                return new ArrayList<AiGatewayDefinition>();
            }
            String jsonStr = FileUtil.readString((String)this.gatewayPath, (Charset)CharsetUtil.CHARSET_UTF_8);
            return JSONUtil.toList((String)jsonStr, AiGatewayDefinition.class);
        }
        catch (Exception e) {
            log.error("\u89e3\u6790aiGateway\u914d\u7f6e\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u6838\u67e5", (Throwable)e);
            return new ArrayList<AiGatewayDefinition>();
        }
    }
}

