/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.data.graph.spark.common.api;

import com.geoway.atlas.common.config.AtlasSystemProperties$;
import com.geoway.atlas.common.error.NotEqualException;
import com.geoway.atlas.common.error.NotEqualException$;
import com.geoway.atlas.data.common.data.AtlasDataHub$;
import com.geoway.atlas.data.common.data.AtlasDataModelRDao;
import com.geoway.atlas.data.common.data.AtlasDataModelWDao;
import com.geoway.atlas.data.common.data.AtlasDataName;
import com.geoway.atlas.data.common.data.AtlasDataStore;
import com.geoway.atlas.data.common.data.AtlasDataStore$;
import com.geoway.atlas.data.common.dataset.AtlasDataSet;
import com.geoway.atlas.data.common.schema.AtlasSchema;
import com.geoway.atlas.data.common.storage.AtlasDataParams;
import com.geoway.atlas.data.common.storage.AtlasDataParams$;
import com.geoway.atlas.dataset.common.manager.DataManager;
import com.geoway.atlas.dataset.common.manager.DataManager$;
import com.geoway.atlas.dataset.graph.common.AtlasGraphSchema;
import com.geoway.atlas.dataset.graph.spark.GraphSparkProvider;
import com.geoway.atlas.dataset.graph.spark.GraphSparkProvider$;
import java.io.Serializable;
import org.graphframes.GraphFrame;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;

public final class GraphSparkDataApi$ {
    public static GraphSparkDataApi$ MODULE$;

    static {
        new GraphSparkDataApi$();
    }

    public void loadGraphData(AtlasDataName dataName, Option<Map<String, String>> dataLabel, String dataStoreFormat, Map<String, String> loadParams) {
        Map dataStoreParams = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)AtlasDataStore$.MODULE$.DATA_STORE_FORMAT()), (Object)dataStoreFormat)}));
        AtlasDataParams atlasParams = AtlasDataParams$.MODULE$.apply(dataStoreParams);
        Tuple2 tuple2 = atlasParams.extractUrlParams(loadParams);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        AtlasDataName storageName = (AtlasDataName)tuple2._1();
        Map nLoadParams = (Map)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)storageName, (Object)nLoadParams);
        Tuple2 tuple23 = tuple22;
        AtlasDataName storageName2 = (AtlasDataName)tuple23._1();
        Map nLoadParams2 = (Map)tuple23._2();
        AtlasDataStore atlasDataStore = AtlasDataHub$.MODULE$.getAtlasDataStore(dataStoreParams);
        String atlasFramework = AtlasSystemProperties$.MODULE$.getFramework();
        if (!AtlasSystemProperties$.MODULE$.SPARK_FRAMEWORK().equals(atlasFramework)) {
            String x$1 = "\u8bbe\u7f6e\u7684\u8ba1\u7b97\u6846\u67b6\u4e0e\u5f53\u524d\u7684\u8ba1\u7b97\u6846\u67b6\u4e0d\u76f8\u540c\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e!";
            Thread x$2 = NotEqualException$.MODULE$.apply$default$2(x$1);
            int x$3 = NotEqualException$.MODULE$.apply$default$3(x$1);
            throw new NotEqualException(x$1, x$2, x$3);
        }
        Map connectParams = atlasParams.extractConnectParams(nLoadParams2);
        Map schemaParams = atlasParams.extractGetSchemaParams(nLoadParams2);
        Map partitionParams = atlasParams.extractReadParams(nLoadParams2);
        atlasDataStore.connection(connectParams);
        Map storageParams = atlasDataStore.getStorageInfo().getStorageParams();
        Map daoFactoryParams = atlasDataStore.getStorageInfo().getDaoFactoryParams();
        AtlasSchema atlasSchema = atlasDataStore.getSchema(storageName2, dataName, schemaParams);
        AtlasDataModelRDao dao = null;
        try {
            dao = atlasDataStore.getAtlasDataModelReadDao(atlasSchema, partitionParams);
        }
        finally {
            atlasDataStore.close();
        }
        GraphSparkProvider sparkProvider = GraphSparkProvider$.MODULE$.apply((AtlasGraphSchema)atlasSchema);
        AtlasDataSet graphDataSet = sparkProvider.provideData(null, dao, partitionParams.$plus$plus((GenTraversableOnce)storageParams).$plus$plus((GenTraversableOnce)daoFactoryParams), ClassTag$.MODULE$.apply(GraphFrame.class));
        ObjectRef totalDataLabel = ObjectRef.create((Object)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataManager$.MODULE$.DATA_TYPE()), (Object)DataManager.DataType$.MODULE$.GRAPH())}))));
        dataLabel.foreach((Function1 & Serializable & scala.Serializable)m -> {
            totalDataLabel.elem = ((Map)totalDataLabel.elem).$plus$plus((GenTraversableOnce)m);
            return BoxedUnit.UNIT;
        });
        DataManager$.MODULE$.register(graphDataSet, (Option)new Some((Object)((Map)totalDataLabel.elem)));
    }

    public void saveGraphData(AtlasDataName atlasDataName, Option<Map<String, String>> matchLabelOpts, String dataStoreFormat, Map<String, String> saveParams) {
        ObjectRef labelMap = ObjectRef.create((Object)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataManager$.MODULE$.DATA_TYPE()), (Object)DataManager.DataType$.MODULE$.GRAPH())}))));
        matchLabelOpts.foreach((Function1 & Serializable & scala.Serializable)map -> {
            labelMap.elem = map.$plus$plus((GenTraversableOnce)((Map)labelMap.elem));
            return BoxedUnit.UNIT;
        });
        Tuple2 tuple2 = DataManager$.MODULE$.get(atlasDataName, (Option)new Some((Object)((Map)labelMap.elem)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        AtlasDataSet atlasDataSet = (AtlasDataSet)tuple2._1();
        Option dataLabel = (Option)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)atlasDataSet, (Object)dataLabel);
        Tuple2 tuple23 = tuple22;
        AtlasDataSet atlasDataSet2 = (AtlasDataSet)tuple23._1();
        Option dataLabel2 = (Option)tuple23._2();
        Map dataStoreParams = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)AtlasDataStore$.MODULE$.DATA_STORE_FORMAT()), (Object)dataStoreFormat)}));
        AtlasDataParams atlasParams = AtlasDataParams$.MODULE$.apply(dataStoreParams);
        Tuple2 tuple24 = atlasParams.extractUrlParams(saveParams);
        if (tuple24 == null) {
            throw new MatchError((Object)tuple24);
        }
        AtlasDataName storageName = (AtlasDataName)tuple24._1();
        Map nSaveParams = (Map)tuple24._2();
        Tuple2 tuple25 = new Tuple2((Object)storageName, (Object)nSaveParams);
        Tuple2 tuple26 = tuple25;
        AtlasDataName storageName2 = (AtlasDataName)tuple26._1();
        Map nSaveParams2 = (Map)tuple26._2();
        AtlasDataStore atlasDataStore = AtlasDataHub$.MODULE$.getAtlasDataStore(dataStoreParams);
        String atlasFramework = AtlasSystemProperties$.MODULE$.getFramework();
        if (!AtlasSystemProperties$.MODULE$.SPARK_FRAMEWORK().equals(atlasFramework)) {
            String x$1 = "\u8bbe\u7f6e\u7684\u8ba1\u7b97\u6846\u67b6\u4e0e\u5f53\u524d\u7684\u8ba1\u7b97\u6846\u67b6\u4e0d\u76f8\u540c\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e!";
            Thread x$2 = NotEqualException$.MODULE$.apply$default$2(x$1);
            int x$3 = NotEqualException$.MODULE$.apply$default$3(x$1);
            throw new NotEqualException(x$1, x$2, x$3);
        }
        Map connectParams = atlasParams.extractConnectParams(nSaveParams2);
        Map createSchemaParams = atlasParams.extractCreateSchemaParams(nSaveParams2);
        Map writeParams = atlasParams.extractWriteParams(nSaveParams2);
        atlasDataStore.connection(connectParams);
        Map storageParams = atlasDataStore.getStorageInfo().getStorageParams();
        Map daoFactoryParams = atlasDataStore.getStorageInfo().getDaoFactoryParams();
        AtlasDataModelWDao dao = null;
        try {
            AtlasSchema createSchema = atlasDataStore.getSchema(storageName2, atlasDataName, createSchemaParams);
            dao = atlasDataStore.getAtlasDataModelWriteDao(storageName2, atlasDataSet2.getAtlasSchema(), createSchema);
        }
        finally {
            atlasDataStore.close();
        }
        GraphSparkProvider sparkProvider = GraphSparkProvider$.MODULE$.apply((AtlasGraphSchema)atlasDataSet2.getAtlasSchema());
        sparkProvider.saveData(atlasDataSet2, dao, storageParams.$plus$plus((GenTraversableOnce)daoFactoryParams).$plus$plus((GenTraversableOnce)writeParams), ClassTag$.MODULE$.apply(GraphFrame.class));
    }

    private GraphSparkDataApi$() {
        MODULE$ = this;
    }
}

