/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.equalization;

import geotrellis.raster.BitCells;
import geotrellis.raster.ByteCells;
import geotrellis.raster.DataType;
import geotrellis.raster.DoubleCells;
import geotrellis.raster.FloatCells;
import geotrellis.raster.IntCells;
import geotrellis.raster.MultibandTile;
import geotrellis.raster.MultibandTile$;
import geotrellis.raster.ShortCells;
import geotrellis.raster.Tile;
import geotrellis.raster.UByteCells;
import geotrellis.raster.UShortCells;
import geotrellis.raster.equalization.HistogramEqualization;
import geotrellis.raster.histogram.Histogram;
import geotrellis.raster.histogram.StreamingHistogram;
import geotrellis.raster.histogram.StreamingHistogram$;
import java.io.Serializable;
import java.util.Arrays;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.math.package$;
import scala.runtime.java8.JFunction1;

public final class HistogramEqualization$ {
    public static HistogramEqualization$ MODULE$;
    private final HistogramEqualization.BucketComparator geotrellis$raster$equalization$HistogramEqualization$$cmp;

    static {
        new HistogramEqualization$();
    }

    public HistogramEqualization.BucketComparator geotrellis$raster$equalization$HistogramEqualization$$cmp() {
        return this.geotrellis$raster$equalization$HistogramEqualization$$cmp;
    }

    public double intensityToCdf(DataType cellType, Tuple2<Object, Object>[] cdf, double x) {
        double d;
        int i = Arrays.binarySearch((Object[])cdf, new Tuple2.mcDD.sp(x, 0.0), this.geotrellis$raster$equalization$HistogramEqualization$$cmp());
        double smallestCdf = cdf[0]._2$mcD$sp();
        if (x < cdf[0]._1$mcD$sp()) {
            d = smallestCdf;
        } else if (-1 * i > cdf.length) {
            d = 1.0;
        } else if (i >= 0) {
            d = cdf[i]._2$mcD$sp();
        } else {
            int j = -1 * i - 2;
            double label0 = cdf[j + 0]._1$mcD$sp();
            double label1 = cdf[j + 1]._1$mcD$sp();
            double t = (x - label0) / (label1 - label0);
            double cdf0 = cdf[j + 0]._2$mcD$sp();
            double cdf1 = cdf[j + 1]._2$mcD$sp();
            d = (1.0 - t) * cdf0 + t * cdf1;
        }
        double rawCdf = d;
        return package$.MODULE$.max(0.0, package$.MODULE$.min(1.0, (rawCdf - smallestCdf) / (1.0 - smallestCdf)));
    }

    public double toIntensity(DataType cellType, double x) {
        double d;
        int bits = cellType.bits();
        DataType dataType = cellType;
        if (dataType instanceof FloatCells) {
            d = 3.4028234663852886E38 * ((double)2 * x - 1.0);
        } else if (dataType instanceof DoubleCells) {
            d = Double.MAX_VALUE * ((double)2 * x - 1.0);
        } else {
            boolean bl = dataType instanceof BitCells ? true : (dataType instanceof UByteCells ? true : dataType instanceof UShortCells);
            if (bl) {
                d = (double)((1 << bits) - 1) * x;
            } else {
                boolean bl2 = dataType instanceof ByteCells ? true : (dataType instanceof ShortCells ? true : dataType instanceof IntCells);
                if (bl2) {
                    d = (double)((1 << bits) - 1) * x - (double)(1 << bits - 1);
                } else {
                    throw new MatchError((Object)dataType);
                }
            }
        }
        return d;
    }

    private double transform(DataType cellType, Function1<Object, Object> fn, double x) {
        return this.toIntensity(cellType, fn.apply$mcDD$sp(x));
    }

    public Tile apply(Tile tile) {
        StreamingHistogram histogram = StreamingHistogram$.MODULE$.fromTile(tile, 131072);
        return this.apply(tile, histogram);
    }

    public <T> Tile apply(Tile tile, Histogram<T> histogram) {
        DataType dataType = tile.cellType();
        Tuple2<Object, Object>[] tuple2Array = histogram.cdf();
        JFunction1.mcDD.sp & Serializable & scala.Serializable localIntensityToCdf = (JFunction1.mcDD.sp & Serializable & scala.Serializable)x -> MODULE$.intensityToCdf(dataType, tuple2Array, x);
        DataType dataType2 = tile.cellType();
        JFunction1.mcDD.sp & Serializable & scala.Serializable localTransform = arg_0 -> HistogramEqualization$.$anonfun$apply$2(dataType2, (Function1)localIntensityToCdf, arg_0);
        return tile.mapDouble((Function1<Object, Object>)localTransform);
    }

    public MultibandTile apply(MultibandTile tile2) {
        Vector histograms = (Vector)tile2.bands().map((Function1 & Serializable & scala.Serializable)tile -> StreamingHistogram$.MODULE$.fromTile((Tile)tile, 131072), Vector$.MODULE$.canBuildFrom());
        return this.apply(tile2, (Seq)histograms);
    }

    public <T> MultibandTile apply(MultibandTile tile, Seq<Histogram<T>> histograms) {
        return MultibandTile$.MODULE$.apply((Traversable<Tile>)((Traversable)((TraversableLike)tile.bands().zip(histograms, Vector$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple22 = x0$1;
            if (tuple22 == null) {
                throw new MatchError((Object)tuple22);
            }
            Tile tile = (Tile)tuple22._1();
            Histogram histogram = (Histogram)tuple22._2();
            Tile tile2 = MODULE$.apply(tile, histogram);
            return tile2;
        }, Vector$.MODULE$.canBuildFrom())));
    }

    public static final /* synthetic */ double $anonfun$apply$2(DataType eta$0$2$1, Function1 localIntensityToCdf$1, double x) {
        return MODULE$.transform(eta$0$2$1, (Function1<Object, Object>)localIntensityToCdf$1, x);
    }

    private HistogramEqualization$() {
        MODULE$ = this;
        this.geotrellis$raster$equalization$HistogramEqualization$$cmp = new HistogramEqualization.BucketComparator();
    }
}

