/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.render.png;

import geotrellis.raster.Tile;
import geotrellis.raster.render.png.Chunk;
import geotrellis.raster.render.png.Filter;
import geotrellis.raster.render.png.GreyPngEncoding;
import geotrellis.raster.render.png.IndexedPngEncoding;
import geotrellis.raster.render.png.NoFilter$;
import geotrellis.raster.render.png.PaethFilter$;
import geotrellis.raster.render.png.PngColorEncoding;
import geotrellis.raster.render.png.PngEncoder$;
import geotrellis.raster.render.png.RgbPngEncoding;
import geotrellis.raster.render.png.Settings;
import geotrellis.raster.render.png.Util$;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import scala.Array$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0001\t]a\u0001B\u001a5\u0001vB\u0001B\u0013\u0001\u0003\u0016\u0004%\ta\u0013\u0005\t!\u0002\u0011\t\u0012)A\u0005\u0019\")\u0011\u000b\u0001C\u0001%\"9Q\u000b\u0001b\u0001\n\u000b1\u0006BB/\u0001A\u00035q\u000bC\u0004_\u0001\t\u0007IQA0\t\r\r\u0004\u0001\u0015!\u0004a\u0011\u001d!\u0007A1A\u0005\u0006}Ca!\u001a\u0001!\u0002\u001b\u0001\u0007b\u00024\u0001\u0005\u0004%)a\u0018\u0005\u0007O\u0002\u0001\u000bQ\u00021\t\u000f!\u0004!\u0019!C\u0003?\"1\u0011\u000e\u0001Q\u0001\u000e\u0001DqA\u001b\u0001C\u0002\u0013\u0015q\f\u0003\u0004l\u0001\u0001\u0006i\u0001\u0019\u0005\bY\u0002\u0011\r\u0011\"\u0002`\u0011\u0019i\u0007\u0001)A\u0007A\"9a\u000e\u0001b\u0001\n\u000by\u0007B\u00029\u0001A\u00035!\fC\u0004r\u0001\t\u0007IQA0\t\rI\u0004\u0001\u0015!\u0004a\u0011\u001d\u0019\bA1A\u0005\u0006}Ca\u0001\u001e\u0001!\u0002\u001b\u0001\u0007\"B;\u0001\t\u00031\bbBA\n\u0001\u0011\u0005\u0011Q\u0003\u0005\b\u00033\u0001A\u0011AA\u000e\u0011\u001d\tY\u0003\u0001C\u0001\u0003[Aq!a\r\u0001\t\u0003\t)\u0004C\u0004\u0002<\u0001!\t!!\u0010\t\u000f\u0005\r\u0003\u0001\"\u0001\u0002F!9\u0011\u0011\n\u0001\u0005\u0002\u0005-\u0003bBA-\u0001\u0011\u0005\u00111\f\u0005\b\u0003?\u0002A\u0011AA1\u0011%\ty\bAA\u0001\n\u0003\t\t\tC\u0005\u0002\u0006\u0002\t\n\u0011\"\u0001\u0002\b\"I\u0011Q\u0014\u0001\u0002\u0002\u0013\u0005\u0013q\u0014\u0005\t\u0003W\u0003\u0011\u0011!C\u0001?\"I\u0011Q\u0016\u0001\u0002\u0002\u0013\u0005\u0011q\u0016\u0005\n\u0003w\u0003\u0011\u0011!C!\u0003{C\u0011\"a3\u0001\u0003\u0003%\t!!4\t\u0013\u0005]\u0007!!A\u0005B\u0005e\u0007\"CAn\u0001\u0005\u0005I\u0011IAo\u0011%\ty\u000eAA\u0001\n\u0003\n\toB\u0005\u0002fR\n\t\u0011#\u0001\u0002h\u001aA1\u0007NA\u0001\u0012\u0003\tI\u000f\u0003\u0004R[\u0011\u0005\u0011q\u001f\u0005\n\u00037l\u0013\u0011!C#\u0003;D\u0011\"!?.\u0003\u0003%\t)a?\t\u0013\u0005}X&!A\u0005\u0002\n\u0005\u0001\"\u0003B\u0007[\u0005\u0005I\u0011\u0002B\b\u0005)\u0001fnZ#oG>$WM\u001d\u0006\u0003kY\n1\u0001\u001d8h\u0015\t9\u0004(\u0001\u0004sK:$WM\u001d\u0006\u0003si\naA]1ti\u0016\u0014(\"A\u001e\u0002\u0015\u001d,w\u000e\u001e:fY2L7o\u0001\u0001\u0014\t\u0001qDi\u0012\t\u0003\u007f\tk\u0011\u0001\u0011\u0006\u0002\u0003\u0006)1oY1mC&\u00111\t\u0011\u0002\u0007\u0003:L(+\u001a4\u0011\u0005}*\u0015B\u0001$A\u0005\u001d\u0001&o\u001c3vGR\u0004\"a\u0010%\n\u0005%\u0003%\u0001D*fe&\fG.\u001b>bE2,\u0017\u0001C:fiRLgnZ:\u0016\u00031\u0003\"!\u0014(\u000e\u0003QJ!a\u0014\u001b\u0003\u0011M+G\u000f^5oON\f\u0011b]3ui&twm\u001d\u0011\u0002\rqJg.\u001b;?)\t\u0019F\u000b\u0005\u0002N\u0001!)!j\u0001a\u0001\u0019\u0006I1+S$O\u0003R+&+R\u000b\u0002/B\u0019q\b\u0017.\n\u0005e\u0003%!B!se\u0006L\bCA \\\u0013\ta\u0006I\u0001\u0003CsR,\u0017AC*J\u000f:\u000bE+\u0016*FA\u0005!\u0011\n\u0013#S+\u0005\u0001\u0007CA b\u0013\t\u0011\u0007IA\u0002J]R\fQ!\u0013%E%\u0002\nAAQ&H\t\u0006)!iS$EA\u0005!\u0001\u000b\u0014+F\u0003\u0015\u0001F\nV#!\u0003\u0011!&KT*\u0002\u000bQ\u0013fj\u0015\u0011\u0002\t%#\u0015\tV\u0001\u0006\u0013\u0012\u000bE\u000bI\u0001\u0005\u0013\u0016sE)A\u0003J\u000b:#\u0005%\u0001\u0004G\u00132#VIU\u000b\u00025\u00069a)\u0013'U\u000bJ\u0003\u0013!\u0002#F!RC\u0015A\u0002#F!RC\u0005%A\u0003T\u0011&3E+\u0001\u0004T\u0011&3E\u000bI\u0001\foJLG/\u001a%fC\u0012,'\u000f\u0006\u0003xu\u0006%\u0001CA y\u0013\tI\bI\u0001\u0003V]&$\b\"B>\u0019\u0001\u0004a\u0018a\u00013pgB\u0019Q0!\u0002\u000e\u0003yT1a`A\u0001\u0003\tIwN\u0003\u0002\u0002\u0004\u0005!!.\u0019<b\u0013\r\t9A \u0002\u0011\t\u0006$\u0018mT;uaV$8\u000b\u001e:fC6Da!\u000f\rA\u0002\u0005-\u0001\u0003BA\u0007\u0003\u001fi\u0011\u0001O\u0005\u0004\u0003#A$\u0001\u0002+jY\u0016\f1c\u001e:ji\u0016\u0014\u0015mY6he>,h\u000eZ%oM>$2a^A\f\u0011\u0015Y\u0018\u00041\u0001}\u0003A\u0019'/Z1uK\nKH/\u001a\"vM\u001a,'\u000f\u0006\u0003\u0002\u001e\u0005%\u0002\u0003BA\u0010\u0003Ki!!!\t\u000b\t\u0005\r\u0012\u0011A\u0001\u0004]&|\u0017\u0002BA\u0014\u0003C\u0011!BQ=uK\n+hMZ3s\u0011\u0019I$\u00041\u0001\u0002\f\u0005qqO]5uKBK\u00070\u001a7ECR\fG#B<\u00020\u0005E\u0002\"B>\u001c\u0001\u0004a\bBB\u001d\u001c\u0001\u0004\tY!\u0001\fxe&$X\rU5yK2$\u0015\r^1O_\u001aKG\u000e^3s)\u00159\u0018qGA\u001d\u0011\u0015YH\u00041\u0001}\u0011\u0019ID\u00041\u0001\u0002\f\u0005\u0019rO]5uKBK\u00070\u001a7ECR\f\u0007+Y3uQR)q/a\u0010\u0002B!)10\ba\u0001y\"1\u0011(\ba\u0001\u0003\u0017\t\u0001b\u001e:ji\u0016,e\u000e\u001a\u000b\u0004o\u0006\u001d\u0003\"B>\u001f\u0001\u0004a\u0018!E<sSR,w*\u001e;qkR\u001cFO]3b[R)q/!\u0014\u0002X!9\u0011qJ\u0010A\u0002\u0005E\u0013AA8t!\ri\u00181K\u0005\u0004\u0003+r(\u0001D(viB,Ho\u0015;sK\u0006l\u0007BB\u001d \u0001\u0004\tY!\u0001\bxe&$XMQ=uK\u0006\u0013(/Y=\u0015\u0007]\u000bi\u0006\u0003\u0004:A\u0001\u0007\u00111B\u0001\noJLG/\u001a)bi\"$Ra^A2\u0003{Bq!!\u001a\"\u0001\u0004\t9'\u0001\u0003qCRD\u0007\u0003BA5\u0003orA!a\u001b\u0002tA\u0019\u0011Q\u000e!\u000e\u0005\u0005=$bAA9y\u00051AH]8pizJ1!!\u001eA\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011PA>\u0005\u0019\u0019FO]5oO*\u0019\u0011Q\u000f!\t\re\n\u0003\u0019AA\u0006\u0003\u0011\u0019w\u000e]=\u0015\u0007M\u000b\u0019\tC\u0004KEA\u0005\t\u0019\u0001'\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011\u0011\u0012\u0016\u0004\u0019\u0006-5FAAG!\u0011\ty)!'\u000e\u0005\u0005E%\u0002BAJ\u0003+\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005]\u0005)\u0001\u0006b]:|G/\u0019;j_:LA!a'\u0002\u0012\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t\t\u000b\u0005\u0003\u0002$\u0006%VBAAS\u0015\u0011\t9+!\u0001\u0002\t1\fgnZ\u0005\u0005\u0003s\n)+\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005E\u0016q\u0017\t\u0004\u007f\u0005M\u0016bAA[\u0001\n\u0019\u0011I\\=\t\u0011\u0005ef%!AA\u0002\u0001\f1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA`!\u0019\t\t-a2\u000226\u0011\u00111\u0019\u0006\u0004\u0003\u000b\u0004\u0015AC2pY2,7\r^5p]&!\u0011\u0011ZAb\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005=\u0017Q\u001b\t\u0004\u007f\u0005E\u0017bAAj\u0001\n9!i\\8mK\u0006t\u0007\"CA]Q\u0005\u0005\t\u0019AAY\u0003!A\u0017m\u001d5D_\u0012,G#\u00011\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!)\u0002\r\u0015\fX/\u00197t)\u0011\ty-a9\t\u0013\u0005e6&!AA\u0002\u0005E\u0016A\u0003)oO\u0016s7m\u001c3feB\u0011Q*L\n\u0005[\u0005-x\t\u0005\u0004\u0002n\u0006MHjU\u0007\u0003\u0003_T1!!=A\u0003\u001d\u0011XO\u001c;j[\u0016LA!!>\u0002p\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u0019\u0015\u0005\u0005\u001d\u0018!B1qa2LHcA*\u0002~\")!\n\ra\u0001\u0019\u00069QO\\1qa2LH\u0003\u0002B\u0002\u0005\u0013\u0001Ba\u0010B\u0003\u0019&\u0019!q\u0001!\u0003\r=\u0003H/[8o\u0011!\u0011Y!MA\u0001\u0002\u0004\u0019\u0016a\u0001=%a\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0011\t\u0002\u0005\u0003\u0002$\nM\u0011\u0002\u0002B\u000b\u0003K\u0013aa\u00142kK\u000e$\b")
public class PngEncoder
implements Product,
scala.Serializable {
    private final Settings settings;
    private final byte[] SIGNATURE;
    private final int IHDR;
    private final int BKGD;
    private final int PLTE;
    private final int TRNS;
    private final int IDAT;
    private final int IEND;
    private final byte FILTER;
    private final int DEPTH;
    private final int SHIFT;

    public static Option<Settings> unapply(PngEncoder pngEncoder) {
        return PngEncoder$.MODULE$.unapply(pngEncoder);
    }

    public static PngEncoder apply(Settings settings) {
        return PngEncoder$.MODULE$.apply(settings);
    }

    public static <A> Function1<Settings, A> andThen(Function1<PngEncoder, A> function1) {
        return PngEncoder$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, PngEncoder> compose(Function1<A, Settings> function1) {
        return PngEncoder$.MODULE$.compose(function1);
    }

    public Settings settings() {
        return this.settings;
    }

    public final byte[] SIGNATURE() {
        return this.SIGNATURE;
    }

    public final int IHDR() {
        return this.IHDR;
    }

    public final int BKGD() {
        return this.BKGD;
    }

    public final int PLTE() {
        return this.PLTE;
    }

    public final int TRNS() {
        return this.TRNS;
    }

    public final int IDAT() {
        return this.IDAT;
    }

    public final int IEND() {
        return this.IEND;
    }

    public final byte FILTER() {
        return this.FILTER;
    }

    public final int DEPTH() {
        return this.DEPTH;
    }

    public final int SHIFT() {
        return this.SHIFT;
    }

    public void writeHeader(DataOutputStream dos, Tile raster) {
        int width = raster.cols$mcI$sp();
        int height = raster.rows$mcI$sp();
        dos.write(this.SIGNATURE());
        Chunk cIHDR = new Chunk(this.IHDR());
        cIHDR.writeInt(width);
        cIHDR.writeInt(height);
        cIHDR.writeByte((byte)8);
        cIHDR.writeByte(this.settings().colorType().n());
        cIHDR.writeByte((byte)0);
        cIHDR.writeByte((byte)0);
        cIHDR.writeByte((byte)0);
        cIHDR.writeTo(dos);
    }

    public void writeBackgroundInfo(DataOutputStream dos) {
        RgbPngEncoding rgbPngEncoding;
        Option<Object> option2;
        GreyPngEncoding greyPngEncoding;
        Option<Object> option3;
        PngColorEncoding pngColorEncoding = this.settings().colorType();
        if (pngColorEncoding instanceof GreyPngEncoding && (option3 = (greyPngEncoding = (GreyPngEncoding)pngColorEncoding).transparent()) instanceof Some) {
            Some some = (Some)option3;
            int ndColor = BoxesRunTime.unboxToInt((Object)some.value());
            Chunk cTRNS = new Chunk(this.TRNS());
            cTRNS.writeByte((byte)0);
            cTRNS.writeByte(Util$.MODULE$.shift(ndColor, 8));
            cTRNS.writeTo(dos);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (pngColorEncoding instanceof RgbPngEncoding && (option2 = (rgbPngEncoding = (RgbPngEncoding)pngColorEncoding).transparent()) instanceof Some) {
            Some some = (Some)option2;
            int ndColor = BoxesRunTime.unboxToInt((Object)some.value());
            Chunk cTRNS = new Chunk(this.TRNS());
            cTRNS.writeByte((byte)0);
            cTRNS.writeByte(Util$.MODULE$.shift(ndColor, 24));
            cTRNS.writeByte((byte)0);
            cTRNS.writeByte(Util$.MODULE$.shift(ndColor, 16));
            cTRNS.writeByte((byte)0);
            cTRNS.writeByte(Util$.MODULE$.shift(ndColor, 8));
            cTRNS.writeTo(dos);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (pngColorEncoding instanceof IndexedPngEncoding) {
            IndexedPngEncoding indexedPngEncoding = (IndexedPngEncoding)pngColorEncoding;
            int[] rgbs = indexedPngEncoding.rgbs();
            int[] alphas = indexedPngEncoding.as();
            Chunk cPLTE = new Chunk(this.PLTE());
            new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(rgbs)).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)rgb -> {
                cPLTE.writeByte(Util$.MODULE$.shift(rgb, 16));
                cPLTE.writeByte(Util$.MODULE$.shift(rgb, 8));
                cPLTE.writeByte(Util$.MODULE$.byte(rgb));
            });
            cPLTE.writeTo(dos);
            Chunk cTRNS = new Chunk(this.TRNS());
            new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(alphas)).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)a -> cTRNS.writeByte(Util$.MODULE$.byte(a)));
            cTRNS.writeTo(dos);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public ByteBuffer createByteBuffer(Tile raster) {
        int size = BoxesRunTime.unboxToInt(raster.size());
        int[] data = raster.toArray();
        ByteBuffer bb = ByteBuffer.allocate(size * this.DEPTH());
        if (this.DEPTH() == 4) {
            Util$.MODULE$.initByteBuffer32(bb, data, size);
        } else if (this.DEPTH() == 3) {
            Util$.MODULE$.initByteBuffer24(bb, data, size);
        } else if (this.DEPTH() == 2) {
            Util$.MODULE$.initByteBuffer16(bb, data, size);
        } else if (this.DEPTH() == 1) {
            Util$.MODULE$.initByteBuffer8(bb, data, size);
        } else {
            throw package$.MODULE$.error(new StringBuilder(19).append("unsupported depth: ").append(this.DEPTH()).toString());
        }
        return bb;
    }

    public void writePixelData(DataOutputStream dos, Tile raster) {
        Filter filter2 = this.settings().filter();
        if (PaethFilter$.MODULE$.equals(filter2)) {
            this.writePixelDataPaeth(dos, raster);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (NoFilter$.MODULE$.equals(filter2)) {
            this.writePixelDataNoFilter(dos, raster);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw package$.MODULE$.error("filter %s not supported");
        }
    }

    public void writePixelDataNoFilter(DataOutputStream dos, Tile raster) {
        int cols = raster.cols$mcI$sp();
        int size = cols * raster.rows$mcI$sp();
        Chunk cIDAT = new Chunk(this.IDAT());
        ByteBuffer bb = this.createByteBuffer(raster);
        DeflaterOutputStream dfos = new DeflaterOutputStream((OutputStream)cIDAT.cos(), new Deflater(1));
        int byteWidth = cols * this.DEPTH();
        byte[] currLine = (byte[])Array$.MODULE$.ofDim(byteWidth, ClassTag$.MODULE$.Byte());
        for (int yspan = 0; yspan < size; yspan += cols) {
            bb.position(yspan * this.DEPTH());
            bb.get(currLine);
            dfos.write(this.FILTER());
            dfos.write(currLine);
        }
        dfos.finish();
        cIDAT.writeTo(dos);
    }

    public void writePixelDataPaeth(DataOutputStream dos, Tile raster) {
        int cols = raster.cols$mcI$sp();
        int size = cols * raster.rows$mcI$sp();
        Chunk cIDAT = new Chunk(this.IDAT());
        int j = 0;
        ByteBuffer bb = this.createByteBuffer(raster);
        DeflaterOutputStream dfos = new DeflaterOutputStream((OutputStream)cIDAT.cos(), new Deflater(1));
        int byteWidth = cols * this.DEPTH();
        byte[] lineOut = (byte[])Array$.MODULE$.ofDim(byteWidth, ClassTag$.MODULE$.Byte());
        byte[] prevLine = (byte[])Array$.MODULE$.ofDim(byteWidth, ClassTag$.MODULE$.Byte());
        byte[] currLine = (byte[])Array$.MODULE$.ofDim(byteWidth, ClassTag$.MODULE$.Byte());
        byte[] tmp = null;
        for (int yspan = 0; yspan < size; yspan += cols) {
            bb.position(yspan * this.DEPTH());
            bb.get(currLine);
            for (j = 0; j < this.DEPTH(); ++j) {
                lineOut[j] = Util$.MODULE$.byte(currLine[j] - prevLine[j]);
            }
            while (j < byteWidth) {
                int a = currLine[j - this.DEPTH()] & 0xFF;
                int b = prevLine[j] & 0xFF;
                int c = prevLine[j - this.DEPTH()] & 0xFF;
                int pa = b - c;
                int pb = a - c;
                int pc = pa + pb;
                if (pa < 0) {
                    pa = -pa;
                }
                if (pb < 0) {
                    pb = -pb;
                }
                if (pc < 0) {
                    pc = -pc;
                }
                if (pa <= pb && pa <= pc) {
                    c = a;
                } else if (pb <= pc) {
                    c = b;
                }
                lineOut[j] = Util$.MODULE$.byte(currLine[j] - c);
                ++j;
            }
            dfos.write(this.FILTER());
            dfos.write(lineOut);
            tmp = prevLine;
            prevLine = currLine;
            currLine = tmp;
        }
        dfos.finish();
        cIDAT.writeTo(dos);
    }

    public void writeEnd(DataOutputStream dos) {
        Chunk cIEND = new Chunk(this.IEND());
        cIEND.writeTo(dos);
    }

    public void writeOutputStream(OutputStream os, Tile raster) {
        DataOutputStream dos = new DataOutputStream(os);
        this.writeHeader(dos, raster);
        this.writeBackgroundInfo(dos);
        this.writePixelData(dos, raster);
        this.writeEnd(dos);
        dos.flush();
    }

    public byte[] writeByteArray(Tile raster) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.writeOutputStream(baos, raster);
        return baos.toByteArray();
    }

    public void writePath(String path, Tile raster) {
        FileOutputStream fos = new FileOutputStream(new File(path));
        this.writeOutputStream(fos, raster);
        fos.close();
    }

    public PngEncoder copy(Settings settings) {
        return new PngEncoder(settings);
    }

    public Settings copy$default$1() {
        return this.settings();
    }

    public String productPrefix() {
        return "PngEncoder";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return this.settings();
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof PngEncoder;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof PngEncoder)) return false;
        boolean bl = true;
        if (!bl) return false;
        PngEncoder pngEncoder = (PngEncoder)x$1;
        Settings settings = this.settings();
        Settings settings2 = pngEncoder.settings();
        if (settings == null) {
            if (settings2 != null) {
                return false;
            }
        } else if (!((Object)settings).equals(settings2)) return false;
        if (!pngEncoder.canEqual(this)) return false;
        return true;
    }

    public PngEncoder(Settings settings) {
        this.settings = settings;
        Product.$init$((Product)this);
        this.SIGNATURE = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{(byte)137, 80, 78, 71, 13, 10, 26, 10}), ClassTag$.MODULE$.Byte());
        this.IHDR = 1229472850;
        this.BKGD = 1649100612;
        this.PLTE = 1347179589;
        this.TRNS = 1951551059;
        this.IDAT = 1229209940;
        this.IEND = 1229278788;
        this.FILTER = settings.filter().n();
        this.DEPTH = settings.colorType().depth();
        this.SHIFT = (this.DEPTH() - 1) * 8;
    }
}

