/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.vectorize;

import geotrellis.raster.RasterExtent;
import geotrellis.raster.Tile;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0001\u0005}d\u0001B\u0014)\u0001=B\u0001B\u000e\u0001\u0003\u0006\u0004%\ta\u000e\u0005\ty\u0001\u0011\t\u0011)A\u0005q!AQ\b\u0001B\u0001B\u0003%a\bC\u0003B\u0001\u0011\u0005!\tC\u0004H\u0001\t\u0007I\u0011\u0001%\t\r1\u0003\u0001\u0015!\u0003J\u0011\u001di\u0005A1A\u0005\u0002!CaA\u0014\u0001!\u0002\u0013I\u0005bB(\u0001\u0005\u0004%\t\u0001\u0015\u0005\u0007)\u0002\u0001\u000b\u0011B)\t\u000fU\u0003!\u0019!C\u0001!\"1a\u000b\u0001Q\u0001\nECqa\u0016\u0001C\u0002\u0013\u0005\u0001\f\u0003\u0004f\u0001\u0001\u0006I!\u0017\u0005\bM\u0002\u0011\r\u0011\"\u0001I\u0011\u00199\u0007\u0001)A\u0005\u0013\"9\u0001\u000e\u0001b\u0001\n\u0003A\u0005BB5\u0001A\u0003%\u0011\nC\u0004k\u0001\t\u0007I\u0011\u0001%\t\r-\u0004\u0001\u0015!\u0003J\u0011\u001da\u0007A1A\u0005\u0002!Ca!\u001c\u0001!\u0002\u0013I\u0005b\u00028\u0001\u0005\u0004%\t\u0001\u0013\u0005\u0007_\u0002\u0001\u000b\u0011B%\t\u000fA\u0004!\u0019!C\u0001\u0011\"1\u0011\u000f\u0001Q\u0001\n%CqA\u001d\u0001C\u0002\u0013\u0005\u0001\n\u0003\u0004t\u0001\u0001\u0006I!\u0013\u0005\bi\u0002\u0011\r\u0011\"\u0001I\u0011\u0019)\b\u0001)A\u0005\u0013\"9a\u000f\u0001b\u0001\n\u0003A\u0005BB<\u0001A\u0003%\u0011\nC\u0003y\u0001\u0011\u0005\u0011\u0010C\u0004\u0002\n\u0001!\t!a\u0003\t\u000f\u0005=\u0001\u0001\"\u0001\u0002\u0012!9\u0011Q\u0005\u0001\u0005\u0002\u0005\u001d\u0002bBA'\u0001\u0011\u0005\u0011q\n\u0005\b\u00037\u0002A\u0011AA/\u0005-\u0001v\u000e\\=h_:L'0\u001a:\u000b\u0005%R\u0013!\u0003<fGR|'/\u001b>f\u0015\tYC&\u0001\u0004sCN$XM\u001d\u0006\u0002[\u0005Qq-Z8ue\u0016dG.[:\u0004\u0001M\u0011\u0001\u0001\r\t\u0003cQj\u0011A\r\u0006\u0002g\u0005)1oY1mC&\u0011QG\r\u0002\u0007\u0003:L(+\u001a4\u0002\u0003I,\u0012\u0001\u000f\t\u0003sij\u0011AK\u0005\u0003w)\u0012A\u0001V5mK\u0006\u0011!\u000fI\u0001\re\u0006\u001cH/\u001a:FqR,g\u000e\u001e\t\u0003s}J!\u0001\u0011\u0016\u0003\u0019I\u000b7\u000f^3s\u000bb$XM\u001c;\u0002\rqJg.\u001b;?)\r\u0019UI\u0012\t\u0003\t\u0002i\u0011\u0001\u000b\u0005\u0006m\u0011\u0001\r\u0001\u000f\u0005\u0006{\u0011\u0001\rAP\u0001\u0005G>d7/F\u0001J!\t\t$*\u0003\u0002Le\t\u0019\u0011J\u001c;\u0002\u000b\r|Gn\u001d\u0011\u0002\tI|wo]\u0001\u0006e><8\u000fI\u0001\u000eQ\u0006dgmQ3mY^KG\r\u001e5\u0016\u0003E\u0003\"!\r*\n\u0005M\u0013$A\u0002#pk\ndW-\u0001\biC247)\u001a7m/&$G\u000f\u001b\u0011\u0002\u001d!\fGNZ\"fY2DU-[4ii\u0006y\u0001.\u00197g\u0007\u0016dG\u000eS3jO\"$\b%\u0001\u0006kiN4\u0015m\u0019;pef,\u0012!\u0017\t\u00035\u000el\u0011a\u0017\u0006\u00039v\u000bAaZ3p[*\u0011alX\u0001\u0004UR\u001c(B\u00011b\u00031awnY1uS>tG/Z2i\u0015\u0005\u0011\u0017aA8sO&\u0011Am\u0017\u0002\u0010\u000f\u0016|W.\u001a;ss\u001a\u000b7\r^8ss\u0006Y!\u000e^:GC\u000e$xN]=!\u0003!qu\n\u0016$P+:#\u0015!\u0003(P)\u001a{UK\u0014#!\u0003\u0011aUI\u0012+\u0002\u000b1+e\t\u0016\u0011\u0002\t\u0011{uKT\u0001\u0006\t>;f\nI\u0001\u0006%&;\u0005\nV\u0001\u0007%&;\u0005\n\u0016\u0011\u0002\u0005U\u0003\u0016aA+QA\u00059Ak\u0014)M\u000b\u001a#\u0016\u0001\u0003+P!2+e\t\u0016\u0011\u0002\u0015\t{E\u000bV(N\u0019\u00163E+A\u0006C\u001fR#v*\u0014'F\rR\u0003\u0013a\u0003\"P)R{UJU%H\u0011R\u000bABQ(U)>k%+S$I)\u0002\n\u0001\u0002V(Q%&;\u0005\nV\u0001\n)>\u0003&+S$I)\u0002\n!a\u001d3\u0015\u0007i\f)\u0001E\u0002|\u0003\u0003i\u0011\u0001 \u0006\u0003{z\fA\u0001\\1oO*\tq0\u0001\u0003kCZ\f\u0017bAA\u0002y\n11\u000b\u001e:j]\u001eDa!a\u0002\"\u0001\u0004I\u0015!\u00013\u0002\u0005MlGc\u0001>\u0002\u000e!1\u0011q\u0001\u0012A\u0002%\u000bA!\\1sWRA\u00111CA\r\u0003;\t\t\u0003E\u0002[\u0003+I1!a\u0006\\\u0005)\u0019un\u001c:eS:\fG/\u001a\u0005\u0007\u00037\u0019\u0003\u0019A%\u0002\u0007\r|G\u000e\u0003\u0004\u0002 \r\u0002\r!S\u0001\u0004e><\bBBA\u0012G\u0001\u0007\u0011*A\u0001n\u0003%i\u0017m[3NCJ\\7\u000f\u0006\u0007\u0002*\u0005=\u00121IA#\u0003\u000f\nI\u0005E\u00022\u0003WI1!!\f3\u0005\r\te.\u001f\u0005\b\u0003c!\u0003\u0019AA\u001a\u0003\u0019\u0001x.\u001b8ugB1\u0011QGA \u0003'i!!a\u000e\u000b\t\u0005e\u00121H\u0001\b[V$\u0018M\u00197f\u0015\r\tiDM\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA!\u0003o\u00111\"\u0011:sCf\u0014UO\u001a4fe\"1\u00111\u0004\u0013A\u0002%Ca!a\b%\u0001\u0004I\u0005BBA\u0004I\u0001\u0007\u0011\n\u0003\u0004\u0002L\u0011\u0002\r!S\u0001\u0003a\u0012\f\u0011CZ5oI:+\u0007\u0010\u001e#je\u0016\u001cG/[8o)%I\u0015\u0011KA*\u0003+\n9\u0006\u0003\u0004\u0002\u001c\u0015\u0002\r!\u0013\u0005\u0007\u0003?)\u0003\u0019A%\t\r\u0005\u001dQ\u00051\u0001J\u0011\u0019\tI&\na\u0001\u0013\u0006YA/\u0019:hKR4\u0016\r\\;f\u000359W\r\u001e'j]\u0016\f'OU5oOV!\u0011qLA:)\u0019\t\t'a\u001a\u0002jA\u0019!,a\u0019\n\u0007\u0005\u00154L\u0001\u0006MS:,\u0017M\u001d*j]\u001eDa!!\u0017'\u0001\u0004I\u0005bBA6M\u0001\u0007\u0011QN\u0001\u000bgR\f'\u000f\u001e)pS:$\b#B\u0019\u0002p%K\u0015bAA9e\t1A+\u001e9mKJ\"q!!\u001e'\u0005\u0004\t9HA\u0001U#\u0011\tI(!\u000b\u0011\u0007E\nY(C\u0002\u0002~I\u0012qAT8uQ&tw\r")
public class Polygonizer {
    private final Tile r;
    private final RasterExtent rasterExtent;
    private final int cols;
    private final int rows;
    private final double halfCellWidth;
    private final double halfCellHeight;
    private final GeometryFactory jtsFactory;
    private final int NOTFOUND;
    private final int LEFT;
    private final int DOWN;
    private final int RIGHT;
    private final int UP;
    private final int TOPLEFT;
    private final int BOTTOMLEFT;
    private final int BOTTOMRIGHT;
    private final int TOPRIGHT;

    public Tile r() {
        return this.r;
    }

    public int cols() {
        return this.cols;
    }

    public int rows() {
        return this.rows;
    }

    public double halfCellWidth() {
        return this.halfCellWidth;
    }

    public double halfCellHeight() {
        return this.halfCellHeight;
    }

    public GeometryFactory jtsFactory() {
        return this.jtsFactory;
    }

    public int NOTFOUND() {
        return this.NOTFOUND;
    }

    public int LEFT() {
        return this.LEFT;
    }

    public int DOWN() {
        return this.DOWN;
    }

    public int RIGHT() {
        return this.RIGHT;
    }

    public int UP() {
        return this.UP;
    }

    public int TOPLEFT() {
        return this.TOPLEFT;
    }

    public int BOTTOMLEFT() {
        return this.BOTTOMLEFT;
    }

    public int BOTTOMRIGHT() {
        return this.BOTTOMRIGHT;
    }

    public int TOPRIGHT() {
        return this.TOPRIGHT;
    }

    public String sd(int d) {
        int n = d;
        String string2 = this.NOTFOUND() == n ? "NOTFOUND" : (this.LEFT() == n ? "LEFT" : (this.DOWN() == n ? "DOWN" : (this.RIGHT() == n ? "RIGHT" : (this.UP() == n ? "UP" : "BAD"))));
        return string2;
    }

    public String sm(int d) {
        int n = d;
        String string2 = this.TOPLEFT() == n ? "TOPLEFT" : (this.BOTTOMLEFT() == n ? "BOTTOMLEFT" : (this.BOTTOMRIGHT() == n ? "BOTTOMRIGHT" : (this.TOPRIGHT() == n ? "TOPRIGHT" : "BAD")));
        return string2;
    }

    public Coordinate mark(int col, int row, int m) {
        Coordinate coordinate;
        double mapX = this.rasterExtent.gridColToMap$mcI$sp(col);
        double mapY = this.rasterExtent.gridRowToMap$mcI$sp(row);
        if (m == this.TOPLEFT()) {
            coordinate = new Coordinate(mapX - this.halfCellWidth(), mapY + this.halfCellHeight());
        } else if (m == this.BOTTOMLEFT()) {
            coordinate = new Coordinate(mapX - this.halfCellWidth(), mapY - this.halfCellHeight());
        } else if (m == this.BOTTOMRIGHT()) {
            coordinate = new Coordinate(mapX + this.halfCellWidth(), mapY - this.halfCellHeight());
        } else if (m == this.TOPRIGHT()) {
            coordinate = new Coordinate(mapX + this.halfCellWidth(), mapY + this.halfCellHeight());
        } else {
            throw package$.MODULE$.error("Bad Mark Integer");
        }
        return coordinate;
    }

    public Object makeMarks(ArrayBuffer<Coordinate> points, int col, int row, int d, int pd) {
        BoxedUnit boxedUnit;
        if (d == this.DOWN()) {
            if (pd != this.DOWN()) {
                if (pd == this.RIGHT()) {
                    boxedUnit = points.$plus$eq((Object)this.mark(col, row - 1, this.BOTTOMLEFT()));
                } else if (pd == this.LEFT()) {
                    boxedUnit = points.$plus$eq((Object)this.mark(col, row - 1, this.TOPLEFT()));
                } else {
                    points.$plus$eq((Object)this.mark(col, row - 1, this.TOPRIGHT()));
                    boxedUnit = points.$plus$eq((Object)this.mark(col, row - 1, this.TOPLEFT()));
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else if (d == this.RIGHT()) {
            if (pd != this.RIGHT()) {
                if (pd == this.UP()) {
                    boxedUnit = points.$plus$eq((Object)this.mark(col - 1, row, this.BOTTOMRIGHT()));
                } else if (pd == this.DOWN()) {
                    boxedUnit = points.$plus$eq((Object)this.mark(col - 1, row, this.BOTTOMLEFT()));
                } else {
                    points.$plus$eq((Object)this.mark(col - 1, row, this.TOPLEFT()));
                    boxedUnit = points.$plus$eq((Object)this.mark(col - 1, row, this.BOTTOMLEFT()));
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else if (d == this.UP()) {
            if (pd != this.UP()) {
                if (pd == this.LEFT()) {
                    boxedUnit = points.$plus$eq((Object)this.mark(col, row + 1, this.TOPRIGHT()));
                } else if (pd == this.RIGHT()) {
                    boxedUnit = points.$plus$eq((Object)this.mark(col, row + 1, this.BOTTOMRIGHT()));
                } else {
                    points.$plus$eq((Object)this.mark(col, row + 1, this.BOTTOMLEFT()));
                    boxedUnit = points.$plus$eq((Object)this.mark(col, row + 1, this.BOTTOMRIGHT()));
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else if (d == this.LEFT()) {
            if (pd != this.LEFT()) {
                if (pd == this.DOWN()) {
                    boxedUnit = points.$plus$eq((Object)this.mark(col + 1, row, this.TOPLEFT()));
                } else if (pd == this.UP()) {
                    boxedUnit = points.$plus$eq((Object)this.mark(col + 1, row, this.TOPRIGHT()));
                } else {
                    points.$plus$eq((Object)this.mark(col + 1, row, this.BOTTOMRIGHT()));
                    boxedUnit = points.$plus$eq((Object)this.mark(col + 1, row, this.TOPRIGHT()));
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw package$.MODULE$.error(new StringBuilder(18).append("Unknown direction ").append(d).toString());
        }
        return boxedUnit;
    }

    public int findNextDirection(int col, int row, int d, int targetValue) {
        for (int i = d + 3; i < d + 7; ++i) {
            int m = i % 4;
            if (m == 0) {
                if (col <= 0 || this.r().get(col - 1, row) != targetValue) continue;
                return this.LEFT();
            }
            if (m == 1) {
                if (row + 1 >= this.rows() || this.r().get(col, row + 1) != targetValue) continue;
                return this.DOWN();
            }
            if (m == 2) {
                if (col + 1 >= this.cols() || this.r().get(col + 1, row) != targetValue) continue;
                return this.RIGHT();
            }
            if (m != 3 || row <= 0 || this.r().get(col, row - 1) != targetValue) continue;
            return this.UP();
        }
        return this.NOTFOUND();
    }

    public <T> LinearRing getLinearRing(int targetValue, Tuple2<Object, Object> startPoint) {
        ArrayBuffer arrayBuffer;
        ArrayBuffer points = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        int startCol = startPoint._1$mcI$sp();
        int startRow = startPoint._2$mcI$sp();
        int direction = this.NOTFOUND();
        if (startRow + 1 < this.rows() && this.r().get(startCol, startRow + 1) == targetValue) {
            direction = this.DOWN();
        }
        if (direction == this.NOTFOUND() && startCol + 1 < this.cols() && this.r().get(startCol + 1, startRow) == targetValue) {
            direction = this.RIGHT();
        }
        if (direction == this.NOTFOUND()) {
            points.$plus$eq((Object)this.mark(startCol, startRow, this.TOPLEFT()));
            points.$plus$eq((Object)this.mark(startCol, startRow, this.BOTTOMLEFT()));
            points.$plus$eq((Object)this.mark(startCol, startRow, this.BOTTOMRIGHT()));
            points.$plus$eq((Object)this.mark(startCol, startRow, this.TOPRIGHT()));
            arrayBuffer = points.$plus$eq((Object)this.mark(startCol, startRow, this.TOPLEFT()));
        } else {
            points.$plus$eq((Object)this.mark(startCol, startRow, this.TOPLEFT()));
            Object object = direction == this.RIGHT() ? points.$plus$eq((Object)this.mark(startCol, startRow, this.BOTTOMLEFT())) : BoxedUnit.UNIT;
            int previousDirection = direction;
            int col = startCol;
            int row = startRow;
            boolean bl = false;
            while (!bl) {
                if (direction == this.DOWN()) {
                    ++row;
                } else if (direction == this.RIGHT()) {
                    ++col;
                } else if (direction == this.UP()) {
                    --row;
                } else if (direction == this.LEFT()) {
                    --col;
                }
                this.makeMarks((ArrayBuffer<Coordinate>)points, col, row, direction, previousDirection);
                previousDirection = direction;
                direction = this.findNextDirection(col, row, direction, targetValue);
                if (col != startCol || row != startRow) continue;
                if (previousDirection == this.LEFT() || previousDirection == this.DOWN()) {
                    bl = true;
                    continue;
                }
                if (previousDirection != this.UP() && previousDirection != this.RIGHT() || direction != this.DOWN() && direction != this.LEFT()) continue;
                bl = true;
            }
            Object object2 = previousDirection == this.UP() ? points.$plus$eq((Object)this.mark(col, row, this.TOPRIGHT())) : BoxedUnit.UNIT;
            arrayBuffer = points.$plus$eq((Object)this.mark(startCol, startRow, this.TOPLEFT()));
        }
        return this.jtsFactory().createLinearRing((Coordinate[])points.toArray(ClassTag$.MODULE$.apply(Coordinate.class)));
    }

    public Polygonizer(Tile r, RasterExtent rasterExtent) {
        this.r = r;
        this.rasterExtent = rasterExtent;
        this.cols = r.cols$mcI$sp();
        this.rows = r.rows$mcI$sp();
        this.halfCellWidth = rasterExtent.cellwidth() / 2.0;
        this.halfCellHeight = rasterExtent.cellheight() / 2.0;
        this.jtsFactory = new GeometryFactory();
        this.NOTFOUND = -1;
        this.LEFT = 0;
        this.DOWN = 1;
        this.RIGHT = 2;
        this.UP = 3;
        this.TOPLEFT = 0;
        this.BOTTOMLEFT = 1;
        this.BOTTOMRIGHT = 2;
        this.TOPRIGHT = 3;
    }
}

