/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.vector.interpolation;

import geotrellis.vector.Feature;
import geotrellis.vector.Point$;
import geotrellis.vector.PointFeature$;
import geotrellis.vector.interpolation.Kriging;
import geotrellis.vector.interpolation.ModelType;
import geotrellis.vector.interpolation.NonLinearSemivariogram$;
import geotrellis.vector.interpolation.Semivariogram;
import geotrellis.vector.package$;
import java.io.Serializable;
import org.apache.commons.math3.linear.CholeskyDecomposition;
import org.apache.commons.math3.linear.EigenDecomposition;
import org.apache.commons.math3.linear.LUDecomposition;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.SingularValueDecomposition;
import org.locationtech.jts.geom.Point;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0001\u0005-q!B\n\u0015\u0011\u0003Yb!B\u000f\u0015\u0011\u0003q\u0002\"\u0002\u0015\u0002\t\u0003I\u0003\"\u0002\u0016\u0002\t\u0003Y\u0003\"\u0002\u0016\u0002\t\u0003\u0011\u0006\"\u0002\u0016\u0002\t\u00031\u0006\"\u0002\u0016\u0002\t\u0003Q\u0006\"\u0002\u0016\u0002\t\u0003i\u0006\"\u0002\u0016\u0002\t\u0003\t\u0007\"\u0002\u0016\u0002\t\u0003!\u0007\"\u0002\u0016\u0002\t\u00039\u0007bB5\u0002\u0003\u0003%IA\u001b\u0004\u0005;Q\u00011\u000f\u0003\u00051\u0019\t\u0005\t\u0015!\u00032\u0011!1EB!A!\u0002\u00139\u0005\u0002\u0003'\r\u0005\u0003\u0005\u000b\u0011\u0002\"\t\u00119c!\u0011!Q\u0001\n=CQ\u0001\u000b\u0007\u0005\u0002QDQA\u001f\u0007\u0005\u0012m\f!bR3p\u0017JLw-\u001b8h\u0015\t)b#A\u0007j]R,'\u000f]8mCRLwN\u001c\u0006\u0003/a\taA^3di>\u0014(\"A\r\u0002\u0015\u001d,w\u000e\u001e:fY2L7o\u0001\u0001\u0011\u0005q\tQ\"\u0001\u000b\u0003\u0015\u001d+wn\u0013:jO&twmE\u0002\u0002?\u0015\u0002\"\u0001I\u0012\u000e\u0003\u0005R\u0011AI\u0001\u0006g\u000e\fG.Y\u0005\u0003I\u0005\u0012a!\u00118z%\u00164\u0007C\u0001\u0011'\u0013\t9\u0013E\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0001\u0004=S:LGO\u0010\u000b\u00027\u0005)\u0011\r\u001d9msR)AfL#L\u001bB\u0011A$L\u0005\u0003]Q\u0011qa\u0013:jO&tw\rC\u00031\u0007\u0001\u0007\u0011'\u0001\u0004q_&tGo\u001d\t\u0004AI\"\u0014BA\u001a\"\u0005\u0015\t%O]1z!\r)tH\u0011\b\u0003mur!a\u000e\u001f\u000f\u0005aZT\"A\u001d\u000b\u0005iR\u0012A\u0002\u001fs_>$h(C\u0001\u001a\u0013\t9\u0002$\u0003\u0002?-\u00059\u0001/Y2lC\u001e,\u0017B\u0001!B\u00051\u0001v.\u001b8u\r\u0016\fG/\u001e:f\u0015\tqd\u0003\u0005\u0002!\u0007&\u0011A)\t\u0002\u0007\t>,(\r\\3\t\u000b\u0019\u001b\u0001\u0019A$\u0002\u0011\u0005$HO\u001d$v]\u000e\u0004R\u0001\t%C\u0005*K!!S\u0011\u0003\u0013\u0019+hn\u0019;j_:\u0014\u0004c\u0001\u00113\u0005\")Aj\u0001a\u0001\u0005\u0006I!-\u00198eo&$G\u000f\u001b\u0005\u0006\u001d\u000e\u0001\raT\u0001\u0006[>$W\r\u001c\t\u00039AK!!\u0015\u000b\u0003\u00135{G-\u001a7UsB,G\u0003\u0002\u0017T)VCQ\u0001\r\u0003A\u0002EBQA\u0012\u0003A\u0002\u001dCQA\u0014\u0003A\u0002=#B\u0001L,Y3\")\u0001'\u0002a\u0001c!)a)\u0002a\u0001\u000f\")A*\u0002a\u0001\u0005R\u0019Af\u0017/\t\u000bA2\u0001\u0019A\u0019\t\u000b\u00193\u0001\u0019A$\u0015\t1rv\f\u0019\u0005\u0006a\u001d\u0001\r!\r\u0005\u0006\u0019\u001e\u0001\rA\u0011\u0005\u0006\u001d\u001e\u0001\ra\u0014\u000b\u0004Y\t\u001c\u0007\"\u0002\u0019\t\u0001\u0004\t\u0004\"\u0002(\t\u0001\u0004yEc\u0001\u0017fM\")\u0001'\u0003a\u0001c!)A*\u0003a\u0001\u0005R\u0011A\u0006\u001b\u0005\u0006a)\u0001\r!M\u0001\fe\u0016\fGMU3t_24X\rF\u0001l!\ta\u0017/D\u0001n\u0015\tqw.\u0001\u0003mC:<'\"\u00019\u0002\t)\fg/Y\u0005\u0003e6\u0014aa\u00142kK\u000e$8c\u0001\u0007 YQ)QO^<ysB\u0011A\u0004\u0004\u0005\u0006aE\u0001\r!\r\u0005\u0006\rF\u0001\ra\u0012\u0005\u0006\u0019F\u0001\rA\u0011\u0005\u0006\u001dF\u0001\raT\u0001\u0014GJ,\u0017\r^3Qe\u0016$\u0017n\u0019;pe&s\u0017\u000e\u001e\u000b\u0004y\u0006\u0005\u0001#\u0002\u0011I\u0005\nk\b\u0003\u0002\u0011\u007f\u0005\nK!a`\u0011\u0003\rQ+\b\u000f\\33\u0011\u001d\t\u0019A\u0005a\u0001\u0003\u000b\taB\\;nE\u0016\u0014xJ\u001a)pS:$8\u000fE\u0002!\u0003\u000fI1!!\u0003\"\u0005\rIe\u000e\u001e")
public class GeoKriging
implements Kriging {
    private final Feature<Point, Object>[] points;
    private final Function2<Object, Object, double[]> attrFunc;
    private final double bandwidth;
    private final ModelType model;
    private Function2<Object, Object, Tuple2<Object, Object>> geotrellis$vector$interpolation$Kriging$$_apply;
    private volatile boolean bitmap$0;

    @Override
    public RealMatrix varianceMatrixGen(Semivariogram sv, Feature<Point, Object>[] points) {
        return Kriging.varianceMatrixGen$(this, sv, points);
    }

    @Override
    public Tuple2<Object, Object>[] getPointDistancesSorted(Feature<Point, Object>[] points, int minPoints, double bandwidth, Point point) {
        return Kriging.getPointDistancesSorted$(this, points, minPoints, bandwidth, point);
    }

    @Override
    public double[] absArray(double[] arr) {
        return Kriging.absArray$(this, arr);
    }

    @Override
    public Tuple2<Object, Object> apply(double x, double y) {
        return Kriging.apply$(this, x, y);
    }

    @Override
    public Tuple2<Object, Object>[] predict(Point[] pointMatrix) {
        return Kriging.predict$(this, pointMatrix);
    }

    public boolean apply$mcZDD$sp(double v1, double v2) {
        return Function2.apply$mcZDD$sp$((Function2)this, (double)v1, (double)v2);
    }

    public double apply$mcDDD$sp(double v1, double v2) {
        return Function2.apply$mcDDD$sp$((Function2)this, (double)v1, (double)v2);
    }

    public float apply$mcFDD$sp(double v1, double v2) {
        return Function2.apply$mcFDD$sp$((Function2)this, (double)v1, (double)v2);
    }

    public int apply$mcIDD$sp(double v1, double v2) {
        return Function2.apply$mcIDD$sp$((Function2)this, (double)v1, (double)v2);
    }

    public long apply$mcJDD$sp(double v1, double v2) {
        return Function2.apply$mcJDD$sp$((Function2)this, (double)v1, (double)v2);
    }

    public void apply$mcVDD$sp(double v1, double v2) {
        Function2.apply$mcVDD$sp$((Function2)this, (double)v1, (double)v2);
    }

    public boolean apply$mcZDI$sp(double v1, int v2) {
        return Function2.apply$mcZDI$sp$((Function2)this, (double)v1, (int)v2);
    }

    public double apply$mcDDI$sp(double v1, int v2) {
        return Function2.apply$mcDDI$sp$((Function2)this, (double)v1, (int)v2);
    }

    public float apply$mcFDI$sp(double v1, int v2) {
        return Function2.apply$mcFDI$sp$((Function2)this, (double)v1, (int)v2);
    }

    public int apply$mcIDI$sp(double v1, int v2) {
        return Function2.apply$mcIDI$sp$((Function2)this, (double)v1, (int)v2);
    }

    public long apply$mcJDI$sp(double v1, int v2) {
        return Function2.apply$mcJDI$sp$((Function2)this, (double)v1, (int)v2);
    }

    public void apply$mcVDI$sp(double v1, int v2) {
        Function2.apply$mcVDI$sp$((Function2)this, (double)v1, (int)v2);
    }

    public boolean apply$mcZDJ$sp(double v1, long v2) {
        return Function2.apply$mcZDJ$sp$((Function2)this, (double)v1, (long)v2);
    }

    public double apply$mcDDJ$sp(double v1, long v2) {
        return Function2.apply$mcDDJ$sp$((Function2)this, (double)v1, (long)v2);
    }

    public float apply$mcFDJ$sp(double v1, long v2) {
        return Function2.apply$mcFDJ$sp$((Function2)this, (double)v1, (long)v2);
    }

    public int apply$mcIDJ$sp(double v1, long v2) {
        return Function2.apply$mcIDJ$sp$((Function2)this, (double)v1, (long)v2);
    }

    public long apply$mcJDJ$sp(double v1, long v2) {
        return Function2.apply$mcJDJ$sp$((Function2)this, (double)v1, (long)v2);
    }

    public void apply$mcVDJ$sp(double v1, long v2) {
        Function2.apply$mcVDJ$sp$((Function2)this, (double)v1, (long)v2);
    }

    public boolean apply$mcZID$sp(int v1, double v2) {
        return Function2.apply$mcZID$sp$((Function2)this, (int)v1, (double)v2);
    }

    public double apply$mcDID$sp(int v1, double v2) {
        return Function2.apply$mcDID$sp$((Function2)this, (int)v1, (double)v2);
    }

    public float apply$mcFID$sp(int v1, double v2) {
        return Function2.apply$mcFID$sp$((Function2)this, (int)v1, (double)v2);
    }

    public int apply$mcIID$sp(int v1, double v2) {
        return Function2.apply$mcIID$sp$((Function2)this, (int)v1, (double)v2);
    }

    public long apply$mcJID$sp(int v1, double v2) {
        return Function2.apply$mcJID$sp$((Function2)this, (int)v1, (double)v2);
    }

    public void apply$mcVID$sp(int v1, double v2) {
        Function2.apply$mcVID$sp$((Function2)this, (int)v1, (double)v2);
    }

    public boolean apply$mcZII$sp(int v1, int v2) {
        return Function2.apply$mcZII$sp$((Function2)this, (int)v1, (int)v2);
    }

    public double apply$mcDII$sp(int v1, int v2) {
        return Function2.apply$mcDII$sp$((Function2)this, (int)v1, (int)v2);
    }

    public float apply$mcFII$sp(int v1, int v2) {
        return Function2.apply$mcFII$sp$((Function2)this, (int)v1, (int)v2);
    }

    public int apply$mcIII$sp(int v1, int v2) {
        return Function2.apply$mcIII$sp$((Function2)this, (int)v1, (int)v2);
    }

    public long apply$mcJII$sp(int v1, int v2) {
        return Function2.apply$mcJII$sp$((Function2)this, (int)v1, (int)v2);
    }

    public void apply$mcVII$sp(int v1, int v2) {
        Function2.apply$mcVII$sp$((Function2)this, (int)v1, (int)v2);
    }

    public boolean apply$mcZIJ$sp(int v1, long v2) {
        return Function2.apply$mcZIJ$sp$((Function2)this, (int)v1, (long)v2);
    }

    public double apply$mcDIJ$sp(int v1, long v2) {
        return Function2.apply$mcDIJ$sp$((Function2)this, (int)v1, (long)v2);
    }

    public float apply$mcFIJ$sp(int v1, long v2) {
        return Function2.apply$mcFIJ$sp$((Function2)this, (int)v1, (long)v2);
    }

    public int apply$mcIIJ$sp(int v1, long v2) {
        return Function2.apply$mcIIJ$sp$((Function2)this, (int)v1, (long)v2);
    }

    public long apply$mcJIJ$sp(int v1, long v2) {
        return Function2.apply$mcJIJ$sp$((Function2)this, (int)v1, (long)v2);
    }

    public void apply$mcVIJ$sp(int v1, long v2) {
        Function2.apply$mcVIJ$sp$((Function2)this, (int)v1, (long)v2);
    }

    public boolean apply$mcZJD$sp(long v1, double v2) {
        return Function2.apply$mcZJD$sp$((Function2)this, (long)v1, (double)v2);
    }

    public double apply$mcDJD$sp(long v1, double v2) {
        return Function2.apply$mcDJD$sp$((Function2)this, (long)v1, (double)v2);
    }

    public float apply$mcFJD$sp(long v1, double v2) {
        return Function2.apply$mcFJD$sp$((Function2)this, (long)v1, (double)v2);
    }

    public int apply$mcIJD$sp(long v1, double v2) {
        return Function2.apply$mcIJD$sp$((Function2)this, (long)v1, (double)v2);
    }

    public long apply$mcJJD$sp(long v1, double v2) {
        return Function2.apply$mcJJD$sp$((Function2)this, (long)v1, (double)v2);
    }

    public void apply$mcVJD$sp(long v1, double v2) {
        Function2.apply$mcVJD$sp$((Function2)this, (long)v1, (double)v2);
    }

    public boolean apply$mcZJI$sp(long v1, int v2) {
        return Function2.apply$mcZJI$sp$((Function2)this, (long)v1, (int)v2);
    }

    public double apply$mcDJI$sp(long v1, int v2) {
        return Function2.apply$mcDJI$sp$((Function2)this, (long)v1, (int)v2);
    }

    public float apply$mcFJI$sp(long v1, int v2) {
        return Function2.apply$mcFJI$sp$((Function2)this, (long)v1, (int)v2);
    }

    public int apply$mcIJI$sp(long v1, int v2) {
        return Function2.apply$mcIJI$sp$((Function2)this, (long)v1, (int)v2);
    }

    public long apply$mcJJI$sp(long v1, int v2) {
        return Function2.apply$mcJJI$sp$((Function2)this, (long)v1, (int)v2);
    }

    public void apply$mcVJI$sp(long v1, int v2) {
        Function2.apply$mcVJI$sp$((Function2)this, (long)v1, (int)v2);
    }

    public boolean apply$mcZJJ$sp(long v1, long v2) {
        return Function2.apply$mcZJJ$sp$((Function2)this, (long)v1, (long)v2);
    }

    public double apply$mcDJJ$sp(long v1, long v2) {
        return Function2.apply$mcDJJ$sp$((Function2)this, (long)v1, (long)v2);
    }

    public float apply$mcFJJ$sp(long v1, long v2) {
        return Function2.apply$mcFJJ$sp$((Function2)this, (long)v1, (long)v2);
    }

    public int apply$mcIJJ$sp(long v1, long v2) {
        return Function2.apply$mcIJJ$sp$((Function2)this, (long)v1, (long)v2);
    }

    public long apply$mcJJJ$sp(long v1, long v2) {
        return Function2.apply$mcJJJ$sp$((Function2)this, (long)v1, (long)v2);
    }

    public void apply$mcVJJ$sp(long v1, long v2) {
        Function2.apply$mcVJJ$sp$((Function2)this, (long)v1, (long)v2);
    }

    public Function1<Object, Function1<Object, Tuple2<Object, Object>>> curried() {
        return Function2.curried$((Function2)this);
    }

    public Function1<Tuple2<Object, Object>, Tuple2<Object, Object>> tupled() {
        return Function2.tupled$((Function2)this);
    }

    public String toString() {
        return Function2.toString$((Function2)this);
    }

    private Function2<Object, Object, Tuple2<Object, Object>> geotrellis$vector$interpolation$Kriging$$_apply$lzycompute() {
        GeoKriging geoKriging = this;
        synchronized (geoKriging) {
            if (!this.bitmap$0) {
                this.geotrellis$vector$interpolation$Kriging$$_apply = Kriging.geotrellis$vector$interpolation$Kriging$$_apply$(this);
                this.bitmap$0 = true;
            }
        }
        return this.geotrellis$vector$interpolation$Kriging$$_apply;
    }

    @Override
    public Function2<Object, Object, Tuple2<Object, Object>> geotrellis$vector$interpolation$Kriging$$_apply() {
        return !this.bitmap$0 ? this.geotrellis$vector$interpolation$Kriging$$_apply$lzycompute() : this.geotrellis$vector$interpolation$Kriging$$_apply;
    }

    @Override
    public Function2<Object, Object, Tuple2<Object, Object>> createPredictorInit(int numberOfPoints) {
        int n = this.points.length;
        if (n == 0) {
            throw new IllegalArgumentException("No points in the training dataset");
        }
        RealMatrix unitCol = MatrixUtils.createColumnRealMatrix((double[])((double[])Array$.MODULE$.fill(n, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 1.0, ClassTag$.MODULE$.Double())));
        RealMatrix attrMatrix = MatrixUtils.createRealMatrix((double[][])((double[][])Array$.MODULE$.tabulate(n, (Function1 & Serializable & scala.Serializable)i -> GeoKriging.$anonfun$createPredictorInit$2(this, BoxesRunTime.unboxToInt((Object)i)), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)))));
        int attrSize = attrMatrix.getColumnDimension() - 1;
        RealMatrix scale = new LUDecomposition(MatrixUtils.createRealDiagonalMatrix((double[])((double[])Array$.MODULE$.tabulate(attrSize + 1, (Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)i -> BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(this.absArray(attrMatrix.getColumn(i)))).max((Ordering)Ordering.Double$.MODULE$)), ClassTag$.MODULE$.Double())))).getSolver().getInverse();
        RealMatrix attrMatrixScaled = attrMatrix.multiply(scale);
        RealMatrix ptData = MatrixUtils.createColumnRealMatrix((double[])((double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.points)).map((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToDouble((double)GeoKriging.$anonfun$createPredictorInit$4(x)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))));
        RealMatrix unscaledBetaOLS = new SingularValueDecomposition(attrMatrixScaled).getSolver().solve(ptData);
        RealMatrix betaOLS = scale.multiply(unscaledBetaOLS);
        RealMatrix errorOLS = ptData.subtract(attrMatrix.multiply(betaOLS));
        Feature[] pointsFitting = (Feature[])Array$.MODULE$.tabulate(n, (Function1 & Serializable & scala.Serializable)row -> PointFeature$.MODULE$.apply(this.points[BoxesRunTime.unboxToInt((Object)row)].geom(), BoxesRunTime.boxToDouble((double)errorOLS.getEntry(BoxesRunTime.unboxToInt((Object)row), 0))), ClassTag$.MODULE$.apply(Feature.class));
        ObjectRef res = ObjectRef.create((Object)NonLinearSemivariogram$.MODULE$.apply(pointsFitting, 0.0, 0, this.model));
        double delta = 1.0;
        int counter = 0;
        ObjectRef betaEval = ObjectRef.create((Object)betaOLS);
        while (delta > 0.001) {
            RealMatrix realMatrix;
            ++counter;
            RealMatrix eyen = MatrixUtils.createRealIdentityMatrix((int)n);
            RealMatrix covariogramMatrixIter = unitCol.multiply(unitCol.transpose()).scalarMultiply(((Semivariogram)res.elem).sill()).subtract(this.varianceMatrixGen((Semivariogram)res.elem, this.points)).add(eyen.scalarMultiply(((Semivariogram)res.elem).nugget()));
            try {
                realMatrix = new SingularValueDecomposition(new CholeskyDecomposition(covariogramMatrixIter).getL()).getSolver().solve(eyen);
            }
            catch (Exception exception) {
                realMatrix = new SingularValueDecomposition(new CholeskyDecomposition(covariogramMatrixIter.add(eyen.scalarMultiply(1.0E-7))).getL()).getSolver().solve(eyen);
            }
            RealMatrix covariogramInv = realMatrix;
            RealMatrix unscaledBeta = new SingularValueDecomposition(covariogramInv.multiply(attrMatrixScaled)).getSolver().solve(covariogramInv.multiply(ptData));
            RealMatrix beta = scale.multiply(unscaledBeta);
            RealMatrix errorIter = ptData.subtract(attrMatrix.multiply(beta));
            Feature[] pointsFittingIter = (Feature[])Array$.MODULE$.tabulate(n, (Function1 & Serializable & scala.Serializable)row -> PointFeature$.MODULE$.apply(this.points[BoxesRunTime.unboxToInt((Object)row)].geom(), BoxesRunTime.boxToDouble((double)errorIter.getEntry(BoxesRunTime.unboxToInt((Object)row), 0))), ClassTag$.MODULE$.apply(Feature.class));
            double[] process = beta.subtract((RealMatrix)betaEval.elem).getColumn(0);
            betaEval.elem = beta;
            delta = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(this.absArray((double[])Array$.MODULE$.tabulate(process.length, (Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)i -> scala.math.package$.MODULE$.abs(process[i]) / ((RealMatrix)betaEval$1.elem).getEntry(i, 0), ClassTag$.MODULE$.Double())))).max((Ordering)Ordering.Double$.MODULE$));
            if (!(delta > 1.0E-4)) continue;
            res.elem = NonLinearSemivariogram$.MODULE$.apply(pointsFittingIter, 0.0, 0, this.model);
            if (counter <= 100) continue;
            delta = 1.0E-4;
        }
        RealMatrix covariogramMatrix = unitCol.multiply(unitCol.transpose()).scalarMultiply(((Semivariogram)res.elem).sill()).subtract(this.varianceMatrixGen((Semivariogram)res.elem, this.points)).add(MatrixUtils.createRealIdentityMatrix((int)n).scalarMultiply(((Semivariogram)res.elem).nugget()));
        RealMatrix residual = ptData.subtract(attrMatrix.multiply((RealMatrix)betaEval.elem));
        return (Function2 & Serializable & scala.Serializable)(x, y) -> GeoKriging.$anonfun$createPredictorInit$8(this, attrSize, covariogramMatrix, unitCol, res, betaEval, residual, attrMatrix, attrMatrixScaled, scale, BoxesRunTime.unboxToDouble((Object)x), BoxesRunTime.unboxToDouble((Object)y));
    }

    public static final /* synthetic */ double[] $anonfun$createPredictorInit$2(GeoKriging $this, int i) {
        return (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(new double[]{1.0})).$plus$plus((GenTraversableOnce)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])$this.attrFunc.apply((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.withExtraPointMethods($this.points[i].geom()).x()), (Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.withExtraPointMethods($this.points[i].geom()).y())))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
    }

    public static final /* synthetic */ double $anonfun$createPredictorInit$4(Feature x) {
        return BoxesRunTime.unboxToDouble(x.data());
    }

    public static final /* synthetic */ Tuple2 $anonfun$createPredictorInit$8(GeoKriging $this, int attrSize$1, RealMatrix covariogramMatrix$1, RealMatrix unitCol$1, ObjectRef res$1, ObjectRef betaEval$1, RealMatrix residual$1, RealMatrix attrMatrix$1, RealMatrix attrMatrixScaled$1, RealMatrix scale$1, double x, double y) {
        Point pointPredict = Point$.MODULE$.apply(x, y);
        Tuple2<Object, Object>[] distSortedInfo = $this.getPointDistancesSorted($this.points, attrSize$1 + 2, $this.bandwidth, pointPredict);
        int[] distanceID = (int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])distSortedInfo)).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1._1$mcI$sp()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
        RealMatrix localCovarianceInv = new SingularValueDecomposition(covariogramMatrix$1.getSubMatrix(distanceID, distanceID)).getSolver().getInverse();
        RealMatrix sortedDist = MatrixUtils.createColumnRealMatrix((double[])((double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])distSortedInfo)).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToDouble((double)x$2._2$mcD$sp()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))));
        RealMatrix localCovVector = unitCol$1.getSubMatrix(distanceID, new int[]{0}).scalarMultiply(((Semivariogram)res$1.elem).sill()).subtract(MatrixUtils.createRealMatrix((double[][])((double[][])Array$.MODULE$.tabulate(distanceID.length, 1, (Function2)(JFunction2.mcDII.sp & Serializable & scala.Serializable)(i, x$3) -> ((Semivariogram)res$1.elem).apply(sortedDist.getEntry(i, 0)), ClassTag$.MODULE$.Double()))));
        for (int index$macro$1 = 0; index$macro$1 < distanceID.length; ++index$macro$1) {
            if (sortedDist.getEntry(index$macro$1, 0) != 0.0) continue;
            localCovVector.setEntry(index$macro$1, 0, localCovVector.getEntry(index$macro$1, 0) + ((Semivariogram)res$1.elem).nugget());
        }
        double[] curAttrVal = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(new double[]{1.0})).$plus$plus((GenTraversableOnce)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])$this.attrFunc.apply((Object)BoxesRunTime.boxToDouble((double)x), (Object)BoxesRunTime.boxToDouble((double)y)))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        double kPredict = MatrixUtils.createRowRealMatrix((double[])curAttrVal).multiply((RealMatrix)betaEval$1.elem).getEntry(0, 0) + localCovVector.transpose().multiply(localCovarianceInv).multiply(residual$1.getSubMatrix(distanceID, new int[]{0})).getEntry(0, 0);
        int[] colID = (int[])RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), attrMatrix$1.getColumnDimension() - 1).toArray(ClassTag$.MODULE$.Int());
        RealMatrix sampleAttrSelect = attrMatrix$1.getSubMatrix(distanceID, colID);
        RealMatrix attrMatrixScaledSelect = attrMatrixScaled$1.getSubMatrix(distanceID, colID);
        int rankTemp = new SingularValueDecomposition(attrMatrixScaledSelect.transpose().multiply(localCovarianceInv).multiply(attrMatrixScaledSelect)).getRank();
        RealMatrix xtVinvXTemp = attrMatrixScaledSelect.transpose().multiply(localCovarianceInv).multiply(attrMatrixScaledSelect);
        RealMatrix xtVinvX = rankTemp < attrSize$1 + 1 ? scale$1.multiply(new SingularValueDecomposition(xtVinvXTemp).getSolver().getInverse()).multiply(scale$1) : scale$1.multiply(new EigenDecomposition(xtVinvXTemp).getSolver().getInverse()).multiply(scale$1);
        RealMatrix kVarTemp = MatrixUtils.createColumnRealMatrix((double[])curAttrVal).subtract(sampleAttrSelect.transpose().multiply(localCovarianceInv).multiply(localCovVector));
        double kVar = scala.math.package$.MODULE$.sqrt(((Semivariogram)res$1.elem).sill() - localCovVector.transpose().multiply(localCovarianceInv).multiply(localCovVector).getEntry(0, 0) + kVarTemp.transpose().multiply(xtVinvX).multiply(kVarTemp).getEntry(0, 0));
        return new Tuple2.mcDD.sp(kPredict, kVar);
    }

    public GeoKriging(Feature<Point, Object>[] points, Function2<Object, Object, double[]> attrFunc, double bandwidth, ModelType model) {
        this.points = points;
        this.attrFunc = attrFunc;
        this.bandwidth = bandwidth;
        this.model = model;
        Function2.$init$((Function2)this);
        Kriging.$init$(this);
    }
}

