/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.vector.io.wkb;

import geotrellis.vector.GeomFactory$;
import geotrellis.vector.io.wkb.WKBWriter;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.WKBReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxesRunTime;

public final class WKB$ {
    public static WKB$ MODULE$;
    private transient Logger logger;
    private final ThreadLocal<WKBReader> readerBox;
    private final ThreadLocal<WKBWriter> writerBox;
    private volatile transient boolean bitmap$trans$0;

    static {
        new WKB$();
    }

    private ThreadLocal<WKBReader> readerBox() {
        return this.readerBox;
    }

    private ThreadLocal<WKBWriter> writerBox() {
        return this.writerBox;
    }

    private Logger logger$lzycompute() {
        WKB$ wKB$ = this;
        synchronized (wKB$) {
            if (!this.bitmap$trans$0) {
                this.logger = LoggerFactory.getLogger((String)"geotrellis.vector.io.wkb.WKB");
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    private Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public Geometry read(byte[] value) {
        block1: {
            if (this.logger().isDebugEnabled()) {
                this.logger().debug(new StringBuilder(24).append("Reading WKB from bytes: ").append(new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(value)).toList()).toString());
            }
            if (this.readerBox().get() != null) break block1;
            this.readerBox().set(new WKBReader(GeomFactory$.MODULE$.factory()));
        }
        return this.readerBox().get().read(value);
    }

    public Geometry read(String hex) {
        block1: {
            if (this.logger().isDebugEnabled()) {
                this.logger().debug(new StringBuilder(22).append("Reading WKB from hex: ").append(hex).toString());
            }
            if (this.readerBox().get() != null) break block1;
            this.readerBox().set(new WKBReader(GeomFactory$.MODULE$.factory()));
        }
        return this.readerBox().get().read(WKBReader.hexToBytes((String)hex));
    }

    public byte[] write(Geometry geom, int srid) {
        byte[] byArray;
        if (this.writerBox().get() == null) {
            this.writerBox().set(new WKBWriter(2));
        }
        if (srid == 0) {
            WKBWriter qual$1 = this.writerBox().get();
            Geometry x$1 = geom;
            Option<Object> x$2 = qual$1.write$default$2();
            byArray = qual$1.write(x$1, x$2);
        } else {
            byArray = this.writerBox().get().write(geom, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)srid)));
        }
        return byArray;
    }

    public int write$default$2() {
        return 0;
    }

    private WKB$() {
        MODULE$ = this;
        this.readerBox = new ThreadLocal();
        this.writerBox = new ThreadLocal();
    }
}

