/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.vector.triangulation;

import geotrellis.util.Direction;
import geotrellis.util.Direction$Bottom$;
import geotrellis.util.Direction$BottomLeft$;
import geotrellis.util.Direction$BottomRight$;
import geotrellis.util.Direction$Center$;
import geotrellis.util.Direction$Left$;
import geotrellis.util.Direction$Right$;
import geotrellis.util.Direction$Top$;
import geotrellis.util.Direction$TopLeft$;
import geotrellis.util.Direction$TopRight$;
import geotrellis.vector.Extent;
import geotrellis.vector.MultiPolygon$;
import geotrellis.vector.Polygon$;
import geotrellis.vector.io.wkt.WKT$;
import geotrellis.vector.mesh.CompleteIndexedPointSet;
import geotrellis.vector.mesh.HalfEdgeTable;
import geotrellis.vector.mesh.IndexedPointSet;
import geotrellis.vector.mesh.IndexedPointSet$;
import geotrellis.vector.triangulation.BoundaryDelaunay;
import geotrellis.vector.triangulation.DelaunayStitcher;
import geotrellis.vector.triangulation.DelaunayTriangulation;
import geotrellis.vector.triangulation.StitchedDelaunay;
import geotrellis.vector.triangulation.TriangleMap;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple5;
import scala.collection.GenIterable;
import scala.collection.Iterable$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set$;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Set;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class StitchedDelaunay$
implements scala.Serializable {
    public static StitchedDelaunay$ MODULE$;

    static {
        new StitchedDelaunay$();
    }

    public Tuple3<Object, IndexedPointSet, Map<Direction, Map<Object, Object>>> combinedPointSet(DelaunayTriangulation center, Map<Direction, Tuple2<BoundaryDelaunay, Extent>> neighbors) {
        Direction$Center$ direction$Center$ = Direction$Center$.MODULE$;
        Seq regions = (Seq)((SeqLike)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Product[]{Direction$Left$.MODULE$, Direction$BottomLeft$.MODULE$, Direction$Bottom$.MODULE$, Direction$BottomRight$.MODULE$, Direction$Right$.MODULE$, Direction$TopRight$.MODULE$, Direction$Top$.MODULE$, Direction$TopLeft$.MODULE$}))).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)StitchedDelaunay$.$anonfun$combinedPointSet$1(neighbors, x$1)))).$plus$colon((Object)direction$Center$, Seq$.MODULE$.canBuildFrom());
        Seq ptCounts = (Seq)regions.map((Function1 & Serializable & scala.Serializable)dir -> BoxesRunTime.boxToInteger((int)StitchedDelaunay$.$anonfun$combinedPointSet$2(center, neighbors, dir)), Seq$.MODULE$.canBuildFrom());
        Map countMap = ((TraversableOnce)regions.zip((GenIterable)ptCounts, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Map startIndices = ((TraversableOnce)regions.zip((GenIterable)ptCounts.foldLeft((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), (Function2 & Serializable & scala.Serializable)(accum, count) -> StitchedDelaunay$.$anonfun$combinedPointSet$3(accum, BoxesRunTime.unboxToInt((Object)count))), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        int vertCount = BoxesRunTime.unboxToInt((Object)ptCounts.sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Coordinate[] points = (Coordinate[])Array$.MODULE$.ofDim(vertCount, ClassTag$.MODULE$.apply(Coordinate.class));
        Map vtrans = ((TraversableOnce)regions.map((Function1 & Serializable & scala.Serializable)dir -> new Tuple2(dir, (Object)StitchedDelaunay$.vertIndices$1(dir, center, neighbors, startIndices, countMap)), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        regions.foreach((Function1 & Serializable & scala.Serializable)dir -> {
            StitchedDelaunay$.$anonfun$combinedPointSet$5(vtrans, center, neighbors, points, dir);
            return BoxedUnit.UNIT;
        });
        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)vertCount), (Object)IndexedPointSet$.MODULE$.apply(points), (Object)vtrans);
    }

    public Tuple3<Object, IndexedPointSet, Map<Direction, Map<Object, Object>>> combinedPointSet(Map<Direction, Tuple2<BoundaryDelaunay, Extent>> neighbors) {
        Seq regions = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Product[]{Direction$Center$.MODULE$, Direction$Left$.MODULE$, Direction$BottomLeft$.MODULE$, Direction$Bottom$.MODULE$, Direction$BottomRight$.MODULE$, Direction$Right$.MODULE$, Direction$TopRight$.MODULE$, Direction$Top$.MODULE$, Direction$TopLeft$.MODULE$}))).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)StitchedDelaunay$.$anonfun$combinedPointSet$7(neighbors, x$3)));
        Seq ptCounts = (Seq)regions.map((Function1 & Serializable & scala.Serializable)dir -> BoxesRunTime.boxToInteger((int)StitchedDelaunay$.$anonfun$combinedPointSet$8(neighbors, dir)), Seq$.MODULE$.canBuildFrom());
        Map countMap = ((TraversableOnce)regions.zip((GenIterable)ptCounts, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Map startIndices = ((TraversableOnce)regions.zip((GenIterable)ptCounts.foldLeft((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), (Function2 & Serializable & scala.Serializable)(accum, count) -> StitchedDelaunay$.$anonfun$combinedPointSet$11(accum, BoxesRunTime.unboxToInt((Object)count))), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        int vertCount = BoxesRunTime.unboxToInt((Object)ptCounts.sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Coordinate[] points = (Coordinate[])Array$.MODULE$.ofDim(vertCount, ClassTag$.MODULE$.apply(Coordinate.class));
        Map vtrans = ((TraversableOnce)regions.map((Function1 & Serializable & scala.Serializable)dir -> new Tuple2(dir, (Object)StitchedDelaunay$.vertIndices$2(dir, neighbors, startIndices, countMap)), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        regions.foreach((Function1 & Serializable & scala.Serializable)dir -> {
            StitchedDelaunay$.$anonfun$combinedPointSet$13(vtrans, neighbors, points, dir);
            return BoxedUnit.UNIT;
        });
        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)vertCount), (Object)IndexedPointSet$.MODULE$.apply(points), (Object)vtrans);
    }

    public Tuple3<Object, IndexedPointSet, Map<Direction, Map<Object, Object>>> combinedPointSet(Map<Direction, Tuple2<DelaunayTriangulation, Extent>> neighbors, Predef.DummyImplicit dummy) {
        Seq regions = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Product[]{Direction$Center$.MODULE$, Direction$Left$.MODULE$, Direction$BottomLeft$.MODULE$, Direction$Bottom$.MODULE$, Direction$BottomRight$.MODULE$, Direction$Right$.MODULE$, Direction$TopRight$.MODULE$, Direction$Top$.MODULE$, Direction$TopLeft$.MODULE$}))).filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)StitchedDelaunay$.$anonfun$combinedPointSet$15(neighbors, x$5)));
        Seq ptCounts = (Seq)regions.map((Function1 & Serializable & scala.Serializable)dir -> BoxesRunTime.boxToInteger((int)StitchedDelaunay$.$anonfun$combinedPointSet$16(neighbors, dir)), Seq$.MODULE$.canBuildFrom());
        Map countMap = ((TraversableOnce)regions.zip((GenIterable)ptCounts, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Map startIndices = ((TraversableOnce)regions.zip((GenIterable)ptCounts.foldLeft((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), (Function2 & Serializable & scala.Serializable)(accum, count) -> StitchedDelaunay$.$anonfun$combinedPointSet$19(accum, BoxesRunTime.unboxToInt((Object)count))), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        int vertCount = BoxesRunTime.unboxToInt((Object)ptCounts.sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Coordinate[] points = (Coordinate[])Array$.MODULE$.ofDim(vertCount, ClassTag$.MODULE$.apply(Coordinate.class));
        Map vtrans = ((TraversableOnce)regions.map((Function1 & Serializable & scala.Serializable)dir -> new Tuple2(dir, (Object)StitchedDelaunay$.vertIndices$3(dir, neighbors, startIndices, countMap)), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        regions.foreach((Function1 & Serializable & scala.Serializable)dir -> {
            StitchedDelaunay$.$anonfun$combinedPointSet$21(vtrans, neighbors, points, dir);
            return BoxedUnit.UNIT;
        });
        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)vertCount), (Object)IndexedPointSet$.MODULE$.apply(points), (Object)vtrans);
    }

    public StitchedDelaunay apply(Map<Direction, Tuple2<BoundaryDelaunay, Extent>> neighbors, boolean debug) {
        int n;
        Left left;
        Tuple2 tuple22;
        Either bound;
        Tuple3<Object, IndexedPointSet, Map<Direction, Map<Object, Object>>> tuple32 = this.combinedPointSet(neighbors);
        if (tuple32 == null) {
            throw new MatchError(tuple32);
        }
        int vertCount = BoxesRunTime.unboxToInt((Object)tuple32._1());
        IndexedPointSet allPoints = (IndexedPointSet)tuple32._2();
        Map vtrans = (Map)tuple32._3();
        Tuple3 tuple33 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)vertCount), (Object)allPoints, (Object)vtrans);
        Tuple3 tuple34 = tuple33;
        int vertCount2 = BoxesRunTime.unboxToInt((Object)tuple34._1());
        IndexedPointSet allPoints2 = (IndexedPointSet)tuple34._2();
        Map vtrans2 = (Map)tuple34._3();
        HalfEdgeTable allEdges = new HalfEdgeTable(2 * (3 * vertCount2 - 6));
        Map boundaries = (Map)neighbors.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple22;
            Direction dir;
            block3: {
                Tuple2 tuple23;
                block2: {
                    tuple23 = x0$1;
                    if (tuple23 == null) break block2;
                    dir = (Direction)tuple23._1();
                    tuple22 = (Tuple2)tuple23._2();
                    if (tuple22 != null) break block3;
                }
                throw new MatchError((Object)tuple23);
            }
            BoundaryDelaunay bdt = (BoundaryDelaunay)tuple22._1();
            JFunction1.mcII.sp & Serializable & scala.Serializable reindex = (JFunction1.mcII.sp & Serializable & scala.Serializable)x$8 -> BoxesRunTime.unboxToInt((Object)((MapLike)vtrans2.apply((Object)dir)).apply((Object)BoxesRunTime.boxToInteger((int)x$8)));
            int edgeoffset = allEdges.appendTable(bdt.halfEdgeTable(), (Function1<Object, Object>)reindex);
            Right handle = bdt.liveVertices().size() == 1 ? package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToInteger((int)reindex.apply$mcII$sp(BoxesRunTime.unboxToInt((Object)bdt.liveVertices().toSeq().apply(0))))) : package$.MODULE$.Left().apply((Object)new Tuple2.mcIZ.sp(bdt.boundary() + edgeoffset, bdt.isLinear()));
            Tuple2 tuple24 = new Tuple2((Object)dir, (Object)handle);
            return tuple24;
        }, Map$.MODULE$.canBuildFrom());
        Seq dirs = (Seq)new .colon.colon((Object)((Seq)new .colon.colon((Object)Direction$TopLeft$.MODULE$, (List)new .colon.colon((Object)Direction$Top$.MODULE$, (List)new .colon.colon((Object)Direction$TopRight$.MODULE$, (List)Nil$.MODULE$)))), (List)new .colon.colon((Object)((Seq)new .colon.colon((Object)Direction$Left$.MODULE$, (List)new .colon.colon((Object)Direction$Center$.MODULE$, (List)new .colon.colon((Object)Direction$Right$.MODULE$, (List)Nil$.MODULE$)))), (List)new .colon.colon((Object)((Seq)new .colon.colon((Object)Direction$BottomLeft$.MODULE$, (List)new .colon.colon((Object)Direction$Bottom$.MODULE$, (List)new .colon.colon((Object)Direction$BottomRight$.MODULE$, (List)Nil$.MODULE$)))), (List)Nil$.MODULE$)));
        TriangleMap overlayTris = new TriangleMap(allEdges);
        DelaunayStitcher stitcher = new DelaunayStitcher(allPoints2, allEdges);
        Either either2 = bound = (Either)((TraversableOnce)((TraversableLike)((TraversableLike)dirs.map((Function1 & Serializable & scala.Serializable)row -> (Seq)row.flatMap((Function1 & Serializable & scala.Serializable)dir -> Option$.MODULE$.option2Iterable(boundaries.get(dir)), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)row -> BoxesRunTime.boxToBoolean((boolean)row.nonEmpty()))).map((Function1 & Serializable & scala.Serializable)row -> (Either)row.reduce((Function2 & Serializable & scala.Serializable)(l, r) -> {
            Tuple2 tuple22 = new Tuple2(l, r);
            if (tuple22 != null) {
                Left left;
                Tuple2 tuple23;
                Either either2 = (Either)tuple22._1();
                Either either3 = (Either)tuple22._2();
                if (either2 instanceof Left && (tuple23 = (Tuple2)(left = (Left)either2).value()) != null) {
                    Left left2;
                    Tuple2 tuple24;
                    int left3 = tuple23._1$mcI$sp();
                    boolean isLeftLinear = tuple23._2$mcZ$sp();
                    if (either3 instanceof Left && (tuple24 = (Tuple2)(left2 = (Left)either3).value()) != null) {
                        int right = tuple24._1$mcI$sp();
                        boolean isRightLinear = tuple24._2$mcZ$sp();
                        return package$.MODULE$.Left().apply(stitcher.merge(left3, isLeftLinear, right, isRightLinear, overlayTris, debug));
                    }
                }
            }
            if (tuple22 != null) {
                Left left;
                Tuple2 tuple25;
                Either either4 = (Either)tuple22._1();
                Either either5 = (Either)tuple22._2();
                if (either4 instanceof Left && (tuple25 = (Tuple2)(left = (Left)either4).value()) != null) {
                    int left4 = tuple25._1$mcI$sp();
                    boolean isLeftLinear = tuple25._2$mcZ$sp();
                    if (either5 instanceof Right) {
                        Right right = (Right)either5;
                        int vertex = BoxesRunTime.unboxToInt((Object)right.value());
                        return package$.MODULE$.Left().apply(stitcher.joinToVertex(left4, isLeftLinear, vertex, overlayTris, stitcher.joinToVertex$default$5()));
                    }
                }
            }
            if (tuple22 != null) {
                Either either6 = (Either)tuple22._1();
                Either either7 = (Either)tuple22._2();
                if (either6 instanceof Right) {
                    Left left;
                    Tuple2 tuple26;
                    Right right = (Right)either6;
                    int vertex = BoxesRunTime.unboxToInt((Object)right.value());
                    if (either7 instanceof Left && (tuple26 = (Tuple2)(left = (Left)either7).value()) != null) {
                        int right2 = tuple26._1$mcI$sp();
                        boolean isRightLinear = tuple26._2$mcZ$sp();
                        return package$.MODULE$.Left().apply(stitcher.joinToVertex(right2, isRightLinear, vertex, overlayTris, stitcher.joinToVertex$default$5()));
                    }
                }
            }
            if (tuple22 == null) throw new MatchError((Object)tuple22);
            Either either8 = (Either)tuple22._1();
            Either either9 = (Either)tuple22._2();
            if (!(either8 instanceof Right)) throw new MatchError((Object)tuple22);
            Right right = (Right)either8;
            int v1 = BoxesRunTime.unboxToInt((Object)right.value());
            if (!(either9 instanceof Right)) throw new MatchError((Object)tuple22);
            Right right3 = (Right)either9;
            int v2 = BoxesRunTime.unboxToInt((Object)right3.value());
            return package$.MODULE$.Left().apply((Object)new Tuple2.mcIZ.sp(allEdges.createHalfEdges(v1, v2), true));
        }), Seq$.MODULE$.canBuildFrom())).reduce((Function2 & Serializable & scala.Serializable)(l, r) -> {
            Tuple2 tuple22 = new Tuple2(l, r);
            if (tuple22 != null) {
                Left left;
                Tuple2 tuple23;
                Either either2 = (Either)tuple22._1();
                Either either3 = (Either)tuple22._2();
                if (either2 instanceof Left && (tuple23 = (Tuple2)(left = (Left)either2).value()) != null) {
                    Left left2;
                    Tuple2 tuple24;
                    int left3 = tuple23._1$mcI$sp();
                    boolean isLeftLinear = tuple23._2$mcZ$sp();
                    if (either3 instanceof Left && (tuple24 = (Tuple2)(left2 = (Left)either3).value()) != null) {
                        int right = tuple24._1$mcI$sp();
                        boolean isRightLinear = tuple24._2$mcZ$sp();
                        return package$.MODULE$.Left().apply(stitcher.merge(left3, isLeftLinear, right, isRightLinear, overlayTris, debug));
                    }
                }
            }
            if (tuple22 != null) {
                Left left;
                Tuple2 tuple25;
                Either either4 = (Either)tuple22._1();
                Either either5 = (Either)tuple22._2();
                if (either4 instanceof Left && (tuple25 = (Tuple2)(left = (Left)either4).value()) != null) {
                    int left4 = tuple25._1$mcI$sp();
                    boolean isLeftLinear = tuple25._2$mcZ$sp();
                    if (either5 instanceof Right) {
                        Right right = (Right)either5;
                        int vertex = BoxesRunTime.unboxToInt((Object)right.value());
                        return package$.MODULE$.Left().apply(stitcher.joinToVertex(left4, isLeftLinear, vertex, overlayTris, stitcher.joinToVertex$default$5()));
                    }
                }
            }
            if (tuple22 != null) {
                Either either6 = (Either)tuple22._1();
                Either either7 = (Either)tuple22._2();
                if (either6 instanceof Right) {
                    Left left;
                    Tuple2 tuple26;
                    Right right = (Right)either6;
                    int vertex = BoxesRunTime.unboxToInt((Object)right.value());
                    if (either7 instanceof Left && (tuple26 = (Tuple2)(left = (Left)either7).value()) != null) {
                        int right2 = tuple26._1$mcI$sp();
                        boolean isRightLinear = tuple26._2$mcZ$sp();
                        return package$.MODULE$.Left().apply(stitcher.joinToVertex(right2, isRightLinear, vertex, overlayTris, stitcher.joinToVertex$default$5()));
                    }
                }
            }
            if (tuple22 == null) throw new MatchError((Object)tuple22);
            Either either8 = (Either)tuple22._1();
            Either either9 = (Either)tuple22._2();
            if (!(either8 instanceof Right)) throw new MatchError((Object)tuple22);
            Right right = (Right)either8;
            int v1 = BoxesRunTime.unboxToInt((Object)right.value());
            if (!(either9 instanceof Right)) throw new MatchError((Object)tuple22);
            Right right3 = (Right)either9;
            int v2 = BoxesRunTime.unboxToInt((Object)right3.value());
            return package$.MODULE$.Left().apply((Object)new Tuple2.mcIZ.sp(allEdges.createHalfEdges(v1, v2), true));
        });
        if (either2 instanceof Left && (tuple22 = (Tuple2)(left = (Left)either2).value()) != null) {
            int bnd;
            n = bnd = tuple22._1$mcI$sp();
        } else if (either2 instanceof Right) {
            n = -1;
        } else {
            throw new MatchError((Object)either2);
        }
        int boundary = n;
        return new StitchedDelaunay((Function1<Object, Coordinate>)(Function1 & Serializable & scala.Serializable)x$9 -> allPoints2.getCoordinate(BoxesRunTime.unboxToInt((Object)x$9)), allEdges, boundary, allPoints2, overlayTris);
    }

    public StitchedDelaunay apply(Map<Direction, Tuple2<DelaunayTriangulation, Extent>> neighbors, boolean debug, Predef.DummyImplicit dummy) {
        int n;
        Left left;
        Tuple2 tuple22;
        Either bound;
        Tuple3<Object, IndexedPointSet, Map<Direction, Map<Object, Object>>> tuple32 = this.combinedPointSet(neighbors, dummy);
        if (tuple32 == null) {
            throw new MatchError(tuple32);
        }
        int vertCount = BoxesRunTime.unboxToInt((Object)tuple32._1());
        IndexedPointSet allPoints = (IndexedPointSet)tuple32._2();
        Map vtrans = (Map)tuple32._3();
        Tuple3 tuple33 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)vertCount), (Object)allPoints, (Object)vtrans);
        Tuple3 tuple34 = tuple33;
        int vertCount2 = BoxesRunTime.unboxToInt((Object)tuple34._1());
        IndexedPointSet allPoints2 = (IndexedPointSet)tuple34._2();
        Map vtrans2 = (Map)tuple34._3();
        HalfEdgeTable allEdges = new HalfEdgeTable(2 * (3 * vertCount2 - 6));
        Map boundaries = (Map)neighbors.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple22;
            Direction dir;
            block3: {
                Tuple2 tuple23;
                block2: {
                    tuple23 = x0$1;
                    if (tuple23 == null) break block2;
                    dir = (Direction)tuple23._1();
                    tuple22 = (Tuple2)tuple23._2();
                    if (tuple22 != null) break block3;
                }
                throw new MatchError((Object)tuple23);
            }
            DelaunayTriangulation dt = (DelaunayTriangulation)tuple22._1();
            JFunction1.mcII.sp & Serializable & scala.Serializable reindex = (JFunction1.mcII.sp & Serializable & scala.Serializable)x$11 -> BoxesRunTime.unboxToInt((Object)((MapLike)vtrans2.apply((Object)dir)).apply((Object)BoxesRunTime.boxToInteger((int)x$11)));
            int edgeoffset = allEdges.appendTable(dt.halfEdgeTable(), (Function1<Object, Object>)reindex);
            Right handle = dt.liveVertices().size() == 1 ? package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToInteger((int)reindex.apply$mcII$sp(BoxesRunTime.unboxToInt((Object)dt.liveVertices().toSeq().apply(0))))) : package$.MODULE$.Left().apply((Object)new Tuple2.mcIZ.sp(dt.boundary() + edgeoffset, dt.isLinear()));
            Tuple2 tuple24 = new Tuple2((Object)dir, (Object)handle);
            return tuple24;
        }, Map$.MODULE$.canBuildFrom());
        Seq dirs = (Seq)new .colon.colon((Object)((Seq)new .colon.colon((Object)Direction$TopLeft$.MODULE$, (List)new .colon.colon((Object)Direction$Top$.MODULE$, (List)new .colon.colon((Object)Direction$TopRight$.MODULE$, (List)Nil$.MODULE$)))), (List)new .colon.colon((Object)((Seq)new .colon.colon((Object)Direction$Left$.MODULE$, (List)new .colon.colon((Object)Direction$Center$.MODULE$, (List)new .colon.colon((Object)Direction$Right$.MODULE$, (List)Nil$.MODULE$)))), (List)new .colon.colon((Object)((Seq)new .colon.colon((Object)Direction$BottomLeft$.MODULE$, (List)new .colon.colon((Object)Direction$Bottom$.MODULE$, (List)new .colon.colon((Object)Direction$BottomRight$.MODULE$, (List)Nil$.MODULE$)))), (List)Nil$.MODULE$)));
        TriangleMap overlayTris = new TriangleMap(allEdges);
        DelaunayStitcher stitcher = new DelaunayStitcher(allPoints2, allEdges);
        Either either2 = bound = (Either)((TraversableOnce)((TraversableLike)((TraversableLike)dirs.map((Function1 & Serializable & scala.Serializable)row -> (Seq)row.flatMap((Function1 & Serializable & scala.Serializable)dir -> Option$.MODULE$.option2Iterable(boundaries.get(dir)), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)row -> BoxesRunTime.boxToBoolean((boolean)row.nonEmpty()))).map((Function1 & Serializable & scala.Serializable)row -> (Either)row.reduce((Function2 & Serializable & scala.Serializable)(l, r) -> {
            Tuple2 tuple22 = new Tuple2(l, r);
            if (tuple22 != null) {
                Left left;
                Tuple2 tuple23;
                Either either2 = (Either)tuple22._1();
                Either either3 = (Either)tuple22._2();
                if (either2 instanceof Left && (tuple23 = (Tuple2)(left = (Left)either2).value()) != null) {
                    Left left2;
                    Tuple2 tuple24;
                    int left3 = tuple23._1$mcI$sp();
                    boolean isLeftLinear = tuple23._2$mcZ$sp();
                    if (either3 instanceof Left && (tuple24 = (Tuple2)(left2 = (Left)either3).value()) != null) {
                        int right = tuple24._1$mcI$sp();
                        boolean isRightLinear = tuple24._2$mcZ$sp();
                        return package$.MODULE$.Left().apply(stitcher.merge(left3, isLeftLinear, right, isRightLinear, overlayTris, debug));
                    }
                }
            }
            if (tuple22 != null) {
                Left left;
                Tuple2 tuple25;
                Either either4 = (Either)tuple22._1();
                Either either5 = (Either)tuple22._2();
                if (either4 instanceof Left && (tuple25 = (Tuple2)(left = (Left)either4).value()) != null) {
                    int left4 = tuple25._1$mcI$sp();
                    boolean isLeftLinear = tuple25._2$mcZ$sp();
                    if (either5 instanceof Right) {
                        Right right = (Right)either5;
                        int vertex = BoxesRunTime.unboxToInt((Object)right.value());
                        return package$.MODULE$.Left().apply(stitcher.joinToVertex(left4, isLeftLinear, vertex, overlayTris, stitcher.joinToVertex$default$5()));
                    }
                }
            }
            if (tuple22 != null) {
                Either either6 = (Either)tuple22._1();
                Either either7 = (Either)tuple22._2();
                if (either6 instanceof Right) {
                    Left left;
                    Tuple2 tuple26;
                    Right right = (Right)either6;
                    int vertex = BoxesRunTime.unboxToInt((Object)right.value());
                    if (either7 instanceof Left && (tuple26 = (Tuple2)(left = (Left)either7).value()) != null) {
                        int right2 = tuple26._1$mcI$sp();
                        boolean isRightLinear = tuple26._2$mcZ$sp();
                        return package$.MODULE$.Left().apply(stitcher.joinToVertex(right2, isRightLinear, vertex, overlayTris, stitcher.joinToVertex$default$5()));
                    }
                }
            }
            if (tuple22 == null) throw new MatchError((Object)tuple22);
            Either either8 = (Either)tuple22._1();
            Either either9 = (Either)tuple22._2();
            if (!(either8 instanceof Right)) throw new MatchError((Object)tuple22);
            Right right = (Right)either8;
            int v1 = BoxesRunTime.unboxToInt((Object)right.value());
            if (!(either9 instanceof Right)) throw new MatchError((Object)tuple22);
            Right right3 = (Right)either9;
            int v2 = BoxesRunTime.unboxToInt((Object)right3.value());
            return package$.MODULE$.Left().apply((Object)new Tuple2.mcIZ.sp(allEdges.createHalfEdges(v1, v2), true));
        }), Seq$.MODULE$.canBuildFrom())).reduce((Function2 & Serializable & scala.Serializable)(l, r) -> {
            Tuple2 tuple22 = new Tuple2(l, r);
            if (tuple22 != null) {
                Left left;
                Tuple2 tuple23;
                Either either2 = (Either)tuple22._1();
                Either either3 = (Either)tuple22._2();
                if (either2 instanceof Left && (tuple23 = (Tuple2)(left = (Left)either2).value()) != null) {
                    Left left2;
                    Tuple2 tuple24;
                    int left3 = tuple23._1$mcI$sp();
                    boolean isLeftLinear = tuple23._2$mcZ$sp();
                    if (either3 instanceof Left && (tuple24 = (Tuple2)(left2 = (Left)either3).value()) != null) {
                        int right = tuple24._1$mcI$sp();
                        boolean isRightLinear = tuple24._2$mcZ$sp();
                        return package$.MODULE$.Left().apply(stitcher.merge(left3, isLeftLinear, right, isRightLinear, overlayTris, debug));
                    }
                }
            }
            if (tuple22 != null) {
                Left left;
                Tuple2 tuple25;
                Either either4 = (Either)tuple22._1();
                Either either5 = (Either)tuple22._2();
                if (either4 instanceof Left && (tuple25 = (Tuple2)(left = (Left)either4).value()) != null) {
                    int left4 = tuple25._1$mcI$sp();
                    boolean isLeftLinear = tuple25._2$mcZ$sp();
                    if (either5 instanceof Right) {
                        Right right = (Right)either5;
                        int vertex = BoxesRunTime.unboxToInt((Object)right.value());
                        return package$.MODULE$.Left().apply(stitcher.joinToVertex(left4, isLeftLinear, vertex, overlayTris, stitcher.joinToVertex$default$5()));
                    }
                }
            }
            if (tuple22 != null) {
                Either either6 = (Either)tuple22._1();
                Either either7 = (Either)tuple22._2();
                if (either6 instanceof Right) {
                    Left left;
                    Tuple2 tuple26;
                    Right right = (Right)either6;
                    int vertex = BoxesRunTime.unboxToInt((Object)right.value());
                    if (either7 instanceof Left && (tuple26 = (Tuple2)(left = (Left)either7).value()) != null) {
                        int right2 = tuple26._1$mcI$sp();
                        boolean isRightLinear = tuple26._2$mcZ$sp();
                        return package$.MODULE$.Left().apply(stitcher.joinToVertex(right2, isRightLinear, vertex, overlayTris, stitcher.joinToVertex$default$5()));
                    }
                }
            }
            if (tuple22 == null) throw new MatchError((Object)tuple22);
            Either either8 = (Either)tuple22._1();
            Either either9 = (Either)tuple22._2();
            if (!(either8 instanceof Right)) throw new MatchError((Object)tuple22);
            Right right = (Right)either8;
            int v1 = BoxesRunTime.unboxToInt((Object)right.value());
            if (!(either9 instanceof Right)) throw new MatchError((Object)tuple22);
            Right right3 = (Right)either9;
            int v2 = BoxesRunTime.unboxToInt((Object)right3.value());
            return package$.MODULE$.Left().apply((Object)new Tuple2.mcIZ.sp(allEdges.createHalfEdges(v1, v2), true));
        });
        if (either2 instanceof Left && (tuple22 = (Tuple2)(left = (Left)either2).value()) != null) {
            int bnd;
            n = bnd = tuple22._1$mcI$sp();
        } else if (either2 instanceof Right) {
            n = -1;
        } else {
            throw new MatchError((Object)either2);
        }
        int boundary = n;
        return new StitchedDelaunay((Function1<Object, Coordinate>)(Function1 & Serializable & scala.Serializable)x$12 -> allPoints2.getCoordinate(BoxesRunTime.unboxToInt((Object)x$12)), allEdges, boundary, allPoints2, overlayTris);
    }

    public StitchedDelaunay apply(DelaunayTriangulation center, Map<Direction, Tuple2<BoundaryDelaunay, Extent>> neighbors, boolean debug) {
        int n;
        Left left;
        Tuple2 tuple22;
        Left bound;
        Tuple3<Object, IndexedPointSet, Map<Direction, Map<Object, Object>>> tuple32 = this.combinedPointSet(center, neighbors);
        if (tuple32 == null) {
            throw new MatchError(tuple32);
        }
        int vertCount = BoxesRunTime.unboxToInt((Object)tuple32._1());
        IndexedPointSet allPoints = (IndexedPointSet)tuple32._2();
        Map vtrans = (Map)tuple32._3();
        Tuple3 tuple33 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)vertCount), (Object)allPoints, (Object)vtrans);
        Tuple3 tuple34 = tuple33;
        int vertCount2 = BoxesRunTime.unboxToInt((Object)tuple34._1());
        IndexedPointSet allPoints2 = (IndexedPointSet)tuple34._2();
        Map vtrans2 = (Map)tuple34._3();
        HalfEdgeTable allEdges = new HalfEdgeTable(2 * (3 * vertCount2 - 6));
        Map boundaries = (Map)((TraversableLike)neighbors.filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)StitchedDelaunay$.$anonfun$apply$19(center, x0$1)))).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple22;
            Tuple2 tuple23 = x0$2;
            if (tuple23 == null) throw new MatchError((Object)tuple23);
            Direction dir = (Direction)tuple23._1();
            Tuple2 tuple24 = (Tuple2)tuple23._2();
            if (tuple24 == null) throw new MatchError((Object)tuple23);
            BoundaryDelaunay bdt = (BoundaryDelaunay)tuple24._1();
            JFunction1.mcII.sp & Serializable & scala.Serializable reindex = (JFunction1.mcII.sp & Serializable & scala.Serializable)x$14 -> BoxesRunTime.unboxToInt((Object)((MapLike)vtrans2.apply((Object)dir)).apply((Object)BoxesRunTime.boxToInteger((int)x$14)));
            Direction direction = dir;
            Direction$Center$ direction$Center$ = Direction$Center$.MODULE$;
            if (!(direction != null ? !direction.equals(direction$Center$) : direction$Center$ != null)) {
                int edgeoffset = allEdges.appendTable(center.halfEdgeTable(), (Function1<Object, Object>)reindex);
                Right handle = center.liveVertices().size() == 1 ? package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToInteger((int)reindex.apply$mcII$sp(BoxesRunTime.unboxToInt((Object)center.liveVertices().head())))) : package$.MODULE$.Left().apply((Object)new Tuple2.mcIZ.sp(center.boundary() + edgeoffset, center.isLinear()));
                tuple22 = new Tuple2((Object)dir, (Object)handle);
                return tuple22;
            } else {
                int edgeoffset = allEdges.appendTable(bdt.halfEdgeTable(), (Function1<Object, Object>)reindex);
                Right handle = bdt.liveVertices().size() == 1 ? package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToInteger((int)reindex.apply$mcII$sp(BoxesRunTime.unboxToInt((Object)bdt.liveVertices().head())))) : package$.MODULE$.Left().apply((Object)new Tuple2.mcIZ.sp(bdt.boundary() + edgeoffset, bdt.isLinear()));
                tuple22 = new Tuple2((Object)dir, (Object)handle);
            }
            return tuple22;
        }, Map$.MODULE$.canBuildFrom());
        Seq dirs = (Seq)new .colon.colon((Object)((Seq)new .colon.colon((Object)Direction$TopLeft$.MODULE$, (List)new .colon.colon((Object)Direction$Top$.MODULE$, (List)new .colon.colon((Object)Direction$TopRight$.MODULE$, (List)Nil$.MODULE$)))), (List)new .colon.colon((Object)((Seq)new .colon.colon((Object)Direction$Left$.MODULE$, (List)new .colon.colon((Object)Direction$Center$.MODULE$, (List)new .colon.colon((Object)Direction$Right$.MODULE$, (List)Nil$.MODULE$)))), (List)new .colon.colon((Object)((Seq)new .colon.colon((Object)Direction$BottomLeft$.MODULE$, (List)new .colon.colon((Object)Direction$Bottom$.MODULE$, (List)new .colon.colon((Object)Direction$BottomRight$.MODULE$, (List)Nil$.MODULE$)))), (List)Nil$.MODULE$)));
        TriangleMap overlayTris = new TriangleMap(allEdges);
        DelaunayStitcher stitcher = new DelaunayStitcher(allPoints2, allEdges);
        IntRef i = IntRef.create((int)0);
        Seq joinedRows = (Seq)((TraversableLike)((TraversableLike)dirs.map((Function1 & Serializable & scala.Serializable)row -> (Seq)row.flatMap((Function1 & Serializable & scala.Serializable)dir -> Option$.MODULE$.option2Iterable(boundaries.get(dir)), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)row -> BoxesRunTime.boxToBoolean((boolean)row.nonEmpty()))).map((Function1 & Serializable & scala.Serializable)row -> (Either)row.reduce((arg_0, arg_1) -> StitchedDelaunay$.$anonfun$apply$26(stitcher, overlayTris, debug, allPoints2, i, allEdges, arg_0, arg_1)), Seq$.MODULE$.canBuildFrom());
        Left left2 = bound = joinedRows.isEmpty() ? package$.MODULE$.Left().apply((Object)new Tuple2.mcIZ.sp(-1, true)) : (Either)joinedRows.reduce((arg_0, arg_1) -> StitchedDelaunay$.$anonfun$apply$30(stitcher, overlayTris, debug, allPoints2, i, allEdges, arg_0, arg_1));
        if (left2 instanceof Left && (tuple22 = (Tuple2)(left = left2).value()) != null) {
            int bnd;
            n = bnd = tuple22._1$mcI$sp();
        } else if (left2 instanceof Right) {
            n = -1;
        } else {
            throw new MatchError((Object)left2);
        }
        int boundary = n;
        return new StitchedDelaunay((Function1<Object, Coordinate>)(Function1 & Serializable & scala.Serializable)x$15 -> allPoints2.getCoordinate(BoxesRunTime.unboxToInt((Object)x$15)), allEdges, boundary, allPoints2, overlayTris);
    }

    public boolean apply$default$2() {
        return false;
    }

    public StitchedDelaunay apply(Function1<Object, Coordinate> indexToCoord, HalfEdgeTable halfEdgeTable, int boundary, IndexedPointSet pointSet, TriangleMap fillTriangles) {
        return new StitchedDelaunay(indexToCoord, halfEdgeTable, boundary, pointSet, fillTriangles);
    }

    public Option<Tuple5<Function1<Object, Coordinate>, HalfEdgeTable, Object, IndexedPointSet, TriangleMap>> unapply(StitchedDelaunay x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple5(x$0.indexToCoord(), (Object)x$0.halfEdgeTable(), (Object)BoxesRunTime.boxToInteger((int)x$0.boundary()), (Object)x$0.pointSet(), (Object)x$0.fillTriangles()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$combinedPointSet$1(Map neighbors$1, Product x$1) {
        return neighbors$1.keys().toSet().contains((Object)x$1);
    }

    public static final /* synthetic */ int $anonfun$combinedPointSet$2(DelaunayTriangulation center$1, Map neighbors$1, Direction dir) {
        Direction direction = dir;
        Direction$Center$ direction$Center$ = Direction$Center$.MODULE$;
        return !(direction != null ? !direction.equals(direction$Center$) : direction$Center$ != null) ? center$1.pointSet().length() : ((BoundaryDelaunay)((Tuple2)neighbors$1.apply((Object)dir))._1()).pointSet().length();
    }

    public static final /* synthetic */ Seq $anonfun$combinedPointSet$3(Seq accum, int count) {
        return (Seq)accum.$colon$plus((Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)accum.last()) + count)), Seq$.MODULE$.canBuildFrom());
    }

    private static final Map vertIndices$1(Direction dir, DelaunayTriangulation center$1, Map neighbors$1, Map startIndices$1, Map countMap$1) {
        Direction direction = dir;
        Direction$Center$ direction$Center$ = Direction$Center$.MODULE$;
        Set<Object> liveVs = !(direction != null ? !direction.equals(direction$Center$) : direction$Center$ != null) ? center$1.liveVertices() : ((BoundaryDelaunay)((Tuple2)neighbors$1.apply((Object)dir))._1()).liveVertices();
        return ((TraversableOnce)liveVs.zip((GenIterable)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(BoxesRunTime.unboxToInt((Object)startIndices$1.apply((Object)dir))), BoxesRunTime.unboxToInt((Object)startIndices$1.apply((Object)dir)) + BoxesRunTime.unboxToInt((Object)countMap$1.apply((Object)dir))), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public static final /* synthetic */ void $anonfun$combinedPointSet$6(Coordinate[] points$1, IndexedPointSet pointSet$1, Tuple2 x0$1) {
        Tuple2 tuple22 = x0$1;
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        int orig = tuple22._1$mcI$sp();
        int newix = tuple22._2$mcI$sp();
        Predef$.MODULE$.assert(points$1[newix] == null);
        points$1[newix] = pointSet$1.apply(orig);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$combinedPointSet$5(Map vtrans$1, DelaunayTriangulation center$1, Map neighbors$1, Coordinate[] points$1, Direction dir) {
        Map mapping = (Map)vtrans$1.apply((Object)dir);
        Direction direction = dir;
        Direction$Center$ direction$Center$ = Direction$Center$.MODULE$;
        CompleteIndexedPointSet pointSet = !(direction != null ? !direction.equals(direction$Center$) : direction$Center$ != null) ? center$1.pointSet() : ((BoundaryDelaunay)((Tuple2)neighbors$1.apply((Object)dir))._1()).pointSet();
        mapping.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            StitchedDelaunay$.$anonfun$combinedPointSet$6(points$1, pointSet, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$combinedPointSet$7(Map neighbors$2, Product x$3) {
        return neighbors$2.keys().toSet().contains((Object)x$3);
    }

    public static final /* synthetic */ int $anonfun$combinedPointSet$9(Tuple2 x$4) {
        return ((BoundaryDelaunay)x$4._1()).pointSet().length();
    }

    public static final /* synthetic */ int $anonfun$combinedPointSet$8(Map neighbors$2, Direction dir) {
        return BoxesRunTime.unboxToInt((Object)neighbors$2.get((Object)dir).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)StitchedDelaunay$.$anonfun$combinedPointSet$9(x$4))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
    }

    public static final /* synthetic */ Seq $anonfun$combinedPointSet$11(Seq accum, int count) {
        return (Seq)accum.$colon$plus((Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)accum.last()) + count)), Seq$.MODULE$.canBuildFrom());
    }

    private static final Map vertIndices$2(Direction dir, Map neighbors$2, Map startIndices$2, Map countMap$2) {
        return ((TraversableOnce)((BoundaryDelaunay)((Tuple2)neighbors$2.apply((Object)dir))._1()).liveVertices().toSeq().zip((GenIterable)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0 + BoxesRunTime.unboxToInt((Object)startIndices$2.apply((Object)dir))), BoxesRunTime.unboxToInt((Object)countMap$2.apply((Object)dir)) + BoxesRunTime.unboxToInt((Object)startIndices$2.apply((Object)dir))), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public static final /* synthetic */ void $anonfun$combinedPointSet$14(Coordinate[] points$2, IndexedPointSet pointSet$2, Tuple2 x0$1) {
        Tuple2 tuple22 = x0$1;
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        int orig = tuple22._1$mcI$sp();
        int newix = tuple22._2$mcI$sp();
        Predef$.MODULE$.assert(points$2[newix] == null);
        points$2[newix] = pointSet$2.apply(orig);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$combinedPointSet$13(Map vtrans$2, Map neighbors$2, Coordinate[] points$2, Direction dir) {
        Map mapping = (Map)vtrans$2.apply((Object)dir);
        IndexedPointSet pointSet = ((BoundaryDelaunay)((Tuple2)neighbors$2.apply((Object)dir))._1()).pointSet();
        mapping.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            StitchedDelaunay$.$anonfun$combinedPointSet$14(points$2, pointSet, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$combinedPointSet$15(Map neighbors$3, Product x$5) {
        return neighbors$3.keys().toSet().contains((Object)x$5);
    }

    public static final /* synthetic */ int $anonfun$combinedPointSet$17(Tuple2 x$6) {
        return ((DelaunayTriangulation)x$6._1()).pointSet().length();
    }

    public static final /* synthetic */ int $anonfun$combinedPointSet$16(Map neighbors$3, Direction dir) {
        return BoxesRunTime.unboxToInt((Object)neighbors$3.get((Object)dir).map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToInteger((int)StitchedDelaunay$.$anonfun$combinedPointSet$17(x$6))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
    }

    public static final /* synthetic */ Seq $anonfun$combinedPointSet$19(Seq accum, int count) {
        return (Seq)accum.$colon$plus((Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)accum.last()) + count)), Seq$.MODULE$.canBuildFrom());
    }

    private static final Map vertIndices$3(Direction dir, Map neighbors$3, Map startIndices$3, Map countMap$3) {
        return ((TraversableOnce)((DelaunayTriangulation)((Tuple2)neighbors$3.apply((Object)dir))._1()).liveVertices().toSeq().zip((GenIterable)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0 + BoxesRunTime.unboxToInt((Object)startIndices$3.apply((Object)dir))), BoxesRunTime.unboxToInt((Object)countMap$3.apply((Object)dir)) + BoxesRunTime.unboxToInt((Object)startIndices$3.apply((Object)dir))), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public static final /* synthetic */ void $anonfun$combinedPointSet$22(Coordinate[] points$3, CompleteIndexedPointSet pointSet$3, Tuple2 x0$1) {
        Tuple2 tuple22 = x0$1;
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        int orig = tuple22._1$mcI$sp();
        int newix = tuple22._2$mcI$sp();
        Predef$.MODULE$.assert(points$3[newix] == null);
        points$3[newix] = pointSet$3.apply(orig);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$combinedPointSet$21(Map vtrans$3, Map neighbors$3, Coordinate[] points$3, Direction dir) {
        Map mapping = (Map)vtrans$3.apply((Object)dir);
        CompleteIndexedPointSet pointSet = ((DelaunayTriangulation)((Tuple2)neighbors$3.apply((Object)dir))._1()).pointSet();
        mapping.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            StitchedDelaunay$.$anonfun$combinedPointSet$22(points$3, pointSet, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$apply$19(DelaunayTriangulation center$2, Tuple2 x0$1) {
        Tuple2 tuple22;
        Direction dir;
        block3: {
            Tuple2 tuple23;
            block2: {
                tuple23 = x0$1;
                if (tuple23 == null) break block2;
                dir = (Direction)tuple23._1();
                tuple22 = (Tuple2)tuple23._2();
                if (tuple22 != null) break block3;
            }
            throw new MatchError((Object)tuple23);
        }
        BoundaryDelaunay bdt = (BoundaryDelaunay)tuple22._1();
        Direction direction = dir;
        Direction$Center$ direction$Center$ = Direction$Center$.MODULE$;
        boolean bl = !(direction != null ? !direction.equals(direction$Center$) : direction$Center$ != null) ? center$2.liveVertices().nonEmpty() : bdt.liveVertices().nonEmpty();
        return bl;
    }

    public static final /* synthetic */ Polygon $anonfun$apply$27(IndexedPointSet allPoints$3, Tuple3 x0$3) {
        Tuple3 tuple32 = x0$3;
        if (tuple32 == null) {
            throw new MatchError((Object)tuple32);
        }
        int i = BoxesRunTime.unboxToInt((Object)tuple32._1());
        int j = BoxesRunTime.unboxToInt((Object)tuple32._2());
        int k = BoxesRunTime.unboxToInt((Object)tuple32._3());
        Polygon polygon = Polygon$.MODULE$.apply((Seq<Coordinate>)Predef$.MODULE$.wrapRefArray((Object[])new Coordinate[]{allPoints$3.apply(i), allPoints$3.apply(j), allPoints$3.apply(k), allPoints$3.apply(i)}), Predef.DummyImplicit$.MODULE$.dummyImplicit(), Predef.DummyImplicit$.MODULE$.dummyImplicit());
        return polygon;
    }

    public static final /* synthetic */ Polygon $anonfun$apply$28(IndexedPointSet allPoints$3, Tuple3 x0$4) {
        Tuple3 tuple32 = x0$4;
        if (tuple32 == null) {
            throw new MatchError((Object)tuple32);
        }
        int i = BoxesRunTime.unboxToInt((Object)tuple32._1());
        int j = BoxesRunTime.unboxToInt((Object)tuple32._2());
        int k = BoxesRunTime.unboxToInt((Object)tuple32._3());
        Polygon polygon = Polygon$.MODULE$.apply((Seq<Coordinate>)Predef$.MODULE$.wrapRefArray((Object[])new Coordinate[]{allPoints$3.apply(i), allPoints$3.apply(j), allPoints$3.apply(k), allPoints$3.apply(i)}), Predef.DummyImplicit$.MODULE$.dummyImplicit(), Predef.DummyImplicit$.MODULE$.dummyImplicit());
        return polygon;
    }

    public static final /* synthetic */ Polygon $anonfun$apply$29(IndexedPointSet allPoints$3, Tuple3 x0$5) {
        Tuple3 tuple32 = x0$5;
        if (tuple32 == null) {
            throw new MatchError((Object)tuple32);
        }
        int i = BoxesRunTime.unboxToInt((Object)tuple32._1());
        int j = BoxesRunTime.unboxToInt((Object)tuple32._2());
        int k = BoxesRunTime.unboxToInt((Object)tuple32._3());
        Polygon polygon = Polygon$.MODULE$.apply((Seq<Coordinate>)Predef$.MODULE$.wrapRefArray((Object[])new Coordinate[]{allPoints$3.apply(i), allPoints$3.apply(j), allPoints$3.apply(k), allPoints$3.apply(i)}), Predef.DummyImplicit$.MODULE$.dummyImplicit(), Predef.DummyImplicit$.MODULE$.dummyImplicit());
        return polygon;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static final /* synthetic */ Either $anonfun$apply$26(DelaunayStitcher stitcher$3, TriangleMap overlayTris$3, boolean debug$3, IndexedPointSet allPoints$3, IntRef i$1, HalfEdgeTable allEdges$3, Either l, Either r) {
        block10: {
            block12: {
                block11: {
                    block9: {
                        var10_8 = new Tuple2((Object)l, (Object)r);
                        if (var10_8 == null) break block9;
                        var11_9 = (Either)var10_8._1();
                        var12_10 = (Either)var10_8._2();
                        if (!(var11_9 instanceof Left) || (var14_12 = (Tuple2)(var13_11 = (Left)var11_9).value()) == null) break block9;
                        left = var14_12._1$mcI$sp();
                        isLeftLinear = var14_12._2$mcZ$sp();
                        if (!(var12_10 instanceof Left) || (var18_16 = (Tuple2)(var17_15 = (Left)var12_10).value()) == null) break block9;
                        right = var18_16._1$mcI$sp();
                        isRightLinear = var18_16._2$mcZ$sp();
                        result = stitcher$3.merge(left, isLeftLinear, right, isRightLinear, overlayTris$3, debug$3);
                        if (debug$3) {
                            Predef$.MODULE$.println((Object)"Merging two normal triangulations (row 0)");
                            mp = MultiPolygon$.MODULE$.apply((Traversable<Polygon>)((Traversable)overlayTris$3.triangleVertices().map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$apply$27(geotrellis.vector.mesh.IndexedPointSet scala.Tuple3 ), (Lscala/Tuple3;)Lorg/locationtech/jts/geom/Polygon;)((IndexedPointSet)allPoints$3), Iterable$.MODULE$.canBuildFrom())));
                            v0 /* !! */  = new PrintWriter(i$1, mp){
                                {
                                    this.write(WKT$.MODULE$.write((Geometry)mp$1));
                                    this.close();
                                }
                            };
                        } else {
                            v0 /* !! */  = BoxedUnit.UNIT;
                        }
                        var8_21 = package$.MODULE$.Left().apply(result);
                        break block10;
                    }
                    if (var10_8 == null) break block11;
                    var23_22 = (Either)var10_8._1();
                    var24_23 = (Either)var10_8._2();
                    if (!(var23_22 instanceof Left) || (var26_25 = (Tuple2)(var25_24 = (Left)var23_22).value()) == null) break block11;
                    left = var26_25._1$mcI$sp();
                    isLeftLinear = var26_25._2$mcZ$sp();
                    if (!(var24_23 instanceof Right)) break block11;
                    var29_28 = (Right)var24_23;
                    vertex = BoxesRunTime.unboxToInt((Object)var29_28.value());
                    result = stitcher$3.joinToVertex(left, isLeftLinear, vertex, overlayTris$3, stitcher$3.joinToVertex$default$5());
                    if (debug$3) {
                        Predef$.MODULE$.println((Object)"Merging a single point to a normal triangulation (row 1)");
                        mp = MultiPolygon$.MODULE$.apply((Traversable<Polygon>)((Traversable)overlayTris$3.triangleVertices().map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$apply$28(geotrellis.vector.mesh.IndexedPointSet scala.Tuple3 ), (Lscala/Tuple3;)Lorg/locationtech/jts/geom/Polygon;)((IndexedPointSet)allPoints$3), Iterable$.MODULE$.canBuildFrom())));
                        v1 /* !! */  = new PrintWriter(i$1, mp){
                            {
                                this.write(WKT$.MODULE$.write((Geometry)mp$2));
                                this.close();
                            }
                        };
                    } else {
                        v1 /* !! */  = BoxedUnit.UNIT;
                    }
                    var8_21 = package$.MODULE$.Left().apply(result);
                    break block10;
                }
                if (var10_8 == null) break block12;
                var33_32 = (Either)var10_8._1();
                var34_33 = (Either)var10_8._2();
                if (!(var33_32 instanceof Right)) break block12;
                var35_34 = (Right)var33_32;
                vertex = BoxesRunTime.unboxToInt((Object)var35_34.value());
                if (!(var34_33 instanceof Left) || (var38_37 = (Tuple2)(var37_36 = (Left)var34_33).value()) == null) break block12;
                right = var38_37._1$mcI$sp();
                isRightLinear = var38_37._2$mcZ$sp();
                result = stitcher$3.joinToVertex(right, isRightLinear, vertex, overlayTris$3, stitcher$3.joinToVertex$default$5());
                if (debug$3) {
                    Predef$.MODULE$.println((Object)"Merging a single point to a normal triangulation (row 2)");
                    mp = MultiPolygon$.MODULE$.apply((Traversable<Polygon>)((Traversable)overlayTris$3.triangleVertices().map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$apply$29(geotrellis.vector.mesh.IndexedPointSet scala.Tuple3 ), (Lscala/Tuple3;)Lorg/locationtech/jts/geom/Polygon;)((IndexedPointSet)allPoints$3), Iterable$.MODULE$.canBuildFrom())));
                    v2 /* !! */  = new PrintWriter(i$1, mp){
                        {
                            this.write(WKT$.MODULE$.write((Geometry)mp$3));
                            this.close();
                        }
                    };
                } else {
                    v2 /* !! */  = BoxedUnit.UNIT;
                }
                var8_21 = package$.MODULE$.Left().apply(result);
                break block10;
            }
            if (var10_8 == null) ** GOTO lbl-1000
            var43_42 = (Either)var10_8._1();
            var44_43 = (Either)var10_8._2();
            if (!(var43_42 instanceof Right)) ** GOTO lbl-1000
            var45_44 = (Right)var43_42;
            v1 = BoxesRunTime.unboxToInt((Object)var45_44.value());
            if (var44_43 instanceof Right) {
                var47_46 = (Right)var44_43;
                v2 = BoxesRunTime.unboxToInt((Object)var47_46.value());
                if (debug$3) {
                    Predef$.MODULE$.println((Object)"Merging two single point 'triangulations' (row 3)");
                }
                var8_21 = package$.MODULE$.Left().apply((Object)new Tuple2.mcIZ.sp(allEdges$3.createHalfEdges(v1, v2), true));
            } else lbl-1000:
            // 3 sources

            {
                throw new MatchError((Object)var10_8);
            }
        }
        result = var8_21;
        ++i$1.elem;
        return result;
    }

    public static final /* synthetic */ Polygon $anonfun$apply$31(IndexedPointSet allPoints$3, Tuple3 x0$6) {
        Tuple3 tuple32 = x0$6;
        if (tuple32 == null) {
            throw new MatchError((Object)tuple32);
        }
        int i = BoxesRunTime.unboxToInt((Object)tuple32._1());
        int j = BoxesRunTime.unboxToInt((Object)tuple32._2());
        int k = BoxesRunTime.unboxToInt((Object)tuple32._3());
        Polygon polygon = Polygon$.MODULE$.apply((Seq<Coordinate>)Predef$.MODULE$.wrapRefArray((Object[])new Coordinate[]{allPoints$3.apply(i), allPoints$3.apply(j), allPoints$3.apply(k), allPoints$3.apply(i)}), Predef.DummyImplicit$.MODULE$.dummyImplicit(), Predef.DummyImplicit$.MODULE$.dummyImplicit());
        return polygon;
    }

    public static final /* synthetic */ Polygon $anonfun$apply$32(IndexedPointSet allPoints$3, Tuple3 x0$7) {
        Tuple3 tuple32 = x0$7;
        if (tuple32 == null) {
            throw new MatchError((Object)tuple32);
        }
        int i = BoxesRunTime.unboxToInt((Object)tuple32._1());
        int j = BoxesRunTime.unboxToInt((Object)tuple32._2());
        int k = BoxesRunTime.unboxToInt((Object)tuple32._3());
        Polygon polygon = Polygon$.MODULE$.apply((Seq<Coordinate>)Predef$.MODULE$.wrapRefArray((Object[])new Coordinate[]{allPoints$3.apply(i), allPoints$3.apply(j), allPoints$3.apply(k), allPoints$3.apply(i)}), Predef.DummyImplicit$.MODULE$.dummyImplicit(), Predef.DummyImplicit$.MODULE$.dummyImplicit());
        return polygon;
    }

    public static final /* synthetic */ Polygon $anonfun$apply$33(IndexedPointSet allPoints$3, Tuple3 x0$8) {
        Tuple3 tuple32 = x0$8;
        if (tuple32 == null) {
            throw new MatchError((Object)tuple32);
        }
        int i = BoxesRunTime.unboxToInt((Object)tuple32._1());
        int j = BoxesRunTime.unboxToInt((Object)tuple32._2());
        int k = BoxesRunTime.unboxToInt((Object)tuple32._3());
        Polygon polygon = Polygon$.MODULE$.apply((Seq<Coordinate>)Predef$.MODULE$.wrapRefArray((Object[])new Coordinate[]{allPoints$3.apply(i), allPoints$3.apply(j), allPoints$3.apply(k), allPoints$3.apply(i)}), Predef.DummyImplicit$.MODULE$.dummyImplicit(), Predef.DummyImplicit$.MODULE$.dummyImplicit());
        return polygon;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static final /* synthetic */ Either $anonfun$apply$30(DelaunayStitcher stitcher$3, TriangleMap overlayTris$3, boolean debug$3, IndexedPointSet allPoints$3, IntRef i$1, HalfEdgeTable allEdges$3, Either l, Either r) {
        block10: {
            block12: {
                block11: {
                    block9: {
                        var10_8 = new Tuple2((Object)l, (Object)r);
                        if (var10_8 == null) break block9;
                        var11_9 = (Either)var10_8._1();
                        var12_10 = (Either)var10_8._2();
                        if (!(var11_9 instanceof Left) || (var14_12 = (Tuple2)(var13_11 = (Left)var11_9).value()) == null) break block9;
                        left = var14_12._1$mcI$sp();
                        isLeftLinear = var14_12._2$mcZ$sp();
                        if (!(var12_10 instanceof Left) || (var18_16 = (Tuple2)(var17_15 = (Left)var12_10).value()) == null) break block9;
                        right = var18_16._1$mcI$sp();
                        isRightLinear = var18_16._2$mcZ$sp();
                        result = stitcher$3.merge(left, isLeftLinear, right, isRightLinear, overlayTris$3, stitcher$3.merge$default$6());
                        if (debug$3) {
                            Predef$.MODULE$.println((Object)"Merging two normal triangulations (column)");
                            mp = MultiPolygon$.MODULE$.apply((Traversable<Polygon>)((Traversable)overlayTris$3.triangleVertices().map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$apply$31(geotrellis.vector.mesh.IndexedPointSet scala.Tuple3 ), (Lscala/Tuple3;)Lorg/locationtech/jts/geom/Polygon;)((IndexedPointSet)allPoints$3), Iterable$.MODULE$.canBuildFrom())));
                            v0 /* !! */  = new PrintWriter(i$1, mp){
                                {
                                    this.write(WKT$.MODULE$.write((Geometry)mp$4));
                                    this.close();
                                }
                            };
                        } else {
                            v0 /* !! */  = BoxedUnit.UNIT;
                        }
                        var8_21 = package$.MODULE$.Left().apply(result);
                        break block10;
                    }
                    if (var10_8 == null) break block11;
                    var23_22 = (Either)var10_8._1();
                    var24_23 = (Either)var10_8._2();
                    if (!(var23_22 instanceof Left) || (var26_25 = (Tuple2)(var25_24 = (Left)var23_22).value()) == null) break block11;
                    left = var26_25._1$mcI$sp();
                    isLeftLinear = var26_25._2$mcZ$sp();
                    if (!(var24_23 instanceof Right)) break block11;
                    var29_28 = (Right)var24_23;
                    vertex = BoxesRunTime.unboxToInt((Object)var29_28.value());
                    result = stitcher$3.joinToVertex(left, isLeftLinear, vertex, overlayTris$3, stitcher$3.joinToVertex$default$5());
                    if (debug$3) {
                        Predef$.MODULE$.println((Object)"Merging a single point to a normal triangulation (column)");
                        mp = MultiPolygon$.MODULE$.apply((Traversable<Polygon>)((Traversable)overlayTris$3.triangleVertices().map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$apply$32(geotrellis.vector.mesh.IndexedPointSet scala.Tuple3 ), (Lscala/Tuple3;)Lorg/locationtech/jts/geom/Polygon;)((IndexedPointSet)allPoints$3), Iterable$.MODULE$.canBuildFrom())));
                        v1 /* !! */  = new PrintWriter(i$1, mp){
                            {
                                this.write(WKT$.MODULE$.write((Geometry)mp$5));
                                this.close();
                            }
                        };
                    } else {
                        v1 /* !! */  = BoxedUnit.UNIT;
                    }
                    var8_21 = package$.MODULE$.Left().apply(result);
                    break block10;
                }
                if (var10_8 == null) break block12;
                var33_32 = (Either)var10_8._1();
                var34_33 = (Either)var10_8._2();
                if (!(var33_32 instanceof Right)) break block12;
                var35_34 = (Right)var33_32;
                vertex = BoxesRunTime.unboxToInt((Object)var35_34.value());
                if (!(var34_33 instanceof Left) || (var38_37 = (Tuple2)(var37_36 = (Left)var34_33).value()) == null) break block12;
                right = var38_37._1$mcI$sp();
                isRightLinear = var38_37._2$mcZ$sp();
                result = stitcher$3.joinToVertex(right, isRightLinear, vertex, overlayTris$3, stitcher$3.joinToVertex$default$5());
                if (debug$3) {
                    Predef$.MODULE$.println((Object)"Merging a single point to a normal triangulation (column)");
                    mp = MultiPolygon$.MODULE$.apply((Traversable<Polygon>)((Traversable)overlayTris$3.triangleVertices().map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$apply$33(geotrellis.vector.mesh.IndexedPointSet scala.Tuple3 ), (Lscala/Tuple3;)Lorg/locationtech/jts/geom/Polygon;)((IndexedPointSet)allPoints$3), Iterable$.MODULE$.canBuildFrom())));
                    v2 /* !! */  = new PrintWriter(i$1, mp){
                        {
                            this.write(WKT$.MODULE$.write((Geometry)mp$6));
                            this.close();
                        }
                    };
                } else {
                    v2 /* !! */  = BoxedUnit.UNIT;
                }
                var8_21 = package$.MODULE$.Left().apply(result);
                break block10;
            }
            if (var10_8 == null) ** GOTO lbl-1000
            var43_42 = (Either)var10_8._1();
            var44_43 = (Either)var10_8._2();
            if (!(var43_42 instanceof Right)) ** GOTO lbl-1000
            var45_44 = (Right)var43_42;
            v1 = BoxesRunTime.unboxToInt((Object)var45_44.value());
            if (var44_43 instanceof Right) {
                var47_46 = (Right)var44_43;
                v2 = BoxesRunTime.unboxToInt((Object)var47_46.value());
                if (debug$3) {
                    Predef$.MODULE$.println((Object)"Merging two single point 'triangulations' (column)");
                }
                var8_21 = package$.MODULE$.Left().apply((Object)new Tuple2.mcIZ.sp(allEdges$3.createHalfEdges(v1, v2), true));
            } else lbl-1000:
            // 3 sources

            {
                throw new MatchError((Object)var10_8);
            }
        }
        result = var8_21;
        ++i$1.elem;
        return result;
    }

    private StitchedDelaunay$() {
        MODULE$ = this;
    }
}

