/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.render.ascii;

import geotrellis.raster.Tile;
import java.io.Serializable;
import java.math.MathContext;
import java.util.Locale;
import scala.Function1;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.math.BigDecimal$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public final class NumericEncoder$
implements Product,
scala.Serializable {
    public static NumericEncoder$ MODULE$;

    static {
        new NumericEncoder$();
    }

    public String encodeIntegrals(Tile tile) {
        int cols = tile.cols$mcI$sp();
        int rows = tile.rows$mcI$sp();
        ArrayBuffer buff = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        int max = 0;
        for (int index$macro$2 = 0; index$macro$2 < rows; ++index$macro$2) {
            for (int index$macro$1 = 0; index$macro$1 < cols; ++index$macro$1) {
                int v = tile.get(index$macro$1, index$macro$2);
                String s = v == Integer.MIN_VALUE ? "ND" : String.valueOf(BoxesRunTime.boxToInteger((int)v));
                max = package$.MODULE$.max(max, new StringOps(Predef$.MODULE$.augmentString(s)).size());
                buff.$plus$eq((Object)s);
            }
        }
        return this.createAsciiTileString((String[])buff.toArray(ClassTag$.MODULE$.apply(String.class)), max, cols, rows);
    }

    public String encodeDecimals(Tile tile, int significantDigits) {
        int cols = tile.cols$mcI$sp();
        int rows = tile.rows$mcI$sp();
        ArrayBuffer buff = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        MathContext mc = new MathContext(significantDigits);
        int max = 0;
        for (int index$macro$2 = 0; index$macro$2 < rows; ++index$macro$2) {
            for (int index$macro$1 = 0; index$macro$1 < cols; ++index$macro$1) {
                String s;
                double v = tile.getDouble(index$macro$1, index$macro$2);
                String s2 = Double.isNaN(v) ? "ND" : (new StringOps(Predef$.MODULE$.augmentString(s = String.valueOf(BoxesRunTime.boxToDouble((double)v)))).size() > significantDigits ? BigDecimal$.MODULE$.apply(s).round(mc).toString() : s);
                max = package$.MODULE$.max(new StringOps(Predef$.MODULE$.augmentString(s2)).size(), max);
                buff.$plus$eq((Object)s2);
            }
        }
        return this.createAsciiTileString((String[])buff.toArray(ClassTag$.MODULE$.apply(String.class)), max, cols, rows);
    }

    public int encodeDecimals$default$2() {
        return Integer.MAX_VALUE;
    }

    public String encodeRange(Tile tile, int colMin, int colMax, int rowMin, int rowMax) {
        ObjectRef s = ObjectRef.create((Object)"");
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(rowMin), rowMax).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)row -> {
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(colMin), colMax).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)col -> {
                int z = tile.get(row, col);
                s$1.elem = z == Integer.MIN_VALUE ? new StringBuilder(2).append((String)s$1.elem).append("..").toString() : new StringBuilder(0).append((String)s$1.elem).append(new StringOps(Predef$.MODULE$.augmentString("%02X")).formatLocal(Locale.ENGLISH, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)z)}))).toString();
            });
            s$1.elem = new StringBuilder(1).append((String)s$1.elem).append("\n").toString();
        });
        return (String)s.elem;
    }

    private String createAsciiTileString(String[] buff, int maxSize, int cols, int rows) {
        scala.collection.mutable.StringBuilder sb = new scala.collection.mutable.StringBuilder();
        int limit = package$.MODULE$.max(6, maxSize);
        for (int index$macro$2 = 0; index$macro$2 < rows; ++index$macro$2) {
            for (int index$macro$1 = 0; index$macro$1 < cols; ++index$macro$1) {
                String s = buff[index$macro$2 * cols + index$macro$1];
                String pad = new StringOps(Predef$.MODULE$.augmentString(" ")).$times(package$.MODULE$.max(limit - s.length(), 1));
                sb.append(new StringBuilder(0).append(pad).append(s).toString());
            }
            sb.$plus$eq('\n');
        }
        sb.$plus$eq('\n');
        return sb.toString();
    }

    public String productPrefix() {
        return "NumericEncoder";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof NumericEncoder$;
    }

    public int hashCode() {
        return -1600670353;
    }

    public String toString() {
        return "NumericEncoder";
    }

    private Object readResolve() {
        return MODULE$;
    }

    private NumericEncoder$() {
        MODULE$ = this;
        Product.$init$((Product)this);
    }
}

