/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.resample;

import geotrellis.raster.CellSize;
import geotrellis.raster.Tile;
import geotrellis.raster.resample.Resample;
import geotrellis.vector.Extent;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001!4Q\u0001F\u000b\u0002\u0002qA\u0001\"\t\u0001\u0003\u0002\u0003\u0006IA\t\u0005\tM\u0001\u0011\t\u0011)A\u0005O!AQ\u0006\u0001B\u0001B\u0003%a\u0006C\u00032\u0001\u0011\u0005!\u0007C\u00048\u0001\t\u0007I\u0011\u0001\u001d\t\r}\u0002\u0001\u0015!\u0003:\u0011\u001d\u0001\u0005A1A\u0005\u0002aBa!\u0011\u0001!\u0002\u0013I\u0004b\u0002\"\u0001\u0005\u0004%\t\u0001\u000f\u0005\u0007\u0007\u0002\u0001\u000b\u0011B\u001d\t\u000f\u0011\u0003!\u0019!C\u0001q!1Q\t\u0001Q\u0001\neBqA\u0012\u0001C\u0002\u0013\u0005\u0001\b\u0003\u0004H\u0001\u0001\u0006I!\u000f\u0005\b\u0011\u0002\u0011\r\u0011\"\u00019\u0011\u0019I\u0005\u0001)A\u0005s!)!\n\u0001C\u0001\u0017\")A\u000b\u0001C\u0001+\")\u0001\f\u0001C\u00013\n\t\u0012iZ4sK\u001e\fG/\u001a*fg\u0006l\u0007\u000f\\3\u000b\u0005Y9\u0012\u0001\u0003:fg\u0006l\u0007\u000f\\3\u000b\u0005aI\u0012A\u0002:bgR,'OC\u0001\u001b\u0003)9Wm\u001c;sK2d\u0017n]\u0002\u0001'\t\u0001Q\u0004\u0005\u0002\u001f?5\tQ#\u0003\u0002!+\tA!+Z:b[BdW-\u0001\u0003uS2,\u0007CA\u0012%\u001b\u00059\u0012BA\u0013\u0018\u0005\u0011!\u0016\u000e\\3\u0002\r\u0015DH/\u001a8u!\tA3&D\u0001*\u0015\tQ\u0013$\u0001\u0004wK\u000e$xN]\u0005\u0003Y%\u0012a!\u0012=uK:$\u0018\u0001\u0003;be\u001e,GoQ*\u0011\u0005\rz\u0013B\u0001\u0019\u0018\u0005!\u0019U\r\u001c7TSj,\u0017A\u0002\u001fj]&$h\b\u0006\u00034iU2\u0004C\u0001\u0010\u0001\u0011\u0015\tC\u00011\u0001#\u0011\u00151C\u00011\u0001(\u0011\u0015iC\u00011\u0001/\u00031\u0019(oY\"fY2<\u0016\u000e\u001a;i+\u0005I\u0004C\u0001\u001e>\u001b\u0005Y$\"\u0001\u001f\u0002\u000bM\u001c\u0017\r\\1\n\u0005yZ$A\u0002#pk\ndW-A\u0007te\u000e\u001cU\r\u001c7XS\u0012$\b\u000eI\u0001\u000egJ\u001c7)\u001a7m\u0011\u0016Lw\r\u001b;\u0002\u001dM\u00148mQ3mY\"+\u0017n\u001a5uA\u0005\u0001\u0002.\u00197g'J\u001c7)\u001a7m/&$G\u000f[\u0001\u0012Q\u0006dgm\u0015:d\u0007\u0016dGnV5ei\"\u0004\u0013!\u00055bY\u001a\u001c&oY\"fY2DU-[4ii\u0006\u0011\u0002.\u00197g'J\u001c7)\u001a7m\u0011\u0016Lw\r\u001b;!\u0003=A\u0017\r\u001c4UCJ<W\r^,jIRD\u0017\u0001\u00055bY\u001a$\u0016M]4fi^KG\r\u001e5!\u0003AA\u0017\r\u001c4UCJ<W\r\u001e%fS\u001eDG/A\tiC24G+\u0019:hKRDU-[4ii\u0002\n\u0001\u0002_%oI&\u001cWm\u001d\u000b\u0003\u0019J\u0003BAO'P\u001f&\u0011aj\u000f\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0005i\u0002\u0016BA)<\u0005\rIe\u000e\u001e\u0005\u0006'F\u0001\r!O\u0001\u0002q\u0006A\u00110\u00138eS\u000e,7\u000f\u0006\u0002M-\")qK\u0005a\u0001s\u0005\t\u00110A\u0007d_:$(/\u001b2vi&|gn\u001d\u000b\u00045\u001a<\u0007cA.d\u0019:\u0011A,\u0019\b\u0003;\u0002l\u0011A\u0018\u0006\u0003?n\ta\u0001\u0010:p_Rt\u0014\"\u0001\u001f\n\u0005\t\\\u0014a\u00029bG.\fw-Z\u0005\u0003I\u0016\u00141aU3r\u0015\t\u00117\bC\u0003T'\u0001\u0007\u0011\bC\u0003X'\u0001\u0007\u0011\b")
public abstract class AggregateResample
extends Resample {
    private final Tile tile;
    private final Extent extent;
    private final double srcCellWidth;
    private final double srcCellHeight;
    private final double halfSrcCellWidth;
    private final double halfSrcCellHeight;
    private final double halfTargetWidth;
    private final double halfTargetHeight;

    public double srcCellWidth() {
        return this.srcCellWidth;
    }

    public double srcCellHeight() {
        return this.srcCellHeight;
    }

    public double halfSrcCellWidth() {
        return this.halfSrcCellWidth;
    }

    public double halfSrcCellHeight() {
        return this.halfSrcCellHeight;
    }

    public double halfTargetWidth() {
        return this.halfTargetWidth;
    }

    public double halfTargetHeight() {
        return this.halfTargetHeight;
    }

    public Tuple2<Object, Object> xIndices(double x) {
        double dLeftX = x - this.extent.xmin() - this.halfSrcCellWidth();
        double dLeftCellLeft = dLeftX - this.halfTargetWidth();
        double dLeftCellRight = dLeftX + this.halfTargetWidth();
        int leftIndex = dLeftCellLeft > 0.0 ? (int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(dLeftCellLeft / this.srcCellWidth())) : 0;
        int rightIndex = dLeftCellRight < this.extent.width() ? (int)RichDouble$.MODULE$.floor$extension(Predef$.MODULE$.doubleWrapper(dLeftCellRight / this.srcCellWidth())) : this.tile.cols$mcI$sp() - 1;
        return new Tuple2.mcII.sp(leftIndex, rightIndex);
    }

    public Tuple2<Object, Object> yIndices(double y) {
        double dTopY = this.extent.ymax() - y - this.halfSrcCellHeight();
        double dTopCellTop = dTopY - this.halfTargetHeight();
        double dTopCellBottom = dTopY + this.halfTargetHeight();
        int topIndex = dTopCellTop > 0.0 ? (int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(dTopCellTop / this.srcCellHeight())) : 0;
        int bottomIndex = dTopCellBottom < this.extent.height() ? (int)RichDouble$.MODULE$.floor$extension(Predef$.MODULE$.doubleWrapper(dTopCellBottom / this.srcCellHeight())) : this.tile.rows$mcI$sp() - 1;
        return new Tuple2.mcII.sp(topIndex, bottomIndex);
    }

    public Seq<Tuple2<Object, Object>> contributions(double x, double y) {
        Tuple2<Object, Object> tuple22 = this.xIndices(x);
        if (tuple22 == null) {
            throw new MatchError(tuple22);
        }
        int xLow = tuple22._1$mcI$sp();
        int xHigh = tuple22._2$mcI$sp();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(xLow, xHigh);
        Tuple2.mcII.sp sp3 = sp2;
        int xLow2 = sp3._1$mcI$sp();
        int xHigh2 = sp3._2$mcI$sp();
        Tuple2<Object, Object> tuple23 = this.yIndices(y);
        if (tuple23 == null) {
            throw new MatchError(tuple23);
        }
        int yLow = tuple23._1$mcI$sp();
        int yHigh = tuple23._2$mcI$sp();
        Tuple2.mcII.sp sp4 = new Tuple2.mcII.sp(yLow, yHigh);
        Tuple2.mcII.sp sp5 = sp4;
        int yLow2 = sp5._1$mcI$sp();
        int yHigh2 = sp5._2$mcI$sp();
        return xLow2 > xHigh2 || yLow2 > yHigh2 ? (Seq)package$.MODULE$.Vector().apply((Seq)Nil$.MODULE$) : (Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(xLow2), xHigh2).flatMap((Function1 & java.io.Serializable & Serializable)xs -> AggregateResample.$anonfun$contributions$1(yLow2, yHigh2, BoxesRunTime.unboxToInt((Object)xs)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ Tuple2 $anonfun$contributions$2(int xs$1, int ys) {
        return new Tuple2.mcII.sp(xs$1, ys);
    }

    public static final /* synthetic */ IndexedSeq $anonfun$contributions$1(int yLow$1, int yHigh$1, int xs) {
        return (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(yLow$1), yHigh$1).map((Function1 & java.io.Serializable & Serializable)ys -> AggregateResample.$anonfun$contributions$2(xs, BoxesRunTime.unboxToInt((Object)ys)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public AggregateResample(Tile tile, Extent extent, CellSize targetCS) {
        this.tile = tile;
        this.extent = extent;
        super(tile, extent);
        this.srcCellWidth = extent.width() / (double)tile.cols$mcI$sp();
        this.srcCellHeight = extent.height() / (double)tile.rows$mcI$sp();
        this.halfSrcCellWidth = this.srcCellWidth() / (double)2;
        this.halfSrcCellHeight = this.srcCellHeight() / (double)2;
        this.halfTargetWidth = targetCS.width() / (double)2;
        this.halfTargetHeight = targetCS.height() / (double)2;
    }
}

