/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.distance;

import geotrellis.raster.ArrayTile$;
import geotrellis.raster.DataType;
import geotrellis.raster.DoubleConstantNoDataCellType$;
import geotrellis.raster.MutableArrayTile;
import geotrellis.raster.RasterExtent;
import geotrellis.raster.Tile;
import geotrellis.raster.rasterize.polygon.PolygonRasterizer$;
import geotrellis.vector.Point$;
import geotrellis.vector.voronoi.VoronoiDiagram;
import geotrellis.vector.voronoi.VoronoiDiagram$;
import java.io.Serializable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.mutable.ArrayOps;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction2;

public final class EuclideanDistanceTile$ {
    public static EuclideanDistanceTile$ MODULE$;

    static {
        new EuclideanDistanceTile$();
    }

    private void fillFn(RasterExtent rasterExtent, MutableArrayTile tile, Point base, int col, int row) {
        block1: {
            Tuple2<Object, Object> tuple22 = rasterExtent.gridToMap$mcI$sp(col, row);
            if (tuple22 == null) {
                throw new MatchError(tuple22);
            }
            double x = tuple22._1$mcD$sp();
            double y = tuple22._2$mcD$sp();
            Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(x, y);
            Tuple2.mcDD.sp sp3 = sp2;
            double x2 = sp3._1$mcD$sp();
            double y2 = sp3._2$mcD$sp();
            double currentValue = tile.getDouble(col, row);
            double newValue = package$.MODULE$.sqrt((x2 - geotrellis.vector.package$.MODULE$.withExtraPointMethods(base).x()) * (x2 - geotrellis.vector.package$.MODULE$.withExtraPointMethods(base).x()) + (y2 - geotrellis.vector.package$.MODULE$.withExtraPointMethods(base).y()) * (y2 - geotrellis.vector.package$.MODULE$.withExtraPointMethods(base).y()));
            if (!Double.isNaN(currentValue) && !(currentValue > newValue)) break block1;
            tile.setDouble(col, row, newValue);
        }
    }

    public void rasterizeDistanceCell(RasterExtent rasterExtent, MutableArrayTile tile, Tuple2<Polygon, Coordinate> arg) {
        Tuple2<Polygon, Coordinate> tuple22 = arg;
        if (tuple22 == null) {
            throw new MatchError(tuple22);
        }
        Polygon poly = (Polygon)tuple22._1();
        Coordinate coord = (Coordinate)tuple22._2();
        Tuple2 tuple23 = new Tuple2((Object)poly, (Object)coord);
        Tuple2 tuple24 = tuple23;
        Polygon poly2 = (Polygon)tuple24._1();
        Coordinate coord2 = (Coordinate)tuple24._2();
        try {
            Polygon buffered = (Polygon)poly2.buffer(package$.MODULE$.max(rasterExtent.cellwidth(), rasterExtent.cellheight()));
            Point point = Point$.MODULE$.apply(coord2);
            PolygonRasterizer$.MODULE$.foreachCellByPolygon(buffered, rasterExtent, PolygonRasterizer$.MODULE$.foreachCellByPolygon$default$3(), (Function2<Object, Object, BoxedUnit>)(JFunction2.mcVII.sp & Serializable & scala.Serializable)(col, row) -> MODULE$.fillFn(rasterExtent, tile, point, col, row));
        }
        catch (Throwable e) {
            Predef$.MODULE$.println((Object)new StringBuilder(22).append("Error when handling ").append(poly2).append(": ").append(e.getMessage()).toString());
        }
    }

    public Tile apply(Coordinate[] pts, RasterExtent rasterExtent, DataType cellType) {
        VoronoiDiagram vor = VoronoiDiagram$.MODULE$.apply(pts, rasterExtent.extent(), VoronoiDiagram$.MODULE$.apply$default$3());
        MutableArrayTile tile = ArrayTile$.MODULE$.empty(cellType, rasterExtent.cols(), rasterExtent.rows());
        vor.voronoiCellsWithPoints().foreach((Function1 & Serializable & scala.Serializable)arg -> {
            EuclideanDistanceTile$.MODULE$.rasterizeDistanceCell(rasterExtent, tile, (Tuple2<Polygon, Coordinate>)arg);
            return BoxedUnit.UNIT;
        });
        return tile;
    }

    public Tile apply(Point[] pts, RasterExtent rasterExtent) {
        return this.apply((Coordinate[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pts)).map((Function1 & Serializable & scala.Serializable)pt -> new Coordinate(geotrellis.vector.package$.MODULE$.withExtraPointMethods((Point)pt).x(), geotrellis.vector.package$.MODULE$.withExtraPointMethods((Point)pt).y()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Coordinate.class))), rasterExtent, this.apply$default$3());
    }

    public Tile apply(Tuple2<Object, Object>[] pts, RasterExtent rasterExtent) {
        return this.apply((Coordinate[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pts)).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple22 = x0$1;
            if (tuple22 == null) {
                throw new MatchError((Object)tuple22);
            }
            double x = tuple22._1$mcD$sp();
            double y = tuple22._2$mcD$sp();
            Coordinate coordinate = new Coordinate(x, y);
            return coordinate;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Coordinate.class))), rasterExtent, this.apply$default$3());
    }

    public Tile apply(Tuple3<Object, Object, Object>[] pts, RasterExtent rasterExtent) {
        return this.apply((Coordinate[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pts)).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple3 tuple32 = x0$1;
            if (tuple32 == null) {
                throw new MatchError((Object)tuple32);
            }
            double x = BoxesRunTime.unboxToDouble((Object)tuple32._1());
            double y = BoxesRunTime.unboxToDouble((Object)tuple32._2());
            double z = BoxesRunTime.unboxToDouble((Object)tuple32._3());
            Coordinate coordinate = new Coordinate(x, y, z);
            return coordinate;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Coordinate.class))), rasterExtent, this.apply$default$3());
    }

    public DataType apply$default$3() {
        return DoubleConstantNoDataCellType$.MODULE$;
    }

    private EuclideanDistanceTile$() {
        MODULE$ = this;
    }
}

