/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.io.arg;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import geotrellis.raster.ArrayTile$;
import geotrellis.raster.BitArrayTile;
import geotrellis.raster.BitCellType$;
import geotrellis.raster.BitConstantTile$;
import geotrellis.raster.ByteArrayTile$;
import geotrellis.raster.ByteConstantNoDataCellType$;
import geotrellis.raster.ByteConstantTile;
import geotrellis.raster.ByteConstantTile$;
import geotrellis.raster.DataType;
import geotrellis.raster.DoubleArrayTile$;
import geotrellis.raster.DoubleConstantNoDataCellType$;
import geotrellis.raster.DoubleConstantTile;
import geotrellis.raster.DoubleConstantTile$;
import geotrellis.raster.FloatArrayTile$;
import geotrellis.raster.FloatConstantNoDataCellType$;
import geotrellis.raster.FloatConstantTile;
import geotrellis.raster.FloatConstantTile$;
import geotrellis.raster.GridBounds;
import geotrellis.raster.IntArrayTile$;
import geotrellis.raster.IntConstantNoDataCellType$;
import geotrellis.raster.IntConstantTile;
import geotrellis.raster.IntConstantTile$;
import geotrellis.raster.MutableArrayTile;
import geotrellis.raster.Raster;
import geotrellis.raster.RasterExtent;
import geotrellis.raster.RasterExtent$;
import geotrellis.raster.ShortArrayTile$;
import geotrellis.raster.ShortConstantNoDataCellType$;
import geotrellis.raster.ShortConstantTile;
import geotrellis.raster.ShortConstantTile$;
import geotrellis.raster.Tile;
import geotrellis.raster.UByteArrayTile$;
import geotrellis.raster.UByteConstantNoDataCellType$;
import geotrellis.raster.UByteConstantTile;
import geotrellis.raster.UByteConstantTile$;
import geotrellis.raster.UShortArrayTile$;
import geotrellis.raster.UShortConstantNoDataCellType$;
import geotrellis.raster.UShortConstantTile;
import geotrellis.raster.UShortConstantTile$;
import geotrellis.raster.package$;
import geotrellis.raster.package$ByteArrayFiller$;
import geotrellis.raster.package$DoubleArrayFiller$;
import geotrellis.raster.package$FloatArrayFiller$;
import geotrellis.raster.package$IntArrayFiller$;
import geotrellis.raster.package$ShortArrayFiller$;
import geotrellis.raster.resample.BitResampleAssign;
import geotrellis.raster.resample.ByteBufferResampleAssign;
import geotrellis.raster.resample.DoubleBufferResampleAssign;
import geotrellis.raster.resample.FloatBufferResampleAssign;
import geotrellis.raster.resample.IntBufferResampleAssign;
import geotrellis.raster.resample.ResampleAssign$;
import geotrellis.raster.resample.ShortBufferResampleAssign;
import geotrellis.util.Filesystem$;
import geotrellis.vector.Extent;
import java.io.File;
import java.nio.ByteBuffer;
import scala.Array$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple4;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class ArgReader$ {
    public static ArgReader$ MODULE$;

    static {
        new ArgReader$();
    }

    public final Raster<Tile> read(String path) {
        return this.read(path, (Option<RasterExtent>)None$.MODULE$);
    }

    public final Raster<Tile> read(String path, RasterExtent targetRasterExtent) {
        return this.read(path, (Option<RasterExtent>)new Some((Object)targetRasterExtent));
    }

    private final Raster<Tile> read(String path, Option<RasterExtent> targetRasterExtent) {
        Raster<Tile> raster;
        String layerType;
        DataType dataType;
        Config json = ConfigFactory.parseString(Filesystem$.MODULE$.readText(path));
        String string2 = json.getString("datatype");
        if ("bool".equals(string2)) {
            dataType = BitCellType$.MODULE$;
        } else if ("int8".equals(string2)) {
            dataType = ByteConstantNoDataCellType$.MODULE$;
        } else if ("uint8".equals(string2)) {
            dataType = UByteConstantNoDataCellType$.MODULE$;
        } else if ("int16".equals(string2)) {
            dataType = ShortConstantNoDataCellType$.MODULE$;
        } else if ("uint16".equals(string2)) {
            dataType = UShortConstantNoDataCellType$.MODULE$;
        } else if ("int32".equals(string2)) {
            dataType = IntConstantNoDataCellType$.MODULE$;
        } else if ("float32".equals(string2)) {
            dataType = FloatConstantNoDataCellType$.MODULE$;
        } else if ("float64".equals(string2)) {
            dataType = DoubleConstantNoDataCellType$.MODULE$;
        } else {
            throw new IllegalArgumentException(new StringBuilder(21).append("Unsupported datatype ").append(string2).toString());
        }
        BitCellType$ cellType = dataType;
        double xmin = json.getDouble("xmin");
        double ymin = json.getDouble("ymin");
        double xmax = json.getDouble("xmax");
        double ymax = json.getDouble("ymax");
        Extent extent = new Extent(xmin, ymin, xmax, ymax);
        int cols = json.getInt("cols");
        int rows = json.getInt("rows");
        String string3 = layerType = json.getString("type").toLowerCase();
        String string4 = "constant";
        if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
            Raster<Tile> raster2;
            double v = json.getDouble("constant");
            BitCellType$ bitCellType$ = cellType;
            if (BitCellType$.MODULE$.equals(bitCellType$)) {
                double n = v;
                raster2 = new Raster<Tile>(BitConstantTile$.MODULE$.apply(Double.isNaN(n) ? Integer.MIN_VALUE : (int)n, cols, rows), extent);
            } else if (ByteConstantNoDataCellType$.MODULE$.equals(bitCellType$)) {
                double n = v;
                raster2 = new Raster<ByteConstantTile>(new ByteConstantTile((byte)(Double.isNaN(n) ? -128 : (byte)n), cols, rows, ByteConstantTile$.MODULE$.apply$default$4()), extent);
            } else if (UByteConstantNoDataCellType$.MODULE$.equals(bitCellType$)) {
                double n = v;
                raster2 = new Raster<UByteConstantTile>(new UByteConstantTile((byte)(Double.isNaN(n) ? -128 : (byte)n), cols, rows, UByteConstantTile$.MODULE$.apply$default$4()), extent);
            } else if (ShortConstantNoDataCellType$.MODULE$.equals(bitCellType$)) {
                double n = v;
                raster2 = new Raster<ShortConstantTile>(new ShortConstantTile((short)(Double.isNaN(n) ? Short.MIN_VALUE : (short)n), cols, rows, ShortConstantTile$.MODULE$.apply$default$4()), extent);
            } else if (UShortConstantNoDataCellType$.MODULE$.equals(bitCellType$)) {
                double n = v;
                raster2 = new Raster<UShortConstantTile>(new UShortConstantTile((short)(Double.isNaN(n) ? Short.MIN_VALUE : (short)n), cols, rows, UShortConstantTile$.MODULE$.apply$default$4()), extent);
            } else if (IntConstantNoDataCellType$.MODULE$.equals(bitCellType$)) {
                double n = v;
                raster2 = new Raster<IntConstantTile>(new IntConstantTile(Double.isNaN(n) ? Integer.MIN_VALUE : (int)n, cols, rows, IntConstantTile$.MODULE$.apply$default$4()), extent);
            } else if (FloatConstantNoDataCellType$.MODULE$.equals(bitCellType$)) {
                raster2 = new Raster<FloatConstantTile>(new FloatConstantTile((float)v, cols, rows, FloatConstantTile$.MODULE$.apply$default$4()), extent);
            } else if (DoubleConstantNoDataCellType$.MODULE$.equals(bitCellType$)) {
                raster2 = new Raster<DoubleConstantTile>(new DoubleConstantTile(v, cols, rows, DoubleConstantTile$.MODULE$.apply$default$4()), extent);
            } else {
                throw new IllegalArgumentException(new StringBuilder(21).append("Unsupported datatype ").append(cellType).toString());
            }
            raster = raster2;
        } else {
            Raster<Tile> raster3;
            File file;
            String string5 = layerType;
            String string6 = "arg";
            if (string5 == null ? string6 != null : !string5.equals(string6)) {
                throw scala.sys.package$.MODULE$.error(new StringBuilder(43).append("Cannot read raster layer type ").append(layerType).append(", must be arg").toString());
            }
            if (json.hasPath("path")) {
                File f = new File(json.getString("path"));
                file = f.isAbsolute() ? f : new File(new File(path).getParent(), f.getPath());
            } else {
                String layerName = json.getString("layer");
                file = new File(new File(path).getParent(), new StringBuilder(4).append(layerName).append(".arg").toString());
            }
            String argPath = file.getAbsolutePath();
            Option<RasterExtent> option2 = targetRasterExtent;
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                RasterExtent te = (RasterExtent)some.value();
                raster3 = new Raster<Tile>(this.read(argPath, (DataType)cellType, RasterExtent$.MODULE$.apply(extent, cols, rows), te), te.extent());
            } else if (None$.MODULE$.equals(option2)) {
                raster3 = new Raster<Tile>(this.read(argPath, (DataType)cellType, cols, rows), extent);
            } else {
                throw new MatchError(option2);
            }
            raster = raster3;
        }
        return raster;
    }

    public final Tile read(String path, DataType cellType, int cols, int rows) {
        return ArrayTile$.MODULE$.fromBytes(Filesystem$.MODULE$.slurp(path, Filesystem$.MODULE$.slurp$default$2()), cellType, cols, rows);
    }

    public final Tile read(String path, DataType cellType, RasterExtent rasterExtent, RasterExtent targetExtent) {
        Tile tile;
        int size = cellType.numBytes(BoxesRunTime.unboxToInt(rasterExtent.size()));
        int cols = rasterExtent.cols();
        GridBounds<Object> gridBounds = rasterExtent.gridBoundsFor$mcI$sp(targetExtent.extent(), rasterExtent.gridBoundsFor$default$2());
        if (gridBounds == null) {
            throw new MatchError(gridBounds);
        }
        int colMin = gridBounds.colMin$mcI$sp();
        int rowMin = gridBounds.rowMin$mcI$sp();
        int colMax = gridBounds.colMax$mcI$sp();
        int rowMax = gridBounds.rowMax$mcI$sp();
        Tuple4 tuple42 = new Tuple4((Object)BoxesRunTime.boxToInteger((int)colMin), (Object)BoxesRunTime.boxToInteger((int)rowMin), (Object)BoxesRunTime.boxToInteger((int)colMax), (Object)BoxesRunTime.boxToInteger((int)rowMax));
        Tuple4 tuple43 = tuple42;
        int colMin2 = BoxesRunTime.unboxToInt((Object)tuple43._1());
        int rowMin2 = BoxesRunTime.unboxToInt((Object)tuple43._2());
        int colMax2 = BoxesRunTime.unboxToInt((Object)tuple43._3());
        int rowMax2 = BoxesRunTime.unboxToInt((Object)tuple43._4());
        int startIndex = scala.math.package$.MODULE$.max(cellType.numBytes((rowMin2 - 1) * cols + colMin2 - 1), 0);
        int length = scala.math.package$.MODULE$.min(size - startIndex, cellType.numBytes((rowMax2 + 1) * cols + colMax2 + 1) - startIndex);
        if (length > 0) {
            byte[] bytes = (byte[])Array$.MODULE$.ofDim(size, ClassTag$.MODULE$.Byte());
            Filesystem$.MODULE$.mapToByteArray(path, bytes, startIndex, length);
            tile = this.resampleBytes(bytes, cellType, rasterExtent, targetExtent);
        } else {
            tile = ArrayTile$.MODULE$.empty(cellType, targetExtent.cols(), targetExtent.rows());
        }
        return tile;
    }

    public final Tile resampleBytes(byte[] bytes, DataType cellType, RasterExtent re, RasterExtent targetRe) {
        MutableArrayTile mutableArrayTile;
        int cols = targetRe.cols();
        int rows = targetRe.rows();
        DataType dataType = cellType;
        if (BitCellType$.MODULE$.equals(dataType)) {
            byte[] resampled = (byte[])Array$.MODULE$.ofDim((cols * rows + 7) / 8, ClassTag$.MODULE$.Byte());
            ResampleAssign$.MODULE$.apply(re, targetRe, new BitResampleAssign(bytes, resampled));
            mutableArrayTile = new BitArrayTile(resampled, cols, rows);
        } else if (ByteConstantNoDataCellType$.MODULE$.equals(dataType)) {
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            byte[] resampled = package$ByteArrayFiller$.MODULE$.fill$extension(package$.MODULE$.ByteArrayFiller((byte[])Array$.MODULE$.ofDim(cols * rows, ClassTag$.MODULE$.Byte())), (byte)-128);
            ResampleAssign$.MODULE$.apply(re, targetRe, new ByteBufferResampleAssign(buffer, resampled));
            mutableArrayTile = ByteArrayTile$.MODULE$.apply(resampled, cols, rows);
        } else if (UByteConstantNoDataCellType$.MODULE$.equals(dataType)) {
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            byte[] resampled = package$ByteArrayFiller$.MODULE$.fill$extension(package$.MODULE$.ByteArrayFiller((byte[])Array$.MODULE$.ofDim(cols * rows, ClassTag$.MODULE$.Byte())), (byte)-128);
            ResampleAssign$.MODULE$.apply(re, targetRe, new ByteBufferResampleAssign(buffer, resampled));
            mutableArrayTile = UByteArrayTile$.MODULE$.apply(resampled, cols, rows);
        } else if (ShortConstantNoDataCellType$.MODULE$.equals(dataType)) {
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            short[] resampled = package$ShortArrayFiller$.MODULE$.fill$extension(package$.MODULE$.ShortArrayFiller((short[])Array$.MODULE$.ofDim(cols * rows, ClassTag$.MODULE$.Short())), (short)Short.MIN_VALUE);
            ResampleAssign$.MODULE$.apply(re, targetRe, new ShortBufferResampleAssign(buffer, resampled));
            mutableArrayTile = ShortArrayTile$.MODULE$.apply(resampled, cols, rows);
        } else if (UShortConstantNoDataCellType$.MODULE$.equals(dataType)) {
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            short[] resampled = package$ShortArrayFiller$.MODULE$.fill$extension(package$.MODULE$.ShortArrayFiller((short[])Array$.MODULE$.ofDim(cols * rows, ClassTag$.MODULE$.Short())), (short)Short.MIN_VALUE);
            ResampleAssign$.MODULE$.apply(re, targetRe, new ShortBufferResampleAssign(buffer, resampled));
            mutableArrayTile = UShortArrayTile$.MODULE$.apply(resampled, cols, rows);
        } else if (IntConstantNoDataCellType$.MODULE$.equals(dataType)) {
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            int[] resampled = package$IntArrayFiller$.MODULE$.fill$extension(package$.MODULE$.IntArrayFiller((int[])Array$.MODULE$.ofDim(cols * rows, ClassTag$.MODULE$.Int())), Integer.MIN_VALUE);
            ResampleAssign$.MODULE$.apply(re, targetRe, new IntBufferResampleAssign(buffer, resampled));
            mutableArrayTile = IntArrayTile$.MODULE$.apply(resampled, cols, rows);
        } else if (FloatConstantNoDataCellType$.MODULE$.equals(dataType)) {
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            float[] resampled = package$FloatArrayFiller$.MODULE$.fill$extension(package$.MODULE$.FloatArrayFiller((float[])Array$.MODULE$.ofDim(cols * rows, ClassTag$.MODULE$.Float())), Float.NaN);
            ResampleAssign$.MODULE$.apply(re, targetRe, new FloatBufferResampleAssign(buffer, resampled));
            mutableArrayTile = FloatArrayTile$.MODULE$.apply(resampled, cols, rows);
        } else if (DoubleConstantNoDataCellType$.MODULE$.equals(dataType)) {
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            double[] resampled = package$DoubleArrayFiller$.MODULE$.fill$extension(package$.MODULE$.DoubleArrayFiller((double[])Array$.MODULE$.ofDim(cols * rows, ClassTag$.MODULE$.Double())), Double.NaN);
            ResampleAssign$.MODULE$.apply(re, targetRe, new DoubleBufferResampleAssign(buffer, resampled));
            mutableArrayTile = DoubleArrayTile$.MODULE$.apply(resampled, cols, rows);
        } else {
            throw new IllegalArgumentException(new StringBuilder(21).append("Unsupported datatype ").append(cellType).toString());
        }
        return mutableArrayTile;
    }

    private ArgReader$() {
        MODULE$ = this;
    }
}

