/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.mapalgebra.focal;

import geotrellis.raster.DoubleArrayTile;
import geotrellis.raster.GridBounds;
import geotrellis.raster.Tile;
import geotrellis.raster.mapalgebra.focal.CellwiseCalculation;
import geotrellis.raster.mapalgebra.focal.DoubleArrayTileResult;
import geotrellis.raster.mapalgebra.focal.Neighborhood;
import geotrellis.raster.mapalgebra.focal.TargetCell;
import scala.Function4;
import scala.Option;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u000114A\u0001E\t\u00015!Ia\u0005\u0001B\u0001B\u0003%qd\n\u0005\tU\u0001\u0011\t\u0011)A\u0005W!Aa\u0006\u0001B\u0001B\u0003%q\u0006C\u0005<\u0001\t\u0005\t\u0015!\u0003=\u007f!)\u0001\t\u0001C\u0001\u0003\"9q\t\u0001a\u0001\n\u0003A\u0005bB%\u0001\u0001\u0004%\tA\u0013\u0005\u0007!\u0002\u0001\u000b\u0015\u0002\u001d\t\u000fE\u0003\u0001\u0019!C\u0001%\"9a\u000b\u0001a\u0001\n\u00039\u0006BB-\u0001A\u0003&1\u000bC\u0003[\u0001\u0011\u00051\fC\u0003b\u0001\u0011\u0005!\rC\u0003g\u0001\u0011\u0005q\rC\u0003k\u0001\u0011\u00051N\u0001\fDK2dw/[:f\u001b\u0016\fgnQ1mG\u0012{WO\u00197f\u0015\t\u00112#A\u0003g_\u000e\fGN\u0003\u0002\u0015+\u0005QQ.\u00199bY\u001e,'M]1\u000b\u0005Y9\u0012A\u0002:bgR,'OC\u0001\u0019\u0003)9Wm\u001c;sK2d\u0017n]\u0002\u0001'\r\u00011d\t\t\u00049uyR\"A\t\n\u0005y\t\"aE\"fY2<\u0018n]3DC2\u001cW\u000f\\1uS>t\u0007C\u0001\u0011\"\u001b\u0005)\u0012B\u0001\u0012\u0016\u0005\u0011!\u0016\u000e\\3\u0011\u0005q!\u0013BA\u0013\u0012\u0005U!u.\u001e2mK\u0006\u0013(/Y=US2,'+Z:vYR\f\u0011A]\u0005\u0003M!J!!K\t\u0003!\u0019{7-\u00197DC2\u001cW\u000f\\1uS>t\u0017!\u00018\u0011\u0005qa\u0013BA\u0017\u0012\u00051qU-[4iE>\u0014\bn\\8e\u0003\u0019\u0011w.\u001e8egB\u0019\u0001gM\u001b\u000e\u0003ER\u0011AM\u0001\u0006g\u000e\fG.Y\u0005\u0003iE\u0012aa\u00149uS>t\u0007c\u0001\u00117q%\u0011q'\u0006\u0002\u000b\u000fJLGMQ8v]\u0012\u001c\bC\u0001\u0019:\u0013\tQ\u0014GA\u0002J]R\fa\u0001^1sO\u0016$\bC\u0001\u000f>\u0013\tq\u0014C\u0001\u0006UCJ<W\r^\"fY2L!a\u000f\u0015\u0002\rqJg.\u001b;?)\u0015\u00115\tR#G!\ta\u0002\u0001C\u0003'\u000b\u0001\u0007q\u0004C\u0003+\u000b\u0001\u00071\u0006C\u0003/\u000b\u0001\u0007q\u0006C\u0003<\u000b\u0001\u0007A(A\u0003d_VtG/F\u00019\u0003%\u0019w.\u001e8u?\u0012*\u0017\u000f\u0006\u0002L\u001dB\u0011\u0001\u0007T\u0005\u0003\u001bF\u0012A!\u00168ji\"9qjBA\u0001\u0002\u0004A\u0014a\u0001=%c\u000511m\\;oi\u0002\n1a];n+\u0005\u0019\u0006C\u0001\u0019U\u0013\t)\u0016G\u0001\u0004E_V\u0014G.Z\u0001\bgVlw\fJ3r)\tY\u0005\fC\u0004P\u0015\u0005\u0005\t\u0019A*\u0002\tM,X\u000eI\u0001\u0004C\u0012$G\u0003B&];~CQA\n\u0007A\u0002}AQA\u0018\u0007A\u0002a\n\u0011\u0001\u001f\u0005\u0006A2\u0001\r\u0001O\u0001\u0002s\u00061!/Z7pm\u0016$BaS2eK\")a%\u0004a\u0001?!)a,\u0004a\u0001q!)\u0001-\u0004a\u0001q\u0005A1/\u001a;WC2,X\rF\u0002LQ&DQA\u0018\bA\u0002aBQ\u0001\u0019\bA\u0002a\nQA]3tKR$\u0012a\u0013")
public class CellwiseMeanCalcDouble
extends CellwiseCalculation<Tile>
implements DoubleArrayTileResult {
    private int count;
    private double sum;
    private final int cols;
    private final int rows;
    private final DoubleArrayTile resultTile;
    private final Function4<Object, Object, Object, Object, BoxedUnit> copyOriginalValue;

    @Override
    public DoubleArrayTile result() {
        return DoubleArrayTileResult.result$(this);
    }

    @Override
    public int cols() {
        return this.cols;
    }

    @Override
    public int rows() {
        return this.rows;
    }

    @Override
    public DoubleArrayTile resultTile() {
        return this.resultTile;
    }

    @Override
    public Function4<Object, Object, Object, Object, BoxedUnit> copyOriginalValue() {
        return this.copyOriginalValue;
    }

    @Override
    public void geotrellis$raster$mapalgebra$focal$DoubleArrayTileResult$_setter_$cols_$eq(int x$1) {
        this.cols = x$1;
    }

    @Override
    public void geotrellis$raster$mapalgebra$focal$DoubleArrayTileResult$_setter_$rows_$eq(int x$1) {
        this.rows = x$1;
    }

    @Override
    public void geotrellis$raster$mapalgebra$focal$DoubleArrayTileResult$_setter_$resultTile_$eq(DoubleArrayTile x$1) {
        this.resultTile = x$1;
    }

    @Override
    public void geotrellis$raster$mapalgebra$focal$DoubleArrayTileResult$_setter_$copyOriginalValue_$eq(Function4<Object, Object, Object, Object, BoxedUnit> x$1) {
        this.copyOriginalValue = x$1;
    }

    public int count() {
        return this.count;
    }

    public void count_$eq(int x$1) {
        this.count = x$1;
    }

    public double sum() {
        return this.sum;
    }

    public void sum_$eq(double x$1) {
        this.sum = x$1;
    }

    @Override
    public void add(Tile r, int x, int y) {
        block0: {
            double z = r.getDouble(x, y);
            if (Double.isNaN(z)) break block0;
            this.count_$eq(this.count() + 1);
            this.sum_$eq(this.sum() + z);
        }
    }

    @Override
    public void remove(Tile r, int x, int y) {
        block2: {
            double v = r.getDouble(x, y);
            if (Double.isNaN(v)) break block2;
            this.count_$eq(this.count() - 1);
            if (this.count() == 0) {
                this.sum_$eq(0.0);
            } else {
                this.sum_$eq(this.sum() - v);
            }
        }
    }

    @Override
    public void setValue(int x, int y) {
        this.resultTile().setDouble(x, y, this.sum() / (double)this.count());
    }

    @Override
    public void reset() {
        this.count_$eq(0);
        this.sum_$eq(0.0);
    }

    public CellwiseMeanCalcDouble(Tile r, Neighborhood n, Option<GridBounds<Object>> bounds, TargetCell target) {
        super(r, n, bounds, target);
        DoubleArrayTileResult.$init$(this);
        this.count = 0;
        this.sum = 0.0;
    }
}

