/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.vector.io.wkb;

import geotrellis.vector.io.wkb.WKBConstants$;
import geotrellis.vector.io.wkb.WKBWriter$;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.io.ByteOrderValues;
import org.locationtech.jts.io.OutStream;
import org.locationtech.jts.io.OutputStreamOutStream;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0001\u0005=w!B\u0010!\u0011\u0003Ic!B\u0016!\u0011\u0003a\u0003\"B\u001a\u0002\t\u0003!\u0004\"B\u001b\u0002\t\u00031d\u0001B\u0016!\u0001)C\u0001b\u0013\u0003\u0003\u0002\u0003\u0006I\u0001\u0014\u0005\t\u001f\u0012\u0011\t\u0011)A\u0005\u0019\")1\u0007\u0002C\u0001!\")1\u0007\u0002C\u0001)\")1\u0007\u0002C\u0001-\"9q\u000b\u0002b\u0001\n\u0013A\u0006B\u00021\u0005A\u0003%\u0011\fC\u0004b\t\t\u0007I\u0011\u00022\t\r\r$\u0001\u0015!\u0003E\u0011\u001d!GA1A\u0005\n\u0015Da!\u001d\u0003!\u0002\u00131\u0007b\u0002:\u0005\u0001\u0004%Ia\u001d\u0005\bo\u0012\u0001\r\u0011\"\u0003y\u0011\u0019qH\u0001)Q\u0005i\"1q\u0010\u0002C\u0001\u0003\u0003A\u0011\"a\b\u0005#\u0003%\t!!\t\t\r}$A\u0011BA\u001c\u0011\u001d\t)\u0005\u0002C\u0005\u0003\u000fBq!!\u0016\u0005\t\u0013\t9\u0006C\u0004\u0002f\u0011!I!a\u001a\t\u000f\u0005UD\u0001\"\u0003\u0002x!9\u0011\u0011\u0012\u0003\u0005\n\u0005-\u0005bBAH\t\u0011%\u0011\u0011\u0013\u0005\b\u00037#A\u0011BAO\u0011\u001d\t)\u000b\u0002C\u0005\u0003OCq!!0\u0005\t\u0013\ty,A\u0005X\u0017\n;&/\u001b;fe*\u0011\u0011EI\u0001\u0004o.\u0014'BA\u0012%\u0003\tIwN\u0003\u0002&M\u00051a/Z2u_JT\u0011aJ\u0001\u000bO\u0016|GO]3mY&\u001c8\u0001\u0001\t\u0003U\u0005i\u0011\u0001\t\u0002\n/.\u0013uK]5uKJ\u001c\"!A\u0017\u0011\u00059\nT\"A\u0018\u000b\u0003A\nQa]2bY\u0006L!AM\u0018\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t\u0011&A\u0003u_\"+\u0007\u0010\u0006\u00028\u0005B\u0011\u0001h\u0010\b\u0003su\u0002\"AO\u0018\u000e\u0003mR!\u0001\u0010\u0015\u0002\rq\u0012xn\u001c;?\u0013\tqt&\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0001\u0006\u0013aa\u0015;sS:<'B\u0001 0\u0011\u0015\u00195\u00011\u0001E\u0003\u0015\u0011\u0017\u0010^3t!\rqSiR\u0005\u0003\r>\u0012Q!\u0011:sCf\u0004\"A\f%\n\u0005%{#\u0001\u0002\"zi\u0016\u001c\"\u0001B\u0017\u0002\u001f=,H\u000f];u\t&lWM\\:j_:\u0004\"AL'\n\u00059{#aA%oi\u0006I!-\u001f;f\u001fJ$WM\u001d\u000b\u0004#J\u001b\u0006C\u0001\u0016\u0005\u0011\u0015Yu\u00011\u0001M\u0011\u0015yu\u00011\u0001M)\t\tV\u000bC\u0003L\u0011\u0001\u0007A\nF\u0001R\u0003-\u0011\u0017\u0010^3BeJ\f\u0017pT*\u0016\u0003e\u0003\"A\u00170\u000e\u0003mS!a\t/\u000b\u0003u\u000bAA[1wC&\u0011ql\u0017\u0002\u0016\u0005f$X-\u0011:sCf|U\u000f\u001e9viN#(/Z1n\u00031\u0011\u0017\u0010^3BeJ\f\u0017pT*!\u0003\r\u0011WOZ\u000b\u0002\t\u0006!!-\u001e4!\u0003I\u0011\u0017\u0010^3BeJ\f\u0017pT;u'R\u0014X-Y7\u0016\u0003\u0019\u0004\"aZ8\u000e\u0003!T!aI5\u000b\u0005)\\\u0017a\u00016ug*\u0011A.\\\u0001\rY>\u001c\u0017\r^5p]R,7\r\u001b\u0006\u0002]\u0006\u0019qN]4\n\u0005AD'!F(viB,Ho\u0015;sK\u0006lw*\u001e;TiJ,\u0017-\\\u0001\u0014Ef$X-\u0011:sCf|U\u000f^*ue\u0016\fW\u000eI\u0001\u0005gJLG-F\u0001u!\rqS\u000fT\u0005\u0003m>\u0012aa\u00149uS>t\u0017\u0001C:sS\u0012|F%Z9\u0015\u0005ed\bC\u0001\u0018{\u0013\tYxF\u0001\u0003V]&$\bbB?\u0012\u0003\u0003\u0005\r\u0001^\u0001\u0004q\u0012\n\u0014!B:sS\u0012\u0004\u0013!B<sSR,G#\u0002#\u0002\u0004\u0005u\u0001bBA\u0003'\u0001\u0007\u0011qA\u0001\u0005O\u0016|W\u000e\u0005\u0003\u0002\n\u0005]a\u0002BA\u0006\u0003'qA!!\u0004\u0002\u00129\u0019!(a\u0004\n\u0003\u001dJ!!\n\u0014\n\u0007\u0005UA%A\u0004qC\u000e\\\u0017mZ3\n\t\u0005e\u00111\u0004\u0002\t\u000f\u0016|W.\u001a;ss*\u0019\u0011Q\u0003\u0013\t\u000fI\u001c\u0002\u0013!a\u0001i\u0006yqO]5uK\u0012\"WMZ1vYR$#'\u0006\u0002\u0002$)\u001aA/!\n,\u0005\u0005\u001d\u0002\u0003BA\u0015\u0003gi!!a\u000b\u000b\t\u00055\u0012qF\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\r0\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003k\tYCA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016$R!_A\u001d\u0003wAq!!\u0002\u0016\u0001\u0004\t9\u0001C\u0004\u0002>U\u0001\r!a\u0010\u0002\u0005=\u001c\bcA4\u0002B%\u0019\u00111\t5\u0003\u0013=+Ho\u0015;sK\u0006l\u0017AC<sSR,\u0007k\\5oiR)\u00110!\u0013\u0002T!9\u00111\n\fA\u0002\u00055\u0013A\u00019u!\u0011\tI!a\u0014\n\t\u0005E\u00131\u0004\u0002\u0006!>Lg\u000e\u001e\u0005\b\u0003{1\u0002\u0019AA \u0003=9(/\u001b;f\u0019&tWm\u0015;sS:<G#B=\u0002Z\u0005\r\u0004bBA./\u0001\u0007\u0011QL\u0001\u0005Y&tW\r\u0005\u0003\u0002\n\u0005}\u0013\u0002BA1\u00037\u0011!\u0002T5oKN#(/\u001b8h\u0011\u001d\tid\u0006a\u0001\u0003\u007f\tAb\u001e:ji\u0016\u0004v\u000e\\=h_:$R!_A5\u0003gBq!a\u001b\u0019\u0001\u0004\ti'\u0001\u0003q_2L\b\u0003BA\u0005\u0003_JA!!\u001d\u0002\u001c\t9\u0001k\u001c7zO>t\u0007bBA\u001f1\u0001\u0007\u0011qH\u0001\u0018oJLG/Z$f_6,GO]=D_2dWm\u0019;j_:$r!_A=\u0003{\n9\t\u0003\u0004\u0002|e\u0001\r\u0001T\u0001\rO\u0016|W.\u001a;ssRK\b/\u001a\u0005\b\u0003\u007fJ\u0002\u0019AAA\u0003\t97\r\u0005\u0003\u0002\n\u0005\r\u0015\u0002BAC\u00037\u0011!cR3p[\u0016$(/_\"pY2,7\r^5p]\"9\u0011QH\rA\u0002\u0005}\u0012AD<sSR,')\u001f;f\u001fJ$WM\u001d\u000b\u0004s\u00065\u0005bBA\u001f5\u0001\u0007\u0011qH\u0001\u0012oJLG/Z$f_6,GO]=UsB,GcB=\u0002\u0014\u0006U\u0015\u0011\u0014\u0005\u0007\u0003wZ\u0002\u0019\u0001'\t\u000f\u0005]5\u00041\u0001\u0002\b\u0005\tq\rC\u0004\u0002>m\u0001\r!a\u0010\u0002\u0011]\u0014\u0018\u000e^3J]R$R!_AP\u0003GCa!!)\u001d\u0001\u0004a\u0015\u0001C5oiZ\u000bG.^3\t\u000f\u0005uB\u00041\u0001\u0002@\u0005yqO]5uK\u000e{wN\u001d3j]\u0006$X\rF\u0004z\u0003S\u000b9,a/\t\u000f\u0005-V\u00041\u0001\u0002.\u0006\u00191/Z9\u0011\t\u0005=\u00161W\u0007\u0003\u0003cS1!!\u0002j\u0013\u0011\t),!-\u0003%\r{wN\u001d3j]\u0006$XmU3rk\u0016t7-\u001a\u0005\u0007\u0003sk\u0002\u0019\u0001'\u0002\u000b%tG-\u001a=\t\u000f\u0005uR\u00041\u0001\u0002@\u00059rO]5uK\u000e{wN\u001d3j]\u0006$XmU3rk\u0016t7-\u001a\u000b\bs\u0006\u0005\u00171YAg\u0011\u001d\tYK\ba\u0001\u0003[Cq!!2\u001f\u0001\u0004\t9-A\u0005xe&$XmU5{KB\u0019a&!3\n\u0007\u0005-wFA\u0004C_>dW-\u00198\t\u000f\u0005ub\u00041\u0001\u0002@\u0001")
public class WKBWriter {
    private final int outputDimension;
    private final int byteOrder;
    private final ByteArrayOutputStream byteArrayOS;
    private final byte[] buf;
    private final OutputStreamOutStream byteArrayOutStream;
    private Option<Object> srid;

    public static String toHex(byte[] byArray) {
        return WKBWriter$.MODULE$.toHex(byArray);
    }

    private ByteArrayOutputStream byteArrayOS() {
        return this.byteArrayOS;
    }

    private byte[] buf() {
        return this.buf;
    }

    private OutputStreamOutStream byteArrayOutStream() {
        return this.byteArrayOutStream;
    }

    private Option<Object> srid() {
        return this.srid;
    }

    private void srid_$eq(Option<Object> x$1) {
        this.srid = x$1;
    }

    public byte[] write(Geometry geom, Option<Object> srid) {
        this.byteArrayOS().reset();
        this.srid_$eq(srid);
        this.write(geom, (OutStream)this.byteArrayOutStream());
        return this.byteArrayOS().toByteArray();
    }

    private void write(Geometry geom, OutStream os) {
        block7: {
            while (true) {
                Geometry geometry;
                if ((geometry = geom) instanceof Point) {
                    Point point = (Point)geometry;
                    this.writePoint(point, os);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block7;
                }
                if (geometry instanceof LineString) {
                    LineString lineString = (LineString)geometry;
                    this.writeLineString(lineString, os);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block7;
                }
                if (geometry instanceof Polygon) {
                    Polygon polygon = (Polygon)geometry;
                    this.writePolygon(polygon, os);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block7;
                }
                if (geometry instanceof MultiPoint) {
                    MultiPoint multiPoint = (MultiPoint)geometry;
                    this.writeGeometryCollection(WKBConstants$.MODULE$.wkbMultiPoint(), (GeometryCollection)multiPoint, os);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block7;
                }
                if (geometry instanceof MultiLineString) {
                    MultiLineString multiLineString = (MultiLineString)geometry;
                    this.writeGeometryCollection(WKBConstants$.MODULE$.wkbMultiLineString(), (GeometryCollection)multiLineString, os);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block7;
                }
                if (geometry instanceof MultiPolygon) {
                    MultiPolygon multiPolygon = (MultiPolygon)geometry;
                    this.writeGeometryCollection(WKBConstants$.MODULE$.wkbMultiPolygon(), (GeometryCollection)multiPolygon, os);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block7;
                }
                if (!(geometry instanceof GeometryCollection)) break;
                GeometryCollection geometryCollection = (GeometryCollection)geometry;
                geom = geometryCollection;
            }
            throw package$.MODULE$.error("Unknown Geometry type");
        }
    }

    public Option<Object> write$default$2() {
        return None$.MODULE$;
    }

    private void writePoint(Point pt, OutStream os) {
        if (pt.getCoordinateSequence().size() == 0) {
            throw new IllegalArgumentException("Empty Points cannot be represented in WKB");
        }
        this.writeByteOrder(os);
        this.writeGeometryType(WKBConstants$.MODULE$.wkbPoint(), (Geometry)pt, os);
        this.writeCoordinateSequence(pt.getCoordinateSequence(), false, os);
    }

    private void writeLineString(LineString line, OutStream os) {
        this.writeByteOrder(os);
        this.writeGeometryType(WKBConstants$.MODULE$.wkbLineString(), (Geometry)line, os);
        this.writeCoordinateSequence(line.getCoordinateSequence(), true, os);
    }

    private void writePolygon(Polygon poly, OutStream os) {
        this.writeByteOrder(os);
        this.writeGeometryType(WKBConstants$.MODULE$.wkbPolygon(), (Geometry)poly, os);
        this.writeInt(poly.getNumInteriorRing() + 1, os);
        this.writeCoordinateSequence(poly.getExteriorRing().getCoordinateSequence(), true, os);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), poly.getNumInteriorRing()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> this.writeCoordinateSequence(poly.getInteriorRingN(i).getCoordinateSequence(), true, os));
    }

    private void writeGeometryCollection(int geometryType, GeometryCollection gc, OutStream os) {
        this.writeByteOrder(os);
        this.writeGeometryType(geometryType, (Geometry)gc, os);
        this.writeInt(gc.getNumGeometries(), os);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), gc.getNumGeometries()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> this.write(gc.getGeometryN(i), os));
    }

    private void writeByteOrder(OutStream os) {
        this.buf()[0] = this.byteOrder == 2 ? WKBConstants$.MODULE$.wkbNDR() : WKBConstants$.MODULE$.wkbXDR();
        os.write(this.buf(), 1);
    }

    private void writeGeometryType(int geometryType, Geometry g, OutStream os) {
        int flag3D = this.outputDimension == 3 ? Integer.MIN_VALUE : 0;
        Option<Object> option2 = this.srid();
        if (option2 instanceof Some) {
            int srid;
            Some some = (Some)option2;
            int n = srid = BoxesRunTime.unboxToInt((Object)some.value());
            int typeInt = geometryType | flag3D | 0x20000000;
            this.writeInt(typeInt, os);
            this.writeInt(n, os);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option2)) {
            int typeInt = geometryType | flag3D;
            this.writeInt(typeInt, os);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option2);
        }
    }

    private void writeInt(int intValue, OutStream os) {
        ByteOrderValues.putInt((int)intValue, (byte[])this.buf(), (int)this.byteOrder);
        os.write(this.buf(), 4);
    }

    private void writeCoordinate(CoordinateSequence seq, int index, OutStream os) {
        block1: {
            ByteOrderValues.putDouble((double)seq.getX(index), (byte[])this.buf(), (int)this.byteOrder);
            os.write(this.buf(), 8);
            ByteOrderValues.putDouble((double)seq.getY(index), (byte[])this.buf(), (int)this.byteOrder);
            os.write(this.buf(), 8);
            if (this.outputDimension < 3) break block1;
            double ordVal = Double.NaN;
            if (seq.getDimension() >= 3) {
                ordVal = seq.getOrdinate(index, 2);
            }
            ByteOrderValues.putDouble((double)ordVal, (byte[])this.buf(), (int)this.byteOrder);
            os.write(this.buf(), 8);
        }
    }

    private void writeCoordinateSequence(CoordinateSequence seq, boolean writeSize, OutStream os) {
        if (writeSize) {
            this.writeInt(seq.size(), os);
        }
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), seq.size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> this.writeCoordinate(seq, i, os));
    }

    public WKBWriter(int outputDimension, int byteOrder) {
        this.outputDimension = outputDimension;
        this.byteOrder = byteOrder;
        Predef$.MODULE$.require(outputDimension == 2 || outputDimension == 3, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Output dimension (").append($this.outputDimension).append(") must be 2 or 3").toString());
        Predef$.MODULE$.require(byteOrder == 1 || byteOrder == 2, (Function0 & Serializable & scala.Serializable)() -> "Invalid byteOrder");
        this.byteArrayOS = new ByteArrayOutputStream();
        this.buf = new byte[8];
        this.byteArrayOutStream = new OutputStreamOutStream((OutputStream)this.byteArrayOS());
        this.srid = None$.MODULE$;
    }

    public WKBWriter(int outputDimension) {
        this(outputDimension, 1);
    }

    public WKBWriter() {
        this(2, 1);
    }
}

