/*
 * Decompiled with CFR 0.152.
 */
package squants.motion;

import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Set;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Try;
import squants.Dimension;
import squants.Quantity;
import squants.UnitOfMeasure;
import squants.energy.Energy;
import squants.energy.Joules$;
import squants.mass.Kilograms$;
import squants.mass.Mass;
import squants.motion.Acceleration;
import squants.motion.Force$;
import squants.motion.ForceUnit;
import squants.motion.KiloElectronVoltsPerMicrometer$;
import squants.motion.KilogramForce$;
import squants.motion.MegaElectronVoltsPerCentimeter$;
import squants.motion.MetersPerSecondSquared$;
import squants.motion.Momentum;
import squants.motion.NewtonSeconds$;
import squants.motion.Newtons$;
import squants.motion.NewtonsPerSecond$;
import squants.motion.Pascals$;
import squants.motion.PoundForce$;
import squants.motion.Pressure;
import squants.motion.Yank;
import squants.space.Area;
import squants.space.Length;
import squants.space.SquareMeters$;
import squants.time.Frequency;
import squants.time.Seconds$;
import squants.time.Time;
import squants.time.TimeDerivative;
import squants.time.TimeIntegral;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005]f\u0001B\u0010!\u0005\u0015B\u0001b\u000f\u0001\u0003\u0006\u0004%\t\u0001\u0010\u0005\t\u0007\u0002\u0011\t\u0011)A\u0005{!AA\t\u0001BC\u0002\u0013\u0005Q\t\u0003\u0005J\u0001\t\u0005\t\u0015!\u0003G\u0011\u0015Q\u0005\u0001\"\u0003L\u0011\u0015q\u0005\u0001\"\u0001P\u0011!\t\t\u0006\u0001C\tE\u0005M\u0003bBA+\u0001\u0011E\u0011q\u000b\u0005\u0007_\u0001!\t%!\u0017\t\u000f\u0005\u0005\u0004\u0001\"\u0001\u0002d!9\u0011q\u0010\u0001\u0005\u0002\u0005\u0005\u0005bBA@\u0001\u0011\u0005\u0011Q\u0011\u0005\b\u0003\u007f\u0002A\u0011AAK\u0011\u001d\ty\b\u0001C\u0001\u00033Cq!a \u0001\t\u0003\tI\u000b\u0003\u0004\u0002.\u0002!\t\u0001\u0010\u0005\u0007\u0003_\u0003A\u0011\u0001\u001f\t\r\u0005E\u0006\u0001\"\u0001=\u0011\u0019\t\u0019\f\u0001C\u0001y!1\u0011Q\u0017\u0001\u0005\u0002q:Q!\u0015\u0011\t\u0002I3Qa\b\u0011\t\u0002MCQA\u0013\f\u0005\u0002uCaA\u0018\f\u0005\u0002\u0001z\u0006\"\u00020\u0017\t\u0003q\bbBA\u0007-\u0011\u0005\u0011q\u0002\u0005\b\u0003C1B\u0011AA\u0012\u0011\u001d\tYC\u0006C\u0001\u0003GAq!!\f\u0017\t\u0003\ty\u0003C\u0005\u0002HY\t\t\u0011\"\u0003\u0002J\t)ai\u001c:dK*\u0011\u0011EI\u0001\u0007[>$\u0018n\u001c8\u000b\u0003\r\nqa]9vC:$8o\u0001\u0001\u0014\t\u00011C&\u000e\t\u0004O!RS\"\u0001\u0012\n\u0005%\u0012#\u0001C)vC:$\u0018\u000e^=\u0011\u0005-\u0002Q\"\u0001\u0011\u0011\u00075\u0002$'D\u0001/\u0015\ty#%\u0001\u0003uS6,\u0017BA\u0019/\u00059!\u0016.\\3EKJLg/\u0019;jm\u0016\u0004\"aK\u001a\n\u0005Q\u0002#\u0001C'p[\u0016tG/^7\u0011\u000752\u0004(\u0003\u00028]\taA+[7f\u0013:$Xm\u001a:bYB\u00111&O\u0005\u0003u\u0001\u0012A!W1oW\u0006)a/\u00197vKV\tQ\b\u0005\u0002?\u00036\tqHC\u0001A\u0003\u0015\u00198-\u00197b\u0013\t\u0011uH\u0001\u0004E_V\u0014G.Z\u0001\u0007m\u0006dW/\u001a\u0011\u0002\tUt\u0017\u000e^\u000b\u0002\rB\u00111fR\u0005\u0003\u0011\u0002\u0012\u0011BR8sG\u0016,f.\u001b;\u0002\u000bUt\u0017\u000e\u001e\u0011\u0002\rqJg.\u001b;?)\rQC*\u0014\u0005\u0006w\u0015\u0001\r!\u0010\u0005\u0006\t\u0016\u0001\rAR\u0001\nI&lWM\\:j_:,\u0012\u0001\u0015\b\u0003WU\tQAR8sG\u0016\u0004\"a\u000b\f\u0014\tY!vK\u0017\t\u0003}UK!AV \u0003\r\u0005s\u0017PU3g!\r9\u0003LK\u0005\u00033\n\u0012\u0011\u0002R5nK:\u001c\u0018n\u001c8\u0011\u0005yZ\u0016B\u0001/@\u00051\u0019VM]5bY&T\u0018M\u00197f)\u0005\u0011\u0016!B1qa2LXC\u00011s)\r\t70 \u000b\u0003U\tDQa\u0019\rA\u0004\u0011\f1A\\;n!\r)W\u000e\u001d\b\u0003M.t!a\u001a6\u000e\u0003!T!!\u001b\u0013\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0001\u0015B\u00017@\u0003\u001d\u0001\u0018mY6bO\u0016L!A\\8\u0003\u000f9+X.\u001a:jG*\u0011An\u0010\t\u0003cJd\u0001\u0001B\u0003t1\t\u0007AOA\u0001B#\t)\b\u0010\u0005\u0002?m&\u0011qo\u0010\u0002\b\u001d>$\b.\u001b8h!\tq\u00140\u0003\u0002{\u007f\t\u0019\u0011I\\=\t\u000bqD\u0002\u0019\u00019\u0002\u00039DQ\u0001\u0012\rA\u0002\u0019#2a`A\u0006!\u0015\t\t!a\u0002+\u001b\t\t\u0019AC\u0002\u0002\u0006}\nA!\u001e;jY&!\u0011\u0011BA\u0002\u0005\r!&/\u001f\u0005\u0006we\u0001\r\u0001_\u0001\u0005]\u0006lW-\u0006\u0002\u0002\u0012A!\u00111CA\u000f\u001b\t\t)B\u0003\u0003\u0002\u0018\u0005e\u0011\u0001\u00027b]\u001eT!!a\u0007\u0002\t)\fg/Y\u0005\u0005\u0003?\t)B\u0001\u0004TiJLgnZ\u0001\faJLW.\u0019:z+:LG/\u0006\u0002\u0002&9\u00191&a\n\n\u0007\u0005%\u0002%A\u0004OK^$xN\\:\u0002\rMLWK\\5u\u0003\u0015)h.\u001b;t+\t\t\t\u0004\u0005\u0004\u00024\u0005u\u0012\u0011I\u0007\u0003\u0003kQA!a\u000e\u0002:\u0005I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0004\u0003wy\u0014AC2pY2,7\r^5p]&!\u0011qHA\u001b\u0005\r\u0019V\r\u001e\t\u0005O\u0005\r#&C\u0002\u0002F\t\u0012Q\"\u00168ji>3W*Z1tkJ,\u0017a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!a\u0013\u0011\t\u0005M\u0011QJ\u0005\u0005\u0003\u001f\n)B\u0001\u0004PE*,7\r^\u0001\u000fi&lW-\u00138uK\u001e\u0014\u0018\r^3e+\u0005\u0011\u0014a\u0003;j[\u0016$UM]5wK\u0012,\u0012\u0001O\u000b\u0003\u00037\u00022!LA/\u0013\r\tyF\f\u0002\u0005)&lW-\u0001\u0004%i&lWm\u001d\u000b\u0005\u0003K\n)\b\u0005\u0003\u0002h\u0005=d\u0002BA5\u0003[r1aZA6\u0013\u0005\u0019\u0013B\u00017#\u0013\u0011\t\t(a\u001d\u0003\r\u0015sWM]4z\u0015\ta'\u0005C\u0004\u0002x)\u0001\r!!\u001f\u0002\tQD\u0017\r\u001e\t\u0005\u0003O\nY(\u0003\u0003\u0002~\u0005M$A\u0002'f]\u001e$\b.\u0001\u0003%I&4HcA;\u0002\u0004\"9\u0011qO\u0006A\u0002\u0005eD\u0003BAD\u0003\u001b\u00032aKAE\u0013\r\tY\t\t\u0002\r\u0003\u000e\u001cW\r\\3sCRLwN\u001c\u0005\b\u0003ob\u0001\u0019AAH!\u0011\t9'!%\n\t\u0005M\u00151\u000f\u0002\u0005\u001b\u0006\u001c8\u000f\u0006\u0003\u0002\u0010\u0006]\u0005bBA<\u001b\u0001\u0007\u0011q\u0011\u000b\u0005\u00037\u000b\t\u000bE\u0002,\u0003;K1!a(!\u0005!\u0001&/Z:tkJ,\u0007bBA<\u001d\u0001\u0007\u00111\u0015\t\u0005\u0003O\n)+\u0003\u0003\u0002(\u0006M$\u0001B!sK\u0006$B!a)\u0002,\"9\u0011qO\bA\u0002\u0005m\u0015!\u0003;p\u001d\u0016<Ho\u001c8t\u0003=!xnS5m_\u001e\u0014\u0018-\u001c$pe\u000e,\u0017\u0001\u0004;p!>,h\u000e\u001a$pe\u000e,\u0017\u0001\t;p\u0017&dw.\u00127fGR\u0014xN\u001c,pYR\u001c\b+\u001a:NS\u000e\u0014x.\\3uKJ\f\u0001\u0005^8NK\u001e\fW\t\\3diJ|gNV8miN\u0004VM]\"f]RLW.\u001a;fe\u0002")
public final class Force
extends Quantity<Force>
implements TimeDerivative<Momentum>,
TimeIntegral<Yank> {
    private final double value;
    private final ForceUnit unit;

    public static Set<UnitOfMeasure<Force>> units() {
        return Force$.MODULE$.units();
    }

    public static Newtons$ siUnit() {
        return Force$.MODULE$.siUnit();
    }

    public static Newtons$ primaryUnit() {
        return Force$.MODULE$.primaryUnit();
    }

    public static String name() {
        return Force$.MODULE$.name();
    }

    public static Try<Force> apply(Object object) {
        return Force$.MODULE$.apply(object);
    }

    public static Dimension<Force> dimensionImplicit() {
        return Force$.MODULE$.dimensionImplicit();
    }

    public static <N> Try<Force> parseTuple(Tuple2<N, String> tuple22, Numeric<N> numeric) {
        return Force$.MODULE$.parseTuple(tuple22, numeric);
    }

    public static Try<Force> parseString(String string2) {
        return Force$.MODULE$.parseString(string2);
    }

    public static Option<UnitOfMeasure<Force>> symbolToUnit(String string2) {
        return Force$.MODULE$.symbolToUnit(string2);
    }

    @Override
    public Quantity $div(Time that) {
        return TimeIntegral.$div$((TimeIntegral)this, that);
    }

    @Override
    public Quantity per(Time that) {
        return TimeIntegral.per$(this, that);
    }

    @Override
    public Time $div(Quantity that) {
        return TimeIntegral.$div$((TimeIntegral)this, that);
    }

    @Override
    public Quantity $times(Frequency that) {
        return TimeIntegral.$times$(this, that);
    }

    @Override
    public Quantity $times(Time that) {
        return TimeDerivative.$times$(this, that);
    }

    @Override
    public Frequency $div(Quantity that) {
        return TimeDerivative.$div$(this, that);
    }

    @Override
    public double value() {
        return this.value;
    }

    public ForceUnit unit() {
        return this.unit;
    }

    public Force$ dimension() {
        return Force$.MODULE$;
    }

    @Override
    public Momentum timeIntegrated() {
        return NewtonSeconds$.MODULE$.apply(BoxesRunTime.boxToDouble((double)this.toNewtons()), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    @Override
    public Yank timeDerived() {
        return NewtonsPerSecond$.MODULE$.apply(BoxesRunTime.boxToDouble((double)this.toNewtons()), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    @Override
    public Time time() {
        return Seconds$.MODULE$.apply(BoxesRunTime.boxToInteger((int)1), (Numeric)Numeric.IntIsIntegral$.MODULE$);
    }

    public Energy $times(Length that) {
        return Joules$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toNewtons() * that.toMeters())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Nothing$ $div(Length that) {
        return Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public Acceleration $div(Mass that) {
        return MetersPerSecondSquared$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toNewtons() / that.toKilograms())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Mass $div(Acceleration that) {
        return Kilograms$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toNewtons() / that.toMetersPerSecondSquared())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Pressure $div(Area that) {
        return Pascals$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toNewtons() / that.toSquareMeters())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Area $div(Pressure that) {
        return SquareMeters$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toNewtons() / that.toPascals())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public double toNewtons() {
        return this.to(Newtons$.MODULE$);
    }

    public double toKilogramForce() {
        return this.to(KilogramForce$.MODULE$);
    }

    public double toPoundForce() {
        return this.to(PoundForce$.MODULE$);
    }

    public double toKiloElectronVoltsPerMicrometer() {
        return this.to(KiloElectronVoltsPerMicrometer$.MODULE$);
    }

    public double toMegaElectronVoltsPerCentimeter() {
        return this.to(MegaElectronVoltsPerCentimeter$.MODULE$);
    }

    public Force(double value, ForceUnit unit) {
        this.value = value;
        this.unit = unit;
        TimeDerivative.$init$(this);
        TimeIntegral.$init$(this);
    }
}

