/*
 * Decompiled with CFR 0.152.
 */
package com.azavea.gdal;

import cz.adamh.utils.NativeUtils;
import java.io.UnsupportedEncodingException;

public class GDALWarp {
    private static final String GDALWARP_BINDINGS_RESOURCE_ELF = "/resources/libgdalwarp_bindings.so";
    private static final String GDALWARP_BINDINGS_RESOURCE_MACHO = "/resources/libgdalwarp_bindings.dylib";
    private static final String GDALWARP_BINDINGS_RESOURCE_DLL = "/resources/gdalwarp_bindings.dll";
    public static final int GDT_Unknown = 0;
    public static final int GDT_Byte = 1;
    public static final int GDT_UInt16 = 2;
    public static final int GDT_Int16 = 3;
    public static final int GDT_UInt32 = 4;
    public static final int GDT_Int32 = 5;
    public static final int GDT_Float32 = 6;
    public static final int GDT_Float64 = 7;
    public static final int GDT_CInt16 = 8;
    public static final int GDT_CInt32 = 9;
    public static final int GDT_CFloat32 = 10;
    public static final int GDT_CFloat64 = 11;
    public static final int GDT_TypeCount = 12;
    public static final int GCI_Undefined = 0;
    public static final int GCI_GrayIndex = 1;
    public static final int GCI_PaletteIndex = 2;
    public static final int GCI_RedBand = 3;
    public static final int GCI_GreenBand = 4;
    public static final int GCI_BlueBand = 5;
    public static final int GCI_AlphaBand = 6;
    public static final int GCI_HueBand = 7;
    public static final int GCI_SaturationBand = 8;
    public static final int GCI_LightnessBand = 9;
    public static final int GCI_CyanBand = 10;
    public static final int GCI_MagentaBand = 11;
    public static final int GCI_YellowBand = 12;
    public static final int GCI_BlackBand = 13;
    public static final int GCI_YCbCr_YBand = 14;
    public static final int GCI_YCbCr_CbBand = 15;
    public static final int GCI_YCbCr_CrBand = 16;
    public static final int GCI_Max = 16;
    public static final int SOURCE = 0;
    public static final int WARPED = 1;
    private static final String ANSI_RESET = "\u001b[0m";
    private static final String ANSI_RED = "\u001b[31m";
    private static ThreadLocal<byte[]> scratch_1d = new ThreadLocal();
    private static ThreadLocal<byte[][]> scratch_2d = new ThreadLocal();

    private static native void _init(int var0);

    private static int ensure_scratch_1d() {
        int len;
        if (scratch_1d.get() == null) {
            len = 256;
            scratch_1d.set(new byte[len]);
        } else {
            len = scratch_1d.get().length;
        }
        return len;
    }

    private static int ensure_scratch_2d() {
        int len;
        if (scratch_2d.get() == null) {
            len = 256;
            scratch_2d.set(new byte[len][len]);
        } else {
            len = scratch_2d.get().length;
        }
        return len;
    }

    private static void grow_scratch_1d(int _len) {
        int len = _len <= 0 ? scratch_1d.get().length << 1 : _len;
        scratch_1d.set(new byte[len]);
    }

    private static void grow_scratch_2d(int _len) {
        int len = _len <= 0 ? scratch_2d.get().length << 1 : _len;
        scratch_2d.set(new byte[len][len]);
    }

    public static void init(int size) throws Exception {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains("linux")) {
            NativeUtils.loadLibraryFromJar(GDALWARP_BINDINGS_RESOURCE_ELF);
        } else if (os.contains("mac")) {
            NativeUtils.loadLibraryFromJar(GDALWARP_BINDINGS_RESOURCE_MACHO);
        } else if (os.contains("win")) {
            NativeUtils.loadLibraryFromJar(GDALWARP_BINDINGS_RESOURCE_DLL);
        } else {
            throw new Exception("Unsupported platform");
        }
        GDALWarp._init(size);
    }

    public static String get_version_info(String key) throws UnsupportedEncodingException {
        int array_len = GDALWarp.ensure_scratch_1d();
        int result_len = GDALWarp._get_version_info(key, scratch_1d.get());
        if (result_len < array_len) {
            return new String(scratch_1d.get(), 0, result_len, "UTF-8").trim();
        }
        GDALWarp.grow_scratch_1d(result_len + 1);
        GDALWarp._get_version_info(key, scratch_1d.get());
        return new String(scratch_1d.get(), 0, result_len, "UTF-8").trim();
    }

    public static native void deinit();

    public static native int _get_version_info(String var0, byte[] var1);

    public static native void set_config_option(String var0, String var1);

    public static native long get_token(String var0, String[] var1);

    public static native int get_block_size(long var0, int var2, int var3, int var4, int[] var5, int[] var6);

    public static native int get_histogram(long var0, int var2, int var3, int var4, double var5, double var7, long[] var9, boolean var10, boolean var11);

    public static native int get_offset(long var0, int var2, int var3, int var4, double[] var5, int[] var6);

    public static native int get_scale(long var0, int var2, int var3, int var4, double[] var5, int[] var6);

    public static native int noop(long var0, int var2, int var3);

    public static native int get_color_interpretation(long var0, int var2, int var3, int var4, int[] var5);

    public static native int get_metadata_domain_list(long var0, int var2, int var3, int var4, byte[][] var5);

    public static int get_metadata_domain_list(long token, int dataset, int attempts, int band_number, String[][] domain_list) throws UnsupportedEncodingException {
        int array_len = GDALWarp.ensure_scratch_2d();
        int retval = GDALWarp.get_metadata_domain_list(token, dataset, attempts, band_number, scratch_2d.get());
        if (retval >= 0) {
            int n = 0;
            n = 0;
            while (scratch_2d.get()[n][0] != 0) {
                ++n;
            }
            domain_list[0] = new String[n];
            --n;
            while (n >= 0) {
                int m = 0;
                byte[] bytes = scratch_2d.get()[n];
                for (m = 0; m < array_len && bytes[m] != 0; ++m) {
                }
                domain_list[0][n] = new String(bytes, 0, m, "UTF-8").trim();
                --n;
            }
            return retval;
        }
        if (retval == -1) {
            GDALWarp.grow_scratch_2d(0);
            return GDALWarp.get_metadata_domain_list(token, dataset, attempts, band_number, domain_list);
        }
        return retval;
    }

    public static native int get_metadata(long var0, int var2, int var3, int var4, String var5, byte[][] var6);

    public static int get_metadata(long token, int dataset, int attempts, int band_number, String domain, String[][] list2) throws UnsupportedEncodingException {
        int array_len = GDALWarp.ensure_scratch_2d();
        int retval = GDALWarp.get_metadata(token, dataset, attempts, band_number, domain, scratch_2d.get());
        if (retval >= 0) {
            int n = 0;
            n = 0;
            while (scratch_2d.get()[n][0] != 0) {
                ++n;
            }
            list2[0] = new String[n];
            --n;
            while (n >= 0) {
                int m = 0;
                byte[] bytes = scratch_2d.get()[n];
                for (m = 0; m < array_len && bytes[m] != 0; ++m) {
                }
                list2[0][n] = new String(bytes, 0, m, "UTF-8").trim();
                --n;
            }
            return retval;
        }
        if (retval == -1) {
            GDALWarp.grow_scratch_2d(0);
            return GDALWarp.get_metadata(token, dataset, attempts, band_number, domain, list2);
        }
        return retval;
    }

    public static native int get_metadata_item(long var0, int var2, int var3, int var4, String var5, String var6, byte[] var7);

    public static int get_metadata_item(long token, int dataset, int attempts, int band_number, String key, String domain, String[] value) throws UnsupportedEncodingException {
        int array_len = GDALWarp.ensure_scratch_1d();
        int retval = GDALWarp.get_metadata_item(token, dataset, attempts, band_number, key, domain, scratch_1d.get());
        if (retval >= 0) {
            int m = 0;
            byte[] bytes = scratch_1d.get();
            for (m = 0; m < array_len && bytes[m] != 0; ++m) {
            }
            value[0] = new String(bytes, 0, m, "UTF-8").trim();
            return retval;
        }
        if (retval == -1) {
            GDALWarp.grow_scratch_1d(0);
            return GDALWarp.get_metadata_item(token, dataset, attempts, band_number, key, domain, value);
        }
        return retval;
    }

    public static native int get_overview_widths_heights(long var0, int var2, int var3, int var4, int[] var5, int[] var6);

    public static native int get_crs_proj4(long var0, int var2, int var3, byte[] var4);

    public static native int get_crs_wkt(long var0, int var2, int var3, byte[] var4);

    public static native int get_band_nodata(long var0, int var2, int var3, int var4, double[] var5, int[] var6);

    public static native int get_band_min_max(long var0, int var2, int var3, int var4, boolean var5, double[] var6, int[] var7);

    public static native int get_band_data_type(long var0, int var2, int var3, int var4, int[] var5);

    public static native int get_band_count(long var0, int var2, int var3, int[] var4);

    public static native int get_width_height(long var0, int var2, int var3, int[] var4);

    public static native int get_data(long var0, int var2, int var3, int[] var4, int[] var5, int var6, int var7, byte[] var8);

    public static native int get_transform(long var0, int var2, int var3, double[] var4);

    static {
        try {
            GDALWarp.init(256);
        }
        catch (Exception e) {
            System.err.println("\u001b[31mINITIALIZATION FAILED\u001b[0m");
        }
    }
}

